/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.repository.common.util.NLS;

public class RecursiveIgnoreRule
extends IgnoreRule {
    public RecursiveIgnoreRule(IShareable file, DefaultIgnoreProvider provider, String pattern, boolean ignorecase, boolean ignoreWildCards) {
        super(file, provider, pattern, ignorecase, ignoreWildCards);
    }

    @Override
    public boolean isTrivial() {
        return false;
    }

    @Override
    public boolean shouldBeIgnored(IRelativeLocation path) {
        IRelativeLocation root = this.getRootShareableLocalPath();
        if (root.isPrefixOf(path) && !root.equals(path)) {
            return super.shouldBeIgnored(path);
        }
        return false;
    }

    @Override
    public boolean isEffectiveBelow(IShareable shareable) {
        IRelativeLocation root = this.getRootShareableLocalPath();
        IRelativeLocation path = shareable.getLocalPath();
        return root.isPrefixOf(path);
    }

    @Override
    public boolean isRecursive() {
        return true;
    }

    @Override
    public String getShortDescription() {
        return NLS.bind((String)Messages.IgnoreUtils_2, (Object[])new Object[]{this.getMatcher().getPattern(), this.getFile().getLocalPath()}, (Object[])new Object[0]);
    }
}

