/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.LoadFilter;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LoadRequest;
import com.ibm.team.filesystem.client.internal.load.RemovedShare;
import com.ibm.team.filesystem.client.internal.operations.ILoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.InvalidLoadRequest;
import com.ibm.team.filesystem.client.internal.operations.LoadEvaluator;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.RepoIdConnectionComponentTriple;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.IInvalidLoadRequest;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.filesystem.client.operations.IRemovedShare;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IShareableToLoad;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class NonHierarchicalLoadEvaluator
extends LoadEvaluator {
    private HashMap<ISandbox, Set<IRemovedShare>> sharesToRemove = new HashMap();
    private HashSet<LoadLocation> treesToLoad;
    private HashMap<ILocation, ICollision> collisions;
    private HashMap<ILocation, IShareableToLoad> newItems;
    private ArrayList<ILoadOverlap> loadOverLaps;
    private ArrayList<IShareOutOfSync> sharesOutOfSync;
    private ArrayList<IInvalidLoadRequest> invalidLoadRequests;
    private static final ILoadEvaluator.LoadValidations[] SUPPORTED = new ILoadEvaluator.LoadValidations[]{ILoadEvaluator.LoadValidations.SOME_SHARES_TO_REMOVE, ILoadEvaluator.LoadValidations.INVALID_REQUEST, ILoadEvaluator.LoadValidations.MULTIPLE_SANDBOX, ILoadEvaluator.LoadValidations.OUT_OF_SYNC_SHARES, ILoadEvaluator.LoadValidations.USES_LOAD_ROOT};

    @Override
    public final void doEvaluation(IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(100 * this.requestsByCFA.size()));
        this.treesToLoad = new HashSet();
        this.sharesToRemove = new HashMap();
        this.collisions = new HashMap();
        this.newItems = new HashMap();
        this.loadOverLaps = new ArrayList();
        this.invalidLoadRequests = new ArrayList();
        this.sharesOutOfSync = new ArrayList();
        HashMap<IShare, IConnection> sharesToVerifyInSync = new HashMap<IShare, IConnection>();
        for (Map.Entry entry : this.requestsByCFA.entrySet()) {
            this.getElementsToLoad((ISandbox)entry.getKey(), (Map)entry.getValue(), sharesToVerifyInSync, (IProgressMonitor)monitor.newChild(90));
        }
        if (!sharesToVerifyInSync.isEmpty()) {
            OutOfSyncDilemmaHandler outOfSyncDilemmaHandler = new OutOfSyncDilemmaHandler(){

                @Override
                public int outOfSync(Collection<IShareOutOfSync> shares) {
                    NonHierarchicalLoadEvaluator.this.sharesOutOfSync.addAll(shares);
                    return 0;
                }
            };
            VerifySharesOperation verifyInSyncOp = new VerifySharesOperation(outOfSyncDilemmaHandler);
            for (Map.Entry entry : sharesToVerifyInSync.entrySet()) {
                verifyInSyncOp.addToVerify((IConnection)entry.getValue(), (IShare)entry.getKey());
            }
            verifyInSyncOp.run((IProgressMonitor)monitor.newChild(10));
        }
        monitor.done();
    }

    private void getElementsToLoad(ISandbox sandbox, Map<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> requestsByConnection, HashMap<IShare, IConnection> sharesToVerifyInSync, IProgressMonitor progress) throws TeamRepositoryException, FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        monitor.setTaskName(Messages.LoadOperation_14);
        Map<RepoIdConnectionComponentTriple, Map<UUID, Set<IShare>>> relatedShares = this.getShares(sandbox, (IProgressMonitor)monitor.newChild(1));
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        monitor.setWorkRemaining(requestsByConnection.size());
        for (Map.Entry<IConnection, Map<ConfigurationFacade, Set<LoadRequest>>> entryByConnection : requestsByConnection.entrySet()) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            SubMonitor iterProgress = monitor.newChild(1);
            iterProgress.setWorkRemaining(100);
            IConnection connection = entryByConnection.getKey();
            Map<ConfigurationFacade, Set<LoadRequest>> requestsForConnection = entryByConnection.getValue();
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(sandbox.getRoot());
            this.reviseRequests(cfa, connection, requestsForConnection, (IProgressMonitor)iterProgress.newChild(10));
            Map<UUID, Map<UUID, ? extends IVersionable>> fullVersionables = this.fetchInfoForLoadEvaluation(connection, requestsForConnection, components, relatedShares, (IProgressMonitor)iterProgress.newChild(40));
            this.checkExistance(connection, requestsForConnection, sharesToVerifyInSync, relatedShares, fullVersionables, (IProgressMonitor)iterProgress.newChild(10));
            for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> toLoadByConfig : requestsForConnection.entrySet()) {
                ConfigurationFacade descriptor = toLoadByConfig.getKey();
                for (LoadRequest request : toLoadByConfig.getValue()) {
                    IRelativeLocation relativeLoadPath;
                    IVersionable versionable = fullVersionables.get(descriptor.getComponentHandle().getItemId()).get(request.getVersionableToLoad().getItemId());
                    if (versionable == null) {
                        throw new IllegalStateException();
                    }
                    boolean isLoadWithAnotherName = false;
                    String loadName = versionable.getName();
                    if (request.getAlternativeName().length() > 0) {
                        loadName = request.getAlternativeName();
                        isLoadWithAnotherName = true;
                    }
                    if (!LoadFilter.include(relativeLoadPath = request.getRelativeLoadPath(), loadName)) continue;
                    LoadLocation location = new LoadLocation(request.getSandbox(), relativeLoadPath, loadName, request.getConnection(), components.get(request.getComponent().getItemId()), request.getVersionableToLoad(), isLoadWithAnotherName);
                    this.treesToLoad.add(location);
                }
            }
        }
    }

    private void reviseRequests(ICopyFileArea cfa, IConnection connection, Map<ConfigurationFacade, Set<LoadRequest>> requestsForConnection, IProgressMonitor progress) throws TeamRepositoryException {
        if (cfa == null) {
            return;
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)requestsForConnection.size());
        for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> entry : requestsForConnection.entrySet()) {
            ConfigurationFacade configuration = entry.getKey();
            Set<LoadRequest> requests = entry.getValue();
            HashMap<UUID, IShare> organizedShares = new HashMap<UUID, IShare>();
            HashMap<UUID, Integer> numberOfSharesByFolder = new HashMap<UUID, Integer>();
            Collection<IShare> shares = cfa.allShares(configuration.getConnectionHandle(), configuration.getComponentHandle(), (IProgressMonitor)monitor.newChild(1));
            for (IShare share : shares) {
                organizedShares.put(share.getSharingDescriptor().getRootVersionable().getItemId(), share);
                IVersionableHandle root = share.getSharingDescriptor().getReloadRoot();
                if (root == null) continue;
                Integer count = (Integer)numberOfSharesByFolder.get(root.getItemId());
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                numberOfSharesByFolder.put(root.getItemId(), count);
            }
            HashMap<UUID, HashSet<IFileItemHandle>> requestedFileItemsByFolder = new HashMap<UUID, HashSet<IFileItemHandle>>();
            Iterator<LoadRequest> iterator = requests.iterator();
            while (iterator.hasNext()) {
                InvalidLoadRequest invalidLoadRequest;
                IStatus msg;
                LoadRequest request = iterator.next();
                if (!request.isReloadRequest() && request.getRelativeLoadPath() != null && !request.getRelativeLoadPath().isEmpty()) {
                    iterator.remove();
                    msg = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.NonHierarchicalLoadEvaluator_0, (Object)request.getRelativeLoadPath().toString(), (Object[])new Object[0]));
                    invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.UnsupportedRequest, msg);
                    this.invalidLoadRequests.add(invalidLoadRequest);
                    continue;
                }
                if (!request.isReloadRequest() && request.getAlternativeName() != null && !request.getAlternativeName().equals("")) {
                    iterator.remove();
                    msg = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.NonHierarchicalLoadEvaluator_1, (Object)request.getAlternativeName(), (Object[])new Object[0]));
                    invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.UnsupportedRequest, msg);
                    this.invalidLoadRequests.add(invalidLoadRequest);
                    continue;
                }
                IShare share = (IShare)organizedShares.get(request.getVersionableToLoad().getItemId());
                if (share == null || share.getSharingDescriptor().getReloadRoot() == null || !(request.getVersionableToLoad() instanceof IFileItemHandle) || !(share.getSharingDescriptor().getReloadRoot() instanceof IFolderHandle)) continue;
                IFolderHandle folder = (IFolderHandle)share.getSharingDescriptor().getReloadRoot();
                HashSet<IFileItemHandle> children = (HashSet<IFileItemHandle>)requestedFileItemsByFolder.get(folder.getItemId());
                if (children == null) {
                    children = new HashSet<IFileItemHandle>();
                    requestedFileItemsByFolder.put(folder.getItemId(), children);
                }
                children.add((IFileItemHandle)request.getVersionableToLoad());
            }
            HashSet<UUID> keptRequests2 = new HashSet<UUID>();
            for (Map.Entry entry1 : requestedFileItemsByFolder.entrySet()) {
                UUID folderUUID = (UUID)entry1.getKey();
                if (!numberOfSharesByFolder.containsKey(folderUUID) || ((Set)requestedFileItemsByFolder.get(folderUUID)).size() == ((Integer)numberOfSharesByFolder.get(folderUUID)).intValue()) continue;
                keptRequests2.add(folderUUID);
            }
            HashSet<LoadRequest> newRequests = new HashSet<LoadRequest>();
            Iterator<LoadRequest> iterator2 = requests.iterator();
            while (iterator2.hasNext()) {
                LoadRequest request = iterator2.next();
                IShare share = (IShare)organizedShares.get(request.getVersionableToLoad().getItemId());
                if (share == null || share.getSharingDescriptor().getReloadRoot() == null) continue;
                Boolean convert = true;
                if (request.getVersionableToLoad() instanceof IFileItemHandle && share.getSharingDescriptor().getReloadRoot() instanceof IFolderHandle) {
                    convert = !keptRequests2.contains(share.getSharingDescriptor().getReloadRoot().getItemId());
                }
                if (!convert.booleanValue()) continue;
                iterator2.remove();
                LoadRequest newRequest = new LoadRequest(request.getSandbox(), null, null, connection, request.getComponent(), share.getSharingDescriptor().getReloadRoot(), request.isReloadRequest());
                newRequests.add(newRequest);
            }
            requests.addAll(newRequests);
        }
    }

    private Map<RepoIdConnectionComponentTriple, Map<UUID, Set<IShare>>> getShares(ISandbox sandbox, IProgressMonitor progress) throws FileSystemException {
        HashMap<RepoIdConnectionComponentTriple, Map<UUID, Set<IShare>>> existingShares = new HashMap<RepoIdConnectionComponentTriple, Map<UUID, Set<IShare>>>();
        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
        if (cfaManager.copyFileAreaExists(sandbox.getRoot(), 1)) {
            IShare[] iShareArray = sandbox.allShares(progress);
            int n = iShareArray.length;
            int n2 = 0;
            while (n2 < n) {
                IShare share = iShareArray[n2];
                if (share.getSharingDescriptor() != null) {
                    Set<IShare> shares;
                    IVersionableHandle reloadRoot;
                    ISharingDescriptor shareDesc = share.getSharingDescriptor();
                    RepoIdConnectionComponentTriple descriptor = new RepoIdConnectionComponentTriple(shareDesc.getRepositoryId(), shareDesc.getConnectionHandle(), shareDesc.getComponent());
                    Map<UUID, Set<IShare>> relatedShares = existingShares.get(descriptor);
                    if (relatedShares == null) {
                        relatedShares = new HashMap<UUID, Set<IShare>>();
                        existingShares.put(descriptor, relatedShares);
                    }
                    if ((reloadRoot = shareDesc.getReloadRoot()) == null) {
                        reloadRoot = shareDesc.getRootVersionable();
                    }
                    if ((shares = relatedShares.get(reloadRoot.getItemId())) == null) {
                        shares = new HashSet<IShare>();
                        relatedShares.put(reloadRoot.getItemId(), shares);
                    }
                    shares.add(share);
                }
                ++n2;
            }
        }
        return existingShares;
    }

    private Map<UUID, Map<UUID, ? extends IVersionable>> fetchInfoForLoadEvaluation(IConnection connection, Map<ConfigurationFacade, Set<LoadRequest>> requestsForConnection, Map<UUID, IComponent> components, Map<RepoIdConnectionComponentTriple, Map<UUID, Set<IShare>>> existingShares, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IComponentHandle> componentsToRetrieve = new ArrayList<IComponentHandle>();
        ArrayList<IComponentHandle> interestingComponents = new ArrayList<IComponentHandle>();
        ArrayList<List<? extends IVersionableHandle>> interestingVersionables = new ArrayList<List<? extends IVersionableHandle>>();
        for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> entryByConfig : requestsForConnection.entrySet()) {
            ConfigurationFacade descriptor = entryByConfig.getKey();
            HashSet<UUID> uuids = new HashSet<UUID>();
            if (!components.containsKey(descriptor.getComponentHandle().getItemId())) {
                componentsToRetrieve.add(descriptor.getComponentHandle());
            }
            interestingComponents.add(descriptor.getComponentHandle());
            ArrayList<IVersionableHandle> versionables = new ArrayList<IVersionableHandle>();
            interestingVersionables.add(versionables);
            for (LoadRequest request : entryByConfig.getValue()) {
                versionables.add(request.getVersionableToLoad());
                uuids.add(request.getVersionableToLoad().getItemId());
            }
            Map<UUID, Set<IShare>> shares = existingShares.get(new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponentHandle()));
            if (shares == null) continue;
            for (Set<IShare> relatedShares : shares.values()) {
                Iterator<IShare> iterator = relatedShares.iterator();
                if (!iterator.hasNext()) continue;
                IShare share = iterator.next();
                ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
                IVersionableHandle reloadRoot = sharingDescriptor.getReloadRoot();
                if (reloadRoot == null) {
                    reloadRoot = sharingDescriptor.getRootVersionable();
                }
                if (!uuids.add(reloadRoot.getItemId())) continue;
                versionables.add(reloadRoot);
            }
        }
        if (!componentsToRetrieve.isEmpty()) {
            List fullComponents = connection.teamRepository().itemManager().fetchCompleteItems(componentsToRetrieve, 0, (IProgressMonitor)monitor.newChild(20));
            for (IComponent component : fullComponents) {
                components.put(component.getItemId(), component);
            }
        }
        return this.fetchCompleteItems(connection, interestingComponents, interestingVersionables, monitor.newChild(80));
    }

    private void checkExistance(IConnection connection, Map<ConfigurationFacade, Set<LoadRequest>> requestsForConnection, HashMap<IShare, IConnection> sharesToVerifyInSync, Map<RepoIdConnectionComponentTriple, Map<UUID, Set<IShare>>> existingShares, Map<UUID, Map<UUID, ? extends IVersionable>> fullVersionables, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)requestsForConnection.size());
        for (Map.Entry<ConfigurationFacade, Set<LoadRequest>> entryByConfig : requestsForConnection.entrySet()) {
            SubMonitor iterMonitor = monitor.newChild(1);
            ConfigurationFacade descriptor = entryByConfig.getKey();
            Set<LoadRequest> toLoad = entryByConfig.getValue();
            Map<UUID, Set<IShare>> shares = existingShares.get(new RepoIdConnectionComponentTriple(descriptor.getRepositoryId(), descriptor.getConnectionHandle(), descriptor.getComponentHandle()));
            Map<UUID, ? extends IVersionable> fullVersionablesForComponent = fullVersionables.get(descriptor.getComponentHandle().getItemId());
            if (fullVersionablesForComponent == null) continue;
            iterMonitor.setWorkRemaining(fullVersionablesForComponent.size());
            for (Map.Entry<UUID, ? extends IVersionable> entry : fullVersionablesForComponent.entrySet()) {
                Set<IShare> relatedShares;
                UUID itemId = entry.getKey();
                if (entry.getValue() == null) {
                    Set<IShare> relatedShares2;
                    LoadRequest request = null;
                    Iterator<LoadRequest> iLoadRequest = toLoad.iterator();
                    while (iLoadRequest.hasNext()) {
                        LoadRequest loadRequest = iLoadRequest.next();
                        if (!loadRequest.getVersionableToLoad().getItemId().equals((Object)itemId)) continue;
                        iLoadRequest.remove();
                        request = loadRequest;
                        break;
                    }
                    if (request != null) {
                        relatedShares2 = null;
                        if (shares != null) {
                            relatedShares2 = shares.get(itemId);
                        }
                        if (relatedShares2 != null) {
                            this.addSharesForRemoval(itemId, relatedShares2, (IProgressMonitor)iterMonitor.newChild(1));
                            continue;
                        }
                        IStatus msg = FileSystemStatusUtil.getStatusFor(2, Messages.LoadOperation_16);
                        InvalidLoadRequest invalidLoadRequest = new InvalidLoadRequest(request, IInvalidLoadRequest.InvalidLoadRequestReason.NonExistantItem, msg);
                        this.invalidLoadRequests.add(invalidLoadRequest);
                        continue;
                    }
                    if (shares == null) continue;
                    relatedShares2 = shares.get(itemId);
                    this.addSharesForRemoval(itemId, relatedShares2, (IProgressMonitor)iterMonitor.newChild(1));
                    continue;
                }
                if (shares == null || (relatedShares = shares.get(itemId)) == null) continue;
                for (IShare share : relatedShares) {
                    sharesToVerifyInSync.put(share, connection);
                }
            }
        }
    }

    private void addSharesForRemoval(UUID itemId, Set<IShare> shares, IProgressMonitor progress) throws FileSystemException {
        if (shares != null) {
            for (IShare share : shares) {
                Set<IRemovedShare> sharesForRemoval = this.sharesToRemove.get(share.getSandbox());
                if (sharesForRemoval == null) {
                    sharesForRemoval = new HashSet<IRemovedShare>();
                    this.sharesToRemove.put(share.getSandbox(), sharesForRemoval);
                }
                sharesForRemoval.add(new RemovedShare(share, progress));
            }
        }
    }

    @Override
    public Map<ISandbox, Set<IRemovedShare>> getSharesToBeRemoved() {
        return this.sharesToRemove;
    }

    @Override
    public Map<ILocation, ICollision> getCollisions() {
        return this.collisions;
    }

    @Override
    public Map<ILocation, IShareableToLoad> getNewSharesToLoad() {
        return this.newItems;
    }

    @Override
    public Collection<IShareOutOfSync> getSharesOutOfSync() {
        return this.sharesOutOfSync;
    }

    @Override
    public Collection<ILoadEvaluator.LoadValidations> getSupportedValidations() {
        return Arrays.asList(SUPPORTED);
    }

    @Override
    public Collection<LoadLocation> getItemsToLoad() {
        return this.treesToLoad;
    }

    @Override
    public Collection<ILoadOverlap> getLoadOverlaps() {
        return this.loadOverLaps;
    }

    @Override
    public Collection<IInvalidLoadRequest> getInvalidLoadRequests() {
        return this.invalidLoadRequests;
    }
}

