/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest.util;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.BackupInShedDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.FilesystemRestClientDTOchangesetFactory;
import java.util.List;

public class BackupUtil {
    public static BackupDilemmaHandler getBackupDilemmaHandler(final ParmsBackupDilemmaHandler backupInstructions, final List<BackupInShedDTO> backedUpInShed) {
        BackupDilemmaHandler dilemmaHandler = backupInstructions == null ? new BackupDilemmaHandler(){

            @Override
            public boolean backupEnabled() {
                return true;
            }

            @Override
            public void backedUpInShed(IShareable shareable, ILocation shedLocation) {
                if (backedUpInShed != null) {
                    backedUpInShed.add(BackupUtil.translateBackupInShed(shareable, shedLocation));
                }
            }
        } : new BackupDilemmaHandler(){

            @Override
            public boolean backupEnabled() {
                return backupInstructions.backupEnabled;
            }

            @Override
            public int getMaxFileSize() {
                if (backupInstructions.maxFileSize == null) {
                    return super.getMaxFileSize();
                }
                return backupInstructions.maxFileSize;
            }

            @Override
            public int getPreferredShedLifespan() {
                if (backupInstructions.preferredShedLifespan == null) {
                    return super.getPreferredShedLifespan();
                }
                return backupInstructions.preferredShedLifespan;
            }

            @Override
            public void backedUpInShed(IShareable shareable, ILocation shedLocation) {
                if (backedUpInShed != null) {
                    backedUpInShed.add(BackupUtil.translateBackupInShed(shareable, shedLocation));
                }
            }
        };
        return dilemmaHandler;
    }

    private static BackupInShedDTO translateBackupInShed(IShareable shareable, ILocation shedLocation) {
        BackupInShedDTO result = FilesystemRestClientDTOchangesetFactory.eINSTANCE.createBackupInShedDTO();
        result.setShareable(CoreUtil.translateShareable(shareable));
        result.setShedLocation(shedLocation.toOSString());
        return result;
    }
}

