/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.DeliverDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IDeliverOperation;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemManager;
import com.ibm.team.filesystem.client.workitems.internal.Messages;
import com.ibm.team.filesystem.client.workitems.operations.ICheckinAndDeliverOperation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class CheckinAndDeliverOperation
extends FileSystemOperation
implements ICheckinAndDeliverOperation {
    private IWorkItemHandle workItem;
    private final DeliverDilemmaHandler dilemmaHandler;
    private String changeSetComment;
    private List<CheckInAndDeliverRequest> requests = new ArrayList<CheckInAndDeliverRequest>();
    private boolean refreshBeforeRun;
    private int nonAtomicCommitFileUploadLimit = 200;
    private boolean nonAtomicCommitIsAnOption = true;

    public CheckinAndDeliverOperation(DeliverDilemmaHandler dilemmaHandler) {
        super((DilemmaHandler)(dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler));
        this.dilemmaHandler = dilemmaHandler == null ? DeliverDilemmaHandler.getDefault() : dilemmaHandler;
    }

    @Override
    public void changeSetLinkage(IWorkItemHandle workItem, String changeSetComment) {
        this.workItem = workItem;
        this.changeSetComment = changeSetComment;
    }

    @Override
    public void add(IWorkspaceConnection source, IWorkspaceConnection target, IChangeHistorySyncReport report, IComponentHandle component, List<ILocalChange> localChanges) {
        CheckInAndDeliverRequest request = new CheckInAndDeliverRequest(source, target, localChanges, report, component);
        this.requests.add(request);
    }

    public void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckinAndDeliverOperation_PROGRESS_DELIVER, (int)100);
        IDeliverOperation deliverOperation = IOperationFactory.instance.getDeliverOperation(this.dilemmaHandler);
        this.configureCheckinOptions((ICheckinOptions)deliverOperation);
        deliverOperation.setRefreshBeforeRun(this.refreshBeforeRun);
        SubMonitor loopProgress = progress.newChild(75).setWorkRemaining(this.requests.size());
        for (CheckInAndDeliverRequest request : this.requests) {
            this.checkIn(request, deliverOperation, (IProgressMonitor)loopProgress.newChild(1));
        }
        deliverOperation.run((IProgressMonitor)progress.newChild(25));
    }

    private void configureCheckinOptions(ICheckinOptions operation) {
        if (this.nonAtomicCommitIsAnOption) {
            operation.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
        } else {
            operation.disableNonAtomicCommit();
        }
    }

    private void checkIn(CheckInAndDeliverRequest request, IDeliverOperation deliverOperation, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CheckinAndDeliverOperation_PROGRESS_MESSAGE, (int)100);
        IWorkspaceConnection source = request.source;
        IWorkspaceConnection target = request.target;
        List<ILocalChange> localChanges = request.localChanges;
        IChangeHistorySyncReport report = request.report;
        IComponentHandle component = request.component;
        ICheckinOperation checkInOperation = IOperationFactory.instance.getCheckinOperation(this.dilemmaHandler.getCommitDilemmaHandler(), request.resolver);
        this.configureCheckinOptions((ICheckinOptions)checkInOperation);
        checkInOperation.setRefreshBeforeRun(this.refreshBeforeRun);
        checkInOperation.requestCheckin(localChanges.toArray(new ILocalChange[0]), null, this.changeSetComment, (IProgressMonitor)progress.newChild(5));
        checkInOperation.run((IProgressMonitor)progress.newChild(55));
        Collection committedChangeSets = checkInOperation.getCommittedChangeSets();
        report = source.compareTo((IFlowNodeConnection)target, 1, Collections.EMPTY_LIST, (IProgressMonitor)progress.newChild(10));
        progress.setTaskName(Messages.CheckinAndDeliverOperation_PROGRESS_MESSAGE_CHECKIN);
        IFileSystemWorkItemManager workItemManager = (IFileSystemWorkItemManager)source.teamRepository().getClientLibrary(IFileSystemWorkItemManager.class);
        ArrayList outgoingHandles = new ArrayList(committedChangeSets);
        List outgoing = source.teamRepository().itemManager().fetchCompleteItems(outgoingHandles, 0, (IProgressMonitor)progress.newChild(5));
        SubMonitor loopProgress = progress.newChild(10).setWorkRemaining(outgoing.size() * 2);
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)source.teamRepository());
        for (IChangeSet changeSet : outgoing) {
            if (changeSet == null || !changeSet.isActive()) continue;
            String trimmedComment = this.changeSetComment.trim();
            if (trimmedComment.length() > 0) {
                manager.setComment((IChangeSetHandle)changeSet, this.changeSetComment, (IProgressMonitor)loopProgress.newChild(1));
            }
            if (this.workItem == null) continue;
            workItemManager.createLink((IWorkspaceHandle)source.getResolvedWorkspace(), (IChangeSetHandle)changeSet, new IWorkItemHandle[]{this.workItem}, (IProgressMonitor)loopProgress.newChild(1));
        }
        deliverOperation.deliver(source, target, report, component);
    }

    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    private static class CheckInAndDeliverRequest {
        public final IWorkspaceConnection source;
        public final IWorkspaceConnection target;
        public final List<ILocalChange> localChanges;
        public final IChangeHistorySyncReport report;
        public final IComponentHandle component;
        public final IRepositoryResolver resolver;

        public CheckInAndDeliverRequest(IWorkspaceConnection sourceConnection, IWorkspaceConnection targetConnection, List<ILocalChange> changes, IChangeHistorySyncReport report, IComponentHandle component) {
            this.source = sourceConnection;
            this.target = targetConnection;
            this.localChanges = new ArrayList<ILocalChange>(changes.size());
            for (ILocalChange change : changes) {
                if (!change.getConnection().sameItemId((IItemHandle)this.source.getContextHandle())) {
                    throw new IllegalArgumentException();
                }
                this.localChanges.add(change);
            }
            this.report = report;
            this.component = component;
            this.resolver = new IRepositoryResolver(){

                public ITeamRepository getRepoFor(String uri, UUID id) throws TeamRepositoryException {
                    if (id.equals((Object)CheckInAndDeliverRequest.this.source.teamRepository().getId())) {
                        return CheckInAndDeliverRequest.this.source.teamRepository();
                    }
                    if (id.equals((Object)CheckInAndDeliverRequest.this.target.teamRepository().getId())) {
                        return CheckInAndDeliverRequest.this.target.teamRepository();
                    }
                    throw new TeamRepositoryException(NLS.bind((String)Messages.CheckinAndDeliverOperation_0, (Object)CheckInAndDeliverRequest.this.source.teamRepository().getRepositoryURI(), (Object)CheckInAndDeliverRequest.this.target.teamRepository().getRepositoryURI()));
                }
            };
        }
    }
}

