/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.analysis;

import com.ibm.team.fulltext.common.ArtifactToken;
import com.ibm.team.fulltext.common.TokenizerTypes;
import com.ibm.team.fulltext.common.internal.StandardTokenTypes;
import com.ibm.team.fulltext.common.internal.analysis.ArtifactAttribute;
import com.ibm.team.fulltext.common.internal.analysis.SplitTokenFilter;
import java.util.Arrays;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class MultiCharacterFilter
extends SplitTokenFilter {
    private boolean isQuery = false;

    protected MultiCharacterFilter(TokenStream stream, boolean isQuery) {
        super(stream);
        this.isQuery = isQuery;
    }

    @Override
    protected void splitToken(ArtifactAttribute token) {
        if (token.isArtifact() && !token.applies(TokenizerTypes.NORMALIZE_EXPAND_MULTICHARACTER)) {
            this.addToQueue(token);
            return;
        }
        String termText = token.term();
        String normalized = this.filterMultiCharacter(termText, false);
        if (normalized != null && normalized.length() > 1) {
            String expanded;
            ArtifactToken normalizedToken = this.internalCreateToken(normalized, token, 1, StandardTokenTypes.MULTICHARACTER_NORMALIZED, null);
            this.addToQueue((TermAttribute)normalizedToken);
            if (this.isQuery) {
                this.addToQueue((TermAttribute)this.createReplacement(termText, token, StandardTokenTypes.MULTICHARACTER, normalizedToken));
            }
            if ((expanded = this.filterMultiCharacter(termText, true)) != null && expanded.length() > 1) {
                this.addToQueue((TermAttribute)this.createReplacement(expanded, token, StandardTokenTypes.MULTICHARACTER_EXPANDED, normalizedToken));
            }
        } else {
            this.addToQueue(token);
        }
    }

    private Token createReplacement(String termText, ArtifactAttribute token, StandardTokenTypes type, Token createdFrom) {
        return this.internalCreateToken(termText, token, 0, type, createdFrom);
    }

    private ArtifactToken internalCreateToken(String termText, ArtifactAttribute token, int increment, StandardTokenTypes type, Token createdFrom) {
        if (termText == null) {
            return null;
        }
        ArtifactToken newToken = new ArtifactToken(termText, token.startOffset(), token.endOffset(), type.getId(), createdFrom);
        newToken.setPositionIncrement(increment);
        return newToken;
    }

    public String filterMultiCharacter(String text, boolean expand) {
        boolean containsMultiCharacter = false;
        char[] buffer = text.toCharArray();
        int length = text.length();
        int i = 0;
        while (i < length) {
            char c = buffer[i];
            switch (c) {
                case '\u00e4': {
                    containsMultiCharacter = true;
                    if (expand) {
                        buffer[i++] = 97;
                        buffer = Arrays.copyOf(buffer, length + 1);
                        if (i < length) {
                            System.arraycopy(buffer, i, buffer, i + 1, length - i);
                        }
                        buffer[i] = 101;
                        ++length;
                        break;
                    }
                    buffer[i] = 97;
                    break;
                }
                case '\u00f6': {
                    containsMultiCharacter = true;
                    if (expand) {
                        buffer[i++] = 111;
                        buffer = Arrays.copyOf(buffer, length + 1);
                        if (i < length) {
                            System.arraycopy(buffer, i, buffer, i + 1, length - i);
                        }
                        buffer[i] = 101;
                        ++length;
                        break;
                    }
                    buffer[i] = 111;
                    break;
                }
                case '\u00fc': {
                    containsMultiCharacter = true;
                    if (expand) {
                        buffer[i++] = 117;
                        buffer = Arrays.copyOf(buffer, length + 1);
                        if (i < length) {
                            System.arraycopy(buffer, i, buffer, i + 1, length - i);
                        }
                        buffer[i] = 101;
                        ++length;
                        break;
                    }
                    buffer[i] = 117;
                    break;
                }
                case '\u00df': {
                    containsMultiCharacter = true;
                    if (expand) {
                        buffer[i++] = 115;
                        buffer = Arrays.copyOf(buffer, length + 1);
                        if (i < length) {
                            System.arraycopy(buffer, i, buffer, i + 1, length - i);
                        }
                        buffer[i] = 115;
                        ++length;
                        break;
                    }
                    buffer[i] = 223;
                }
            }
            ++i;
        }
        if (containsMultiCharacter) {
            return new String(buffer);
        }
        return null;
    }
}

