/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.query;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.fulltext.common.FulltextException;
import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import com.ibm.team.fulltext.common.internal.TokenGroup;
import com.ibm.team.fulltext.common.internal.analysis.DelegatingAnalyzer;
import com.ibm.team.fulltext.common.internal.analysis.QuoteAnalyzer;
import com.ibm.team.fulltext.common.internal.index.IIndexAccess;
import com.ibm.team.fulltext.common.internal.index.IndexManagerImpl;
import com.ibm.team.fulltext.common.internal.query.DefaultQueryProvider;
import com.ibm.team.fulltext.common.internal.query.FindRelatedQueryBuilder;
import com.ibm.team.fulltext.common.internal.query.IQueryManager;
import com.ibm.team.fulltext.common.internal.query.Messages;
import com.ibm.team.fulltext.common.internal.query.PorterStemmingCache;
import com.ibm.team.fulltext.common.internal.result.ResultFactory;
import com.ibm.team.fulltext.common.internal.result.ScoredResultDTO;
import com.ibm.team.fulltext.common.internal.result.URIReferenceDTO;
import com.ibm.team.fulltext.common.internal.util.AnalyzerDebugUtils;
import com.ibm.team.fulltext.common.internal.util.QueryUtils;
import com.ibm.team.fulltext.common.model.IScoredResult;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.ExtensionRegistryReaderListener;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class QueryManagerImpl
implements IQueryManager,
ExtensionRegistryReaderListener<Object> {
    private static final int MAX_CLAUSE_COUNT = 10000;
    public static final long SCORE_TO_LONG_MULTIPLIER = 100000L;
    private static final String QUERY_PROVIDER_EXTENSION_POINT = "queryProvider";
    private static final String QUERY_PROVIDER_CLASS_ATTRIBUTE = "class";
    private static final String TOKEN_TYPE = "tokenType";
    private static final String TOKEN_TYPE_ID = "id";
    private static QueryManagerImpl fgSingleton = new QueryManagerImpl();
    public static float MIN_SCORE_FACTOR_DUPLICATE = 0.3f;
    private static final float DEFAULT_SCORE_FACTOR = 1.0f;
    private final IQueryProvider fDefaultQueryProvider = new DefaultQueryProvider();
    private final Map<String, IConfigurationElement> fQueryProviders = new ConcurrentHashMap<String, IConfigurationElement>();
    private final Map<String, IQueryProvider> fResolvedQueryProvidersCache = new ConcurrentHashMap<String, IQueryProvider>();
    private final DelegatingAnalyzer fDelegatingAnalyzer = new DelegatingAnalyzer(true);

    public static IQueryManager getInstance() {
        return fgSingleton;
    }

    private QueryManagerImpl() {
        BooleanQuery.setMaxClauseCount((int)10000);
        ExtensionRegistryReader<Object> extensionReader = new ExtensionRegistryReader<Object>("com.ibm.team.fulltext.common", QUERY_PROVIDER_EXTENSION_POINT){};
        extensionReader.addListener((ExtensionRegistryReaderListener)this);
        extensionReader.start();
    }

    public void handleExtensionAdded(IConfigurationElement element, Object descriptor) throws Exception {
        IConfigurationElement[] tokenTypes;
        IConfigurationElement[] iConfigurationElementArray = tokenTypes = element.getChildren(TOKEN_TYPE);
        int n = tokenTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement tokenType = iConfigurationElementArray[n2];
            String tokenTypeId = tokenType.getAttribute(TOKEN_TYPE_ID);
            this.fQueryProviders.put(tokenTypeId, element);
            ++n2;
        }
    }

    public void handleExtensionRemoved(IConfigurationElement element, Object descriptor) throws Exception {
        IConfigurationElement[] tokenTypes;
        IConfigurationElement[] iConfigurationElementArray = tokenTypes = element.getChildren(TOKEN_TYPE);
        int n = tokenTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement tokenType = iConfigurationElementArray[n2];
            String tokenTypeId = tokenType.getAttribute(TOKEN_TYPE_ID);
            this.fQueryProviders.remove(tokenTypeId);
            this.fResolvedQueryProvidersCache.remove(tokenTypeId);
            ++n2;
        }
    }

    public void handleBundleStarted(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptors) throws Exception {
    }

    public void handleBundleStopped(String bundleSymbolicName, List<IConfigurationElement> elements, List<Object> descriptor) throws Exception {
    }

    @Override
    public List<IScoredResult> find(Collection<UUID> context, UUID[] owners, String text, String language, String[] searchScope, String constrainType, boolean sortByDate, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        List<IScoredResult> result = Collections.emptyList();
        try {
            try {
                this.fDelegatingAnalyzer.setOverridenLanguage(language);
                PorterStemmingCache.initialize();
                result = this.doFind(context, owners, text, searchScope, constrainType, indexAccess, this.fDelegatingAnalyzer, sortByDate, configFilter);
            }
            catch (BooleanQuery.TooManyClauses tooManyClauses) {
                PorterStemmingCache.clear();
                this.fDelegatingAnalyzer.setOverridenLanguage(null);
            }
        }
        finally {
            PorterStemmingCache.clear();
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
        return result;
    }

    @Override
    public List<IScoredResult> findByContainerReferences(Set<UUID> contexts, UUID[] owners, URIReference[] containerReferences, String[] searchScope, String constrainType, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        int index = 0;
        int length = containerReferences.length;
        List<IScoredResult> result = null;
        int maxClauseCount = BooleanQuery.getMaxClauseCount();
        while (index < length) {
            BooleanQuery query = new BooleanQuery();
            int max = Math.min(index + maxClauseCount, length);
            int i = index;
            while (i < max) {
                URIReference container = containerReferences[i];
                query.add(new BooleanClause((Query)new TermQuery(new Term("_containerId", container.getURI().toString())), BooleanClause.Occur.SHOULD));
                ++i;
            }
            try {
                if (result == null) {
                    result = this.execute(contexts, owners, (Query)query, null, searchScope, indexAccess, constrainType, 1.0f, 1.0f, false, configFilter);
                } else {
                    result.addAll(this.execute(contexts, owners, (Query)query, null, searchScope, indexAccess, constrainType, 1.0f, 1.0f, false, configFilter));
                }
            }
            catch (IOException e) {
                throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, "", searchScope, constrainType), (Object[])new Object[0]), e);
            }
            catch (TeamRepositoryException e) {
                throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, "", searchScope, constrainType), (Object[])new Object[0]), e);
            }
            index += max;
        }
        return result;
    }

    private List<IScoredResult> doFind(Collection<UUID> context, UUID[] owners, String text, String[] searchScope, String constrainType, IIndexAccess indexAccess, Analyzer analyzer, boolean sortByDate, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        try {
            BooleanQuery bQuery = new BooleanQuery();
            text = text.trim();
            if (text.startsWith("\"") && text.endsWith("\"") && text.length() > 1) {
                QuoteAnalyzer quoteAnalyzer = new QuoteAnalyzer(IndexManagerImpl.getInstance().getOptions(true));
                DisjunctionMaxQuery spanQuery = this.createSpanQuery(text, quoteAnalyzer, 0);
                bQuery.add((Query)spanQuery, BooleanClause.Occur.MUST);
            } else {
                ITokenGroup tokenGroup = TokenGroup.createTokenGroup(analyzer, "com.ibm.team.fulltext.service.internal.analysis.DelegatingAnalyzer.ContentWildcardAware", new StringReader(text));
                Set<String> tokenTypes = tokenGroup.getTokenTypes();
                for (String tokenType : tokenTypes) {
                    Query tokenQuery;
                    IQueryProvider queryProvider = this.fDefaultQueryProvider;
                    if (this.fQueryProviders.containsKey(tokenType)) {
                        if (this.fResolvedQueryProvidersCache.containsKey(tokenType)) {
                            queryProvider = this.fResolvedQueryProvidersCache.get(tokenType);
                        } else {
                            queryProvider = (IQueryProvider)this.fQueryProviders.get(tokenType).createExecutableExtension(QUERY_PROVIDER_CLASS_ATTRIBUTE);
                            this.fResolvedQueryProvidersCache.put(tokenType, queryProvider);
                        }
                    }
                    if ((tokenQuery = queryProvider.createQuery(tokenType, analyzer, tokenGroup)) == null) continue;
                    QueryUtils.conditionalAdd(bQuery, tokenQuery, BooleanClause.Occur.MUST);
                }
                DisjunctionMaxQuery spanQuery = this.createSpanQuery(text, analyzer, 2);
                QueryUtils.conditionalAdd(bQuery, (Query)spanQuery, BooleanClause.Occur.SHOULD);
            }
            if (constrainType != null) {
                BooleanQuery constrainTypeQuery = new BooleanQuery();
                constrainTypeQuery.setBoost(0.0f);
                TermQuery artifactTypeQuery = new TermQuery(new Term("_artifactType", constrainType));
                QueryUtils.conditionalAdd(constrainTypeQuery, (Query)artifactTypeQuery, BooleanClause.Occur.SHOULD);
                TermQuery containerTypeQuery = new TermQuery(new Term("_containerType", constrainType));
                QueryUtils.conditionalAdd(constrainTypeQuery, (Query)containerTypeQuery, BooleanClause.Occur.SHOULD);
                QueryUtils.conditionalAdd(bQuery, (Query)constrainTypeQuery, BooleanClause.Occur.MUST);
            }
            return this.execute(context, owners, (Query)bQuery, null, searchScope, indexAccess, constrainType, 0.0f, 1.0f, sortByDate, configFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, text, searchScope, constrainType), (Object[])new Object[0]), e);
        }
        catch (CoreException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, text, searchScope, constrainType), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, text, searchScope, constrainType), (Object[])new Object[0]), e);
        }
    }

    private DisjunctionMaxQuery createSpanQuery(String text, Analyzer analyzer, int slop) throws IOException {
        String[] fields;
        DisjunctionMaxQuery spanQuery = new DisjunctionMaxQuery(0.0f);
        String[] stringArray = fields = new String[]{"_name", "_content", "_meta", "_tags"};
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            ArrayList<SpanTermQuery> spans = new ArrayList<SpanTermQuery>();
            TokenStream tokenStream = analyzer.tokenStream(field, (Reader)new StringReader(text));
            TermAttribute termAtt = (TermAttribute)tokenStream.getAttribute(TermAttribute.class);
            while (tokenStream.incrementToken()) {
                spans.add(new SpanTermQuery(new Term(field, termAtt.term())));
            }
            if (!spans.isEmpty()) {
                SpanNearQuery spanNearQuery = new SpanNearQuery(spans.toArray(new SpanQuery[spans.size()]), slop, true);
                spanQuery.add((Query)spanNearQuery);
                if (field == "_name") {
                    spanNearQuery.setBoost(2.0f);
                }
            }
            ++n2;
        }
        return spanQuery;
    }

    private Filter getQueryFilter(BooleanQuery filter, Collection<UUID> contexts, UUID[] owners) {
        BooleanQuery contextsQuery = null;
        if (contexts != null && !contexts.isEmpty()) {
            contextsQuery = new BooleanQuery();
            contextsQuery.setBoost(0.0f);
            for (UUID context : contexts) {
                TermQuery contextQuery = new TermQuery(new Term("_context", context.getUuidValue()));
                QueryUtils.conditionalAdd(contextsQuery, (Query)contextQuery, BooleanClause.Occur.SHOULD);
            }
        }
        BooleanQuery ownersQuery = null;
        if (owners != null && owners.length > 0) {
            ownersQuery = new BooleanQuery();
            ownersQuery.setBoost(0.0f);
            UUID[] uUIDArray = owners;
            int n = owners.length;
            int contextQuery = 0;
            while (contextQuery < n) {
                UUID owner = uUIDArray[contextQuery];
                TermQuery ownerQuery = new TermQuery(new Term("_owner", owner.getUuidValue()));
                QueryUtils.conditionalAdd(ownersQuery, (Query)ownerQuery, BooleanClause.Occur.SHOULD);
                ++contextQuery;
            }
            BooleanQuery oldOwnersQuery = new BooleanQuery();
            oldOwnersQuery.setBoost(0.0f);
            BooleanQuery oldContextsQuery = new BooleanQuery();
            oldContextsQuery.setBoost(0.0f);
            UUID[] uUIDArray2 = owners;
            int n2 = owners.length;
            int n3 = 0;
            while (n3 < n2) {
                UUID owner = uUIDArray2[n3];
                TermQuery oldContextQuery = new TermQuery(new Term("_context", owner.getUuidValue()));
                QueryUtils.conditionalAdd(oldContextsQuery, (Query)oldContextQuery, BooleanClause.Occur.SHOULD);
                ++n3;
            }
            QueryUtils.conditionalAdd(oldOwnersQuery, (Query)oldContextsQuery, BooleanClause.Occur.MUST);
            TermRangeQuery allOwnersRangeQuery = new TermRangeQuery("_owner", null, null, true, true);
            allOwnersRangeQuery.setBoost(0.0f);
            QueryUtils.conditionalAdd(oldOwnersQuery, (Query)allOwnersRangeQuery, BooleanClause.Occur.MUST_NOT);
            QueryUtils.conditionalAdd(ownersQuery, (Query)oldOwnersQuery, BooleanClause.Occur.SHOULD);
        }
        if (contextsQuery == null && ownersQuery == null) {
            if (filter != null) {
                return new CachingWrapperFilter((Filter)new QueryWrapperFilter((Query)filter));
            }
            return null;
        }
        if (filter != null) {
            if (contextsQuery != null) {
                QueryUtils.conditionalAdd(filter, (Query)contextsQuery, BooleanClause.Occur.MUST);
            }
            if (ownersQuery != null) {
                QueryUtils.conditionalAdd(filter, (Query)ownersQuery, BooleanClause.Occur.MUST);
            }
            return new CachingWrapperFilter((Filter)new QueryWrapperFilter((Query)filter));
        }
        if (contextsQuery != null && ownersQuery == null) {
            return new CachingWrapperFilter((Filter)new QueryWrapperFilter((Query)contextsQuery));
        }
        if (ownersQuery != null && contextsQuery == null) {
            return new CachingWrapperFilter((Filter)new QueryWrapperFilter((Query)ownersQuery));
        }
        BooleanQuery contextAndOwnerQuery = new BooleanQuery();
        contextAndOwnerQuery.setBoost(0.0f);
        QueryUtils.conditionalAdd(contextAndOwnerQuery, (Query)contextsQuery, BooleanClause.Occur.MUST);
        QueryUtils.conditionalAdd(contextAndOwnerQuery, (Query)ownersQuery, BooleanClause.Occur.MUST);
        return new CachingWrapperFilter((Filter)new QueryWrapperFilter((Query)contextAndOwnerQuery));
    }

    @Override
    public List<IScoredResult> findDuplicateByReference(Collection<UUID> context, UUID[] owners, String id, String name, String content, String language, String type, String[] searchScope, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        if (name == null && content == null) {
            return this.doFindDuplicate(context, owners, id, type, searchScope, indexAccess, configFilter);
        }
        try {
            this.fDelegatingAnalyzer.setOverridenLanguage(language);
            List<IScoredResult> list = this.doFindDuplicate(context, owners, id, name, content, type, searchScope, indexAccess, this.fDelegatingAnalyzer, configFilter);
            return list;
        }
        finally {
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
    }

    @Override
    public List<IScoredResult> findDuplicate(Collection<UUID> context, UUID[] owners, String name, String content, String language, String type, String[] searchScope, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        try {
            this.fDelegatingAnalyzer.setOverridenLanguage(language);
            List<IScoredResult> list = this.doFindDuplicate(context, owners, name, content, type, searchScope, indexAccess, this.fDelegatingAnalyzer, configFilter);
            return list;
        }
        finally {
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
    }

    private List<IScoredResult> doFindDuplicate(Collection<UUID> context, UUID[] owners, String id, String type, String[] searchScope, IIndexAccess indexAccess, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        try {
            String constrainType = type;
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(id, type, constrainType, searchScope, indexAccess);
            return this.execute(context, owners, (Query)queries.getFirst(), queries.getSecond(), searchScope, indexAccess, constrainType, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), false, configFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, searchScope, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, searchScope, null), (Object[])new Object[0]), e);
        }
    }

    private List<IScoredResult> doFindDuplicate(Collection<UUID> context, UUID[] owners, String id, String name, String content, String type, String[] searchScope, IIndexAccess indexAccess, Analyzer analyzer, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(id, name, content, type, searchScope, indexAccess, analyzer);
            return this.execute(context, owners, (Query)queries.getFirst(), queries.getSecond(), searchScope, indexAccess, type, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), false, configFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
    }

    private List<IScoredResult> doFindDuplicate(Collection<UUID> context, UUID[] owners, String name, String content, String type, String[] searchScope, IIndexAccess indexAccess, Analyzer analyzer, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(name, content, type, searchScope, indexAccess, analyzer);
            return this.execute(context, owners, (Query)queries.getFirst(), queries.getSecond(), searchScope, indexAccess, type, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), false, configFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, type, String.valueOf(name) + "\n\n" + content, searchScope, null), (Object[])new Object[0]), e);
        }
    }

    @Override
    public List<IScoredResult> findRelatedByReference(Collection<UUID> context, String id, String type, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        return this.doFindRelated(context, id, type, indexAccess, configFilter);
    }

    @Override
    public List<IScoredResult> findRelated(Collection<UUID> context, String name, String content, String language, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        IndexManagerImpl indexManager = IndexManagerImpl.getInstance();
        IIndexAccess indexAccess = indexManager.getIndexAccess();
        try {
            this.fDelegatingAnalyzer.setOverridenLanguage(language);
            List<IScoredResult> list = this.doFindRelated(context, name, content, indexAccess, this.fDelegatingAnalyzer, configFilter);
            return list;
        }
        finally {
            this.fDelegatingAnalyzer.setOverridenLanguage(null);
        }
    }

    private List<IScoredResult> doFindRelated(Collection<UUID> context, String id, String type, IIndexAccess indexAccess, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(id, type, null, null, indexAccess);
            return this.execute(context, null, (Query)queries.getFirst(), queries.getSecond(), null, indexAccess, null, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), false, configFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, null, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(id, type, null, null, null), (Object[])new Object[0]), e);
        }
    }

    private List<IScoredResult> doFindRelated(Collection<UUID> context, String name, String content, IIndexAccess indexAccess, Analyzer analyzer, IQueryManager.IConfigFilter configFilter) throws FulltextException {
        try {
            FindRelatedQueryBuilder queryBuilder = new FindRelatedQueryBuilder();
            QueryUtils.Pair<BooleanQuery, BooleanQuery> queries = queryBuilder.buildQuery(name, content, null, null, indexAccess, analyzer);
            return this.execute(context, null, (Query)queries.getFirst(), queries.getSecond(), null, indexAccess, null, MIN_SCORE_FACTOR_DUPLICATE, this.getScoreNormalizationFactor(queryBuilder), false, configFilter);
        }
        catch (IOException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, String.valueOf(name) + "\n\n" + content, null, null), (Object[])new Object[0]), e);
        }
        catch (TeamRepositoryException e) {
            throw new FulltextException(NLS.bind((String)Messages.getString("QueryManagerImpl.ERROR_EXECUTING_QUERY"), (Object)this.getLogDetails(null, null, String.valueOf(name) + "\n\n" + content, null, null), (Object[])new Object[0]), e);
        }
    }

    private float getScoreNormalizationFactor(FindRelatedQueryBuilder builder) {
        float knownTermCount;
        float unknownTermCount = builder.getUnknownTermCount();
        float allTermCount = unknownTermCount + (knownTermCount = (float)builder.getKnownTermCount());
        if (allTermCount == 0.0f) {
            return 1.0f;
        }
        float unknownTermRatio = unknownTermCount / allTermCount;
        return Math.max(0.1f, 1.0f - unknownTermRatio);
    }

    private List<IScoredResult> execute(Collection<UUID> context, UUID[] owners, Query query, BooleanQuery filter, String[] searchScope, IIndexAccess indexAccess, String constrainType, float minScoreFactor, float maxScoreRatio, final boolean sortByDate, IQueryManager.IConfigFilter configFilter) throws IOException, TeamRepositoryException {
        ArrayList<IScoredResult> allResults = new ArrayList<IScoredResult>();
        HashMap<String, ArrayList<ScoredResultDTO>> resultsByType = new HashMap<String, ArrayList<ScoredResultDTO>>();
        AnalyzerDebugUtils.printQuery(query);
        List<QueryUtils.Pair<Document, Float>> documents = indexAccess.search(searchScope, query, this.getQueryFilter(filter, context, owners), minScoreFactor);
        HashMap<URIReferenceDTO, ScoredResultDTO> mapRefToResult = new HashMap<URIReferenceDTO, ScoredResultDTO>(documents.size());
        final HashMap<ScoredResultDTO, String> mapResultToDate = new HashMap<ScoredResultDTO, String>(sortByDate ? documents.size() : 10);
        int i = 0;
        while (i < documents.size()) {
            ScoredResultDTO existingResult;
            Document document = documents.get(i).getFirst();
            String id = document.get("_id");
            String type = document.get("_artifactType");
            String name = document.get("_artifactName");
            String details = document.get("_artifactDetails");
            if (details == null) {
                details = document.get("_name");
            }
            URIReferenceDTO resultReference = ResultFactory.eINSTANCE.createURIReferenceDTO();
            resultReference.setName(name);
            resultReference.setDetails(details);
            resultReference.setTypeVal(type);
            resultReference.setUriVal(id);
            long score = Math.round(documents.get(i).getSecond().floatValue() * 100000.0f);
            ArrayList<URIReferenceDTO> containerReferences = null;
            String[] containerIds = document.getValues("_containerId");
            if (containerIds != null) {
                containerReferences = new ArrayList<URIReferenceDTO>(containerIds.length);
                String[] containerContexts = document.getValues("_containerContext");
                String[] containerTypes = document.getValues("_containerType");
                String[] containerDetails = document.getValues("_containerDetails");
                String[] containerNames = document.getValues("_containerName");
                int j = 0;
                while (j < containerIds.length) {
                    String containerId = containerIds[j];
                    String containerContext = containerContexts != null && containerContexts.length > j ? containerContexts[j] : null;
                    String containerType = containerTypes[j];
                    String containerDetail = containerDetails[j];
                    String containerName = containerNames[j];
                    if (containerContext == null || context == null || context.isEmpty() || context.contains(UUID.valueOf((String)containerContext))) {
                        URIReferenceDTO containerReference = ResultFactory.eINSTANCE.createURIReferenceDTO();
                        containerReference.setName(containerName);
                        containerReference.setDetails(containerDetail);
                        containerReference.setTypeVal(containerType);
                        containerReference.setUriVal(containerId);
                        containerReferences.add(containerReference);
                    }
                    ++j;
                }
            }
            if (constrainType != null && !type.equals(constrainType) && containerReferences != null) {
                for (URIReferenceDTO containerReference : containerReferences) {
                    if (!containerReference.getTypeVal().equals(constrainType)) continue;
                    resultReference = containerReference;
                    containerReferences = null;
                    break;
                }
            }
            if ((existingResult = (ScoredResultDTO)mapRefToResult.get(resultReference)) != null) {
                long existingScore = existingResult.getScore();
                long newScore = Math.min(100000L, score + existingScore);
                existingResult.setScore(newScore);
            } else {
                String indexDate;
                ScoredResultDTO result = ResultFactory.eINSTANCE.createScoredResultDTO();
                result.setResultValue(resultReference);
                result.setScore((long)((float)score * maxScoreRatio));
                if (containerReferences != null) {
                    result.getContainerValues().addAll(containerReferences);
                }
                if (configFilter != null) {
                    String resultType = result.getResultValue().getTypeVal();
                    ArrayList<ScoredResultDTO> results = (ArrayList<ScoredResultDTO>)resultsByType.get(resultType);
                    if (results == null) {
                        results = new ArrayList<ScoredResultDTO>();
                        resultsByType.put(resultType, results);
                    }
                    results.add(result);
                } else {
                    allResults.add(result);
                }
                mapRefToResult.put(result.getResultValue(), result);
                if (sortByDate && (indexDate = document.get("_indexDate")) != null) {
                    mapResultToDate.put(result, indexDate);
                }
            }
            ++i;
        }
        if (configFilter != null) {
            for (String resultType : resultsByType.keySet()) {
                List results = (List)resultsByType.get(resultType);
                configFilter.filter(results, allResults);
            }
        }
        Collections.sort(allResults, new Comparator<IScoredResult>(){

            @Override
            public int compare(IScoredResult o1, IScoredResult o2) {
                if (sortByDate) {
                    String date1 = (String)mapResultToDate.get(o1);
                    String date2 = (String)mapResultToDate.get(o2);
                    if (date1 != null && date2 != null && !date1.equals(date2)) {
                        return date1.compareTo(date2) * -1;
                    }
                    if (date1 != null && date2 == null) {
                        return -1;
                    }
                }
                if (o1.getScore() == o2.getScore()) {
                    return 0;
                }
                return o1.getScore() > o2.getScore() ? -1 : 1;
            }
        });
        return allResults;
    }

    private String getLogDetails(String id, String type, String text, String[] searchScope, String constrainType) {
        String details = "";
        details = String.valueOf(details) + " [Text: " + text + "] ";
        details = String.valueOf(details) + " [Constrain Type: " + constrainType + "] ";
        details = String.valueOf(details) + " [ID: " + id + "] ";
        details = String.valueOf(details) + " [Type: " + type + "] ";
        if (searchScope != null && searchScope.length != 0) {
            String scopeVal = "";
            String[] stringArray = searchScope;
            int n = searchScope.length;
            int n2 = 0;
            while (n2 < n) {
                String scope = stringArray[n2];
                scopeVal = String.valueOf(scopeVal) + scope + " ";
                ++n2;
            }
            details = String.valueOf(details) + " [Search Scope: " + scopeVal + "] ";
        } else {
            details = String.valueOf(details) + " [Search Scope: null] ";
        }
        return details;
    }
}

