/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.daemon.trace;

import com.ibm.team.filesystem.client.daemon.events.ILightweightEvent;
import com.ibm.team.filesystem.client.daemon.events.ILightweightEventListener;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.daemon.Messages;
import com.ibm.team.filesystem.client.internal.daemon.trace.DaemonTracer;
import com.ibm.team.filesystem.client.internal.daemon.trace.reader.FilesystemLogDirectory;
import com.ibm.team.filesystem.client.internal.daemon.trace.reader.ILogDirectory;
import com.ibm.team.filesystem.client.internal.utils.FilesystemLock;
import com.ibm.team.filesystem.client.restproxy.Discovery2;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class RotatingDaemonTracer
implements ILightweightEventListener<ILightweightEvent> {
    private static final Log log = LogFactory.getLog((String)RotatingDaemonTracer.class.getName());
    private static final String SUFFIX_DAEMONTRACE = ".daemontrace";
    private static final String SUFFIX_DAEMONTRACE_GZ = ".daemontrace.gz";
    private long LOG_DIR_LOCKTIME = 20000L;
    private static final int MAX_QUEUE_SIZE = 2048;
    private static final int BATCH_SIZE = 1024;
    private DaemonTracer tracer;
    private final Discovery2.AutoTracingParams params;
    private final File logBase;
    private final FilesystemLock logDirLock;
    private LinkedList<ILightweightEvent> eventQueue = new LinkedList();
    private Thread eventQueueSink = null;
    public static final SimpleDateFormat FMT = new SimpleDateFormat("yyyy-MM-dd-HH.mm.ss.SSS");
    public static FilenameFilter FILTER_LOGFILE = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            String dateString;
            try {
                dateString = RotatingDaemonTracer.getNameWithoutSuffix(name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            try {
                FMT.parse(dateString);
            }
            catch (ParseException parseException) {
                return false;
            }
            return true;
        }
    };

    public RotatingDaemonTracer(Discovery2.AutoTracingParams params, File baseRoot) {
        this.params = params;
        File candidateLogBase = params.getLogDirectory() == null ? baseRoot : params.getLogDirectory();
        if (!candidateLogBase.exists()) {
            candidateLogBase.mkdirs();
        }
        if (!candidateLogBase.exists() || !candidateLogBase.isDirectory()) {
            this.logBase = null;
            this.logDirLock = null;
            return;
        }
        this.logBase = candidateLogBase;
        this.logDirLock = new FilesystemLock(new File(this.logBase, ".lock"));
        this.tracer = this.createLogFile();
    }

    @Override
    public void handleEvent(ILightweightEvent event) {
        try {
            this.doHandleEvent(event);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleEvent(ILightweightEvent event) {
        if (this.tracer == null) {
            return;
        }
        LinkedList<ILightweightEvent> linkedList = this.eventQueue;
        synchronized (linkedList) {
            int eventQueueSize = this.eventQueue.size();
            if (eventQueueSize > 2048) {
                int toDrop = eventQueueSize - 2048 + 512;
                this.dropEvents(toDrop, new EventQueueTooLargeEvent(toDrop));
            }
            this.startEventQueueSink();
            this.eventQueue.add(event);
            this.eventQueue.notifyAll();
        }
    }

    private void dropEvents(int toRemove, IDroppedEvent dropEvent) {
        int removedEvents = 0;
        ListIterator iterator = this.eventQueue.listIterator();
        while (iterator.hasNext()) {
            ILightweightEvent e = (ILightweightEvent)iterator.next();
            if (!(e instanceof IDroppedEvent) && !(e instanceof FSDaemon.IShutdownEvent)) {
                iterator.remove();
                ++removedEvents;
            }
            if (removedEvents == toRemove) break;
        }
        this.eventQueue.addFirst(dropEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startEventQueueSink() {
        LinkedList<ILightweightEvent> linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (this.eventQueueSink != null) {
                if (this.eventQueueSink.getState() == Thread.State.NEW || this.eventQueueSink.isAlive()) {
                    return;
                }
                this.eventQueueSink = null;
                int eventQueueSize = this.eventQueue.size();
                if (eventQueueSize > 2048) {
                    int toDrop = eventQueueSize - 2048 + 512;
                    this.dropEvents(toDrop, this.createDeadEventQueueSinkEvent(toDrop));
                } else {
                    this.eventQueue.add(this.createDeadEventQueueSinkEvent(0));
                }
            }
            this.eventQueueSink = new Thread(new Runnable(){

                @Override
                public void run() {
                    RotatingDaemonTracer.this.handleEventAsynchronously();
                }
            });
            this.eventQueueSink.setName("Daemon logger");
            this.eventQueueSink.start();
        }
    }

    private IDroppedEvent createDeadEventQueueSinkEvent(final int size) {
        return new IDroppedEvent(){

            public String toString() {
                if (size > 0) {
                    return NLS.bind((String)Messages.getString("RotatingDaemonTracer_DEAD_EVENT_QUEUE_SINK_AND_FLUSH"), (Object)size);
                }
                return Messages.getString("RotatingDaemonTracer_DEAD_EVENT_QUEUE_SINK");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEventAsynchronously() {
        ArrayList<ILightweightEvent> batch = new ArrayList<ILightweightEvent>(1024);
        while (true) {
            boolean haveShutdownEvent = false;
            LinkedList<ILightweightEvent> linkedList = this.eventQueue;
            synchronized (linkedList) {
                if (this.eventQueue.isEmpty()) {
                    try {
                        this.eventQueue.wait();
                    }
                    catch (InterruptedException e) {
                        log.error((Object)e);
                        continue;
                    }
                }
                try {
                    if (this.eventQueue.size() < 1024) {
                        batch.addAll(this.eventQueue);
                        this.eventQueue.clear();
                    } else {
                        List subList = this.eventQueue.subList(0, 1024);
                        batch.addAll(subList);
                        subList.clear();
                    }
                }
                catch (NoSuchElementException e) {
                    log.error((Object)e);
                    continue;
                }
            }
            if (this.tracer != null) {
                haveShutdownEvent = this.tracer.handleEvents(batch);
                batch.clear();
            }
            if (haveShutdownEvent) {
                return;
            }
            this.cleanLogDir();
        }
    }

    private void cleanLogDir() {
        if (this.tracer == null) {
            return;
        }
        File current = this.tracer.getOutputFile();
        long len = current.length();
        if (len > this.params.getMaxSizeForLog()) {
            this.rotateLogFile(current);
            this.purgeStaleLogs();
        }
    }

    private IStatus purgeStaleLogs() {
        IStatus acquireResult = this.logDirLock.acquire(this.LOG_DIR_LOCKTIME, null);
        if (!acquireResult.isOK()) {
            return acquireResult;
        }
        try {
            FilesystemLogDirectory logDir = new FilesystemLogDirectory(this.logBase);
            long total = 0L;
            ILogDirectory.ILogDirectoryEntry[] entries = logDir.getEntries();
            try {
                ILogDirectory.ILogDirectoryEntry[] iLogDirectoryEntryArray = entries;
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    ILogDirectory.ILogDirectoryEntry entry = iLogDirectoryEntryArray[n2];
                    total += entry.getSize();
                    ++n2;
                }
                int i = 0;
                while (total > this.params.getMaxSizeOfRotatedLogs()) {
                    FilesystemLogDirectory.FilesystemLogDirectoryEntry entry = (FilesystemLogDirectory.FilesystemLogDirectoryEntry)entries[i++];
                    total -= entry.getSize();
                    entry.delete();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        finally {
            this.logDirLock.release(null);
        }
        return Status.OK_STATUS;
    }

    private IStatus rotateLogFile(File current) {
        block16: {
            try {
                IStatus acquireResult = this.logDirLock.acquire(this.LOG_DIR_LOCKTIME, null);
                if (!acquireResult.isOK()) {
                    IStatus iStatus = acquireResult;
                    return iStatus;
                }
                try {
                    if (!this.params.getCompressRotatedLogs()) break block16;
                    try {
                        File zipped = new File(current.getParent(), String.valueOf(current.getName()) + ".gz");
                        FileInputStream in = new FileInputStream(current);
                        try {
                            FileOutputStream out = new FileOutputStream(zipped);
                            try {
                                GZIPOutputStream gzipOut = new GZIPOutputStream(out);
                                RotatingDaemonTracer.transfer(in, gzipOut);
                                gzipOut.close();
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                    current.delete();
                }
                finally {
                    this.logDirLock.release(null);
                }
            }
            finally {
                this.tracer = this.createLogFile();
            }
        }
        return Status.OK_STATUS;
    }

    public static void transfer(InputStream in, OutputStream out) throws IOException {
        byte[] bytes = new byte[32000];
        try {
            int len = in.read(bytes);
            while (len > -1) {
                out.write(bytes, 0, len);
                len = in.read(bytes);
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    private DaemonTracer createLogFile() {
        IStatus acquireResult;
        if (this.logDirLock == null) {
            return null;
        }
        String extraComment = null;
        if (this.tracer != null) {
            extraComment = "Continued from " + this.tracer.getOutputFile().getAbsolutePath();
        }
        if ((acquireResult = this.logDirLock.acquire(this.LOG_DIR_LOCKTIME, null)).isOK()) {
            try {
                String logName = String.valueOf(FMT.format(new Date())) + SUFFIX_DAEMONTRACE;
                DaemonTracer daemonTracer = new DaemonTracer(new File(this.logBase, logName), extraComment);
                return daemonTracer;
            }
            finally {
                this.logDirLock.release(null);
            }
        }
        log.error((Object)acquireResult);
        return null;
    }

    public void join() throws InterruptedException {
        this.eventQueueSink.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList<ILightweightEvent> linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (this.eventQueueSink == null) {
                return;
            }
            this.handleEvent(new FSDaemon.IShutdownEvent(){

                @Override
                public FSDaemon getDaemon() {
                    return null;
                }
            });
        }
    }

    public static String getNameWithoutSuffix(String name) throws IllegalArgumentException {
        if (!name.endsWith(SUFFIX_DAEMONTRACE) && !name.endsWith(SUFFIX_DAEMONTRACE_GZ)) {
            throw new IllegalArgumentException("Bad name: " + name);
        }
        try {
            return name.substring(0, FMT.toPattern().length());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Bad date format: " + name);
        }
    }

    public static InputStream getInputStreamForLogFile(ILogDirectory.ILogDirectoryEntry next) throws IOException {
        String name = next.getName();
        if (name.endsWith(SUFFIX_DAEMONTRACE)) {
            return next.getContent();
        }
        if (name.endsWith(SUFFIX_DAEMONTRACE_GZ)) {
            return new GZIPInputStream(next.getContent());
        }
        throw new IllegalArgumentException("Unknown suffix: " + name);
    }

    private static class EventQueueTooLargeEvent
    implements IDroppedEvent {
        private final int droppedEvents;

        public EventQueueTooLargeEvent(int droppedEvents) {
            this.droppedEvents = droppedEvents;
        }

        public String toString() {
            return NLS.bind((String)Messages.getString("RotatingDaemonTracer_EVENT_QUEUE_TOO_LARGE"), (Object)this.droppedEvents);
        }
    }

    public static interface IDroppedEvent
    extends ILightweightEvent {
    }
}

