/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.ApplicationEnvironment;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;

public class EnvironmentReservation
extends ClientEntity<EnvironmentReservation> {
    public Long startDate;
    public Long endDate;
    public Phase phase;
    public ReleaseEnvironment environment;
    @Deprecated
    public String[] environments;
    @Deprecated
    @JsonReadOnly
    public String environmentName;
    @SerializedName(value="applicationTargets")
    @JsonReadOnly
    public ApplicationEnvironment[] applicationEnvironments;
    @JsonReadOnly
    public ReservationConflict[] conflicts;
    @JsonReadOnly
    public ReservationConflict[] warnings;

    public EnvironmentReservation() {
        this.path = "/environmentReservations/";
        this.oldPath = "/environmentReservation/";
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public EnvironmentReservation setStartDate(Long startDate) {
        return this.startDate(startDate);
    }

    public EnvironmentReservation startDate(Long startDate) {
        this.handleNull(startDate, "startDate");
        this.startDate = startDate;
        return this;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public EnvironmentReservation setEndDate(Long endDate) {
        return this.endDate(endDate);
    }

    public EnvironmentReservation endDate(Long endDate) {
        this.handleNull(endDate, "endDate");
        this.endDate = endDate;
        return this;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public EnvironmentReservation setPhase(Phase phase) {
        return this.phase(phase);
    }

    public EnvironmentReservation phase(Phase phase) {
        this.handleNull(phase, "phase");
        this.phase = phase;
        return this;
    }

    public ReleaseEnvironment getEnvironment() {
        return this.environment;
    }

    public EnvironmentReservation setEnvironment(ReleaseEnvironment environment) {
        return this.environment(environment);
    }

    public EnvironmentReservation environment(ReleaseEnvironment environment) {
        this.handleNull(environment, "environment");
        this.environment = environment;
        return this;
    }

    public ReleaseEnvironment[] getAvailableEnvironments(long startTime, long endTime) {
        String extraParams = "?startDate=" + startTime + "&endDate=" + endTime + "&withConflicts=true&phaseId=" + this.phase.id;
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).statusCode(200).when().get(this.path() + "environments" + extraParams, new Object[0])).as(ReleaseEnvironment[].class, ObjectMapperType.GSON);
    }

    @Deprecated
    public EnvironmentReservation environments(ReleaseEnvironment ... environments) {
        this.handleNull(environments, "environments");
        this.environments = EnvironmentReservation.ids(environments);
        return this;
    }

    @Deprecated
    public String getEnvironmentName() {
        return this.environmentName;
    }

    public ApplicationEnvironment[] getApplicationEnvironments() {
        return this.applicationEnvironments;
    }

    public ReservationConflict[] getConflicts() {
        return this.conflicts;
    }

    public ReservationConflict[] getWarnings() {
        return this.warnings;
    }

    public static class ConflictingApplicationEnvironment {
        @JsonReadOnly
        public String name;
        @JsonReadOnly
        public String application;

        public String getName() {
            return this.name;
        }

        public String getApplication() {
            return this.application;
        }
    }

    public static class ReservationConflict {
        @JsonReadOnly
        public String startDate;
        @JsonReadOnly
        public String endDate;
        @JsonReadOnly
        public String release;
        @JsonReadOnly
        public String environment;
        @JsonReadOnly
        public String phase;
        @JsonReadOnly
        public ConflictingApplicationEnvironment[] targets;

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public String getRelease() {
            return this.release;
        }

        public String getEnvironment() {
            return this.environment;
        }

        public String getPhase() {
            return this.phase;
        }

        public ConflictingApplicationEnvironment[] getTargets() {
            return this.targets;
        }
    }
}

