/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.guice.spi.container;

import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.spi.BindingScopingVisitor;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCInstantiatedComponentProvider;
import com.sun.jersey.core.spi.component.ioc.IoCManagedComponentProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceComponentProviderFactory
implements IoCComponentProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(GuiceComponentProviderFactory.class.getName());
    private final Map<Scope, ComponentScope> scopeMap = this.createScopeMap();
    private final Injector injector;

    public GuiceComponentProviderFactory(ResourceConfig config, Injector injector) {
        this.injector = injector;
        this.register(config, injector);
    }

    private void register(ResourceConfig config, Injector injector) {
        while (injector != null) {
            for (Key key : injector.getBindings().keySet()) {
                Type type = key.getTypeLiteral().getType();
                if (!(type instanceof Class)) continue;
                Class c = (Class)type;
                if (ResourceConfig.isProviderClass((Class)c)) {
                    LOGGER.info("Registering " + c.getName() + " as a provider class");
                    config.getClasses().add(c);
                    continue;
                }
                if (!ResourceConfig.isRootResourceClass((Class)c)) continue;
                LOGGER.info("Registering " + c.getName() + " as a root resource class");
                config.getClasses().add(c);
            }
            injector = injector.getParent();
        }
    }

    public IoCComponentProvider getComponentProvider(Class c) {
        return this.getComponentProvider(null, c);
    }

    public IoCComponentProvider getComponentProvider(ComponentContext cc, Class clazz) {
        Key key;
        Injector i;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getComponentProvider(" + clazz.getName() + ")");
        }
        if ((i = this.findInjector(key = Key.get((Class)clazz))) == null) {
            if (!this.isImplicitGuiceComponent(clazz)) {
                return null;
            }
            try {
                if (this.injector.getBinding(key) != null) {
                    LOGGER.info("Binding " + clazz.getName() + " to GuiceInstantiatedComponentProvider");
                    return new GuiceInstantiatedComponentProvider(this.injector, clazz);
                }
            }
            catch (ConfigurationException e) {
                LOGGER.log(Level.INFO, "Cannot bind " + clazz.getName(), e);
                throw e;
            }
        }
        final Scope[] scope = new Scope[1];
        i.getBinding(key).acceptScopingVisitor((BindingScopingVisitor)new BindingScopingVisitor<Void>(){

            public Void visitEagerSingleton() {
                scope[0] = Scopes.SINGLETON;
                return null;
            }

            public Void visitScope(Scope theScope) {
                scope[0] = theScope;
                return null;
            }

            public Void visitScopeAnnotation(Class scopeAnnotation) {
                throw new UnsupportedOperationException();
            }

            public Void visitNoScoping() {
                scope[0] = Scopes.NO_SCOPE;
                return null;
            }
        });
        assert (scope[0] != null);
        ComponentScope componentScope = this.getComponentScope(scope[0]);
        LOGGER.info("Binding " + clazz.getName() + " to GuiceManagedComponentProvider with the scope \"" + componentScope + "\"");
        return new GuiceManagedComponentProvider(i, componentScope, clazz);
    }

    private Injector findInjector(Key<?> key) {
        for (Injector i = this.injector; i != null; i = i.getParent()) {
            if (!i.getBindings().containsKey(key)) continue;
            return i;
        }
        return null;
    }

    private ComponentScope getComponentScope(Scope scope) {
        ComponentScope cs = this.scopeMap.get(scope);
        return cs != null ? cs : ComponentScope.Undefined;
    }

    public boolean isImplicitGuiceComponent(Class<?> c) {
        for (Constructor<?> con : c.getConstructors()) {
            if (!con.isAnnotationPresent(Inject.class)) continue;
            return true;
        }
        return false;
    }

    public Map<Scope, ComponentScope> createScopeMap() {
        HashMap<Scope, ComponentScope> result = new HashMap<Scope, ComponentScope>();
        result.put(Scopes.SINGLETON, ComponentScope.Singleton);
        result.put(Scopes.NO_SCOPE, ComponentScope.PerRequest);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GuiceManagedComponentProvider
    extends GuiceInstantiatedComponentProvider
    implements IoCManagedComponentProvider {
        private final ComponentScope scope;

        public GuiceManagedComponentProvider(Injector injector, ComponentScope scope, Class<?> clazz) {
            super(injector, clazz);
            this.scope = scope;
        }

        public ComponentScope getScope() {
            return this.scope;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GuiceInstantiatedComponentProvider
    implements IoCInstantiatedComponentProvider {
        private final Injector injector;
        private final Class<?> clazz;

        public GuiceInstantiatedComponentProvider(Injector injector, Class<?> clazz) {
            this.injector = injector;
            this.clazz = clazz;
        }

        public Class<?> getInjectableClass(Class<?> c) {
            return c.getSuperclass();
        }

        public Object getInjectableInstance(Object o) {
            return o;
        }

        public Object getInstance() {
            return this.injector.getInstance(this.clazz);
        }
    }
}

