/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.restproxy.notification;

import com.ibm.team.filesystem.client.daemon.OrderlyShutdownNotification;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMessageException;
import com.ibm.team.filesystem.client.restproxy.notification.ClientNotificationChannel;
import com.ibm.team.filesystem.client.restproxy.notification.Notification;
import com.ibm.team.filesystem.client.restproxy.notification.NotificationMarshaller;
import com.ibm.team.repository.common.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class NotificationJob
extends Job {
    private static String PLUGIN_ID = "com.ibm.team.filesystem.client.daemon";
    private static final Log log = LogFactory.getLog((String)NotificationJob.class.getName());
    private final ClientNotificationChannel channel;
    private final NotificationMarshaller marshaller = new NotificationMarshaller();
    private final String uri;
    private final String key;
    private final Object waitLock = new Object();
    private boolean isConnected = false;
    private volatile boolean shouldShutdown = false;
    private HttpMethod request;

    public NotificationJob(String name, String key, ClientNotificationChannel channel, String uri) {
        super(name);
        this.channel = channel;
        this.uri = uri;
        this.key = key;
        this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                Object object = NotificationJob.this.waitLock;
                synchronized (object) {
                    NotificationJob.this.waitLock.notifyAll();
                }
            }
        });
        this.setSystem(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        if (this.shouldShutdown) {
            return Status.OK_STATUS;
        }
        GetMethod get = new GetMethod();
        Object object = this.waitLock;
        synchronized (object) {
            this.request = get;
        }
        try {
            get.setURI(new URI(this.uri, true));
        }
        catch (URIException e) {
            log.error((Object)("Unable to set URI: " + this.uri), (Throwable)e);
            return new Status(4, PLUGIN_ID, "Could not generate URI " + this.uri, (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error((Object)("Unable to set URI: " + this.uri), (Throwable)e);
            return new Status(4, PLUGIN_ID, "Could not generate URI " + this.uri, (Throwable)e);
        }
        get.addRequestHeader("X-Secret-Key", this.key);
        this.channel.getClient().beginRequest();
        if (this.channel.getClient().isShutdown()) {
            this.channel.getClient().endRequest();
            return Status.OK_STATUS;
        }
        try {
            try {
                this.channel.getClient().client.executeMethod((HttpMethod)get);
                InputStream s = get.getResponseBodyAsStream();
                Object object2 = this.waitLock;
                synchronized (object2) {
                    this.isConnected = true;
                    this.waitLock.notifyAll();
                }
                try {
                    while (this.readNotification(s)) {
                    }
                }
                catch (Throwable throwable) {
                    Object object3 = this.waitLock;
                    synchronized (object3) {
                        this.isConnected = false;
                        if (!this.shouldShutdown) {
                            this.schedule();
                        }
                    }
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                Object object4 = this.waitLock;
                synchronized (object4) {
                    this.isConnected = false;
                    if (!this.shouldShutdown) {
                        this.schedule();
                    }
                }
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
            catch (HttpException e) {
                log.error((Object)("Problem during get: " + this.uri), (Throwable)e);
                Status status = new Status(4, PLUGIN_ID, "Could execute get: " + this.uri, (Throwable)e);
                try {
                    get.releaseConnection();
                }
                finally {
                    this.channel.getClient().endRequest();
                }
                return status;
            }
            catch (IOException e) {
                log.error((Object)("Problem during get: " + this.uri), (Throwable)e);
                Status status = new Status(4, PLUGIN_ID, "Could execute get: " + this.uri, (Throwable)e);
                try {
                    get.releaseConnection();
                }
                finally {
                    this.channel.getClient().endRequest();
                }
                return status;
            }
            catch (RuntimeException e) {
                log.error((Object)("Problem during get: " + this.uri), (Throwable)e);
                Status status = new Status(4, PLUGIN_ID, "Could execute get: " + this.uri, (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    get.releaseConnection();
                }
                finally {
                    this.channel.getClient().endRequest();
                }
                return status;
            }
        }
        finally {
            try {
                get.releaseConnection();
            }
            finally {
                this.channel.getClient().endRequest();
            }
        }
        return Status.OK_STATUS;
    }

    public boolean readNotification(InputStream in) throws IOException {
        Notification n;
        try {
            n = this.marshaller.read(in, this.channel);
        }
        catch (RestMessageException e) {
            log.error((Object)"Exception deserializing", (Throwable)e);
            if (e.isRecoverable()) {
                return !this.shouldShutdown;
            }
            return false;
        }
        catch (SocketException socketException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        if (n == null) {
            return false;
        }
        if ("orderlyShutdown".equals(n.getKey()) && OrderlyShutdownNotification.TYPE.equals(n.getType())) {
            this.shouldShutdown = true;
        }
        this.channel.notificationReceived(n);
        return !this.shouldShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        Object object = this.waitLock;
        synchronized (object) {
            this.shouldShutdown = false;
            this.schedule();
            try {
                while (!this.isConnected && !this.shouldShutdown && this.getState() != 0) {
                    this.waitLock.wait();
                }
            }
            catch (InterruptedException e) {
                log.info((Object)"Unexpected interrupt", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.waitLock;
        synchronized (object) {
            this.shouldShutdown = true;
            if (this.request != null) {
                this.request.abort();
            }
            this.waitLock.notifyAll();
        }
    }
}

