/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.util;

import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetWorkItemCriteria;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableFileDesc2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubset2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetSubsetCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.dto.IBuildableSubsetWorkItemCriteria2;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.buildablesubset.common.util.Constants;
import com.ibm.team.repository.common.UUID;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class BuildableSubsetSerializer
implements Constants {
    private BuildableSubsetSerializer() {
    }

    public static void serialize(Object object, Object subset, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        if (object instanceof IBuildableSubset) {
            BuildableSubsetSerializer.serializeSubset((IBuildableSubset)object, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        } else if (object instanceof IBuildableFileDesc) {
            BuildableSubsetSerializer.serializeBuildableFileDesc((IBuildableFileDesc)object, subset instanceof IBuildableSubset ? (IBuildableSubset)subset : null, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        } else if (object instanceof IBuildableSubsetWorkItemCriteria) {
            BuildableSubsetSerializer.serializeCriterion((IBuildableSubsetWorkItemCriteria)object, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        } else if (object instanceof IBuildableSubsetSubsetCriteria) {
            BuildableSubsetSerializer.serializeCriterion((IBuildableSubsetSubsetCriteria)object, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        } else if (object instanceof IBuildableSubset2) {
            BuildableSubsetSerializer.serializeSubset((IBuildableSubset2)object, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        } else if (object instanceof IBuildableFileDesc2) {
            BuildableSubsetSerializer.serializeBuildableFileDesc((IBuildableFileDesc2)object, subset instanceof IBuildableSubset2 ? (IBuildableSubset2)subset : null, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        } else if (object instanceof IBuildableSubsetWorkItemCriteria2) {
            BuildableSubsetSerializer.serializeCriterion((IBuildableSubsetWorkItemCriteria2)object, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        } else if (object instanceof IBuildableSubsetSubsetCriteria2) {
            BuildableSubsetSerializer.serializeCriterion((IBuildableSubsetSubsetCriteria2)object, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        }
    }

    public static String serializeSubset(IBuildableSubset subset, String repositoryLocation, boolean ignoreDynamicallyResolvedElements) {
        if (subset != null) {
            StringBuilder buf = new StringBuilder(1000);
            BuildableSubsetSerializer.serializeSubset(subset, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
            return buf.toString();
        }
        return "";
    }

    public static String serializeSubset(IBuildableSubset2 subset, String repositoryLocation, boolean ignoreDynamicallyResolvedElements) {
        if (subset != null) {
            StringBuilder buf = new StringBuilder(1000);
            BuildableSubsetSerializer.serializeSubset(subset, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
            return buf.toString();
        }
        return "";
    }

    public static void serializeSubset(IBuildableSubset subset, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        if (subset != null) {
            String visibility = subset.getVisibility() == null ? null : subset.getVisibility().name();
            BuildableSubsetSerializer.serializeSubset(subset, buf, repositoryLocation, subset.getNewSlug(), subset.getLabel(), subset.getDescription(), subset.getBuildDefinitionUUID(), subset.getWorkspaceUUID(), subset.getOwnerID(), visibility, subset.getBuildableFileDescs(), subset.getCriteria(), ignoreDynamicallyResolvedElements);
        }
    }

    public static void serializeSubset(IBuildableSubset2 subset, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        if (subset != null) {
            String slug = BuildableSubsetUtil.getSlug(subset.getLabel(), subset.getBuildDefinition().getItemId().getUuidValue());
            String buildDefinitionUUID = subset.getBuildDefinition() == null ? null : subset.getBuildDefinition().getItemId().getUuidValue();
            String workspaceUUID = subset.getWorkspace() == null ? null : subset.getWorkspace().getItemId().getUuidValue();
            String ownerID = subset.getOwner() == null ? null : subset.getOwner().getItemId().getUuidValue();
            String visibility = subset.getVisibility() == null ? null : subset.getVisibility().getName();
            BuildableSubsetSerializer.serializeSubset(subset, buf, repositoryLocation, slug, subset.getLabel(), subset.getDescription(), buildDefinitionUUID, workspaceUUID, ownerID, visibility, subset.getBuildableFileDescs(), subset.getCriteria(), ignoreDynamicallyResolvedElements);
        }
    }

    private static void serializeSubset(Object subset, StringBuilder buf, String repositoryLocation, String slug, String label, String description, String buildDefinitionUUID, String workspaceUUID, String ownerID, String visibility, List<?> buildableFiles, List<?> criteria, boolean ignoreDynamicallyResolvedElements) {
        String buildableSubsetNamespace = String.valueOf(repositoryLocation.endsWith("/") ? repositoryLocation : String.valueOf(repositoryLocation) + "/") + "storage" + "/" + "team_enterprise_buildablesubset" + "/" + slug;
        BuildableSubsetSerializer.internalSerializeSubset(subset, buf, repositoryLocation, buildableSubsetNamespace, label, description, buildDefinitionUUID, workspaceUUID, ownerID, visibility, buildableFiles, criteria, ignoreDynamicallyResolvedElements);
    }

    private static void internalSerializeSubset(Object subset, StringBuilder buf, String repositoryLocation, String buildableSubsetNamespace, String label, String description, String buildDefinitionUUID, String workspaceUUID, String ownerID, String visibility, List<?> buildableFiles, List<?> criteria, boolean ignoreDynamicallyResolvedElements) {
        buf.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:ns1=\"http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/\">\n  <rdf:Description rdf:about=");
        buf.append("\"" + buildableSubsetNamespace + "\">\n");
        buf.append("  <ns1:label>" + label + "</ns1:" + "label" + ">\n");
        try {
            buf.append("  <ns1:description>" + (description == null ? "" : URLEncoder.encode(description, "UTF-8")) + "</ns1:" + "description" + ">\n");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            buf.append("  <ns1:description>" + (description == null ? "" : description) + "</ns1:" + "description" + ">\n");
        }
        if (buildDefinitionUUID != null && !buildDefinitionUUID.isEmpty()) {
            buf.append("  <ns1:buildDefinitionUUID>" + buildDefinitionUUID + "</ns1:" + "buildDefinitionUUID" + ">\n");
        }
        if (workspaceUUID != null && !workspaceUUID.isEmpty()) {
            buf.append("  <ns1:workspaceUUID>" + workspaceUUID + "</ns1:" + "workspaceUUID" + ">\n");
        }
        if (ownerID != null && !ownerID.isEmpty()) {
            buf.append("  <ns1:ownerId>" + ownerID + "</ns1:" + "ownerId" + ">\n");
        }
        if (visibility != null) {
            buf.append("  <ns1:visibility>" + visibility + "</ns1:" + "visibility" + ">\n");
        }
        if (buildableFiles != null) {
            for (Object fileDesc : buildableFiles) {
                BuildableSubsetSerializer.serialize(fileDesc, subset, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
            }
        }
        if (criteria != null) {
            for (Object criterion : criteria) {
                BuildableSubsetSerializer.serialize(criterion, subset, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
            }
        }
        buf.append("  </rdf:Description>\n </rdf:RDF>");
    }

    public static void serializeBuildableFileDesc(IBuildableFileDesc fileDesc, IBuildableSubset subset, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        BuildableSubsetSerializer.serializeBuildableFileDesc(buf, repositoryLocation, fileDesc.getComponentId(), fileDesc.getFileItemId(), fileDesc.getScmPath(), fileDesc.getCriteriaReferences(), ignoreDynamicallyResolvedElements, subset);
    }

    public static void serializeBuildableFileDesc(IBuildableFileDesc2 fileDesc, IBuildableSubset2 subset, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        BuildableSubsetSerializer.serializeBuildableFileDesc(buf, repositoryLocation, fileDesc.getComponent().getItemId().getUuidValue(), fileDesc.getFileItem().getItemId().getUuidValue(), fileDesc.getScmPath(), fileDesc.getCriteriaReferences(), ignoreDynamicallyResolvedElements, subset);
    }

    private static void serializeBuildableFileDesc(StringBuilder buf, String repositoryLocation, String componentId, String fileItemId, String scmPath, List<String> references, boolean ignoreDynamicallyResolvedElements, Object subset) {
        if (ignoreDynamicallyResolvedElements && subset != null && !references.isEmpty()) {
            boolean bl;
            ArrayList<String> dynamicUUIDs = new ArrayList<String>();
            if (subset instanceof IBuildableSubset) {
                for (IBuildableSubsetCriteria iBuildableSubsetCriteria : ((IBuildableSubset)subset).getCriteria()) {
                    if (!iBuildableSubsetCriteria.isDynamic() || iBuildableSubsetCriteria.getUUID() == null) continue;
                    dynamicUUIDs.add(iBuildableSubsetCriteria.getUUID().getUuidValue());
                }
            } else if (subset instanceof IBuildableSubset2) {
                for (IBuildableSubsetCriteria2 iBuildableSubsetCriteria2 : ((IBuildableSubset2)subset).getCriteria()) {
                    if (!iBuildableSubsetCriteria2.isDynamic() || iBuildableSubsetCriteria2.getUUID() == null) continue;
                    dynamicUUIDs.add(iBuildableSubsetCriteria2.getUUID().getUuidValue());
                }
            }
            boolean bl2 = true;
            for (String ref : references) {
                String uuid = ref;
                int slash = uuid.indexOf(47);
                if (slash != -1) {
                    uuid = uuid.substring(0, slash);
                }
                if (dynamicUUIDs.contains(uuid)) continue;
                bl = false;
                break;
            }
            if (bl) {
                return;
            }
        }
        buf.append("  <ns1:fileDesc>_componentId=" + componentId + "_fileItemId=" + fileItemId);
        if (scmPath != null && !scmPath.isEmpty()) {
            buf.append("_scmPath=").append(scmPath);
        }
        buf.append("</ns1:fileDesc>\n");
        for (String ref : references) {
            if (ref.isEmpty()) continue;
            buf.append("  <ns1:fileDescRef>");
            buf.append(ref);
            buf.append("</ns1:fileDescRef>\n");
        }
    }

    public static void serializeCriterion(IBuildableSubsetWorkItemCriteria criterion, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        BuildableSubsetSerializer.serializeWorkItemCriterion(buf, repositoryLocation, criterion.getUUID(), criterion.isDynamic(), criterion.isIncludeChildren(), criterion.isIncludeImpacted(), criterion.getWorkItems(), criterion.getAdditionalWorkItems(), ignoreDynamicallyResolvedElements);
    }

    public static void serializeCriterion(IBuildableSubsetWorkItemCriteria2 criterion, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        BuildableSubsetSerializer.serializeWorkItemCriterion(buf, repositoryLocation, criterion.getUUID(), criterion.isDynamic(), criterion.isIncludeChildren(), criterion.isIncludeImpacted(), criterion.getWorkItems(), criterion.getAdditionalWorkItems(), ignoreDynamicallyResolvedElements);
    }

    private static void serializeWorkItemCriterion(StringBuilder buf, String repositoryLocation, UUID uuid, boolean isDynamic, boolean isIncludeChildren, boolean isIncludeImpacted, List<Integer> workItems, List<Integer> additionalWorkItems, boolean ignoreDynamicallyResolvedElements) {
        boolean comma;
        buf.append("  <ns1:criteria>\n");
        buf.append("    <ns1:type>workItem</ns1:type>\n");
        buf.append("    <ns1:uuid>" + uuid.getUuidValue() + "</ns1:" + "uuid" + ">\n");
        buf.append("    <ns1:dynamic>" + String.valueOf(isDynamic) + "</ns1:" + "dynamic" + ">\n");
        buf.append("    <ns1:includeChildren>" + String.valueOf(isIncludeChildren) + "</ns1:" + "includeChildren" + ">\n");
        buf.append("    <ns1:includeImpacted>" + String.valueOf(isIncludeImpacted) + "</ns1:" + "includeImpacted" + ">\n");
        if (!workItems.isEmpty()) {
            buf.append("    <ns1:workItems>");
            comma = false;
            for (Integer wi : workItems) {
                if (comma) {
                    buf.append(',');
                } else {
                    comma = true;
                }
                buf.append(wi);
            }
            buf.append("</ns1:workItems>\n  ");
        }
        if (!(additionalWorkItems.isEmpty() || isDynamic && ignoreDynamicallyResolvedElements)) {
            buf.append("    <ns1:extraWorkItems>");
            comma = false;
            for (Integer wi : additionalWorkItems) {
                if (comma) {
                    buf.append(',');
                } else {
                    comma = true;
                }
                buf.append(wi);
            }
            buf.append("</ns1:extraWorkItems>\n  ");
        }
        buf.append("</ns1:criteria>\n");
    }

    public static void serializeCriterion(IBuildableSubsetSubsetCriteria criterion, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        BuildableSubsetSerializer.serializeSubsetCriterion(buf, repositoryLocation, criterion.getUUID(), criterion.isDynamic(), criterion.getLabel(), criterion.getSlug(), criterion.getChildCriteria(), criterion.getSubset(), ignoreDynamicallyResolvedElements);
    }

    public static void serializeCriterion(IBuildableSubsetSubsetCriteria2 criterion, String repositoryLocation, StringBuilder buf, boolean ignoreDynamicallyResolvedElements) {
        BuildableSubsetSerializer.serializeSubsetCriterion(buf, repositoryLocation, criterion.getUUID(), criterion.isDynamic(), criterion.getLabel(), criterion.getSlug(), criterion.getChildCriteria(), criterion.getSubset(), ignoreDynamicallyResolvedElements);
    }

    private static void serializeSubsetCriterion(StringBuilder buf, String repositoryLocation, UUID uuid, boolean isDynamic, String label, String slug, List<?> childCriteria, Object subset, boolean ignoreDynamicallyResolvedElements) {
        buf.append("  <ns1:criteria>\n");
        buf.append("    <ns1:type>subset</ns1:type>\n");
        buf.append("    <ns1:uuid>" + uuid.getUuidValue() + "</ns1:" + "uuid" + ">\n");
        buf.append("    <ns1:dynamic>" + String.valueOf(isDynamic) + "</ns1:" + "dynamic" + ">\n");
        buf.append("    <ns1:label>" + label + "</ns1:" + "label" + ">\n");
        buf.append("    <ns1:slug>" + slug + "</ns1:" + "slug" + ">\n");
        for (Object childCriterion : childCriteria) {
            BuildableSubsetSerializer.serialize(childCriterion, subset, repositoryLocation, buf, ignoreDynamicallyResolvedElements);
        }
        buf.append("</ns1:criteria>\n");
    }

    public static String serializeTransitoryFileList(IBuildableSubset2 subset, String subsetId, String repositoryLocation) {
        StringBuilder buf = new StringBuilder(1000);
        if (subset != null) {
            String buildDefinitionUUID = subset.getBuildDefinition() == null ? null : subset.getBuildDefinition().getItemId().getUuidValue();
            String workspaceUUID = subset.getWorkspace() == null ? null : subset.getWorkspace().getItemId().getUuidValue();
            String ownerID = subset.getOwner() == null ? null : subset.getOwner().getItemId().getUuidValue();
            String visibility = subset.getVisibility() == null ? null : subset.getVisibility().getName();
            String transitoryFileListNamespace = String.valueOf(repositoryLocation.endsWith("/") ? repositoryLocation : String.valueOf(repositoryLocation) + "/") + "storage" + "/" + "team_enterprise_transitory_filelist" + "/" + subsetId;
            BuildableSubsetSerializer.internalSerializeSubset(subset, buf, repositoryLocation, transitoryFileListNamespace, subset.getLabel(), subset.getDescription(), buildDefinitionUUID, workspaceUUID, ownerID, visibility, subset.getBuildableFileDescs(), subset.getCriteria(), true);
        }
        return buf.toString();
    }
}

