/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.transaction;

import com.urbancode.persistence.PersistenceException;
import com.urbancode.persistence.hibernate.HibernateUtil;
import com.urbancode.transaction.TransactionBoundDataSynchronization;
import com.urbancode.transaction.TransactionUtil;
import com.urbancode.transaction.TransientPostCommitHook;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateTransactionUtil
implements TransactionUtil {
    private static final Logger log = LoggerFactory.getLogger(HibernateTransactionUtil.class);
    private static ConcurrentMap<Long, Map<String, Object>> threadBoundTxData = new ConcurrentHashMap<Long, Map<String, Object>>();
    private static ThreadLocal transientPostCommitHooks = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new LinkedHashSet();
        }
    };
    private final Set<Runnable> preCommitHooks = new LinkedHashSet<Runnable>();
    private final Set<Runnable> postCommitHooks = new LinkedHashSet<Runnable>();

    HibernateTransactionUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPreCommitHook(Runnable r) {
        Set<Runnable> set = this.preCommitHooks;
        synchronized (set) {
            this.preCommitHooks.add(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPostCommitHook(Runnable r) {
        Set<Runnable> set = this.postCommitHooks;
        synchronized (set) {
            this.postCommitHooks.add(r);
        }
    }

    public void addTransientPostCommitHook(TransientPostCommitHook r) {
        Set hooks = (Set)transientPostCommitHooks.get();
        hooks.add(r);
    }

    public void begin() {
        Transaction tx = HibernateUtil.getCurrentSession().getTransaction();
        if (!tx.isActive()) {
            tx.begin();
            tx.registerSynchronization((Synchronization)new TransactionBoundDataSynchronization(tx));
            Long threadId = Thread.currentThread().getId();
            Map threadMap = (Map)threadBoundTxData.get(threadId);
            if (threadMap != null) {
                Set entrySet = threadMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    this.bind((String)entry.getKey(), entry.getValue());
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("BEGIN TRANSACTION [Thread-" + Thread.currentThread().getId() + "]");
        }
    }

    public void bind(String key, Object value) {
        Transaction tx = HibernateUtil.getCurrentSession().getTransaction();
        TransactionBoundDataSynchronization.bind(tx, key, value);
    }

    public Object unbind(String key) {
        Transaction tx = HibernateUtil.getCurrentSession().getTransaction();
        return TransactionBoundDataSynchronization.unbind(tx, key);
    }

    public Object get(String key) {
        Transaction tx = HibernateUtil.getCurrentSession().getTransaction();
        return TransactionBoundDataSynchronization.get(tx, key);
    }

    public void bindToAll(String key, Object value) {
        Long threadId = Thread.currentThread().getId();
        threadBoundTxData.putIfAbsent(threadId, new HashMap());
        Map bindMap = (Map)threadBoundTxData.get(threadId);
        bindMap.put(key, value);
        this.bind(key, value);
    }

    public void unbindFromAll(String key) {
        Long threadId = Thread.currentThread().getId();
        Map bindMap = (Map)threadBoundTxData.get(threadId);
        bindMap.remove(key);
        if (bindMap.isEmpty()) {
            threadBoundTxData.remove(threadId);
        }
        this.unbind(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        Set<Runnable> set = this.preCommitHooks;
        synchronized (set) {
            for (Runnable r : this.preCommitHooks) {
                r.run();
            }
        }
        HibernateUtil.getCurrentSession().getTransaction().commit();
        if (log.isDebugEnabled()) {
            log.debug("COMMIT TRANSACTION [Thread-" + Thread.currentThread().getId() + "]");
        }
        set = this.postCommitHooks;
        synchronized (set) {
            for (Runnable r : this.postCommitHooks) {
                try {
                    r.run();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error("Error while processing post-commit hooks after commit: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        Set hooks = (Set)transientPostCommitHooks.get();
        transientPostCommitHooks.remove();
        if (hooks != null) {
            for (TransientPostCommitHook hook : hooks) {
                try {
                    hook.setCommitted(true);
                    hook.run();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error("Error while processing transient post-commit hooks after commit: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws PersistenceException {
        try {
            Transaction tx = HibernateUtil.getCurrentSession().getTransaction();
            tx.rollback();
            if (log.isDebugEnabled()) {
                log.debug("ROLLBACK TRANSACTION [Thread-" + Thread.currentThread().getId() + "]");
            }
        }
        finally {
            Set hooks = (Set)transientPostCommitHooks.get();
            transientPostCommitHooks.remove();
            for (TransientPostCommitHook hook : hooks) {
                try {
                    hook.setCommitted(false);
                    hook.run();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error("Error while processing transient post-commit hooks after rollback: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Exception e) throws PersistenceException {
        long threadId = Thread.currentThread().getId();
        boolean mustCloseSession = false;
        Throwable cause = e;
        if (cause instanceof PersistenceException) {
            PersistenceException pe = (PersistenceException)cause;
            cause = pe.getCause();
        }
        if (cause instanceof JDBCException || cause instanceof HibernateException || cause instanceof SQLException) {
            mustCloseSession = true;
        }
        try {
            this.rollback();
            if (log.isInfoEnabled()) {
                log.info("Successfully rolled back transaction for Thread-" + threadId);
            }
        }
        catch (Exception rollbackException) {
            mustCloseSession = true;
            if (log.isErrorEnabled()) {
                log.error("Error rolling back database transaction for Thread-" + threadId + ": " + rollbackException.getMessage(), (Throwable)rollbackException);
            }
        }
        finally {
            block18: {
                if (mustCloseSession) {
                    try {
                        HibernateUtil.getCurrentSession().close();
                    }
                    catch (Exception closeException) {
                        if (!log.isErrorEnabled()) break block18;
                        log.error("Unable to close the session: " + closeException.getMessage(), (Throwable)closeException);
                    }
                }
            }
        }
        if (e instanceof PersistenceException) {
            throw (PersistenceException)e;
        }
        throw new PersistenceException(e);
    }

    public boolean isActive() {
        Session session = HibernateUtil.getCurrentSession();
        Transaction tx = session.getTransaction();
        return tx.isActive();
    }

    public void registerSychronization(Synchronization s) {
        Session session = HibernateUtil.getCurrentSession();
        Transaction tx = session.getTransaction();
        tx.registerSynchronization(s);
    }

    public Object getTransaction() throws PersistenceException {
        Session session = HibernateUtil.getCurrentSession();
        return session.getTransaction();
    }
}

