/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.common.notification;

import com.ibm.team.build.common.model.IBuildDefinition;
import com.ibm.team.build.common.notification.NotificationCriteria;
import com.ibm.team.build.common.notification.NotificationCriteriaFromBuildDefinition;
import java.util.ArrayList;
import java.util.List;

public class NotificationCriteriaFromBuildDefinitionHelper {
    public static List<NotificationCriteriaFromBuildDefinition> getAllCriteriasFromBuildDefinition(IBuildDefinition buildDefinition) {
        ArrayList<NotificationCriteriaFromBuildDefinition> criteriaList = new ArrayList<NotificationCriteriaFromBuildDefinition>();
        int numCriterias = NotificationCriteriaFromBuildDefinitionHelper.getNumCriteriasProperty(buildDefinition);
        int i = 0;
        while (i < numCriterias) {
            NotificationCriteriaFromBuildDefinition newCriteria = NotificationCriteriaFromBuildDefinitionHelper.getCriteriaFromProperties(buildDefinition, i);
            if (newCriteria != null) {
                criteriaList.add(newCriteria);
            }
            ++i;
        }
        return criteriaList;
    }

    public static int getNumCriteriasProperty(IBuildDefinition buildDefinition) {
        int numCriterias;
        String numCriteriasProperty = buildDefinition.getConfigurationPropertyValue("com.ibm.team.build.email", "build.email.numCriteria", "0");
        try {
            numCriterias = Integer.parseInt(numCriteriasProperty);
        }
        catch (NumberFormatException numberFormatException) {
            numCriterias = 0;
        }
        return numCriterias;
    }

    public static NotificationCriteriaFromBuildDefinition getCriteriaFromProperties(IBuildDefinition buildDefinition, int criteriaNumber) {
        String configId = "com.ibm.team.build.email";
        String prefix = "build.email.criteria." + criteriaNumber;
        NotificationCriteriaFromBuildDefinition newCriteria = null;
        if (buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".name", null) != null) {
            newCriteria = new NotificationCriteriaFromBuildDefinition();
            newCriteria.setCriteriaName(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".name", null));
            newCriteria.setEnabled(Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".enabled", Boolean.toString(false))));
            newCriteria.setPersonalCriteria(Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".includePersonalBuilds", Boolean.toString(false))));
            NotificationCriteria.NotifyCondition completedCondition = Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".notifyOnBuildCompleted", Boolean.toString(false))) == false ? NotificationCriteria.NotifyCondition.NEVER : (Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".notifyOnBuildCompletedAlways", Boolean.toString(false))) != false ? NotificationCriteria.NotifyCondition.ALWAYS : NotificationCriteria.NotifyCondition.ON_ERROR);
            newCriteria.setNotifyCompletedCondition(completedCondition);
            NotificationCriteria.NotifyCondition abandonedCondition = Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".notifyOnBuildAbandoned", Boolean.toString(false))) == false ? NotificationCriteria.NotifyCondition.NEVER : (Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".notifyOnBuildAbandonedAlways", Boolean.toString(false))) != false ? NotificationCriteria.NotifyCondition.ALWAYS : NotificationCriteria.NotifyCondition.ON_ERROR);
            newCriteria.setNotifyAbandonedCondition(abandonedCondition);
            newCriteria.setNotifySCM(Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".notifyUsersWhoDelivered", Boolean.toString(false))));
            newCriteria.setNotifyRequestor(Boolean.valueOf(buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".notifyBuildRequestor", Boolean.toString(false))));
            String emailList = buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".emailsToNotify", "");
            String[] emailArrayList = emailList.trim().length() > 0 ? emailList.split(",") : new String[]{};
            newCriteria.setEmails(emailArrayList);
            String userList = buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".usersToNotify", "");
            String[] userArrayList = userList.trim().length() > 0 ? userList.split("\n") : new String[]{};
            newCriteria.setUsers(userArrayList);
            String roleList = buildDefinition.getConfigurationPropertyValue(configId, String.valueOf(prefix) + ".rolesToNotify", "");
            String[] roleArrayList = roleList.trim().length() > 0 ? roleList.split("\n") : new String[]{};
            newCriteria.setRoles(roleArrayList);
            newCriteria.setPropertyNamePrefixNumber(criteriaNumber);
        }
        return newCriteria;
    }

    public static void createPropertiesFromCriteria(IBuildDefinition buildDefinition, NotificationCriteriaFromBuildDefinition criteria) {
        String configId = "com.ibm.team.build.email";
        String prefix = "build.email.criteria." + criteria.getPropertyNamePrefixNumber();
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".enabled", Boolean.toString(criteria.isEnabled()));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".name", criteria.getCriteriaName());
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".includePersonalBuilds", Boolean.toString(criteria.isPersonalCriteria()));
        boolean notifyCompleted = false;
        boolean notifyCompletedAlways = false;
        switch (criteria.getNotifyCompletedCondition()) {
            case NEVER: {
                notifyCompleted = false;
                notifyCompletedAlways = false;
                break;
            }
            case ON_ERROR: {
                notifyCompleted = true;
                notifyCompletedAlways = false;
                break;
            }
            case ALWAYS: {
                notifyCompleted = true;
                notifyCompletedAlways = true;
            }
        }
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildCompleted", Boolean.toString(notifyCompleted));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildCompletedAlways", Boolean.toString(notifyCompletedAlways));
        boolean notifyAbandoned = false;
        boolean notifyAbandonedAlways = false;
        switch (criteria.getNotifyAbandonedCondition()) {
            case NEVER: {
                notifyAbandoned = false;
                notifyAbandonedAlways = false;
                break;
            }
            case ON_ERROR: {
                notifyAbandoned = true;
                notifyAbandonedAlways = false;
                break;
            }
            case ALWAYS: {
                notifyAbandoned = true;
                notifyAbandonedAlways = true;
            }
        }
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildAbandoned", Boolean.toString(notifyAbandoned));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildAbandonedAlways", Boolean.toString(notifyAbandonedAlways));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".notifyUsersWhoDelivered", Boolean.toString(criteria.isNotifySCM()));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".notifyBuildRequestor", Boolean.toString(criteria.isNotifyRequestor()));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".emailsToNotify", NotificationCriteriaFromBuildDefinitionHelper.arrayToString(criteria.getEmails(), ","));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".usersToNotify", NotificationCriteriaFromBuildDefinitionHelper.arrayToString(criteria.getUsers(), "\n"));
        buildDefinition.setConfigurationProperty(configId, String.valueOf(prefix) + ".rolesToNotify", NotificationCriteriaFromBuildDefinitionHelper.arrayToString(criteria.getRoles(), "\n"));
    }

    public static void deleteCriteriaProperties(IBuildDefinition buildDefinition, int criteriaNumber) {
        String configId = "com.ibm.team.build.email";
        String prefix = "build.email.criteria." + criteriaNumber;
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".enabled");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".name");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".includePersonalBuilds");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildCompleted");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildCompletedAlways");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildAbandoned");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".notifyOnBuildAbandonedAlways");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".notifyUsersWhoDelivered");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".notifyBuildRequestor");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".emailsToNotify");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".usersToNotify");
        buildDefinition.removeConfigurationProperty(configId, String.valueOf(prefix) + ".rolesToNotify");
    }

    public static String arrayToString(String[] array, String separator) {
        StringBuffer result = new StringBuffer();
        if (array.length > 0) {
            result.append(array[0]);
            int i = 1;
            while (i < array.length) {
                result.append(separator);
                result.append(array[i]);
                ++i;
            }
        }
        return result.toString();
    }
}

