/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_value;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.commons.util.ObjectUtil;
import com.urbancode.commons.util.crypto.CryptStringUtil;
import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.security.GeneralSecurityException;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.NONE)
@Entity
@Table(name="ps_prop_value", uniqueConstraints={@UniqueConstraint(columnNames={"name", "prop_sheet_id"})})
public class PropValue
extends AbstractEntity<UUID>
implements Comparable<PropValue> {
    private static final long serialVersionUID = -6676786342302221908L;
    public static final String SECURE_MASK_VALUE = "****";
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    UUID id = IDGenerator.createID();
    @NotNull
    @ManyToOne
    @JoinColumn(name="prop_sheet_id", updatable=false)
    PropSheet propSheet;
    @NotNull
    @Column(name="name", updatable=false)
    @Length(min=1, max=256)
    String name;
    @Column(name="value")
    @Length(max=4000)
    String value;
    @Lob
    @Column(name="long_value")
    String longValue;
    @Column(name="label")
    @Length(max=4000)
    String label;
    @Lob
    @Column(name="long_label")
    String longLabel;
    @Column(name="description")
    @Length(max=4000)
    String description;
    @NotNull
    @Column(name="secure")
    @Type(type="yes_no")
    Boolean secure = false;

    protected PropValue() {
    }

    public PropValue(String name, String value, boolean secure) {
        this.name = name;
        this.setSecure(secure);
        this.setValue(value);
    }

    public PropValue(String name, String value) {
        this(name, value, false);
    }

    public PropValue(PropValue copy) {
        this.name = copy.name;
        this.value = copy.value;
        this.label = copy.label;
        this.secure = copy.secure;
        this.description = copy.description;
    }

    public UUID getId() {
        return this.id;
    }

    public PropSheet getPropSheet() {
        return this.propSheet;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        String result;
        String string = result = StringUtils.isEmpty((String)this.longValue) ? this.value : this.longValue;
        if (result == null) {
            result = "";
        } else {
            try {
                if (CryptStringUtil.isEncrypted((String)result)) {
                    result = CryptStringUtil.decrypt((String)result);
                }
            }
            catch (GeneralSecurityException e) {
                throw new TranslatableException("Error decrypting value", (Throwable)e, new Object[0]);
            }
        }
        return result;
    }

    public String getRawValue() {
        String result = this.value;
        if (StringUtils.isEmpty((String)result)) {
            result = this.longValue;
        }
        return result;
    }

    public String getSafeValue() {
        String result = this.getValue();
        if (this.isSecure().booleanValue()) {
            result = SECURE_MASK_VALUE;
        }
        return result;
    }

    public boolean isUsingDefault() {
        boolean result = false;
        PropDef propDef = this.getPropDef();
        if (propDef != null) {
            String value = this.getValue();
            result = StringUtils.isEmpty((String)value) ? true : StringUtils.equals((String)value, (String)propDef.getDefaultValue());
        }
        return result;
    }

    public PropDef getPropDef() {
        PropSheetDef propSheetDef;
        PropDef result = null;
        if (this.propSheet != null && (propSheetDef = this.propSheet.getPropSheetDef()) != null) {
            result = propSheetDef.getPropDef(this.name);
        }
        return result;
    }

    private boolean isValidValue(String value) {
        boolean result = true;
        PropDef propDef = this.getPropDef();
        if (propDef != null && !propDef.isValidValue(value)) {
            result = false;
        }
        return result;
    }

    public void setValue(String value) {
        if (value == null) {
            throw new TranslatableException("Null value not allowed. Remove the PropValue instead.", new Object[0]);
        }
        if (!this.isValidValue(value)) {
            throw new TranslatableException("Value for property named %s is not valid. Check that it matches any pattern defined by the property definition!", new Object[]{this.name});
        }
        String newValue = null;
        if (this.isSecure().booleanValue()) {
            if (!SECURE_MASK_VALUE.equals(value)) {
                try {
                    newValue = CryptStringUtil.encrypt((String)value);
                }
                catch (Exception e) {
                    throw new TranslatableException("Error encrypting value", (Throwable)e, new Object[0]);
                }
            }
        } else {
            newValue = value;
        }
        if (newValue != null && !newValue.equals(this.getRawValue())) {
            this.setValueProperty(newValue);
            if (this.propSheet != null) {
                this.propSheet.getPersistenceData().setDirty(true);
            }
        }
    }

    private void setValueProperty(String newValue) {
        if (newValue.length() > 4000) {
            this.longValue = newValue;
            this.value = null;
        } else {
            this.longValue = null;
            this.value = newValue;
        }
    }

    public String getLabel() {
        String result = StringUtils.isEmpty((String)this.longLabel) ? this.label : this.longLabel;
        return result;
    }

    public void setLabel(String label) {
        if (label == null) {
            this.longLabel = null;
            this.label = null;
        } else if (label.length() > 4000) {
            this.longLabel = label;
            this.label = null;
        } else {
            this.label = label;
            this.longLabel = null;
        }
        if (this.propSheet != null) {
            this.propSheet.getPersistenceData().setDirty(true);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        if (this.propSheet != null) {
            this.propSheet.getPersistenceData().setDirty(true);
        }
    }

    public Boolean isSecure() {
        PropDef propDef;
        Boolean result = Boolean.TRUE.equals(this.secure);
        if (!result.booleanValue() && (propDef = this.getPropDef()) != null) {
            result = propDef.isSecure();
        }
        return result;
    }

    public void setSecure(Boolean secure) {
        if (!ObjectUtil.isEqual((Object)this.secure, (Object)secure)) {
            String value = this.getValue();
            this.secure = secure;
            this.setValue(value);
            if (this.propSheet != null) {
                this.propSheet.getPersistenceData().setDirty(true);
            }
        }
    }

    public void setPropSheet(PropSheet propSheet) {
        if (this.propSheet != null) {
            throw new TranslatableException("Cannot set PropSheet when it has already been set.", new Object[0]);
        }
        if (!this.isValidValue(this.value)) {
            throw new TranslatableException("Value for property named %s is not valid. Check that it matches any pattern defined by the property definition!", new Object[]{this.name});
        }
        this.propSheet = propSheet;
        propSheet.getPersistenceData().setDirty(true);
    }

    @Override
    public int compareTo(PropValue other) {
        return this.name.compareToIgnoreCase(other.name);
    }
}

