/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.web.rest;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_def.PropDefAllowedValue;
import com.urbancode.air.property.prop_def.http.HttpPropInfo;
import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.commons.webext.util.AbstractResource;
import com.urbancode.commons.webext.util.JSONUtilities;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="propDef")
public class PropDefResource
extends AbstractResource<PropDef> {
    public static final String SECURE_PROP_OBFUSCATE = "****";
    private static PropDefResource instance = new PropDefResource();
    @Context
    UriInfo uriInfo;

    public static PropDefResource getInstance() {
        return instance;
    }

    protected JSONObject getBasicJSON(PropDef propDef) throws Exception {
        return this.getPropDefJSON(propDef, false);
    }

    private JSONObject getPropDefJSON(PropDef propDef, boolean export) throws JSONException {
        JSONObject propertyJsonObject = new JSONObject();
        if (!export) {
            propertyJsonObject.put("id", (Object)propDef.getId());
            if (propDef.getType().isHttpBased()) {
                String propSheetDefParam;
                PropSheetDef propSheetDef = propDef.getPropSheetDef();
                if (propSheetDef.isVersioned()) {
                    try {
                        propSheetDefParam = URLEncoder.encode(propSheetDef.getPersistenceData().getPath().replace('/', '&'), "UTF-8") + ".-1";
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    propSheetDefParam = propSheetDef.getId().toString();
                }
                HttpPropInfo info = propDef.getHttpPropInfo();
                if (info.getResolveHttpValuesUrl() == null || info.getResolveHttpValuesUrl().isEmpty()) {
                    propertyJsonObject.put("resolveHttpValuesUrl", (Object)("property/propSheetDef/" + propSheetDefParam + "/resolveHttpValues/" + propDef.getName()));
                } else {
                    propertyJsonObject.put("resolveHttpValuesUrl", (Object)info.getResolveHttpValuesUrl());
                }
            }
        }
        propertyJsonObject.put("name", (Object)propDef.getName());
        propertyJsonObject.put("label", (Object)propDef.getLabel());
        propertyJsonObject.put("pattern", (Object)propDef.getPattern());
        propertyJsonObject.put("type", (Object)propDef.getTypeName());
        if (export) {
            propertyJsonObject.put("value", (Object)propDef.getRawDefaultValue());
        } else {
            propertyJsonObject.put("value", (Object)propDef.getSafeDefaultValue());
        }
        propertyJsonObject.put("defaultLabel", (Object)propDef.getDefaultLabel());
        propertyJsonObject.put("required", propDef.isRequired());
        propertyJsonObject.put("description", (Object)propDef.getDescription());
        propertyJsonObject.put("placeholder", (Object)propDef.getPlaceholder());
        if (propDef.getType() != null) {
            if (propDef.getType().hasAllowedValues()) {
                List<PropDefAllowedValue> allowedValues = propDef.getAllowedValues();
                JSONArray allowedValueJsonArray = this.getAllowedValuesJson(allowedValues);
                propertyJsonObject.put("allowedValues", (Object)allowedValueJsonArray);
            }
            if (propDef.getType().isHttpBased()) {
                HttpPropInfo info = propDef.getHttpPropInfo();
                propertyJsonObject.put("httpUrl", (Object)info.getUrl());
                if (!StringUtil.isEmpty((String)info.getUsername())) {
                    propertyJsonObject.put("httpUsername", (Object)info.getUsername());
                }
                if (!StringUtil.isEmpty((String)info.getPassword())) {
                    propertyJsonObject.put("httpPassword", (Object)SECURE_PROP_OBFUSCATE);
                    propertyJsonObject.put("httpEncryptedPassword", (Object)info.getPassword());
                }
                propertyJsonObject.put("httpFormat", (Object)info.getFormatName());
                propertyJsonObject.put("httpBasePath", (Object)info.getBasePath());
                propertyJsonObject.put("httpValuePath", (Object)info.getValuePath());
                propertyJsonObject.put("httpLabelPath", (Object)info.getLabelPath());
            }
        }
        return propertyJsonObject;
    }

    public JSONObject getAllowedValueJson(PropDefAllowedValue allowedValue) throws JSONException {
        JSONObject allowedValueJsonObject = new JSONObject();
        allowedValueJsonObject.put("label", (Object)allowedValue.getLabel());
        allowedValueJsonObject.put("value", (Object)allowedValue.getValue());
        return allowedValueJsonObject;
    }

    public JSONArray getAllowedValuesJson(List<PropDefAllowedValue> allowedValues) throws JSONException {
        JSONArray allowedValueJsonArray = new JSONArray();
        for (PropDefAllowedValue allowedValue : allowedValues) {
            allowedValueJsonArray.put((Object)this.getAllowedValueJson(allowedValue));
        }
        return allowedValueJsonArray;
    }

    protected JSONObject getExportJSON(PropDef propDef) throws Exception {
        return this.getPropDefJSON(propDef, true);
    }

    public void setValuesFromJSON(PropDef propDef, JSONObject submittedJson) throws JSONException {
        PropSheetDef propSheetDef = propDef.getPropSheetDef();
        if (propSheetDef == null) {
            throw new IllegalArgumentException("Must set a PropSheetDef on a PropDef before passing it to this method.");
        }
        String label = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"label");
        String pattern = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"pattern");
        String value = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"value");
        String defaultLabel = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"defaultLabel");
        Boolean required = JSONUtilities.getBooleanFromJsonObject((JSONObject)submittedJson, (String)"required");
        String description = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"description");
        String placeholder = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"placeholder");
        String typeName = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"type");
        JSONArray allowedValuesArray = JSONUtilities.getJsonArrayFromJsonObject((JSONObject)submittedJson, (String)"allowedValues");
        ArrayList<JSONObject> allowedValues = new ArrayList<JSONObject>();
        if (allowedValuesArray != null && allowedValuesArray.length() > 0) {
            for (int i = 0; i < allowedValuesArray.length(); ++i) {
                JSONObject allowedValueObject = allowedValuesArray.getJSONObject(i);
                allowedValues.add(allowedValueObject);
            }
        }
        String url = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"httpUrl");
        String username = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"httpUsername");
        String password = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"httpPassword");
        String format = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"httpFormat");
        String basePath = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"httpBasePath");
        String valuePath = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"httpValuePath");
        String labelPath = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"httpLabelPath");
        String resolveUrl = JSONUtilities.getStringFromJsonObject((JSONObject)submittedJson, (String)"resolveHttpValuesUrl");
        PropDef.PropDefType type = PropDef.PropDefType.valueOf(typeName);
        String oldValue = propDef.getDefaultValue();
        propDef.setType(type);
        if (label == null || label.length() == 0) {
            propDef.setLabel(propDef.getName());
        } else {
            propDef.setLabel(label);
        }
        if (required == null) {
            propDef.setRequired(false);
        } else {
            propDef.setRequired(required);
        }
        propDef.setPattern(pattern);
        propDef.setDescription(description);
        propDef.setPlaceholder(placeholder);
        if (!propDef.isSecure() || !SECURE_PROP_OBFUSCATE.equals(value)) {
            propDef.setDefaultValue(value);
        }
        propDef.setDefaultLabel(defaultLabel);
        if (type.hasAllowedValues()) {
            propDef.removeAllAllowedValues();
            for (JSONObject allowedValue : allowedValues) {
                String propLabel = JSONUtilities.getStringFromJsonObject((JSONObject)allowedValue, (String)"label");
                String propValue = JSONUtilities.getStringFromJsonObject((JSONObject)allowedValue, (String)"value");
                if (propValue == null) continue;
                if (propLabel == null || propLabel.length() == 0) {
                    propLabel = propValue;
                }
                propDef.addAllowedValue(propValue, propLabel);
            }
        } else if (type.isHttpBased()) {
            HttpPropInfo info = propDef.getHttpPropInfo();
            info.setUrl(url);
            info.setUsername(username);
            try {
                info.setPassword(password);
            }
            catch (GeneralSecurityException e) {
                throw new TranslatableException("Unable to encrypt password for HTTP property.", new Object[0]);
            }
            info.setFormatName(format);
            info.setBasePath(basePath);
            info.setValuePath(valuePath);
            info.setLabelPath(labelPath);
            if (resolveUrl != null) {
                info.setResolveHttpValuesUrl(resolveUrl);
            } else {
                String propSheetDefParam;
                if (propSheetDef.isVersioned()) {
                    try {
                        propSheetDefParam = URLEncoder.encode(propSheetDef.getPersistenceData().getPath().replace('/', '&'), "UTF-8") + ".-1";
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    propSheetDefParam = propSheetDef.getId().toString();
                }
                info.setResolveHttpValuesUrl("property/propSheetDef/" + propSheetDefParam + "/resolveHttpValues/" + propDef.getName());
            }
        }
        if (!StringUtils.equals((String)oldValue, (String)value)) {
            String name = propDef.getName();
            Set<PropSheet> propSheets = propSheetDef.getPropSheetList();
            for (PropSheet propSheet : propSheets) {
                String existingValue = propSheet.getPropValue(name);
                if (existingValue != null && !existingValue.equals(oldValue)) continue;
                propSheet.setPropValue(name, value);
            }
        }
    }

    public void importPropertyDefs(PropSheetDef sheetDef, JSONArray propDefJson, boolean isUpgrade) throws JSONException {
        if (isUpgrade) {
            for (PropDef propDef : sheetDef.getDirectPropDefList()) {
                boolean propExists = false;
                for (int i = 0; i < propDefJson.length(); ++i) {
                    JSONObject jProp = propDefJson.getJSONObject(i);
                    String propName = JSONUtilities.getStringFromJsonObject((JSONObject)jProp, (String)"name");
                    if (!propName.equals(propDef.getName())) continue;
                    propExists = true;
                    break;
                }
                if (propExists) continue;
                sheetDef.removePropDef(propDef);
            }
        }
        for (int i = 0; i < propDefJson.length(); ++i) {
            JSONObject jSONObject = propDefJson.getJSONObject(i);
            String propName = JSONUtilities.getStringFromJsonObject((JSONObject)jSONObject, (String)"name");
            String propTypeString = JSONUtilities.getStringFromJsonObject((JSONObject)jSONObject, (String)"type");
            PropDef.PropDefType propType = PropDef.PropDefType.valueOf(propTypeString);
            PropDef propDef = sheetDef.getDirectPropDef(propName);
            if (propDef == null) {
                propDef = sheetDef.createPropDef(propType, propName);
            }
            this.setValuesFromJSON(propDef, jSONObject);
            sheetDef.movePropDef(propDef, i);
        }
    }

    public JSONObject getUnsafeJSON(PropDef propDef) throws JSONException {
        JSONObject propertyJsonObject = this.getPropDefJSON(propDef, false);
        if (propDef.getType().isHttpBased()) {
            propertyJsonObject.put("httpPassword", (Object)propDef.getHttpPropInfo().getPassword());
        }
        return propertyJsonObject;
    }
}

