/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.workitems.internal.process;

import com.ibm.team.filesystem.common.internal.util.XmlUtil;
import com.ibm.team.filesystem.common.workitems.internal.process.ApprovalType;
import com.ibm.team.filesystem.common.workitems.internal.process.Messages;
import com.ibm.team.filesystem.common.workitems.internal.process.RequireWorkItemApprovalProblemObject;
import com.ibm.team.filesystem.common.workitems.internal.process.WorkItemAdvisorMarkupText;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IManagedItemHandle;
import com.ibm.team.repository.common.IRepositoryRoot;
import com.ibm.team.repository.common.IRepositoryRootHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import com.ibm.team.scm.common.internal.process.AdvisorDetailConstants;
import com.ibm.team.scm.common.internal.process.UnifiedProcessDescriptionUtil;
import com.ibm.team.scm.common.links.ChangeSetLinks;
import com.ibm.team.scm.common.process.DeliverOperationData;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.ProcessProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequireWorkItemApprovalAdvisor
implements IOperationAdvisor {
    private static String ELEMENT_REQUIRES = "requires";
    private static String ELEMENT_APPROVAL = "approval";
    private static String ELEMENT_APPROVERS = "approvers";
    private static String ATTR_TYPE = "type";
    private static String ATTR_ROLE = "role";
    private static String ATTR_NUMBER_OF_APPROVERS = "number-of-approvers";
    public static String VAL_REVIEW = "Review";
    public static String VAL_APPROVAL = "Approval";
    public static String VAL_VERIFICATION = "Verification";
    public static String VAL_DEFAULT_ROLE = "default";
    public static final String ID_APPROVAL_ADVISOR = "com.ibm.team.process.deliver.requireWorkItemApproval";
    public static final String ID_APPROVAL_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemApprovalProblem";
    public static final String ID_CONFIGURATION_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemApproval.configurationProblem";
    private List<Requirement> fRequirements = new ArrayList<Requirement>();
    private ProviderFactory provider;
    private ItemProvider items;
    private ProcessProvider process;
    private AdvisableOperation operation;
    private IRole[] knownRoles;
    private UUID repoUuid;

    public RequireWorkItemApprovalAdvisor(ProviderFactory provider, UUID repoUuid) {
        this.provider = provider;
        this.items = provider.getItemProvider();
        this.process = provider.getProcessProvider();
        this.repoUuid = repoUuid;
    }

    public void run(AdvisableOperation op, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object opData = op.getOperationData();
        if (!(opData instanceof DeliverOperationData)) {
            return;
        }
        this.operation = op;
        DeliverOperationData data = (DeliverOperationData)opData;
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.0"), 1000);
        try {
            this.initialize(advisorConfiguration);
            IProcessArea handle = op.getProcessArea();
            IProcessArea processArea = null;
            try {
                processArea = (IProcessArea)this.items.fetchItem((IManagedItemHandle)handle, (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            }
            catch (ItemNotFoundException itemNotFoundException) {
                IAdvisorInfo info = collector.createProblemInfo(Messages.getString("RequireWorkItemApprovalAdvisor.5"), Messages.getString("RequireWorkItemApprovalAdvisor.NO_DISTRIBUTED"), ID_CONFIGURATION_PROBLEM);
                collector.addInfo((IReportInfo)info);
                monitor.done();
                return;
            }
            try {
                if (data.getChangeSetHandles().size() > 0) {
                    this.addProblems(data, processArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
                }
            }
            catch (TeamRepositoryException e) {
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemApprovalAdvisor.1"), (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void initialize(IProcessConfigurationElement advisorConfiguration) {
        IProcessConfigurationElement[] children = advisorConfiguration.getChildren();
        int i = 0;
        while (i < children.length) {
            IProcessConfigurationElement child = children[i];
            String childName = child.getName();
            if (ELEMENT_REQUIRES.equals(childName)) {
                IProcessConfigurationElement[] children2 = child.getChildren();
                int j = 0;
                while (j < children2.length) {
                    IProcessConfigurationElement child2 = children2[j];
                    String child2Name = child2.getName();
                    if (ELEMENT_APPROVAL.equals(child2Name)) {
                        String approvalType = child2.getAttribute(ATTR_TYPE);
                        ArrayList<Approvers> allApprovers = new ArrayList<Approvers>();
                        IProcessConfigurationElement[] children3 = child2.getChildren();
                        int k = 0;
                        while (k < children3.length) {
                            IProcessConfigurationElement child3 = children3[k];
                            String child3Name = child3.getName();
                            if (ELEMENT_APPROVERS.equals(child3Name)) {
                                Approvers approvers = new Approvers();
                                approvers.role = child3.getAttribute(ATTR_ROLE);
                                String numberString = child3.getAttribute(ATTR_NUMBER_OF_APPROVERS);
                                try {
                                    approvers.numberOfApprovers = Integer.parseInt(numberString);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    approvers.numberOfApprovers = 1;
                                }
                                allApprovers.add(approvers);
                            }
                            ++k;
                        }
                        Requirement requirement = new Requirement();
                        requirement.type = approvalType;
                        requirement.approvers = allApprovers.toArray(new Approvers[allApprovers.size()]);
                        this.fRequirements.add(requirement);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addProblems(DeliverOperationData data, IProcessArea processArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask("", 1000 * (data.getChangeSetHandles().size() + 3));
        try {
            if (!this.checkRequirementsSpecification(processArea, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 1000))) {
                return;
            }
            Map links = ChangeSetLinks.resolveLinks((ProviderFactory)this.provider, (List)data.getChangeSetHandles(), (String)"com.ibm.team.filesystem.workitems.change_set", (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            for (IChangeSet changeSet : links.keySet()) {
                ArrayList<IAuditable> workItemHandles = new ArrayList<IAuditable>();
                if (changeSet != null) {
                    List linkTargets = (List)links.get(changeSet);
                    for (IAuditable referencedItem : linkTargets) {
                        if (!(referencedItem instanceof IWorkItemHandle)) continue;
                        workItemHandles.add(referencedItem);
                    }
                }
                this.addProblem(data, workItemHandles, changeSet, collector, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        }
        finally {
            monitor.done();
        }
    }

    private boolean checkRequirementsSpecification(IProcessArea processArea, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.2"), 500);
        try {
            IRole[] roles = this.process.getRoles(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            boolean succeeded = true;
            for (Requirement requirement : this.fRequirements) {
                if (!this.isValidTypeValue(requirement.type)) {
                    collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemApprovalAdvisor.3"), NLS.bind((String)Messages.getString("RequireWorkItemApprovalAdvisor.4"), (Object[])new Object[]{VAL_APPROVAL, VAL_REVIEW, VAL_VERIFICATION}, (Object[])new Object[0]), ID_CONFIGURATION_PROBLEM));
                    succeeded = false;
                }
                int i = 0;
                while (i < requirement.approvers.length) {
                    Approvers approvers = requirement.approvers[i];
                    if (!this.isValidRoleValue(approvers.role, roles)) {
                        collector.addInfo((IReportInfo)collector.createProblemInfo(Messages.getString("RequireWorkItemApprovalAdvisor.5"), Messages.getString("RequireWorkItemApprovalAdvisor.6"), ID_CONFIGURATION_PROBLEM));
                        succeeded = false;
                    }
                    ++i;
                }
            }
            boolean bl = succeeded;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isValidTypeValue(String typeValue) {
        return VAL_APPROVAL.equals(typeValue) || VAL_REVIEW.equals(typeValue) || VAL_VERIFICATION.equals(typeValue);
    }

    private boolean isValidRoleValue(String roleValue, IRole[] definedRoles) {
        return VAL_DEFAULT_ROLE.equals(roleValue) || this.isDefinedRole(roleValue, definedRoles);
    }

    private boolean isDefinedRole(String roleValue, IRole[] definedRoles) {
        int i = 0;
        while (i < definedRoles.length) {
            if (definedRoles[i].getId().equals(roleValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addProblem(DeliverOperationData data, List workItems, IChangeSet changeSet, IAdvisorInfoCollector collector, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.7"), 1000);
        try {
            if (workItems == null || workItems.isEmpty()) {
                collector.addInfo((IReportInfo)this.createProblem(Messages.getString("RequireWorkItemApprovalAdvisor.8"), Messages.getString("RequireWorkItemApprovalAdvisor.9"), "", collector, data, changeSet, workItems, processArea));
                return;
            }
            workItems = this.items.fetchItems(workItems, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            ListIterator iterator = workItems.listIterator();
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                collector.addInfo((IReportInfo)collector.createExceptionInfo(Messages.getString("RequireWorkItemApprovalAdvisor.10"), (Throwable)new TeamRepositoryException(Messages.getString("RequireWorkItemApprovalAdvisor.11"))));
                iterator.remove();
            }
            LinkedList<String> approvalErrorXml = new LinkedList<String>();
            LinkedList<String> approvalErrorMessages = new LinkedList<String>();
            LinkedList<RequireWorkItemApprovalFailure> failures = new LinkedList<RequireWorkItemApprovalFailure>();
            this.checkApprovals(workItems, processArea, approvalErrorXml, approvalErrorMessages, failures, (IProgressMonitor)new SubProgressMonitor(monitor, 600));
            if (approvalErrorMessages.size() > 0) {
                IAdvisorInfo info = this.createProblem(Messages.getString("RequireWorkItemApprovalAdvisor.12"), this.describeProblems(approvalErrorMessages), this.generateProblemXml(approvalErrorXml, failures), collector, data, changeSet, workItems, processArea);
                collector.addInfo((IReportInfo)info);
            }
        }
        finally {
            monitor.done();
        }
    }

    private String describeProblems(Collection<String> approvalProblems) {
        StringBuffer buf = new StringBuffer();
        if (approvalProblems.size() == 1) {
            buf.append(NLS.bind((String)Messages.getString("RequireWorkItemApprovalAdvisor.19"), (Object)approvalProblems.iterator().next(), (Object[])new Object[0]));
        } else {
            buf.append(Messages.getString("RequireWorkItemApprovalAdvisor.20"));
            for (String problem : approvalProblems) {
                buf.append(NLS.bind((String)Messages.getString("RequireWorkItemApprovalAdvisor.24"), (Object)problem, (Object[])new Object[0]));
            }
        }
        return buf.toString();
    }

    private String generateProblemXml(Collection<String> errors, Collection<RequireWorkItemApprovalFailure> failures) throws TeamRepositoryException {
        String serialized;
        if (errors.isEmpty()) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        XmlUtil.TagEscaper escaper = XmlUtil.escapeTag((String)"require-workitem-approval-errors");
        escaper.setSelfTerminated(false);
        escaper.addAttribute("version", "1");
        escaper.addAttribute("repository-uuid", this.repoUuid.getUuidValue());
        buf.append(escaper);
        for (String error : errors) {
            buf.append('\t');
            buf.append(error);
            buf.append('\n');
        }
        IRepositoryRootHandle root = (IRepositoryRootHandle)IRepositoryRoot.ITEM_TYPE.createItemHandle(this.repoUuid, null);
        WorkItemAdvisorMarkupText aml = new WorkItemAdvisorMarkupText(root);
        if (failures.size() == 1) {
            aml.appendParagraph(Messages.getString("RequireWorkItemApprovalAdvisor.14"), new Object[0]);
        } else {
            aml.appendParagraph(Messages.getString("RequireWorkItemApprovalAdvisor.15"), new Object[0]);
        }
        ArrayList<Element> failuesAsAml = new ArrayList<Element>(failures.size());
        for (RequireWorkItemApprovalFailure failure : failures) {
            Element para = aml.makePara(Messages.getString("RequireWorkItemApprovalAdvisor.25"), new Object[]{aml.makeWorkItemLink(failure.badWi), failure.missingCount, failure.readableMissingRoleName, failure.readableMissingRoleType});
            failuesAsAml.add(para);
        }
        aml.appendListContent(AdvisorDetailConstants.ListType.BULLETS, failuesAsAml);
        AdvisorDataMarshaller.AdvisorData data = new AdvisorDataMarshaller.AdvisorData();
        data.text = aml.serialize();
        try {
            Document doc = UnifiedProcessDescriptionUtil.createXmlDoc();
            AdvisorDataMarshaller.marshallInto((AdvisorDataMarshaller.IScmAdvisorMarshallable)data, (Document)doc, null, null);
            serialized = UnifiedProcessDescriptionUtil.serializeDoc((Document)doc);
        }
        catch (AdvisorDataMarshaller.MarshallerException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        buf.append(serialized);
        buf.append(escaper.close());
        return buf.toString();
    }

    private IAdvisorInfo createProblem(String summary, String description, String errorXml, IAdvisorInfoCollector collector, DeliverOperationData data, IChangeSet changeSet, List workItems, IProcessArea processArea) {
        RequireWorkItemApprovalProblemObject object = new RequireWorkItemApprovalProblemObject(changeSet, workItems, processArea);
        IAdvisorInfo problem = collector.createProblemInfo(summary, description, ID_APPROVAL_PROBLEM);
        problem.setData(errorXml);
        problem.setProblemObject((Object)object);
        return problem;
    }

    private void checkApprovals(List workItems, IProcessArea processArea, Collection<String> approvalErrorXml, Collection<String> approvalErrorMessages, Collection<RequireWorkItemApprovalFailure> failures, IProgressMonitor monitor) throws TeamRepositoryException {
        int numWorkItems = workItems.size();
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.13"), numWorkItems);
        try {
            for (IWorkItem workItem : workItems) {
                this.findFailedRequirements(workItem, processArea, approvalErrorXml, approvalErrorMessages, failures, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void findFailedRequirements(IWorkItem workItem, IProcessArea processArea, Collection<String> approvalErrorXml, Collection<String> approvalErrorMessages, Collection<RequireWorkItemApprovalFailure> failures, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.16"), this.fRequirements.size());
        try {
            for (Requirement req : this.fRequirements) {
                this.findFailedRequirement(req, workItem, processArea, approvalErrorXml, approvalErrorMessages, failures, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void findFailedRequirement(Requirement requirement, IWorkItem workItem, IProcessArea processArea, Collection<String> approvalErrorXml, Collection<String> complaints, Collection<RequireWorkItemApprovalFailure> failures, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        IApprovalType requiredType = this.getApprovalType(requirement);
        if (requiredType != null) {
            IApprovals approvals = workItem.getApprovals();
            List approvalDescriptors = approvals.getDescriptors();
            Approvers[] needed = requirement.approvers;
            monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.17"), 1000 * approvalDescriptors.size() * needed.length);
            try {
                Approvers[] approversArray = needed;
                int n = needed.length;
                int n2 = 0;
                while (n2 < n) {
                    Approvers n3 = approversArray[n2];
                    int missing = n3.numberOfApprovers;
                    for (IApprovalDescriptor descriptor : approvalDescriptors) {
                        IApprovalType actualType = WorkItemApprovals.getType((String)descriptor.getTypeIdentifier());
                        if (requiredType == actualType) {
                            missing -= this.countApprovers(n3.role, approvals, descriptor, processArea, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1000));
                            continue;
                        }
                        monitor.worked(1000 * needed.length);
                    }
                    if (missing > 0) {
                        String readableApprovalType = this.findApprovalTypeString(requirement.type);
                        String readableRoleType = this.findRoleString(n3.role, (IProgressMonitor)monitor);
                        XmlUtil.TagEscaper escaper = XmlUtil.escapeTag((String)"approval-error");
                        escaper.addAttribute("work-item-uuid", workItem.getItemId().getUuidValue());
                        escaper.addAttribute("work-item-number", Integer.toString(workItem.getId()));
                        escaper.addAttribute("required-approval-type", Integer.toString(workItem.getId()));
                        escaper.addAttribute("required-approval-string", readableApprovalType);
                        escaper.addAttribute("required-role-type", n3.role);
                        escaper.addAttribute("required-role-string", readableRoleType);
                        escaper.addAttribute("missing-approval-count", Integer.toString(missing));
                        approvalErrorXml.add(escaper.toString());
                        String c = NLS.bind((String)Messages.getString("RequireWorkItemApprovalAdvisor.21"), (Object[])new Object[]{workItem.getId(), missing, readableApprovalType, readableRoleType}, (Object[])new Object[0]);
                        complaints.add(c);
                        RequireWorkItemApprovalFailure failure = new RequireWorkItemApprovalFailure();
                        failure.badWi = workItem;
                        failure.missingCount = missing;
                        failure.readableMissingRoleName = readableApprovalType;
                        failure.readableMissingRoleType = readableRoleType;
                        failures.add(failure);
                    }
                    ++n2;
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private String findRoleString(String roleId, IProgressMonitor progress) throws TeamRepositoryException {
        if (this.knownRoles == null) {
            this.knownRoles = this.process.getRoles(this.operation.getProcessArea(), progress);
        }
        IRole[] iRoleArray = this.knownRoles;
        int n = this.knownRoles.length;
        int n2 = 0;
        while (n2 < n) {
            IRole role = iRoleArray[n2];
            if (roleId.equals(role.getId()) && role instanceof IRole2) {
                return ((IRole2)role).getRoleLabel();
            }
            ++n2;
        }
        return Messages.getString("RequireWorkItemApprovalAdvisor.22");
    }

    private String findApprovalTypeString(String approvalType) {
        ApprovalType app = ApprovalType.findById(approvalType);
        if (app == null) {
            return Messages.getString("RequireWorkItemApprovalAdvisor.23");
        }
        return app.getLabel();
    }

    private int countApprovers(String neededRole, IApprovals approvals, IApprovalDescriptor descriptor, IProcessArea processArea, IProgressMonitor monitor) throws TeamRepositoryException {
        List contents = approvals.getContents(descriptor);
        monitor.beginTask(Messages.getString("RequireWorkItemApprovalAdvisor.18"), contents.size() * 1000);
        try {
            int approvalCount = 0;
            for (IApproval approval : approvals.getContents(descriptor)) {
                IRole[] contributorRoles;
                IApprovalState state = WorkItemApprovals.getState((String)approval.getStateIdentifier());
                if (WorkItemApprovals.APPROVED_STATE != state) continue;
                IContributorHandle handle = approval.getApprover();
                IRole[] iRoleArray = contributorRoles = this.process.getContributorRoles(handle, processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                int n = contributorRoles.length;
                int n2 = 0;
                while (n2 < n) {
                    IRole role = iRoleArray[n2];
                    if (neededRole.equals(role.getId())) {
                        ++approvalCount;
                    }
                    ++n2;
                }
            }
            int n = approvalCount;
            return n;
        }
        finally {
            monitor.done();
        }
    }

    private IApprovalType getApprovalType(Requirement requirement) {
        if (VAL_APPROVAL.equals(requirement.type)) {
            return WorkItemApprovals.APPROVAL_TYPE;
        }
        if (VAL_REVIEW.equals(requirement.type)) {
            return WorkItemApprovals.REVIEW_TYPE;
        }
        if (VAL_VERIFICATION.equals(requirement.type)) {
            return WorkItemApprovals.VERIFICATION_TYPE;
        }
        return null;
    }

    private static class Approvers {
        public String role;
        public int numberOfApprovers;

        private Approvers() {
        }
    }

    private static class RequireWorkItemApprovalFailure {
        public IWorkItem badWi;
        public String readableMissingRoleType;
        public String readableMissingRoleName;
        public int missingCount;

        private RequireWorkItemApprovalFailure() {
        }
    }

    private static class Requirement {
        public String type;
        public Approvers[] approvers;

        private Requirement() {
        }
    }
}

