/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LinkType;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedBufferedInputStream;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public class LocalFileBackup
implements IBackupHandler {
    public static final String JAZZ_SHED = ".jazzShed";
    private static final String PREFIX = "b";
    private static final String FORMAT = "yy-MM-dd_HH.mm.ss.SSS";
    private BackupDilemmaHandler problemHandler;
    private long maxFileSize;
    private boolean shedEntryCreated;
    private String preferredName;
    private IPath sandboxPath;
    private IPath shedEntry;
    private SimpleDateFormat formatter;

    public LocalFileBackup(ISandbox sandbox, BackupDilemmaHandler backupDilemmaHandler) {
        this.problemHandler = backupDilemmaHandler == null ? BackupDilemmaHandler.getDefault() : backupDilemmaHandler;
        this.maxFileSize = (long)this.problemHandler.getMaxFileSize() * 0x100000L;
        this.shedEntryCreated = false;
        this.formatter = new SimpleDateFormat(FORMAT);
        this.preferredName = PREFIX + this.formatter.format(new Date(System.currentTimeMillis()));
        this.sandboxPath = (IPath)sandbox.getRoot().getAdapter(IPath.class);
    }

    @Override
    public void backupInShed(IShareable itemToBackup, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.sandboxPath != null) {
            if (!this.shedEntryCreated) {
                this.cleanup(this.sandboxPath.append(JAZZ_SHED), (IProgressMonitor)progress.newChild(9));
                this.shedEntry = this.sandboxPath.append(JAZZ_SHED).append(this.preferredName);
                File shedEntryFile = this.shedEntry.toFile();
                if (!shedEntryFile.exists() && !shedEntryFile.mkdirs()) {
                    throw new FileSystemException(NLS.bind((String)Messages.Shed_0, (Object)this.shedEntry.toString(), (Object[])new Object[0]));
                }
                this.shedEntryCreated = true;
            }
            ResourceType type = itemToBackup.getResourceType((IProgressMonitor)progress.newChild(1));
            byte[] buffer = new byte[32768];
            if (type != null) {
                IPath shedLocation = this.shedEntry.append(itemToBackup.getLocalPath().removeLastSegments(1).toString());
                File shedLocationFile = shedLocation.toFile();
                if (!shedLocationFile.exists() && !shedLocationFile.mkdirs()) {
                    throw new FileSystemException(NLS.bind((String)Messages.Shed_1, (Object)shedLocation.toString(), (Object[])new Object[]{itemToBackup.getLocalPath().toString()}));
                }
                this.makeBackupCopy(this.sandboxPath, itemToBackup.getLocalPath(), shedLocationFile, buffer, (IProgressMonitor)progress.newChild(90));
                this.problemHandler.backedUpInShed(itemToBackup, new PathLocation(shedLocation.append(itemToBackup.getLocalPath().getName())));
            }
        }
    }

    private void makeBackupCopy(IPath sandboxPath, IRelativeLocation toBackupPath, File shedLocationFile, byte[] buffer, IProgressMonitor progress) {
        block18: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IPath fullPath = sandboxPath;
            String[] stringArray = toBackupPath.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                fullPath = fullPath.append(part);
                ++n2;
            }
            IFileStore storage = EFS.getLocalFileSystem().getStore(fullPath);
            try {
                IFileInfo fileInfo = storage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                if (fileInfo.getAttribute(32)) {
                    IPath shedPath = new Path(shedLocationFile.getAbsolutePath()).append(fullPath.lastSegment());
                    IFileStore shedStorage = EFS.getLocalFileSystem().getStore(shedPath);
                    IPath relativeShedPath = shedPath.removeFirstSegments(sandboxPath.segmentCount());
                    ManagedFileStore managed = new ManagedFileStore(new PathLocation(sandboxPath), new RelativeLocation(relativeShedPath.segments()), shedStorage);
                    String target = fileInfo.getStringAttribute(64);
                    LinkType targetType = managed.getTargetType((IProgressMonitor)monitor.newChild(1));
                    managed.symlink(target == null ? "" : target, targetType == LinkType.DIRECTORY, (IProgressMonitor)monitor.newChild(98));
                    break block18;
                }
                if (fileInfo.isDirectory()) {
                    File copy = new File(shedLocationFile, fullPath.lastSegment());
                    if (copy.exists() || copy.mkdir()) {
                        String[] children = fullPath.toFile().list();
                        if (children != null) {
                            monitor.setWorkRemaining(children.length);
                            String[] stringArray2 = children;
                            int target = children.length;
                            int managed = 0;
                            while (managed < target) {
                                String child = stringArray2[managed];
                                this.makeBackupCopy(sandboxPath, toBackupPath.append(child), copy, buffer, (IProgressMonitor)monitor.newChild(1));
                                ++managed;
                            }
                        }
                    } else {
                        LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.Shed_2, (Object)toBackupPath.toString(), (Object[])new Object[0])));
                    }
                    break block18;
                }
                if (!fileInfo.exists() || fileInfo.getLength() > this.maxFileSize) break block18;
                File copy = new File(shedLocationFile, fullPath.lastSegment());
                try {
                    FileInputStream inputStream = new FileInputStream(fullPath.toFile());
                    UnsynchronizedBufferedInputStream input = new UnsynchronizedBufferedInputStream((InputStream)inputStream);
                    try {
                        if (!copy.createNewFile()) break block18;
                        FileOutputStream stream = new FileOutputStream(copy);
                        try {
                            int numbytes = input.read(buffer);
                            while (numbytes != -1) {
                                stream.write(buffer, 0, numbytes);
                                numbytes = input.read(buffer);
                            }
                        }
                        finally {
                            stream.close();
                        }
                    }
                    finally {
                        input.close();
                    }
                }
                catch (IOException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.Shed_2, (Object)toBackupPath.toString(), (Object[])new Object[0]), e));
                }
            }
            catch (CoreException e) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(2, NLS.bind((String)Messages.Shed_2, (Object)toBackupPath.toString(), (Object[])new Object[0]), e));
            }
        }
    }

    private void cleanup(IPath shedRoot, IProgressMonitor progress) {
        File[] children;
        File shedRootFile = shedRoot.toFile();
        if (!shedRootFile.exists()) {
            return;
        }
        if (!shedRootFile.isDirectory()) {
            shedRootFile.delete();
            return;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(5, -1 * this.problemHandler.getPreferredShedLifespan());
        Date age = calendar.getTime();
        File[] fileArray = children = shedRootFile.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String child = file.getName();
            if (child.startsWith(PREFIX)) {
                String timeStampString = child.substring(PREFIX.length());
                try {
                    Date date = this.formatter.parse(timeStampString);
                    if (date.before(age)) {
                        this.delete(file, progress);
                    }
                }
                catch (ParseException parseException) {
                    this.delete(file, progress);
                }
            } else {
                this.delete(file, progress);
            }
            ++n2;
        }
    }

    private void delete(File file, IProgressMonitor monitor) {
        if (file.delete() || !file.exists()) {
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(file.getAbsolutePath()));
        try {
            IFileInfo fileInfo = fileStore.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
            if (!fileInfo.getAttribute(32) && fileInfo.isDirectory()) {
                File[] children = file.listFiles();
                progress.setWorkRemaining(1 + children.length);
                File[] fileArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    this.delete(child, (IProgressMonitor)progress.newChild(1));
                    ++n2;
                }
            }
            file.delete();
        }
        catch (CoreException coreException) {}
        progress.done();
    }

    public static int getShedEntryCount(ILocation sandboxRoot) {
        IPath sandboxPath = (IPath)sandboxRoot.getAdapter(IPath.class);
        if (sandboxPath != null) {
            File shedLocation = LocalFileBackup.getShedLocation(sandboxPath);
            if (!shedLocation.exists() || !shedLocation.isDirectory()) {
                return 0;
            }
            String[] children = shedLocation.list();
            if (children == null) {
                return 0;
            }
            return children.length;
        }
        return 0;
    }

    private static File getShedLocation(IPath sandboxRoot) {
        return sandboxRoot.append(JAZZ_SHED).toFile();
    }

    public static Iterable<IPath> getShedEntries(IPath sandboxRoot) {
        File shedRoot = LocalFileBackup.getShedLocation(sandboxRoot);
        final File[] files = shedRoot.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (!pathname.isDirectory()) {
                    return false;
                }
                return pathname.getName().startsWith(LocalFileBackup.PREFIX);
            }
        });
        return new Iterable<IPath>(){

            @Override
            public Iterator<IPath> iterator() {
                return new Iterator<IPath>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < files.length;
                    }

                    @Override
                    public IPath next() {
                        return new Path(files[this.i++].getAbsolutePath());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public boolean supportsShedBackup() {
        return true;
    }
}

