/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.api.content;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.client.internal.magic.MagicPattern;
import com.ibm.team.filesystem.client.internal.rest.util.CoreUtil;
import com.ibm.team.filesystem.client.internal.utils.PropertiesLoader;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class MagicContentExaminer {
    private static final String PROP_MIME = "mime";
    private static final String PROP_DELIM = "delim";
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_CASE = "respectcase";
    private static final String MAGIC_SOURCE_DEFAULT = "/resources/magic.default.properties";
    public static final String MAGIC_SOURCE_USER_FILENAME = "magic.properties";
    private static final MagicPattern UNKNOWN = new MagicPattern("", true, ContentProperties.UNKNOWN.getMimeType(), ContentProperties.UNKNOWN.getLineDelimiter(), null, true);
    private final String pathToUserHome;
    private File userDir;
    private List<MagicPattern> matchers = null;
    private static final char ESCAPE = '\\';
    private static final char QUOTE = '\"';
    private static final char SEMI = ';';

    public MagicContentExaminer(String pathToUserHome) {
        this.pathToUserHome = pathToUserHome;
    }

    public MagicContentExaminer() {
        this(null);
    }

    private File getUserDir() throws IOException {
        if (this.userDir != null) {
            return this.userDir;
        }
        if (this.pathToUserHome == null) {
            this.userDir = new File(FileSystemCore.getUserConfigDir().getConfigDir());
            return this.userDir;
        }
        this.userDir = new File(this.pathToUserHome);
        if (!this.userDir.exists()) {
            throw new IOException(NLS.bind((String)Messages.MagicContentExaminer_1, (Object)this.pathToUserHome));
        }
        return this.userDir;
    }

    public final synchronized List<MagicPattern> getMatchers(IProgressMonitor progress) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        if (this.matchers != null) {
            return this.matchers;
        }
        mon.beginTask(Messages.LocalContentExaminer_LOAD_PROGRESS_MESSAGE, 4);
        this.matchers = new ArrayList<MagicPattern>();
        InputStream in = this.getUserPatternStream(mon.newChild(1));
        if (in != null) {
            mon.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_USER);
            this.matchers.addAll(this.parseStream(in, false, mon.newChild(1)));
        }
        mon.setWorkRemaining(2);
        in = this.getBasePatternStream(mon.newChild(1));
        if (in != null) {
            mon.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_DEFAULTS);
            this.matchers.addAll(this.parseStream(in, true, mon.newChild(1)));
        }
        return this.matchers;
    }

    public final synchronized void setMatchers(List<MagicPattern> patterns, IProgressMonitor progress) throws IOException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        File userDir = this.getUserDir();
        this.matchers = new ArrayList<MagicPattern>();
        for (MagicPattern p : patterns) {
            if (!p.isBuiltIn()) continue;
            throw new IllegalArgumentException();
        }
        this.matchers.addAll(patterns);
        mon.setWorkRemaining(2);
        InputStream in = this.getBasePatternStream(mon.newChild(1));
        if (in != null) {
            mon.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_DEFAULTS);
            this.matchers.addAll(this.parseStream(in, true, mon.newChild(1)));
        }
        File patternFile = new File(userDir, MAGIC_SOURCE_USER_FILENAME);
        patternFile.getParentFile().mkdirs();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(patternFile, false), "UTF-8"));
        try {
            writer.write("### Jazz Magic 0");
            writer.newLine();
            for (MagicPattern p : patterns) {
                writer.append(MagicContentExaminer.escapePattern(p.getPattern()));
                writer.append(": ");
                boolean writeSep = false;
                if (p.getMimeType() != null) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_MIME);
                    writer.append(": ");
                    writer.append(MagicContentExaminer.escapeValue(p.getMimeType()));
                    writeSep = true;
                }
                if (p.getEncoding() != null) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_ENCODING);
                    writer.append(": ");
                    writer.append(MagicContentExaminer.escapeValue(p.getEncoding()));
                    writeSep = true;
                }
                if (p.getDelim() != null && p.getDelim() != FileLineDelimiter.LINE_DELIMITER_NONE) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_DELIM);
                    writer.append(": ");
                    writer.write(CoreUtil.getLineDelimiter(p.getDelim()));
                    writeSep = true;
                }
                if (!p.matcher.isIgnoreCase()) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_CASE);
                    writer.append(": true");
                    writeSep = true;
                }
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    private void writeSep(BufferedWriter writer, boolean writeSep) throws IOException {
        if (writeSep) {
            writer.append("; ");
        }
    }

    private static String escapePattern(String s) {
        return s;
    }

    private static String escapeValue(String s) {
        boolean quote = false;
        if (s.contains("\"")) {
            s = s.replace("\"", "\\\"");
            quote = true;
        }
        if (quote || s.contains(";")) {
            return "\"" + s + "\"";
        }
        return s;
    }

    private InputStream getUserPatternStream(SubMonitor subMonitor) {
        File userDir = null;
        try {
            userDir = this.getUserDir();
        }
        catch (IOException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(e));
        }
        if (userDir == null || !userDir.exists()) {
            return null;
        }
        File patternFile = new File(userDir, MAGIC_SOURCE_USER_FILENAME);
        if (!patternFile.exists()) {
            return null;
        }
        try {
            return new FileInputStream(patternFile);
        }
        catch (FileNotFoundException e) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.LocalContentExaminer_COULD_NOT_OPEN_MAGIC_FILE, (Object)patternFile.getAbsolutePath()), e));
            return null;
        }
    }

    private List<MagicPattern> parseStream(InputStream in, boolean isBuiltIn, SubMonitor monitor) {
        LinkedHashMap<String, String> patterns;
        block12: {
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            patterns = new LinkedHashMap<String, String>();
            try {
                try {
                    PropertiesLoader.load(patterns, in, "UTF-8", -1L, (IProgressMonitor)monitor.newChild(9));
                }
                catch (IOException e) {
                    LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Couldn't load base magic file", e));
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        monitor.setWorkRemaining(patterns.size());
        ArrayList<MagicPattern> result = new ArrayList<MagicPattern>(patterns.size());
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            MagicPattern template = this.parseTemplate(entry.getKey(), entry.getValue(), isBuiltIn, monitor.newChild(1));
            if (template == null) continue;
            result.add(template);
        }
        return result;
    }

    private StringBuffer convertToPropsFile(String line) {
        StringBuffer buf = new StringBuffer();
        State s = State.BARE;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            block0 : switch (s) {
                case BARE: {
                    switch (c) {
                        case '\"': {
                            s = State.QUOTED;
                            break block0;
                        }
                        case ';': {
                            buf.append("\n");
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case QUOTED: {
                    switch (c) {
                        case '\\': {
                            s = State.ESCAPED;
                            break block0;
                        }
                        case '\"': {
                            s = State.BARE;
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case ESCAPED: {
                    buf.append(c);
                    s = State.QUOTED;
                }
            }
            ++i;
        }
        return buf;
    }

    private MagicPattern parseTemplate(String pattern, String template, boolean isBuiltIn, SubMonitor monitor) {
        FileLineDelimiter delim;
        String asPropFile = this.convertToPropsFile(template).toString();
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            PropertiesLoader.load(props, new ByteArrayInputStream(asPropFile.getBytes("UTF-8")), "UTF-8", -1L, (IProgressMonitor)monitor);
        }
        catch (IOException e) {
            LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.LocalContentExaminer_FAILED_TO_PARSE, (Object)pattern), (Throwable)e));
            return null;
        }
        String mime = props.get(PROP_MIME);
        String delimStr = props.get(PROP_DELIM);
        if (delimStr == null) {
            delim = null;
        } else {
            try {
                delim = CoreUtil.getLineDelimiter(delimStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.LocalContentExaminer_UNRECOGNIZED_VALUE, (Object[])new String[]{PROP_DELIM, pattern, delimStr})));
                delim = null;
            }
        }
        String encoding = props.get(PROP_ENCODING);
        boolean respectCase = false;
        if (props.containsKey(PROP_CASE)) {
            respectCase = props.get(PROP_CASE).trim().toLowerCase(Locale.ENGLISH).equals("true");
        }
        return new MagicPattern(pattern, !respectCase, mime, delim, encoding, isBuiltIn);
    }

    private InputStream getBasePatternStream(SubMonitor subMonitor) {
        InputStream r = this.getClass().getResourceAsStream(MAGIC_SOURCE_DEFAULT);
        if (r == null) {
            LoggingHelper.log(FileSystemStatusUtil.getStatusFor(4, "Could not open default magic file", null));
        }
        return r;
    }

    protected final String getMagicEncoding(String name, IProgressMonitor monitor) {
        List<MagicPattern> matched = this.getMagicMatchers(name, monitor);
        return this.getEncoding(matched);
    }

    protected final IContentProperties getMagicProperties(String name, IProgressMonitor monitor) {
        List<MagicPattern> matched = this.getMagicMatchers(name, monitor);
        String mimeType = this.getMimeType(matched);
        FileLineDelimiter lineDelimiter = this.getLineDelimiter(matched);
        String encoding = this.getEncoding(matched);
        return new ContentProperties(encoding, mimeType, lineDelimiter);
    }

    private List<MagicPattern> getMagicMatchers(String name, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<MagicPattern> matchers = this.getMatchers((IProgressMonitor)progress.newChild(9));
        ArrayList<MagicPattern> matched = new ArrayList<MagicPattern>(1);
        progress.setWorkRemaining(matchers.size());
        for (MagicPattern defn : matchers) {
            if (defn.matcher.match(name)) {
                matched.add(defn);
            }
            progress.worked(1);
        }
        if (matched.size() == 0) {
            matched.add(UNKNOWN);
        }
        return matched;
    }

    private FileLineDelimiter getLineDelimiter(List<MagicPattern> matched) {
        FileLineDelimiter delim = FileLineDelimiter.LINE_DELIMITER_NONE;
        for (MagicPattern defn : matched) {
            if (defn.delim == null) continue;
            delim = defn.delim;
            break;
        }
        return delim;
    }

    private String getMimeType(List<MagicPattern> matched) {
        String mimeType = "application/unknown";
        for (MagicPattern defn : matched) {
            if (defn.mimeType == null) continue;
            mimeType = defn.mimeType;
            break;
        }
        return mimeType;
    }

    private String getEncoding(List<MagicPattern> matched) {
        for (MagicPattern defn : matched) {
            if (defn.encoding == null) continue;
            return defn.encoding;
        }
        return null;
    }

    public static interface IStreamSource {
        public InputStream getStream() throws FileSystemException;
    }

    private static enum State {
        BARE,
        QUOTED,
        ESCAPED;

    }
}

