/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.internal.repository.rcp.dbhm.DiskBackedHashMap;
import com.ibm.team.repository.client.util.Event;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.client.util.IListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class IgnoredItemSet
implements IListener,
IEventSource {
    static final long IS_IGNORED = -1L;
    public static final String PROGRESS = "progress";
    public static final String PROGRESS_COMPLETE = "complete";
    private final IIgnoreManager igMan;
    Map<ISandbox, ItemSetDiskBackedHashMap> ignoredItems = new HashMap<ISandbox, ItemSetDiskBackedHashMap>();
    private long totalIgnored = 0L;
    private final LinkedList<IEvent> eventList = new LinkedList();
    Job eventProcessor = new Job(Messages.IgnoredItemSet_4){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor progress) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
            try {
                while (true) {
                    IIgnoreEvent event;
                    LinkedList linkedList = IgnoredItemSet.this.eventList;
                    synchronized (linkedList) {
                        monitor.setWorkRemaining(IgnoredItemSet.this.eventList.size());
                        event = (IIgnoreEvent)IgnoredItemSet.this.eventList.poll();
                    }
                    if (event == null) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    this.process(event, monitor.newChild(1));
                    IgnoredItemSet.this.eventSource.queueEvent((Object)event);
                    continue;
                    break;
                }
            }
            catch (FileSystemException e) {
                IStatus iStatus = FileSystemStatusUtil.getStatusFor(4, Messages.IgnoredItemSet_5, (Throwable)((Object)e));
                return iStatus;
            }
            finally {
                monitor.done();
                IgnoredItemSet.this.eventSource.queueEvent((Object)new IgnoredItemSetProgressEvent(IgnoredItemSet.this, IgnoredItemSet.PROGRESS_COMPLETE, IgnoredItemSet.this.getTotalIgnored()));
            }
        }

        private void process(IIgnoreEvent event, SubMonitor monitor) throws FileSystemException {
            monitor.beginTask(null, 2);
            String type = event.getChangeType();
            if ("ignore".equals(type)) {
                IgnoredItemSet.this.addIgnoredItems(event.getChanged((IProgressMonitor)monitor.newChild(1)), (IProgressMonitor)monitor.newChild(1));
            } else if ("unignore".equals(type)) {
                IgnoredItemSet.this.removeIgnoredItems(event.getChanged((IProgressMonitor)monitor.newChild(1)), (IProgressMonitor)monitor.newChild(1));
            }
        }
    };
    private final EventSource eventSource = new EventSource();

    public IgnoredItemSet(IIgnoreManager igMan) {
        this.igMan = igMan;
        this.igMan.addGenericListener(IIgnoreEvent.ALL_EVENTS, this);
    }

    public void internalPopulateFrom(Collection<? extends IShareable> roots, IProgressMonitor progress) throws FileSystemException {
        IShareable current;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        LinkedList<? extends IShareable> toVisit = new LinkedList<IShareable>();
        toVisit.addAll(roots);
        while ((current = (IShareable)toVisit.poll()) != null) {
            monitor.setWorkRemaining(toVisit.size() + 5);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.igMan.shouldBeIgnored(current, (IProgressMonitor)monitor.newChild(1))) {
                long ignoredDescendents = 1L;
                if (current.getResourceType((IProgressMonitor)monitor.newChild(1)) == ResourceType.FOLDER) {
                    ignoredDescendents = this.tallyIgnoredSubtree(current, (IProgressMonitor)monitor.newChild(1));
                }
                this.register(current, ignoredDescendents);
                continue;
            }
            IFileStorage store = ((Shareable)current).getFileStorage();
            Collection<IFileStorage> children = store.getChildren(true, (IProgressMonitor)monitor.newChild(1));
            for (IFileStorage child : children) {
                toVisit.add(child.getShareable());
            }
        }
    }

    public void populateFrom(Collection<? extends IShareable> roots, IProgressMonitor progress) throws FileSystemException {
        this.internalPopulateFrom(roots, progress);
        this.dispatchProcessedEvent(PROGRESS_COMPLETE);
    }

    private void dispatchProcessedEvent(String type) {
        this.eventSource.queueEvent((Object)new IgnoredItemSetProgressEvent(this, type, this.getTotalIgnored()));
    }

    /*
     * Unable to fully structure code
     */
    private long tallyIgnoredSubtree(IShareable ignoredRoot, IProgressMonitor monitor) throws FileSystemException {
        toVisit = new LinkedList<TallyParent>();
        toVisit.add(new TallyParent(((Shareable)ignoredRoot).getFileStorage(), null));
        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(toVisit.size() * 3));
        block0: while (true) {
            current = (TallyParent)toVisit.peek();
            progress.setWorkRemaining(toVisit.size() * 3);
            Assert.isNotNull((Object)current);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            Assert.isTrue((boolean)(current.store.getShareable().getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.FOLDER));
            if (current.visitedChildren) {
                current.setParentTally();
                if (toVisit.size() == 1) {
                    return current.ignoredDescendents + 1L;
                }
                toVisit.poll();
                continue;
            }
            current.visitedChildren = true;
            children = current.store.getChildren(true, (IProgressMonitor)progress.newChild(1));
            current.ignoredDescendents += (long)children.size();
            iterProgress = progress.newChild(1);
            iterProgress.setWorkRemaining(children.size());
            var9_9 = children.iterator();
            while (true) {
                if (var9_9.hasNext()) ** break;
                continue block0;
                child = var9_9.next();
                if (child.getShareable().getResourceType((IProgressMonitor)iterProgress.newChild(1)) != ResourceType.FOLDER) continue;
                toVisit.addFirst(new TallyParent(child, current));
            }
            break;
        }
    }

    private void register(IShareable current, long ignoredDescendents) {
        ISandbox shareRoot = current.getSandbox();
        IRelativeLocation localFullPath = current.getLocalPath();
        ItemSetDiskBackedHashMap shareItems = this.ignoredItems.get(shareRoot);
        if (shareItems == null) {
            shareItems = new ItemSetDiskBackedHashMap();
        }
        shareItems.put(localFullPath, new IgnoreNode(true, ignoredDescendents));
        this.ignoredItems.put(shareRoot, shareItems);
        IRelativeLocation walker = localFullPath;
        while (walker.segmentCount() > 0) {
            IgnoreNode node = (IgnoreNode)shareItems.get(walker = walker.getParent());
            node = node == null ? new IgnoreNode(false, ignoredDescendents) : new IgnoreNode(node.isIgnored, node.ignoreCount + ignoredDescendents);
            shareItems.put(walker, node);
            this.ignoredItems.put(shareRoot, shareItems);
        }
        this.totalIgnored += ignoredDescendents;
    }

    private void deregister(IShareable shareable, SubMonitor monitor) throws FileSystemException {
        Map shareItems = (Map)((Object)this.ignoredItems.get(shareable.getSandbox()));
        IgnoreNode removed = (IgnoreNode)shareItems.remove(shareable.getLocalPath());
        Assert.isNotNull((Object)removed);
        IRelativeLocation walker = shareable.getLocalPath();
        do {
            IgnoreNode node;
            if ((node = (IgnoreNode)shareItems.get(walker = walker.removeLastSegments(1))) == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoredItemSet_2, (Object)walker));
            }
            if (node.ignoreCount > removed.ignoreCount) {
                shareItems.put(walker, new IgnoreNode(false, node.ignoreCount - removed.ignoreCount));
                continue;
            }
            shareItems.remove(walker);
        } while (walker.segmentCount() > 0);
        this.totalIgnored -= removed.ignoreCount;
        this.internalPopulateFrom(Collections.singletonList(shareable), (IProgressMonitor)monitor);
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasIgnoredDescendents(IShareable shareable) {
        shareItems = (Map)this.ignoredItems.get(shareable.getSandbox());
        if (shareItems == null) {
            return false;
        }
        walker = shareable.getLocalPath();
        if (shareItems.get(walker) == null) ** GOTO lbl10
        return true;
lbl-1000:
        // 1 sources

        {
            node = (IgnoreNode)shareItems.get(walker = walker.removeLastSegments(1));
            if (node == null) continue;
            return node.isIgnored;
lbl10:
            // 2 sources

            ** while (walker.segmentCount() > 0)
        }
lbl11:
        // 1 sources

        return false;
    }

    public void removeIgnoredItems(Collection<IShareable> shareables, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)shareables.size());
        for (IShareable shareable : shareables) {
            Map shareItems = (Map)((Object)this.ignoredItems.get(shareable.getSandbox()));
            if (shareItems == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.IgnoredItemSet_3, (Object)shareable.getSandbox().getRoot()));
            }
            IgnoreNode node = (IgnoreNode)shareItems.get(shareable.getLocalPath());
            if (node == null) {
                return;
            }
            this.deregister(shareable, monitor.newChild(1));
        }
        monitor.done();
    }

    private void pruneIgnoredBelow(IShareable shareable, IProgressMonitor monitor) throws FileSystemException {
        Map shareItems = (Map)((Object)this.ignoredItems.get(shareable.getSandbox()));
        if (shareItems == null) {
            return;
        }
        IgnoreNode rootNode = (IgnoreNode)shareItems.get(shareable.getLocalPath());
        if (rootNode == null) {
            return;
        }
        LinkedList<IFileStorage> toPrune = new LinkedList<IFileStorage>();
        toPrune.add(((Shareable)shareable).getFileStorage());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toPrune.size());
        while (!toPrune.isEmpty()) {
            IFileStorage store = (IFileStorage)toPrune.poll();
            progress.setWorkRemaining(toPrune.size());
            Collection<IFileStorage> children = store.getChildren(true, (IProgressMonitor)progress.newChild(1));
            for (IFileStorage child : children) {
                IgnoreNode childNode = (IgnoreNode)shareItems.remove(child.getShareable().getLocalPath());
                if (childNode == null) continue;
                toPrune.addFirst(child);
            }
        }
        long dec = rootNode.ignoreCount;
        IRelativeLocation walker = shareable.getLocalPath();
        while (walker.segmentCount() > 0) {
            walker = walker.getParent();
            IgnoreNode node = (IgnoreNode)shareItems.remove(walker);
            shareItems.put(walker, new IgnoreNode(false, node.ignoreCount - dec));
        }
        this.totalIgnored -= dec;
    }

    public void addIgnoredItems(Collection<IShareable> newlyIgnored, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(newlyIgnored.size() * 3));
        for (IShareable shareable : newlyIgnored) {
            Assert.isTrue((boolean)this.igMan.shouldBeIgnored(shareable, (IProgressMonitor)monitor.newChild(1)));
            this.pruneIgnoredBelow(shareable, (IProgressMonitor)monitor.newChild(1));
            this.internalPopulateFrom(Collections.singletonList(shareable), (IProgressMonitor)monitor.newChild(1));
            monitor.worked(1);
        }
        this.dispatchProcessedEvent(PROGRESS_COMPLETE);
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List events) {
        LinkedList<IEvent> linkedList = this.eventList;
        synchronized (linkedList) {
            this.eventList.addAll(events);
        }
        this.eventProcessor.schedule();
    }

    public void addGenericListener(Object category, IListener listener) {
        this.eventSource.addGenericListener(category, listener);
    }

    public void addGenericListener(Object[] categories, IListener listener) {
        Object[] objectArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            Object category = objectArray[n2];
            this.addGenericListener(category, listener);
            ++n2;
        }
    }

    public void purgeGenericListener(IListener listener) {
        this.eventSource.purgeGenericListener(listener);
    }

    public void removeGenericListener(Object category, IListener listener) {
        this.eventSource.removeGenericListener(category, listener);
    }

    public long getTotalIgnored() {
        return this.totalIgnored;
    }

    public long getIgnoredDescendentCount(IShareable shareable) {
        Map shareItems = (Map)((Object)this.ignoredItems.get(shareable.getSandbox()));
        if (shareItems == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.IgnoredItemSet_6, (Object)shareable.getSandbox().getRoot()));
        }
        IgnoreNode node = (IgnoreNode)shareItems.get(shareable.getLocalPath());
        if (node == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.IgnoredItemSet_7, (Object)shareable.getLocalPath()));
        }
        return node.ignoreCount;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasIgnoredAncestor(IShareable shareable) {
        shareItems = (Map)this.ignoredItems.get(shareable.getSandbox());
        if (shareItems == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.IgnoredItemSet_8, (Object)shareable.getSandbox().getRoot()));
        }
        walker = shareable.getLocalPath();
        node = (IgnoreNode)shareItems.get(walker);
        if (node == null || !node.isIgnored) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            node = (IgnoreNode)shareItems.get(walker = walker.removeLastSegments(1));
            if (node == null) continue;
            return node.isIgnored;
lbl11:
            // 2 sources

            ** while (walker.segmentCount() > 0)
        }
lbl12:
        // 1 sources

        return false;
    }

    private static class IgnoreNode
    implements Serializable {
        private static final long serialVersionUID = -3614816745843352370L;
        final boolean isIgnored;
        final long ignoreCount;

        public IgnoreNode(boolean isIgnored, long ignoreCount) {
            this.isIgnored = isIgnored;
            this.ignoreCount = ignoreCount;
        }
    }

    public static class IgnoredItemSetProgressEvent
    extends Event {
        private static final long serialVersionUID = 7358376225299250693L;
        private final long ignored;

        public IgnoredItemSetProgressEvent(IEventSource eventSource, String eventType, long ignored) {
            super(eventSource, eventType);
            this.ignored = ignored;
        }

        public long getIgnoreCount() {
            return this.ignored;
        }
    }

    private static class ItemSetDiskBackedHashMap
    extends DiskBackedHashMap<IRelativeLocation, IgnoreNode> {
        private ItemSetDiskBackedHashMap() {
        }

        protected long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(out);
            if ((1 & flags) != 0) {
                IRelativeLocation path = (IRelativeLocation)o;
                oos.writeInt(path.segmentCount());
                String[] stringArray = path.segments();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    oos.writeUTF(part);
                    ++n2;
                }
            } else {
                oos.writeObject(o);
            }
            oos.flush();
            return this.persistStream(out);
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            ObjectInputStream ois = new ObjectInputStream(in);
            if ((1 & flags) != 0) {
                int partCount = ois.readInt();
                String[] parts = new String[partCount];
                int i = 0;
                while (i < partCount) {
                    parts[i] = ois.readUTF();
                    ++i;
                }
                return new RelativeLocation(parts);
            }
            return ois.readObject();
        }
    }

    private static class TallyParent {
        final IFileStorage store;
        long ignoredDescendents = 0L;
        boolean visitedChildren = false;
        final TallyParent parent;

        public TallyParent(IFileStorage store, TallyParent parent) {
            this.store = store;
            this.parent = parent;
        }

        public void setParentTally() {
            Assert.isTrue((boolean)this.visitedChildren);
            if (this.parent != null) {
                this.parent.ignoredDescendents += this.ignoredDescendents;
            }
        }
    }
}

