/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.IUpdateSubcomponentOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IComponentHierarchyUpdateResult;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class UpdateSubcomponentOperation
extends FileSystemOperation
implements IUpdateSubcomponentOperation {
    private IWorkspaceConnection fWorkspaceConnection;
    private IComponentHandle fParentComponent;
    private Map<UUID, IComponentHandle> fChildrenToAdd = new HashMap<UUID, IComponentHandle>();
    private Map<UUID, IComponentHandle> fChildrenToRemove = new HashMap<UUID, IComponentHandle>();
    private IChangeSetHandle fPreferredChangeSet;
    private IComponentHierarchyUpdateResult result;

    public UpdateSubcomponentOperation(UpdateDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : dilemmaHandler);
    }

    @Override
    public UpdateDilemmaHandler getDilemmaHandler() {
        return (UpdateDilemmaHandler)super.getDilemmaHandler();
    }

    @Override
    public void addSubcomponents(IWorkspaceConnection workspaceConnection, IComponentHandle parentComponent, Collection<IComponentHandle> childrenToAdd, IChangeSetHandle preferredChangeset) {
        if (!(this.fWorkspaceConnection == null || this.fWorkspaceConnection.equals((Object)workspaceConnection) || this.fParentComponent == null || this.fParentComponent.sameItemId((IItemHandle)parentComponent) || this.fPreferredChangeSet == null || preferredChangeset == null || this.fPreferredChangeSet.sameItemId((IItemHandle)preferredChangeset))) {
            throw new IllegalArgumentException("Future calls to addSubcomponents must operate against the same workspaceConnection/parentComponent/preferredChangeSet");
        }
        this.fWorkspaceConnection = workspaceConnection;
        this.fParentComponent = parentComponent;
        for (IComponentHandle component : childrenToAdd) {
            this.fChildrenToAdd.put(component.getItemId(), component);
            this.fChildrenToRemove.remove(component.getItemId());
        }
        this.fPreferredChangeSet = preferredChangeset;
    }

    @Override
    public void removeSubcomponents(IWorkspaceConnection workspaceConnection, IComponentHandle parentComponent, Collection<IComponentHandle> childrenToRemove, IChangeSetHandle preferredChangeset) {
        if (!(this.fWorkspaceConnection == null || this.fWorkspaceConnection.equals((Object)workspaceConnection) || this.fParentComponent == null || this.fParentComponent.sameItemId((IItemHandle)parentComponent) || this.fPreferredChangeSet == null || preferredChangeset == null || this.fPreferredChangeSet.sameItemId((IItemHandle)preferredChangeset))) {
            throw new IllegalArgumentException("Future calls to removeSubcomponents must operate against the same workspaceConnection/parentComponent/preferredChangeSet");
        }
        this.fWorkspaceConnection = workspaceConnection;
        this.fParentComponent = parentComponent;
        for (IComponentHandle component : childrenToRemove) {
            this.fChildrenToRemove.put(component.getItemId(), component);
            this.fChildrenToAdd.remove(component.getItemId());
        }
        this.fPreferredChangeSet = preferredChangeset;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.result = this.fWorkspaceConnection.updateSubcomponentData(this.fParentComponent, this.fChildrenToAdd.values(), this.fChildrenToRemove.values(), this.fPreferredChangeSet, (IProgressMonitor)progress.newChild(50));
        UpdateOperation updateOperation = new UpdateOperation(this.fWorkspaceConnection, Collections.singletonList(this.result.getReport()), 3, this.getDilemmaHandler(), null);
        this.disableVerifyInSync(updateOperation);
        updateOperation.run((IProgressMonitor)progress.newChild(50));
    }

    @Override
    public IComponentHierarchyUpdateResult getResult() {
        return this.result;
    }
}

