/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.IPersistentFlag;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.IOException;

public class PersistentFlag
implements IPersistentFlag {
    private boolean state = false;
    private File file;

    public PersistentFlag(File file) {
        this.file = file;
        this.state = file.exists();
    }

    @Override
    public boolean setState(boolean newState) throws IOException {
        boolean oldState = this.state;
        this.state = newState;
        if (newState) {
            this.writeTrue();
        } else {
            this.writeFalse();
        }
        return oldState;
    }

    private void writeTrue() throws IOException {
        this.ensureParents();
        if (!this.file.createNewFile()) {
            if (this.file.exists()) {
                return;
            }
            throw new IOException(NLS.bind((String)Messages.PersistentFlag_0, (Object)this.file.getAbsolutePath(), (Object[])new Object[0]));
        }
    }

    private void writeFalse() throws IOException {
        this.ensureParents();
        if (!this.file.delete() && this.file.exists()) {
            throw new IOException(NLS.bind((String)Messages.PersistentFlag_1, (Object)this.file.getAbsolutePath(), (Object[])new Object[0]));
        }
    }

    private void ensureParents() throws IOException {
        File parent = this.file.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
    }

    @Override
    public boolean getState() {
        return this.state;
    }

    public String toString() {
        return String.valueOf(this.file.getAbsolutePath()) + " (" + this.state + ')';
    }
}

