/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.treedifferencer;

import com.ibm.team.foundation.common.treedifferencer.ICost;
import com.ibm.team.foundation.common.treedifferencer.ITree;
import com.ibm.team.foundation.common.treedifferencer.TreeDifference;
import com.ibm.team.foundation.common.treedifferencer.TreeEdit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class TreeComparator {
    public TreeDifference findDifferences(ITree t1, ITree t2, ICost cost) {
        TreeData tree1 = this.preProcess(t1);
        TreeData tree2 = this.preProcess(t2);
        TreeEditChain[][] treedist = new TreeEditChain[tree1.nodes.length][tree2.nodes.length];
        Integer[] integerArray = tree1.lrKeyroot;
        int n = tree1.lrKeyroot.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = integerArray[n2];
            Integer[] integerArray2 = tree2.lrKeyroot;
            int n3 = tree2.lrKeyroot.length;
            int n4 = 0;
            while (n4 < n3) {
                Integer j = integerArray2[n4];
                this.treedist(treedist, tree1, tree2, i, j, cost);
                ++n4;
            }
            ++n2;
        }
        return this.getResult(tree1, tree2, treedist);
    }

    private TreeData preProcess(ITree t) {
        ArrayList<ITree> nodes = new ArrayList<ITree>();
        ArrayList<Integer> l = new ArrayList<Integer>();
        ArrayList<Integer> lrRoots = new ArrayList<Integer>();
        this.preProcess(t, 0, nodes, l, lrRoots);
        return new TreeData(nodes.toArray(new ITree[nodes.size()]), l.toArray(new Integer[l.size()]), lrRoots.toArray(new Integer[lrRoots.size()]));
    }

    private int preProcess(ITree n, int depth, List<ITree> nodes, List<Integer> l, List<Integer> lrRoots) {
        int leftMost = -1;
        for (ITree c : n.getChildren()) {
            int i = this.preProcess(c, depth + 1, nodes, l, lrRoots);
            if (leftMost < 0) {
                leftMost = l.get(i);
                continue;
            }
            lrRoots.add(i);
        }
        int nodeIndex = nodes.size();
        if (leftMost < 0) {
            leftMost = nodeIndex;
        }
        if (depth == 0) {
            lrRoots.add(nodeIndex);
        }
        nodes.add(n);
        l.add(leftMost);
        return nodeIndex;
    }

    private void treedist(TreeEditChain[][] treedist, TreeData tree1, TreeData tree2, int i, int j, ICost cost) {
        int m = i - tree1.l[i] + 2;
        int n = j - tree2.l[j] + 2;
        int ioff = tree1.l[i] - 1;
        int joff = tree2.l[j] - 1;
        TreeEditChain[][] forestdist = new TreeEditChain[m][n];
        int i1 = 1;
        while (i1 < m) {
            forestdist[i1][0] = this.anEdit(TreeEdit.Operation.DELETION, tree1.nodes[i1 + ioff], null, cost, forestdist[i1 - 1][0]);
            ++i1;
        }
        int j1 = 1;
        while (j1 < n) {
            forestdist[0][j1] = this.anEdit(TreeEdit.Operation.INSERTION, tree2.nodes[j1 + joff], null, cost, forestdist[0][j1 - 1]);
            ++j1;
        }
        i1 = 1;
        while (i1 < m) {
            int j12 = 1;
            while (j12 < n) {
                if (tree1.l[i1 + ioff] == tree1.l[i] && tree2.l[j12 + joff] == tree2.l[j]) {
                    forestdist[i1][j12] = this.min(this.anEdit(TreeEdit.Operation.DELETION, tree1.nodes[i1 + ioff], null, cost, forestdist[i1 - 1][j12]), this.anEdit(TreeEdit.Operation.INSERTION, tree2.nodes[j12 + joff], null, cost, forestdist[i1][j12 - 1]), this.anEdit(TreeEdit.Operation.CHANGE, tree1.nodes[i1 + ioff], tree2.nodes[j12 + joff], cost, forestdist[i1 - 1][j12 - 1]));
                    treedist[i1 + ioff][j12 + joff] = forestdist[i1][j12];
                } else {
                    int p = tree1.l[i1 + ioff] - 1 - ioff;
                    int q = tree2.l[j12 + joff] - 1 - joff;
                    forestdist[i1][j12] = this.min(this.anEdit(TreeEdit.Operation.DELETION, tree1.nodes[i1 + ioff], null, cost, forestdist[i1 - 1][j12]), this.anEdit(TreeEdit.Operation.INSERTION, tree2.nodes[j12 + joff], null, cost, forestdist[i1][j12 - 1]), this.anEdit(TreeEdit.Operation.NO_CHANGE, null, null, cost, forestdist[p][q], treedist[i1 + ioff][j12 + joff]));
                }
                ++j12;
            }
            ++i1;
        }
    }

    private TreeDifference getResult(TreeData tree1, TreeData tree2, TreeEditChain[][] treedist) {
        ArrayList<TreeEdit> edits = new ArrayList<TreeEdit>();
        LinkedList<TreeEditChain> queue = new LinkedList<TreeEditChain>();
        HashMap<ITree, ITree> mapping = new HashMap<ITree, ITree>();
        HashSet<ITree> added = new HashSet<ITree>();
        HashSet<ITree> removed = new HashSet<ITree>();
        queue.add(treedist[tree1.nodes.length - 1][tree2.nodes.length - 1]);
        while (!queue.isEmpty()) {
            TreeEditChain editChain = (TreeEditChain)queue.pop();
            TreeEdit edit = editChain.fEdit;
            TreeEdit.Operation operation = edit.getOperation();
            if (operation != TreeEdit.Operation.NO_CHANGE) {
                edits.add(0, edit);
            }
            if (operation == TreeEdit.Operation.INSERTION) {
                added.add(edit.getNode());
            }
            if (operation == TreeEdit.Operation.DELETION) {
                removed.add(edit.getNode());
            }
            if (edit.getNode() != null && edit.getOtherNode() != null) {
                mapping.put(edit.getOtherNode(), edit.getNode());
            }
            TreeEditChain[] treeEditChainArray = editChain.fPredecessors;
            int n = treeEditChainArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeEditChain e = treeEditChainArray[n2];
                if (e != null) {
                    queue.add(0, e);
                }
                ++n2;
            }
        }
        return new TreeDifference(treedist[tree1.nodes.length - 1][tree2.nodes.length - 1].fCost, edits, mapping, added, removed);
    }

    private TreeEditChain min(TreeEditChain ... a) {
        TreeEditChain smallest = a[0];
        int i = 1;
        while (i < a.length) {
            if (smallest.fCost > a[i].fCost) {
                smallest = a[i];
            }
            ++i;
        }
        return smallest;
    }

    private TreeEditChain anEdit(TreeEdit.Operation op, ITree node1, ITree node2, ICost cost, TreeEditChain ... predecessors) {
        int c = 0;
        switch (op) {
            case CHANGE: {
                c = cost.change(node1, node2);
                if (c != 0) break;
                op = TreeEdit.Operation.NO_CHANGE;
                break;
            }
            case DELETION: {
                c = cost.deletion(node1);
                break;
            }
            case INSERTION: {
                c = cost.insertion(node1);
            }
        }
        return new TreeEditChain(new TreeEdit(op, node1, node2), c, predecessors);
    }

    private static class TreeData {
        public final ITree[] nodes;
        public final Integer[] l;
        public final Integer[] lrKeyroot;

        public TreeData(ITree[] tree, Integer[] l, Integer[] lrKeyroot) {
            this.nodes = tree;
            this.l = l;
            this.lrKeyroot = lrKeyroot;
        }
    }

    private static class TreeEditChain {
        private final TreeEditChain[] fPredecessors;
        private final TreeEdit fEdit;
        private final int fCost;

        public TreeEditChain(TreeEdit edit, int cost, TreeEditChain ... predecessor) {
            this.fPredecessors = predecessor;
            this.fEdit = edit;
            TreeEditChain[] treeEditChainArray = predecessor;
            int n = predecessor.length;
            int n2 = 0;
            while (n2 < n) {
                TreeEditChain p = treeEditChainArray[n2];
                if (p != null) {
                    cost += p.fCost;
                }
                ++n2;
            }
            this.fCost = cost;
        }
    }
}

