/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.common.collect.Sets;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.framework.QueryParams;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Role
extends ClientDescribed<Role> {
    public static final Role ADMIN = (Role)new Role().id("00000000-0000-0000-0000-000000000003");
    public static final Role RELEASE_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000004");
    public static final Role OBSERVER = (Role)new Role().id("00000000-0000-0000-0000-000000000005");
    public static final Role DEVELOPMENT_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000301");
    public static final Role QA_MANAGER = (Role)new Role().id("00000000-0000-0000-0000-000000000302");
    public static final Role PARTICIPANT = (Role)new Role().id("00000000-0000-0000-0000-000000000303");
    public Action[] actions;
    @Deprecated
    @JsonReadOnly
    public Boolean enabled;

    public Role() {
        this.path = "/roles/";
    }

    public Action[] getActions() {
        return this.actions;
    }

    public Role setActions(Action ... actions) {
        return this.actions(actions);
    }

    public Role actions(Action ... actions) {
        this.actions = actions;
        return this;
    }

    public Action[] getAllActions() {
        return ((Response)RestAssured.given().get(this.path() + "actions", new Object[0])).as(Action[].class, ObjectMapperType.GSON);
    }

    public Set<Action> getActionSet() {
        HashSet<Object> actionSet = this.actions == null ? Sets.newHashSet() : Sets.newHashSet(this.actions);
        actionSet.remove(Action.VIEW_CHANGES);
        actionSet.remove(Action.VIEW_INITIATIVES);
        return actionSet;
    }

    public Role addAction(Action action) {
        Set<Action> actions = this.getActionSet();
        actions.add(action);
        return this.actions(actions.toArray(new Action[actions.size()]));
    }

    public Role removeAction(Action action) {
        return this.removeActions(action);
    }

    public Role removeActions(Action ... actions) {
        Set<Action> result = this.getActionSet();
        for (Action action : actions) {
            result.remove(action);
        }
        return this.actions(result.toArray(new Action[result.size()]));
    }

    @Override
    public Response put() {
        log.debug("put()");
        return (Response)this.query.apply(RestAssured.given()).body((Object)this, ObjectMapperType.GSON).put(this.writePath(this.id), new Object[0]);
    }

    public void removeInvalidActions() {
        Action[] validActions = new Action[this.actions.length - 2];
        int pos = 0;
        for (int i = 0; i < validActions.length; ++i) {
            if (this.actions[i] == Action.VIEW_CHANGES || this.actions[i] == Action.VIEW_INITIATIVES) continue;
            validActions[pos] = this.actions[i];
        }
        this.actions = validActions;
    }

    public List<Role> getRolesWithNameLike(String name) {
        Role[] allRoles;
        Role newRole = new Role();
        ArrayList<Role> matchingRoles = new ArrayList<Role>();
        for (Role role : allRoles = (Role[])newRole.getAll()) {
            if (!role.name.contains(name)) continue;
            matchingRoles.add(role);
        }
        return matchingRoles;
    }

    public List<Role> getRolesWithNameEqualTo(String name) {
        Role[] allRoles;
        Role newRole = new Role();
        ArrayList<Role> matchingRoles = new ArrayList<Role>();
        for (Role role : allRoles = (Role[])newRole.getAll()) {
            if (!role.name.equals(name)) continue;
            matchingRoles.add(role);
        }
        return matchingRoles;
    }

    public static Role getOrCreateByName(String roleName) {
        Role[] result = (Role[])new Role().filter("name", QueryParams.FilterClass.STRING, QueryFilter.FilterType.EQUALS, roleName).when().getAll();
        for (int i = 0; i < result.length; ++i) {
            if (!result[i].name.equals(roleName)) continue;
            return result[i];
        }
        Role role = (Role)((Role)Clients.role().name(roleName)).save();
        role.actions(role.getAllActions()).save();
        return role;
    }

    public static class Action
    extends ClientDescribed<Action> {
        public static final Action EDIT_APPLICATION = (Action)new Action().id("00000000-0000-0000-0000-000000000088");
        public static final Action EDIT_STATUS_COMMENTS_ATTACHMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000000205");
        public static final Action VIEW_RELEASE = (Action)new Action().id("00000000-0000-0000-0000-000000000005");
        public static final Action EDIT_RELEASE = (Action)new Action().id("00000000-0000-0000-0000-000000000006");
        public static final Action EDIT_SEGMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000000007");
        public static final Action OVERRIDE_TASK_STATE = (Action)new Action().id("00000000-0000-0000-0000-000000000202");
        public static final Action EXEMPT_GATES = (Action)new Action().id("00000000-0000-0000-0000-000000000203");
        public static final Action EDIT_LIFECYCLE = (Action)new Action().id("00000000-0000-0000-0000-000000000204");
        public static final Action EDIT_STATUS = (Action)new Action().id("00000000-0000-0000-0000-000000000201");
        public static final Action EDIT_ENTERPRISE_EVENT = (Action)new Action().id("00000000-0000-0000-0000-000000001206");
        public static final Action EDIT_ENTERPRISE_RELEASE_DEPLOYMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000001208");
        public static final Action VIEW_INITIATIVES = (Action)new Action().id("00000000-0000-0000-0000-000000001306");
        public static final Action EDIT_INITIATIVES = (Action)new Action().id("00000000-0000-0000-0000-000000001307");
        public static final Action VIEW_CHANGES = (Action)new Action().id("00000000-0000-0000-0000-000000001308");
        public static final Action EDIT_CHANGES = (Action)new Action().id("00000000-0000-0000-0000-000000001309");
        public static final Action EDIT_ENVIRONMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000000206");
        public static final Action EDIT_ACTIVITIES = (Action)new Action().id("00000000-0000-0000-0000-000000000209");
        public static final Action SECURITY_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000001");
        public static final Action USER_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000002");
        public static final Action ROLE_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000003");
        public static final Action TEAM_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000004");
        public static final Action INTEGRATION_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000000208");
        public static final Action EDIT_DEPLOYMENT_PLANS = (Action)new Action().id("00000000-0000-0000-0000-000000001301");
        public static final Action EXECUTE_DEPLOYMENT_TASKS = (Action)new Action().id("00000000-0000-0000-0000-000000001302");
        public static final Action LOCK_DEPLOYMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000001303");
        public static final Action EDIT_TASK_TAGS = (Action)new Action().id("00000000-0000-0000-0000-000000001304");
        public static final Action OVERRIDE_MANUAL_TASK_STATE = (Action)new Action().id("00000000-0000-0000-0000-000000001305");
        public static final Action START_DEPLOYMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000001310");
        public static final Action SCHEDULE_DEPLOYMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000001311");
        public static final Action SELECT_VERSIONS = (Action)new Action().id("00000000-0000-0000-0000-000000001312");
        public static final Action CREATE_RELEASE = (Action)new Action().id("00000000-0000-0000-0000-000000001313");
        public static final Action DELETE_RELEASE = (Action)new Action().id("00000000-0000-0000-0000-000000001314");
        public static final Action RESERVE_ENVIRONMENTS = (Action)new Action().id("00000000-0000-0000-0000-000000001315");
        public static final Action ASSIGN_APPLICATIONS = (Action)new Action().id("00000000-0000-0000-0000-000000001316");
        public static final Action SETTINGS_ADMIN = (Action)new Action().id("00000000-0000-0000-0000-000000001317");
        public static final Action VIEW_AUDIT_LOGS = (Action)new Action().id("00000000-0000-0000-0000-000000001318");
        public static final Action EDIT_AUTH_TOKENS = (Action)new Action().id("00000000-0000-0000-0000-000000001319");
        public static final Action EDIT_NOTIFICATIONS = (Action)new Action().id("00000000-0000-0000-0000-000000001320");
        public static final Action MANUAL_QA_PASS = (Action)new Action().id("00000000-0000-0000-0000-000000000101");
        public static final Action QA_MANAGER_REVIEW_PASS = (Action)new Action().id("00000000-0000-0000-0000-000000000102");
        public static final Action UNIT_TESTS_PASS = (Action)new Action().id("00000000-0000-0000-0000-000000000103");
        public String resourceType;

        public String getResourceType() {
            return this.resourceType;
        }

        public Action setResourceType(String resourceType) {
            return this.resourceType(resourceType);
        }

        public Action resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }
    }
}

