/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.annotations.SerializedName;
import com.urbancode.commons.util.query.QueryFilter;
import com.urbancode.release.rest.framework.ClientNamed;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.framework.QueryParams;
import com.urbancode.release.rest.models.AuthenticationRealm;
import org.apache.commons.lang.StringUtils;

public class User
extends ClientNamed<User> {
    public static final User ADMIN = (User)new User().id("00000000-0000-0000-0000-000000000002");
    public static final User RELEASER = (User)new User().id("00000000-0000-0000-0000-000000000003");
    public static final User USER = (User)new User().id("00000000-0000-0000-0000-000000000004");
    @Deprecated
    public static User OTHER_ADMIN;
    public String password;
    public String actualName;
    public String email;
    public String phone;
    @SerializedName(value="isAuthorized")
    public Boolean authorized;
    public int failedAttempts;
    @Deprecated
    public Boolean enabled;
    @JsonReadOnly
    public AuthenticationRealm authenticationRealm;

    public User() {
        this.path = "/users/";
        this.enabled = true;
    }

    public String getPassword() {
        return this.password;
    }

    public User setPassword(String password) {
        return this.password(password);
    }

    public User password(String password) {
        this.password = password;
        return this;
    }

    public String getActualName() {
        return this.actualName;
    }

    public String getDisplayName() {
        String result = this.name;
        if (!StringUtils.isEmpty((String)this.actualName) && !this.name.equals(this.actualName)) {
            result = this.actualName + " (" + this.name + ")";
        }
        return result;
    }

    public User setActualName(String actualName) {
        return this.actualName(actualName);
    }

    public User actualName(String actualName) {
        this.actualName = actualName;
        return this;
    }

    public User phone(String phone) {
        this.phone = phone;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public User setEmail(String email) {
        return this.email(email);
    }

    public int getFailedAttempts() {
        return this.failedAttempts;
    }

    public User setFailedAttempts(int failedAttempts) {
        this.failedAttempts = failedAttempts;
        return this;
    }

    public User email(String email) {
        this.email = email;
        return this;
    }

    public Boolean isAuthorized() {
        return this.authorized;
    }

    public User setAuthorized(Boolean authorized) {
        return this.authorized(authorized);
    }

    public User authorized(boolean authorized) {
        this.authorized = authorized;
        return this;
    }

    public AuthenticationRealm getAuthenticationRealm() {
        return this.authenticationRealm;
    }

    @Deprecated
    public User enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public static User getOrCreateByName(String actualName) {
        String userName = actualName.replace(" ", ".").toLowerCase();
        User[] result = (User[])new User().filter("name", QueryParams.FilterClass.STRING, QueryFilter.FilterType.EQUALS, userName).when().getAll();
        if (result.length > 1) {
            throw new RuntimeException("Too many results returned");
        }
        if (result.length == 1) {
            return result[0];
        }
        User user = (User)((User)Clients.user().name(userName)).password("password").email(userName + "@your.company.com").actualName(actualName).phone("555-555-5555").save();
        return user;
    }
}

