/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.validation.IPropertyConstraintErrorStatus;
import com.ibm.team.repository.common.validation.PropertyConstraintException;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.VersionableHandle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SCMItemUtil {
    public static IVersionableHandle createVersionableHandle(EClass eClass, UUID itemId, UUID optionalStateId) {
        EObject object = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (object instanceof VersionableHandle) {
            VersionableHandle handle = (VersionableHandle)object;
            handle.setItemId(itemId);
            handle.setStateId(optionalStateId);
            return handle;
        }
        return null;
    }

    public static IVersionableHandle createVersionableHandle(ItemType itemType, UUID itemId, UUID optionalStateId) {
        EClass eClass = ItemUtil.getHandleEClass((ItemType)itemType);
        return SCMItemUtil.createVersionableHandle(eClass, itemId, optionalStateId);
    }

    public static VersionableHandle newVersionableHandle(IVersionableHandle versionableHandle, boolean includeStateId) {
        ItemType type = (ItemType)versionableHandle.getItemType();
        UUID itemId = versionableHandle.getItemId();
        UUID optionalStateId = includeStateId ? versionableHandle.getStateId() : null;
        VersionableHandle newVersionableHandle = (VersionableHandle)SCMItemUtil.createVersionableHandle(type, itemId, optionalStateId);
        newVersionableHandle.setOrigin(versionableHandle.getOrigin());
        return newVersionableHandle;
    }

    public static PropertyConstraintException buildConstraintException(IVersionable item, IStatus status) {
        if (item == null) {
            throw new IllegalArgumentException();
        }
        if (status == null) {
            throw new IllegalArgumentException();
        }
        StringBuffer message = new StringBuffer();
        MultiStatus multi = (MultiStatus)status;
        IStatus[] iStatusArray = multi.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s = iStatusArray[n2];
            IPropertyConstraintErrorStatus specific = (IPropertyConstraintErrorStatus)s;
            IItemType type = specific.getRootType();
            message.append("ItemType " + type.getName() + " : property ");
            String[] propertyPath = specific.getPropertyPath();
            int i = 0;
            while (i < propertyPath.length) {
                String pathElem = propertyPath[i];
                message.append(pathElem);
                if (i != 0) {
                    message.append("\\");
                }
                ++i;
            }
            switch (specific.getCode()) {
                case -2: {
                    message.append(" cannot be null.");
                    break;
                }
                case -4: {
                    message.append(" cannot be an empty string.");
                    break;
                }
                case -3: {
                    message.append(" exceeds model specified string size.");
                }
            }
            ++n2;
        }
        message.append("\n");
        PropertyConstraintException e = new PropertyConstraintException(message.toString());
        e.setData((Object)item);
        return e;
    }

    public static int hashCode(EObject o) {
        if (o == null) {
            return 0;
        }
        int hash = 1;
        EClass cls = o.eClass();
        for (EStructuralFeature f : cls.getEAllStructuralFeatures()) {
            hash *= 31;
            if (!o.eIsSet(f)) {
                ++hash;
                continue;
            }
            Object f1 = o.eGet(f);
            if (f1 == null) continue;
            if (f.isMany()) {
                boolean ordered = f.isOrdered();
                List l1 = (List)f1;
                int size = l1.size();
                hash += size;
                int i = 0;
                while (i != size) {
                    Object m1 = l1.get(i);
                    if (ordered) {
                        hash *= 31;
                    }
                    if (m1 instanceof EObject) {
                        hash += SCMItemUtil.hashCode((EObject)m1);
                    } else if (m1 != null) {
                        hash += m1.hashCode();
                    }
                    ++i;
                }
                continue;
            }
            if (f1 instanceof EObject) {
                hash += SCMItemUtil.hashCode((EObject)f1);
                continue;
            }
            if (f1 == null) continue;
            hash += f1.hashCode();
        }
        return hash;
    }

    public static boolean identicalObjects(Object o1, Object o2, boolean ignoreOrderInUnorderedCollections) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (o1 instanceof EObject) {
            return SCMItemUtil.identical((EObject)o1, (EObject)o2, ignoreOrderInUnorderedCollections);
        }
        return o1.equals(o2);
    }

    public static boolean identical(EObject o1, EObject o2, boolean ignoreOrderInUnorderedCollections) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        EClass cls = o1.eClass();
        if (cls != o2.eClass()) {
            return false;
        }
        for (EStructuralFeature f : cls.getEAllStructuralFeatures()) {
            Object f2;
            boolean isSet = o1.eIsSet(f);
            if (isSet != o2.eIsSet(f)) {
                return false;
            }
            if (!isSet) continue;
            Object f1 = o1.eGet(f);
            boolean nonNull = f1 != null;
            if (nonNull != ((f2 = o2.eGet(f)) != null)) {
                return false;
            }
            if (!nonNull) continue;
            if (f.isMany()) {
                List l1 = (List)f1;
                List l2 = (List)f2;
                int size = l1.size();
                if (size != l2.size()) {
                    return false;
                }
                if (!f.isOrdered() && ignoreOrderInUnorderedCollections) {
                    HashMap elementMap = new HashMap(size * 4 / 3);
                    int i = 0;
                    while (i != size) {
                        Integer hash;
                        Object m = l2.get(i);
                        Class<?> c = null;
                        if (m == null) {
                            hash = 0;
                        } else if (m instanceof EObject) {
                            hash = SCMItemUtil.hashCode((EObject)m);
                        } else {
                            hash = m.hashCode();
                            c = m.getClass();
                        }
                        if (!elementMap.containsKey(hash)) {
                            if (c == ArrayList.class) {
                                ArrayList container = new ArrayList();
                                container.add(m);
                                elementMap.put(hash, container);
                            } else {
                                elementMap.put(hash, m);
                            }
                        } else {
                            Object v = elementMap.get(hash);
                            if (v != null && v.getClass() == ArrayList.class) {
                                ArrayList elements = (ArrayList)v;
                                elements.add(m);
                            } else {
                                ArrayList<Object> container = new ArrayList<Object>();
                                container.add(v);
                                container.add(m);
                                elementMap.put(hash, container);
                            }
                        }
                        ++i;
                    }
                    i = 0;
                    while (i != size) {
                        block34: {
                            Object m1 = l1.get(i);
                            Integer hash = m1 == null ? Integer.valueOf(0) : (m1 instanceof EObject ? Integer.valueOf(SCMItemUtil.hashCode((EObject)m1)) : Integer.valueOf(m1.hashCode()));
                            Object values = elementMap.get(hash);
                            if (values == null) {
                                if (m1 != null) {
                                    return false;
                                }
                                if (!elementMap.containsKey(hash)) {
                                    return false;
                                }
                                elementMap.remove(hash);
                            } else {
                                if (values.getClass() == ArrayList.class) {
                                    ArrayList elements = (ArrayList)values;
                                    int numElems = elements.size();
                                    int j = 0;
                                    while (true) {
                                        if (j == numElems) {
                                            return false;
                                        }
                                        Object e = elements.get(i);
                                        if (SCMItemUtil.identicalObjects(e, m1, true)) {
                                            if (numElems == 1) {
                                                elementMap.remove(hash);
                                            } else {
                                                elements.remove(i);
                                            }
                                            break block34;
                                        }
                                        ++j;
                                    }
                                }
                                if (!SCMItemUtil.identicalObjects(values, m1, true)) {
                                    return false;
                                }
                                elementMap.remove(hash);
                            }
                        }
                        ++i;
                    }
                    continue;
                }
                int i = 0;
                while (i != size) {
                    Object m2;
                    Object m1 = l1.get(i);
                    if (!SCMItemUtil.identicalObjects(m1, m2 = l2.get(i), ignoreOrderInUnorderedCollections)) {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            if (SCMItemUtil.identicalObjects(f1, f2, ignoreOrderInUnorderedCollections)) continue;
            return false;
        }
        return true;
    }
}

