/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.service.graph;

import com.ibm.team.repository.common.service.graph.IServiceInterface;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ServiceGraph {
    private final HashMap<String, IServiceInterface> services = new HashMap(255);
    private final Set<IServiceInterface> rootList = new HashSet<IServiceInterface>(128);
    private final Set<IServiceInterface> reachable;
    private final Set<IServiceInterface> unreachable = new HashSet<IServiceInterface>(128);

    public ServiceGraph() {
        this.reachable = new HashSet<IServiceInterface>(128);
    }

    public void addServiceInterfaces(List<IServiceInterface> svcs) {
        for (IServiceInterface service : svcs) {
            this.putServiceInterface(service.getInterfaceName(), service);
        }
    }

    public void addServiceInterfaceToGraphRootList(String name) {
        IServiceInterface service = this.getServiceInterface(name);
        this.verifyServiceIsOkToReach(service);
        this.rootList.add(service);
        boolean added = this.reachable.add(service);
        if (added) {
            this.addPrerequisitesToReachableList(service);
        }
    }

    public void addServiceInterfaceToUnreachableList(String name) {
        IServiceInterface service = this.getServiceInterface(name);
        this.verifyServiceIsOkToBeUnreachable(service);
        this.unreachable.add(service);
    }

    public Set<IServiceInterface> getReachableServices() {
        return this.reachable;
    }

    public Set<IServiceInterface> getUnreachableServices() {
        return this.unreachable;
    }

    public Set<IServiceInterface> getRootReachableServices() {
        return this.rootList;
    }

    public Collection<IServiceInterface> getAllServices() {
        return this.services.values();
    }

    public Set<IServiceInterface> getNeutralServices() {
        Collection<IServiceInterface> svcs = this.getAllServices();
        Set<IServiceInterface> reachableServices = this.getReachableServices();
        Set<IServiceInterface> unreachableServices = this.getUnreachableServices();
        Collection<IServiceInterface> remainingServices = svcs;
        remainingServices.removeAll(reachableServices);
        remainingServices.removeAll(unreachableServices);
        return reachableServices;
    }

    private IServiceInterface getServiceInterface(String name) {
        return this.services.get(name);
    }

    private void putServiceInterface(String serviceName, IServiceInterface serviceInterface) {
        this.services.put(serviceName, serviceInterface);
    }

    private void addPrerequisitesToReachableList(IServiceInterface service) {
        List<IServiceInterface> required = service.getImplementation().getRequiredServiceInterfaces();
        List<IServiceInterface> optional = service.getImplementation().getOptionalServiceInterfaces();
        int size = required.size() + optional.size();
        HashSet<IServiceInterface> prereqs = new HashSet<IServiceInterface>(size);
        prereqs.addAll(required);
        prereqs.addAll(optional);
        for (IServiceInterface prereq : prereqs) {
            this.verifyServiceIsOkToReach(prereq);
            boolean added = this.reachable.add(prereq);
            if (!added) continue;
            this.addPrerequisitesToReachableList(service);
        }
    }

    private void verifyServiceIsOkToReach(IServiceInterface service) {
        if (this.unreachable.contains(service)) {
            throw new IllegalStateException(String.format("Service %s cannot be both reachable and unreachable.", service.getInterfaceName()));
        }
    }

    private void verifyServiceIsOkToBeUnreachable(IServiceInterface service) {
        if (this.reachable.contains(service)) {
            throw new IllegalStateException(String.format("Service %s cannot be both reachable and unreachable.", service.getInterfaceName()));
        }
    }
}

