/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.IServerContainerProvider;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import com.ibm.team.repository.common.transport.IServerContainerDescriptor;
import com.ibm.team.repository.common.transport.TeamServiceRegistryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;

public class ServerContainerDescriptor
extends AbstractElementDescriptor
implements IServerContainerDescriptor {
    private String implementationClassAttribute;
    private IServerContainerProvider provider;

    public ServerContainerDescriptor(IConfigurationElement element) {
        super(element, "serverContainer");
    }

    @Override
    protected void checkElement() {
        this.checkImplementationClass();
    }

    private void checkImplementationClass() {
        String value = this.getImplementationClassAttribute();
        this.checkAttributeIsSet(value, "implementationClass");
    }

    private IServerContainerProvider createProvider() throws TeamServiceRegistryException {
        IServerContainerProvider serverContainerProvider = null;
        try {
            serverContainerProvider = (IServerContainerProvider)this.createInstance("implementationClass");
        }
        catch (CoreException exception) {
            IStatus status = exception.getStatus();
            TeamServiceRegistryException exp = new TeamServiceRegistryException(status.getMessage(), status.getException());
            String implementationClassName = this.getImplementationClassAttribute();
            String message = NLS.bind(Messages.getServerString("ServerContainerDescriptor.ErrorContainerCreate"), implementationClassName, new Object[0]);
            throw new TeamServiceRegistryException(message, exp);
        }
        return serverContainerProvider;
    }

    @Override
    public String getImplementationClassAttribute() {
        return this.implementationClassAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IServerContainerProvider getProvider() throws TeamServiceRegistryException {
        ServerContainerDescriptor serverContainerDescriptor = this;
        synchronized (serverContainerDescriptor) {
            if (this.provider == null) {
                IServerContainerProvider serverContainerProvider = this.createProvider();
                this.setProvider(serverContainerProvider);
            }
            return this.provider;
        }
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setImplementationClassAttribute(this.getAttribute("implementationClass"));
    }

    private void printImplementationClassAttributeOn(StringBuffer buffer) {
        String value = this.getImplementationClassAttribute();
        this.printOn(buffer, "implementationClass", value);
    }

    @Override
    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printImplementationClassAttributeOn(buffer);
    }

    private void setImplementationClassAttribute(String implementationClassAttribute) {
        this.implementationClassAttribute = implementationClassAttribute;
    }

    private void setProvider(IServerContainerProvider provider) {
        this.provider = provider;
    }
}

