/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.lyo.oslc4j.core.annotation.OslcDescription;
import org.eclipse.lyo.oslc4j.core.annotation.OslcName;
import org.eclipse.lyo.oslc4j.core.annotation.OslcNamespace;
import org.eclipse.lyo.oslc4j.core.annotation.OslcPropertyDefinition;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRange;
import org.eclipse.lyo.oslc4j.core.annotation.OslcReadOnly;
import org.eclipse.lyo.oslc4j.core.annotation.OslcRepresentation;
import org.eclipse.lyo.oslc4j.core.annotation.OslcResourceShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcTitle;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueShape;
import org.eclipse.lyo.oslc4j.core.annotation.OslcValueType;
import org.eclipse.lyo.oslc4j.core.model.AbstractResource;
import org.eclipse.lyo.oslc4j.core.model.OAuthConfiguration;
import org.eclipse.lyo.oslc4j.core.model.Publisher;
import org.eclipse.lyo.oslc4j.core.model.Representation;
import org.eclipse.lyo.oslc4j.core.model.ServiceProvider;
import org.eclipse.lyo.oslc4j.core.model.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@OslcNamespace(value="http://open-services.net/ns/core#")
@OslcResourceShape(title="OSLC Service Provider Catalog Resource Shape", describes={"http://open-services.net/ns/core#ServiceProviderCatalog"})
public final class ServiceProviderCatalog
extends AbstractResource {
    private final SortedSet<URI> domains = new TreeSet<URI>();
    private final SortedSet<URI> referencedServiceProviderCatalogs = new TreeSet<URI>();
    private final List<ServiceProvider> serviceProviders = new ArrayList<ServiceProvider>();
    private String description;
    private OAuthConfiguration oauthConfiguration;
    private Publisher publisher;
    private String title;

    public void addDomain(URI domain) {
        this.domains.add(domain);
    }

    public void addDomains(Collection<URI> domains) {
        for (URI domain : domains) {
            this.addDomain(domain);
        }
    }

    public void addServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProviders.add(serviceProvider);
    }

    @OslcDescription(value="Description of the service provider catalog")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/description")
    @OslcReadOnly
    @OslcTitle(value="Description")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getDescription() {
        return this.description;
    }

    @OslcDescription(value="URIs of the OSLC domain specifications that may be implemented by referenced services")
    @OslcName(value="domain")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#domain")
    @OslcReadOnly
    @OslcTitle(value="Domains")
    public URI[] getDomains() {
        return this.domains.toArray(new URI[this.domains.size()]);
    }

    @OslcDescription(value="Defines the three OAuth URIs required for a client to act as an OAuth consumer")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#oauthConfiguration")
    @OslcRange(value={"http://open-services.net/ns/core#OAuthConfiguration"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="OAuth URIs")
    @OslcValueShape(value="resourceShapes/oauthConfiguration")
    @OslcValueType(value=ValueType.LocalResource)
    public OAuthConfiguration getOauthConfiguration() {
        return this.oauthConfiguration;
    }

    @OslcDescription(value="Describes the software product that provides the implementation")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/publisher")
    @OslcRange(value={"http://open-services.net/ns/core#Publisher"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Publisher")
    @OslcValueShape(value="resourceShapes/publisher")
    @OslcValueType(value=ValueType.LocalResource)
    public Publisher getPublisher() {
        return this.publisher;
    }

    @OslcDescription(value="Additional service provider catalogs")
    @OslcName(value="serviceProviderCatalog")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProviderCatalog")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProviderCatalog"})
    @OslcReadOnly
    @OslcTitle(value="Additional Service Provider Catalogs")
    @OslcValueShape(value="resourceShapes/serviceProviderCatalog")
    public URI[] getReferencedServiceProviderCatalogs() {
        return this.referencedServiceProviderCatalogs.toArray(new URI[this.referencedServiceProviderCatalogs.size()]);
    }

    @OslcDescription(value="Service providers")
    @OslcName(value="serviceProvider")
    @OslcPropertyDefinition(value="http://open-services.net/ns/core#serviceProvider")
    @OslcRange(value={"http://open-services.net/ns/core#ServiceProvider"})
    @OslcReadOnly
    @OslcRepresentation(value=Representation.Inline)
    @OslcTitle(value="Service Providers")
    @OslcValueShape(value="resourceShapes/serviceProvider")
    @OslcValueType(value=ValueType.LocalResource)
    public ServiceProvider[] getServiceProviders() {
        return this.serviceProviders.toArray(new ServiceProvider[this.serviceProviders.size()]);
    }

    @OslcDescription(value="Title of the service provider catalog")
    @OslcPropertyDefinition(value="http://purl.org/dc/terms/title")
    @OslcReadOnly
    @OslcTitle(value="Title")
    @OslcValueType(value=ValueType.XMLLiteral)
    public String getTitle() {
        return this.title;
    }

    public void removeDomain(URI domain) {
        this.domains.remove(domain);
    }

    public void removeDomains(Collection<URI> domains) {
        for (URI domain : domains) {
            this.removeDomain(domain);
        }
    }

    public void removeServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProviders.remove(serviceProvider);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDomains(URI[] domains) {
        this.domains.clear();
        if (domains != null) {
            this.domains.addAll(Arrays.asList(domains));
        }
    }

    public void setOauthConfiguration(OAuthConfiguration oauthConfiguration) {
        this.oauthConfiguration = oauthConfiguration;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public void setReferencedServiceProviderCatalogs(URI[] referencedServiceProviderCatalogs) {
        this.referencedServiceProviderCatalogs.clear();
        if (referencedServiceProviderCatalogs != null) {
            this.referencedServiceProviderCatalogs.addAll(Arrays.asList(referencedServiceProviderCatalogs));
        }
    }

    public void setServiceProviders(ServiceProvider[] serviceProviders) {
        this.serviceProviders.clear();
        if (serviceProviders != null) {
            this.serviceProviders.addAll(Arrays.asList(serviceProviders));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

