/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.MarshallingExceptionReasonCode;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.transport.AbstractTeamService;
import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.IAbortableHttpRequest;
import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.transport.ITeamContentService;
import com.ibm.team.repository.common.transport.ITeamModelledRestService;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.ParameterWrapperHandler;
import com.ibm.team.repository.common.transport.ServiceMethodInvocationError;
import com.ibm.team.repository.common.transport.TeamContent;
import com.ibm.team.repository.common.transport.TeamServiceCallContextImpl;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.common.transport.internal.services.Response;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.AuthenticationException;
import com.ibm.team.repository.transport.client.OAuthUtil;
import com.ibm.team.repository.transport.client.ReleasingAndAbortingInputStream;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import com.ibm.team.repository.transport.client.RequestResponsePair;
import com.ibm.team.repository.transport.client.ServiceInvocationHandler;
import com.ibm.team.repository.transport.client.TransportUtils;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.eclipse.core.runtime.OperationCanceledException;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;

public class RemoteTeamService
extends AbstractTeamService {
    private static final Log logger = LogFactory.getLog((String)RemoteTeamService.class.getName());
    private static final String UserAgent = RemoteTeamService.class.getName();
    private static final String UseGzipProperty = "com.ibm.team.repository.common.services.UseGzip";
    private static final String ContentUploadCachingMaximum = "com.ibm.team.repository.transport.client.contentUploadCacheMaximum";
    private static final boolean UseGzip = RemoteTeamService.getUseGzip("com.ibm.team.repository.common.services.UseGzip");
    private static Method objectEquals;
    private static Method objectHashCode;
    private static Method objectToString;
    private final RemoteTeamServer remoteTeamServer;
    private final Object implementation;
    private final InvocationHandler invocationHandler;
    private final String serviceClassName;
    private final boolean isContentService;
    private final boolean isModelledRestService;
    private final String charsetEncoding = HttpUtil.CharsetEncoding.UTF8.toString();
    private static volatile String lastCheckedUrlString;

    static {
        RemoteTeamService.initialize();
        lastCheckedUrlString = null;
    }

    private static boolean getUseGzip(String property) {
        String value = System.getProperty(property, "true");
        return Boolean.valueOf(value);
    }

    private static void initialize() {
        try {
            objectEquals = Object.class.getMethod("equals", Object.class);
            objectHashCode = Object.class.getMethod("hashCode", new Class[0]);
            objectToString = Object.class.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public RemoteTeamService(RemoteTeamServer server, Class<?> serviceClass, ClassLoader serviceClassLoader, String version, List<ComponentConfiguration> componentConfigurations) {
        super(serviceClass, serviceClassLoader, version, componentConfigurations);
        this.remoteTeamServer = server;
        this.invocationHandler = new ServiceInvocationHandler((ITeamService)this);
        this.implementation = Proxy.newProxyInstance(this.getServiceClassLoader(), new Class[]{this.getServiceClass()}, this.invocationHandler);
        this.isContentService = this.implementation instanceof ITeamContentService;
        this.isModelledRestService = this.implementation instanceof ITeamModelledRestService;
        this.serviceClassName = this.getServiceClass().getName();
        RemoteTeamService.validateURL(server.getRepositoryURL());
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.remoteTeamServer == null) {
            throw new IllegalStateException("ITeamServer is disposed");
        }
        if (method.equals(objectEquals)) {
            return this.handleEquals(args[0]);
        }
        if (method.equals(objectHashCode)) {
            return this.handleHashCode();
        }
        if (method.equals(objectToString)) {
            return this.handleToString();
        }
        if (this.isContentService) {
            if (method.getName().equals("get")) {
                return this.invokeContentGet((String)args[0]);
            }
            if (method.getName().equals("put")) {
                this.invokeContentPut((TeamContent)args[0]);
                return null;
            }
            throw new RuntimeException(NLS.bind((String)"Method \"{0}\" is not supported because content services only support get and put.", (Object)method.getName(), (Object[])new Object[0]));
        }
        if (this.isModelledRestService) {
            Object arg = args.length == 0 ? null : args[0];
            return this.invokeModelledRestService(method, arg);
        }
        Method testMethod = this.getMethod(method.getName());
        if (testMethod == null) {
            throw new RuntimeException(NLS.bind((String)"Method \"{0}\" is not supported because it was not found.", (Object)method.getName(), (Object[])new Object[0]));
        }
        if (!method.toString().equals(testMethod.toString())) {
            throw new RuntimeException(NLS.bind((String)"Method is not supported: {0}", (Object)method.getName(), (Object[])new Object[0]));
        }
        return this.executeMethod(method, args);
    }

    private String getURL() {
        String repoPath = this.remoteTeamServer.getRepositoryPath();
        return String.valueOf(repoPath) + "service/" + this.serviceClassName;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Object invokeModelledRestService(Method method, Object argument) throws Throwable {
        block22: {
            block20: {
                block21: {
                    if (argument != null && !(argument instanceof IParameterWrapper)) {
                        throw new RuntimeException("parameter to method should be an instance of IParameterWrapper");
                    }
                    methodName = method.getName();
                    httpMethod /* !! */  = null;
                    isPost = methodName.startsWith("post");
                    parameterType = method.getParameterTypes().length > 0 ? method.getParameterTypes()[0] : null;
                    queryString = ParameterWrapperHandler.createQueryString(parameterType, (IParameterWrapper)((IParameterWrapper)argument), (boolean)isPost);
                    if (methodName.startsWith("get") || methodName.startsWith("put")) {
                        uriString = String.valueOf(this.getURL()) + "/" + this.lowerFirst(methodName.substring(3));
                        if (queryString != null && !queryString.trim().isEmpty()) {
                            uriString = queryString.charAt(0) == '?' ? String.valueOf(uriString) + queryString : String.valueOf(uriString) + "?" + queryString;
                        }
                        httpMethod /* !! */  = methodName.startsWith("get") ? new HttpGet(uriString) : new HttpPut(uriString);
                    } else if (methodName.startsWith("post")) {
                        methodName = this.lowerFirst(methodName.substring(4));
                        httpMethod /* !! */  = new HttpPost(String.valueOf(this.getURL()) + "/" + methodName);
                        isPost = true;
                    } else {
                        throw new RuntimeException("method should start with 'get', 'put' or 'post'");
                    }
                    httpMethod /* !! */ .setHeader("User-Agent", RemoteTeamService.UserAgent);
                    httpMethod /* !! */ .setHeader("http.useragent", RemoteTeamService.UserAgent);
                    httpMethod /* !! */ .setHeader("Accept", HttpUtil.MediaType.XML.toString());
                    httpMethod /* !! */ .setHeader("Accept-Charset", this.charsetEncoding);
                    TransportUtils.setAcceptLanguageHeader((HttpRequest)httpMethod /* !! */ );
                    this.addUseridHeader((HttpRequest)httpMethod /* !! */ );
                    this.addServiceVersionHeader((HttpRequest)httpMethod /* !! */ );
                    if (isPost) {
                        requestEntity = new BufferedHttpEntity((HttpEntity)new ByteArrayEntity(queryString.getBytes(this.charsetEncoding), ContentType.APPLICATION_FORM_URLENCODED));
                        ((HttpPost)httpMethod /* !! */ ).setEntity((HttpEntity)requestEntity);
                    }
                    throwable = null;
                    response = null;
                    try {
                        response = this.executeCancelableHttpMethod((HttpRequestBase)httpMethod /* !! */ , true, true).getResponse();
                    }
                    catch (Throwable e) {
                        throwable = e instanceof TeamServiceException != false && ((TeamServiceException)e).getCause() != null && ((TeamServiceException)e).isFromServer() != false ? e.getCause() : e;
                    }
                    if (throwable != null) {
                        if (response != null) {
                            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                        }
                        throw this.getAppropriateException(throwable, method.getExceptionTypes());
                    }
                    webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
                    serviceResponse = null;
                    responseStream = this.utilGetResponseBodyAsStream((HttpResponse)response, httpMethod /* !! */ .getRequestLine().getUri());
                    envelope = (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
                    if (envelope != null) break block20;
                    var16_16 = this.thrownAwayResult(method.getReturnType());
                    if (response == null) break block21;
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                }
                return var16_16;
            }
            try {
                try {
                    serviceResponse = envelope.getBody().getResponse();
                    fault = envelope.getBody().getFault();
                    if (fault != null) {
                        throwable = this.constructExceptionFromFault(fault);
                        break block22;
                    }
                    if (serviceResponse != null) break block22;
                    throwable = new TeamServiceException("no SOAP response received");
                }
                catch (Throwable e) {
                    throwable = e;
                    if (response == null) ** GOTO lbl75
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                }
            }
            catch (Throwable var15_18) {
                if (response != null) {
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                }
                throw var15_18;
            }
        }
        if (response != null) {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
lbl75:
        // 5 sources

        if (throwable != null) {
            throw this.getAppropriateException(throwable, method.getExceptionTypes());
        }
        return webServicesMarshaller.getResponseReturnValue(serviceResponse, method.getReturnType());
    }

    private InputStream utilGetResponseBodyAsStream(HttpResponse method, String requestUri) throws MarshallingException, IOException {
        InputStream responseStream = method.getEntity().getContent();
        if (responseStream == null) {
            String message = NLS.bind((String)Messages.getServerString("ClientHttpUtil.EmptyResponse"), (Object)requestUri, (Object[])new Object[0]);
            throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_DEMARSHAL_LITERAL, message);
        }
        return responseStream;
    }

    private TeamContent invokeContentGet(String uri) throws IOException, TeamRepositoryException {
        HttpGet method = new HttpGet(String.valueOf(this.getURL()) + "/" + uri);
        method.setHeader("User-Agent", UserAgent);
        method.setHeader("Accept-Charset", this.charsetEncoding);
        TransportUtils.setAcceptLanguageHeader((HttpRequest)method);
        this.addUseridHeader((HttpRequest)method);
        this.addServiceVersionHeader((HttpRequest)method);
        boolean releaseConnection = true;
        CloseableHttpResponse response = null;
        try {
            Header header;
            response = this.executeCancelableHttpMethod((HttpRequestBase)method, false, true).getResponse();
            int status = response.getStatusLine().getStatusCode();
            if (status == 404) {
                this.throwNotFoundException(response, method.getRequestLine().getUri());
            }
            if ((header = response.getFirstHeader("Content-Length")) == null) {
                throw new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingHeader"), (Object)"Content-Length", (Object[])new Object[0]));
            }
            long contentLen = Integer.parseInt(header.getValue());
            if (contentLen > Integer.MAX_VALUE) {
                throw new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.ExceedsMaximumLength"), (Object)contentLen, (Object[])new Object[0]));
            }
            header = response.getFirstHeader("Content-Type");
            if (header == null) {
                throw new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingHeader"), (Object)"Content-Type", (Object[])new Object[0]));
            }
            String contentType = header.getValue();
            header = response.getFirstHeader("Last-Modified");
            if (header == null) {
                throw new IOException(NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingHeader"), (Object)"Last-Modified", (Object[])new Object[0]));
            }
            Timestamp lastModified = new Timestamp(DateUtils.parseDate((String)header.getValue()).getTime());
            ReleasingAndAbortingInputStream in = new ReleasingAndAbortingInputStream(response.getEntity());
            TeamContent result = new TeamContent(uri).setInputStream((InputStream)in).setSize((int)contentLen).setContentType(contentType).setLastModified(lastModified);
            releaseConnection = false;
            TeamContent teamContent = result;
            return teamContent;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (releaseConnection && response != null) {
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            }
        }
    }

    private void throwNotFoundException(CloseableHttpResponse response, String requestUri) throws IOException, ItemNotFoundException {
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        InputStream responseStream = null;
        try {
            if (response.getEntity() != null) {
                responseStream = response.getEntity().getContent();
            }
            Envelope envelope = null;
            if (responseStream != null) {
                try {
                    envelope = (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
                }
                catch (MarshallingException marshallingException) {}
            }
            if (envelope == null) {
                throw new ItemNotFoundException(requestUri);
            }
            Throwable throwable = null;
            Fault fault = envelope.getBody().getFault();
            if (fault != null) {
                throwable = this.constructExceptionFromFault(fault);
            }
            if (throwable == null) {
                throw new ItemNotFoundException(requestUri);
            }
            if (throwable instanceof ItemNotFoundException) {
                throw (ItemNotFoundException)throwable;
            }
            throw new ItemNotFoundException(requestUri, throwable);
        }
        catch (Throwable throwable) {
            if (response != null) {
                HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
            }
            throw throwable;
        }
    }

    private int getCachedContentUploadSize() {
        return Integer.getInteger(ContentUploadCachingMaximum, 1000000);
    }

    private void invokeContentPut(TeamContent teamContent) throws IOException, TeamRepositoryException {
        InputStreamEntity requestEntity;
        InputStreamEntity inputStreamEntity;
        HttpPut method = new HttpPut(String.valueOf(this.getURL()) + "/" + teamContent.getURI());
        this.addUseridHeader((HttpRequest)method);
        this.addServiceVersionHeader((HttpRequest)method);
        method.setHeader("User-Agent", UserAgent);
        TransportUtils.setAcceptLanguageHeader((HttpRequest)method);
        int contentSize = teamContent.getSize();
        String contentType = teamContent.getContentType();
        if (contentType == null) {
            contentType = ContentType.DEFAULT_TEXT.toString();
        }
        if (contentSize > 0 && contentSize < this.getCachedContentUploadSize()) {
            inputStreamEntity = new InputStreamEntity(teamContent.getInputStream(), (long)contentSize);
            inputStreamEntity.setContentType(contentType);
            requestEntity = new BufferedHttpEntity((HttpEntity)inputStreamEntity);
        } else {
            inputStreamEntity = new InputStreamEntity((InputStream)new BufferedInputStream(teamContent.getInputStream(), 16384), (long)contentSize);
            inputStreamEntity.setContentType(contentType);
            requestEntity = inputStreamEntity;
        }
        method.setEntity((HttpEntity)requestEntity);
        String lastModified = DateUtils.formatDate((Date)teamContent.getLastModified());
        method.addHeader("Last-Modified", lastModified);
        CloseableHttpResponse response = null;
        try {
            response = this.executeCancelableHttpMethod((HttpRequestBase)method, true, false).getResponse();
        }
        catch (Throwable throwable) {
            if (response != null) {
                HttpClientUtils.closeQuietly(response);
            }
            throw throwable;
        }
        if (response != null) {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
    }

    private Object executeMethod(Method method, Object[] parameters) throws Throwable {
        String methodName = method.getName();
        String interfaceName = method.getDeclaringClass().getName();
        Class[] parameterTypes = method.getParameterTypes();
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Response serviceResponse = null;
        Throwable throwable = null;
        try {
            webServicesMarshaller.marshalServiceRequest(methodName, interfaceName, parameterTypes, parameters, 0, (OutputStream)byteArrayOutputStream);
            Envelope envelope = this.invokePost(webServicesMarshaller, byteArrayOutputStream);
            if (envelope == null) {
                return this.thrownAwayResult(method.getReturnType());
            }
            serviceResponse = envelope.getBody().getResponse();
            Fault fault = envelope.getBody().getFault();
            if (fault != null) {
                throwable = this.constructExceptionFromFault(fault);
            } else if (serviceResponse == null) {
                throwable = new TeamServiceException(Messages.getServerString("RemoteTeamService.NoResponse"));
            } else if (!serviceResponse.getMethod().equals(methodName)) {
                throwable = new TeamServiceException(NLS.bind((String)Messages.getServerString("RemoteTeamService.UnexpectedResponse"), (Object)methodName, (Object[])new Object[]{serviceResponse.getMethod()}));
            }
        }
        catch (Throwable e) {
            throwable = e;
        }
        if (throwable != null) {
            throw this.getAppropriateException(throwable, method.getExceptionTypes());
        }
        return webServicesMarshaller.getResponseReturnValue(serviceResponse, method.getReturnType());
    }

    private Envelope invokePost(WebServicesMarshaller webServicesMarshaller, ByteArrayOutputStream byteArrayOutputStream) throws Throwable {
        Envelope envelope;
        block12: {
            BufferedHttpEntity requestEntity = new BufferedHttpEntity((HttpEntity)new ByteArrayEntity(byteArrayOutputStream.toByteArray(), ContentType.create((String)"text/xml", null)));
            HttpPost postMethod = new HttpPost(this.getURL());
            postMethod.setHeader("User-Agent", UserAgent);
            TransportUtils.setAcceptLanguageHeader((HttpRequest)postMethod);
            if (postMethod.getFirstHeader("Accept") == null) {
                postMethod.setHeader("Accept", HttpUtil.MediaType.XML.toString());
            }
            if (postMethod.getFirstHeader("Accept-Charset") == null) {
                postMethod.setHeader("Accept-Charset", this.charsetEncoding);
            }
            this.addUseridHeader((HttpRequest)postMethod);
            this.addMarshallingHeader((HttpRequest)postMethod);
            this.addServiceVersionHeader((HttpRequest)postMethod);
            if (UseGzip) {
                postMethod.setHeader("Accept-Encoding", "gzip");
            }
            postMethod.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse response = null;
            HttpClientContext context = null;
            try {
                RequestResponsePair method = this.executeCancelableHttpMethod((HttpRequestBase)postMethod, true, true);
                response = method.getResponse();
                context = method.getContext();
                envelope = this.demarshallEnvelope(webServicesMarshaller, (HttpResponse)response, postMethod.getRequestLine().getUri());
                if (response == null) break block12;
            }
            catch (MarshallingException e) {
                try {
                    Header h;
                    StringBuilder trace = new StringBuilder();
                    trace.append(String.format("%n==> REQUEST URI: %s%n", postMethod.getRequestLine().toString()));
                    Header[] headerArray = postMethod.getAllHeaders();
                    int n = headerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        h = headerArray[n2];
                        trace.append(String.format("===> REQUEST HEADER: %s: %s%n", h.getName(), h.getValue()));
                        ++n2;
                    }
                    if (context != null) {
                        List redirectLocations = context.getRedirectLocations();
                        for (URI redirectLocation : redirectLocations) {
                            trace.append(String.format("==> REDIRECTING GET: %s%n", redirectLocation));
                        }
                    }
                    trace.append(String.format("==> RESPONSE: %s%n", response.getStatusLine()));
                    headerArray = response.getAllHeaders();
                    n = headerArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        h = headerArray[n3];
                        trace.append(String.format("===> RESPONSE HEADER: %s: %s%n", h.getName(), h.getValue()));
                        ++n3;
                    }
                    logger.debug((Object)trace);
                    throw new MarshallingException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        HttpClientUtils.closeQuietly(response);
                    }
                    throw throwable;
                }
            }
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
        return envelope;
    }

    private RequestResponsePair executeCancelableHttpMethod(final HttpRequestBase request, boolean handle404, boolean wrapIOException) throws IOException, TeamServiceException {
        RequestResponsePair method;
        AuthenticationException authEx;
        int status;
        block10: {
            status = 500;
            authEx = null;
            TeamServiceCallContextImpl.setUpCall((IAbortableHttpRequest)new IAbortableHttpRequest(){

                public String getURI() {
                    return request.getRequestLine().getUri();
                }

                public void abort() {
                    request.abort();
                }
            });
            method = new RequestResponsePair(request);
            try {
                try {
                    status = this.remoteTeamServer.executeMethod(this, method, handle404, wrapIOException);
                }
                catch (AuthenticationException e) {
                    status = 401;
                    try {
                        status = OAuthUtil.handleOAuthChallenge(status, this.remoteTeamServer, method, this.remoteTeamServer.getOAuthHandler());
                        if (status == 401) {
                            authEx = e;
                        }
                    }
                    catch (Exception ex) {
                        int statusCode = -1;
                        if (ex instanceof TeamServiceException) {
                            statusCode = ((TeamServiceException)((Object)ex)).getStatusCode();
                        }
                        throw new TeamServiceException(ex.getMessage(), (Throwable)ex, statusCode);
                    }
                    TeamServiceCallContextImpl.tearDownCall();
                    break block10;
                }
            }
            catch (Throwable throwable) {
                TeamServiceCallContextImpl.tearDownCall();
                throw throwable;
            }
            TeamServiceCallContextImpl.tearDownCall();
        }
        if (status == 401 && authEx != null) {
            throw authEx;
        }
        return method;
    }

    private Envelope demarshallEnvelope(WebServicesMarshaller webServicesMarshaller, HttpResponse postMethod, String requestUri) throws IOException, MarshallingException {
        Header[] headers = postMethod.getHeaders("Content-Encoding");
        if (headers == null) {
            headers = new Header[]{};
        }
        boolean gzipped = false;
        int i = 0;
        while (i < headers.length) {
            if (headers[i].getValue().equalsIgnoreCase("gzip")) {
                gzipped = true;
            }
            ++i;
        }
        InputStream responseStream = this.utilGetResponseBodyAsStream(postMethod, requestUri);
        if (gzipped) {
            responseStream = new GZIPInputStream(responseStream, 8192);
        }
        return (Envelope)webServicesMarshaller.demarshalInputStreamToObject(responseStream);
    }

    private Throwable constructExceptionFromFault(Fault fault) {
        Throwable result = MarshallerUtil.decodeFault((Fault)fault, (ClassLoader)this.getServiceClassLoader());
        return result;
    }

    private Throwable getAppropriateException(Throwable exception, Class<?>[] declaredExceptionTypes) {
        Class<?> exceptionClass = exception.getClass();
        if (declaredExceptionTypes == null) {
            declaredExceptionTypes = new Class[]{};
        }
        if (OperationCanceledException.class.isAssignableFrom(exceptionClass)) {
            return exception;
        }
        if (ConnectionException.class.isAssignableFrom(exceptionClass)) {
            return exception;
        }
        if (IllegalArgumentException.class.isAssignableFrom(exceptionClass)) {
            return exception;
        }
        if (Error.class.isAssignableFrom(exceptionClass)) {
            return new ServiceMethodInvocationError(exception);
        }
        if (RuntimeException.class.isAssignableFrom(exceptionClass)) {
            return new ServiceMethodInvocationError(exception);
        }
        int i = 0;
        while (i < declaredExceptionTypes.length) {
            if (declaredExceptionTypes[i].isAssignableFrom(exceptionClass)) {
                return exception;
            }
            ++i;
        }
        if (declaredExceptionTypes.length == 0) {
            String rteMessage = exception instanceof TeamServiceException ? Messages.getServerString("RemoteTeamService.CommError") : Messages.getServerString("RemoteTeamService.UndeclaredException");
            return this.rte(rteMessage, exception);
        }
        exceptionClass = declaredExceptionTypes[0];
        Constructor<?> exceptionConstructor = null;
        Object[] exceptionArgs = null;
        try {
            exceptionConstructor = exceptionClass.getConstructor(String.class, Throwable.class);
            exceptionArgs = new Object[]{exception.getMessage(), exception};
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        if (exceptionConstructor == null) {
            try {
                exceptionConstructor = exceptionClass.getConstructor(Throwable.class);
                exceptionArgs = new Object[]{exception};
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (exceptionConstructor == null) {
            try {
                exceptionConstructor = exceptionClass.getConstructor(String.class);
                exceptionArgs = new Object[]{exception.getMessage()};
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (exceptionConstructor == null) {
            try {
                exceptionConstructor = exceptionClass.getConstructor(new Class[0]);
                exceptionArgs = new Object[]{};
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        if (exceptionConstructor == null) {
            return this.rte(NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingConstructor"), (Object)exceptionClass.getName(), (Object[])new Object[0]), exception);
        }
        Exception throwable = null;
        try {
            return (Throwable)exceptionConstructor.newInstance(exceptionArgs);
        }
        catch (IllegalArgumentException e) {
            throwable = e;
        }
        catch (InstantiationException e) {
            throwable = e;
        }
        catch (IllegalAccessException e) {
            throwable = e;
        }
        catch (InvocationTargetException e) {
            throwable = e;
        }
        return this.rte(NLS.bind((String)Messages.getServerString("RemoteTeamService.ExceptionError"), (Object)exception, (Object[])new Object[0]), throwable);
    }

    private void addMarshallingHeader(HttpRequest method) {
        method.addHeader("X-com-ibm-team-marshaller-version", "0.2");
    }

    private void addUseridHeader(HttpRequest method) {
        String userid = this.remoteTeamServer.getUserid();
        TransportUtils.addUseridHeader(userid, method);
    }

    private void addServiceVersionHeader(HttpRequest method) {
        String version = this.getVersion();
        if (version != null && !version.equals("")) {
            method.addHeader("X-com-ibm-team-service-version", version);
        }
    }

    private RuntimeException rte(String message, Throwable cause) {
        return new RuntimeException(message, cause);
    }

    private String lowerFirst(String string) {
        return String.valueOf(string.substring(0, 1).toLowerCase(Locale.ENGLISH)) + string.substring(1);
    }

    private Object handleEquals(Object argument) {
        return this == argument ? Boolean.TRUE : Boolean.FALSE;
    }

    private Object handleHashCode() {
        return ((Object)((Object)this)).hashCode();
    }

    private Object handleToString() {
        return String.format("%s{%s}", ((Object)((Object)this)).getClass().getName(), this.getURL());
    }

    public String toString() {
        return String.format("%s{%s}", this.getServiceClass().getName(), this.getURL());
    }

    private static void validateURL(String urlString) {
        Throwable t;
        String msg;
        if (urlString.equals(lastCheckedUrlString)) {
            return;
        }
        lastCheckedUrlString = urlString;
        URL urlObject = null;
        try {
            urlObject = new URL(urlString);
        }
        catch (MalformedURLException e) {
            String msg2 = NLS.bind((String)Messages.getServerString("RemoteTeamService.UnparseableUri"), (Object)urlString, (Object[])new Object[0]);
            logger.warn((Object)msg2, (Throwable)e);
            return;
        }
        String protocol = urlObject.getProtocol();
        String host = urlObject.getHost();
        int port = urlObject.getPort();
        if (protocol == null || protocol.length() == 0) {
            msg = NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingProtocol"), (Object)urlString, (Object[])new Object[0]);
            t = new Throwable(msg);
            logger.warn((Object)msg, t);
        }
        if (host == null || host.length() == 0) {
            msg = NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingHost"), (Object)urlString, (Object[])new Object[0]);
            t = new Throwable(msg);
            logger.warn((Object)msg, t);
        }
        if (port != -1) {
            return;
        }
        int defaultPort = urlObject.getDefaultPort();
        if (defaultPort == -1) {
            String msg3 = NLS.bind((String)Messages.getServerString("RemoteTeamService.MissingPort"), (Object)urlString, (Object[])new Object[0]);
            Throwable t2 = new Throwable(msg3);
            logger.warn((Object)msg3, t2);
        }
    }
}

