/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.CertificateHostnameMismatchException;
import com.ibm.team.repository.transport.client.InterruptableSocketFactory2;
import com.ibm.team.repository.transport.client.LogUtil;
import com.ibm.team.repository.transport.client.SSLContextUtil;
import com.ibm.team.repository.transport.client.ValidatingX509TrustManager;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.protocol.HttpContext;

public class SecureInterruptableSocketFactory2
extends InterruptableSocketFactory2
implements LayeredConnectionSocketFactory {
    private static final LogUtil _logger = new LogUtil(SecureInterruptableSocketFactory2.class);
    public static final String SSL_TLS = "SSL_TLS";
    public static final String TLS = "TLS";
    public static final String SSL = "SSL";
    private static final Log LOG = LogFactory.getLog(SecureInterruptableSocketFactory2.class);
    private static final ConcurrentMap<String, X509Certificate> hostnameToCertificate = new ConcurrentHashMap<String, X509Certificate>();
    protected volatile X509Certificate[] lastKnownServerCertPath;
    protected final HandshakeCompletedListener handshakeListener = new HandshakeCompletedListener(){

        @Override
        public void handshakeCompleted(HandshakeCompletedEvent event) {
            _logger.debug("Handshake completed", new Object[0]);
            try {
                Certificate[] certs = event.getPeerCertificates();
                if (certs == null || certs.length == 0) {
                    return;
                }
                if (certs instanceof X509Certificate[]) {
                    SecureInterruptableSocketFactory2.this.lastKnownServerCertPath = (X509Certificate[])certs;
                    return;
                }
                X509Certificate[] certPath = new X509Certificate[certs.length];
                int i = certs.length - 1;
                while (i >= 0) {
                    if (!(certs[i] instanceof X509Certificate)) {
                        return;
                    }
                    certPath[i] = (X509Certificate)certs[i];
                    --i;
                }
                SecureInterruptableSocketFactory2.this.lastKnownServerCertPath = certPath;
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.trace((Object)e);
            }
        }
    };
    private final SSLContext sslContext;
    private final ICertificateValidator validator;

    public SecureInterruptableSocketFactory2(TrustManager trustManager) {
        this(null, trustManager, null);
    }

    public SecureInterruptableSocketFactory2(KeyManager[] keyManagers, TrustManager trustManager) {
        this(keyManagers, trustManager, null);
    }

    public SecureInterruptableSocketFactory2(ICertificateValidator validator) {
        this(null, new ValidatingX509TrustManager(validator), validator);
    }

    public SecureInterruptableSocketFactory2(KeyManager[] keyManager, ICertificateValidator validator) {
        this(keyManager, new ValidatingX509TrustManager(validator), validator);
    }

    private SecureInterruptableSocketFactory2(KeyManager[] keyManager, TrustManager trustManager, ICertificateValidator validator) {
        this.sslContext = SSLContextUtil.createSSLContext(keyManager, trustManager);
        this.validator = validator;
        _logger.debug("Created factory", new Object[0]);
    }

    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException, UnknownHostException {
        return this.createEncryptedSocket(socket, target, port);
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket sock, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket connectedSocket = super.connectSocket(connectTimeout, sock, host, remoteAddress, localAddress, context);
        return this.createEncryptedSocket(connectedSocket, host.getHostName(), remoteAddress.getPort());
    }

    private void handleCertificateHostnameMismatch(String host, int port, SSLSocket sslSocket, IOException exp) throws SSLPeerUnverifiedException, IOException {
        String hostnameKey;
        X509Certificate savedCertificate;
        _logger.debug("Handling certificate hostname mismatch", new Object[0]);
        X509Certificate certificate = null;
        Certificate[] certificates = sslSocket.getSession().getPeerCertificates();
        if (certificates != null && certificates.length > 0 && certificates[0] instanceof X509Certificate) {
            certificate = (X509Certificate)certificates[0];
        }
        if ((savedCertificate = (X509Certificate)hostnameToCertificate.get(hostnameKey = String.valueOf(host) + '-' + port)) != null && savedCertificate.equals(certificate)) {
            _logger.debug("Saved certificate found", new Object[0]);
            return;
        }
        if (this.isPermanentlyAccepted(hostnameKey, certificate)) {
            _logger.debug("Certificate permanently accepted", new Object[0]);
            hostnameToCertificate.put(hostnameKey, certificate);
            return;
        }
        if (this.validator != null) {
            _logger.debug("Validating certificate acceptance", new Object[0]);
            CertificateHostnameMismatchException exception = new CertificateHostnameMismatchException(NLS.bind((String)Messages.getClientString("SecureInterruptableSocketFactory.ServerCertifiateHostnameMismatch"), (Object)host, (Object[])new Object[0]));
            ICertificateValidator.Trust trust = this.validator.validate(certificate, (CertificateException)exception);
            switch (trust) {
                case ACCEPT_CONNECTION: {
                    break;
                }
                case ACCEPT_PERMANENT: {
                    this.storePermanentlyAccepted(hostnameKey, certificate);
                    break;
                }
                case ACCEPT_SESSION: {
                    hostnameToCertificate.put(hostnameKey, certificate);
                    break;
                }
                case REJECT: {
                    throw exp;
                }
            }
        }
    }

    private String getHostnameCertStoreDirectory() {
        String userHome = System.getProperty("user.home");
        return String.valueOf(userHome) + "/.jazzhostnamecerts";
    }

    private boolean isPermanentlyAccepted(String host, X509Certificate certificate) throws IOException {
        X509Certificate savedCertificate;
        String certFilename = (String.valueOf(this.getHostnameCertStoreDirectory()) + '/' + host).replace('/', File.separatorChar);
        File file = new File(certFilename);
        if (!file.exists()) {
            return false;
        }
        FileInputStream input = new FileInputStream(file);
        try {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                savedCertificate = (X509Certificate)cf.generateCertificate(input);
            }
            catch (CertificateException exp) {
                LOG.warn((Object)NLS.bind((String)"The certificate in file \"{0}\" could not be read.", (Object)file.getAbsolutePath(), (Object[])new Object[0]), (Throwable)exp);
                input.close();
                return false;
            }
        }
        finally {
            input.close();
        }
        return savedCertificate.equals(certificate);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storePermanentlyAccepted(String host, X509Certificate certificate) throws IOException {
        SecureInterruptableSocketFactory2._logger.debug("Storing permanently accepted certificate", new Object[0]);
        dirName = this.getHostnameCertStoreDirectory();
        dir = new File(dirName);
        if (!dir.exists() && !dir.mkdirs()) {
            SecureInterruptableSocketFactory2.LOG.warn((Object)NLS.bind((String)"A directory \"{0}\" could not be created to permanently store the accepted certificate", (Object)dir.getAbsolutePath(), (Object[])new Object[0]));
            return;
        }
        file = new File(dir, host);
        output = new FileOutputStream(file, false);
        try {
            try {
                buffer = ByteBuffer.wrap(certificate.getEncoded());
                ** GOTO lbl17
            }
            catch (CertificateEncodingException e) {
                SecureInterruptableSocketFactory2.LOG.warn((Object)NLS.bind((String)"A certificate could not be saved to file \"{0}\".", (Object)file.getAbsolutePath(), (Object[])new Object[0]), (Throwable)e);
                output.close();
                return;
lbl17:
                // 1 sources

                if (true) ** GOTO lbl24
            }
        }
        catch (Throwable var9_9) {
            output.close();
            throw var9_9;
        }
        do {
            output.getChannel().write(buffer);
lbl24:
            // 2 sources

        } while (buffer.hasRemaining());
        output.close();
    }

    private Socket createEncryptedSocket(Socket unencryptedSocket, String host, int port) throws IOException, UnknownHostException {
        _logger.debug("Creating encrypted socket", new Object[0]);
        boolean encryptedSocketFailure = true;
        try {
            Socket socket = this.createSocket(unencryptedSocket, host, port, true);
            encryptedSocketFailure = false;
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (encryptedSocketFailure && unencryptedSocket.getChannel() != null) {
                _logger.debug("Failure creating encrypted socket", new Object[0]);
                unencryptedSocket.getChannel().close();
            }
        }
    }

    private Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.sslContext.getSocketFactory().createSocket(socket, host, port, autoClose);
        sslSocket.addHandshakeCompletedListener(this.handshakeListener);
        _logger.debug("Starting handshake", new Object[0]);
        sslSocket.startHandshake();
        BrowserCompatHostnameVerifier verifier = new BrowserCompatHostnameVerifier();
        try {
            _logger.debug("Verifying hostname", new Object[0]);
            verifier.verify(host, sslSocket);
        }
        catch (IOException exp) {
            this.handleCertificateHostnameMismatch(host, port, sslSocket, exp);
        }
        return sslSocket;
    }

    public X509Certificate[] getLastKnownServerCertificatePath() {
        return this.lastKnownServerCertPath;
    }
}

