/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.transport.client.ITrustStoreProvider;
import com.ibm.team.repository.transport.client.SharedTrustStoreProvider;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class ValidatingX509TrustManager
implements X509TrustManager {
    private X509TrustManager baseTrustManager;
    private ICertificateValidator validator;
    private ITrustStoreProvider trustStoreProvider;

    private void initializeBaseTrustManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        TrustManager[] managers;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        factory.init(this.trustStoreProvider.getRuntimeTrustStore().getKeyStore());
        TrustManager[] trustManagerArray = managers = factory.getTrustManagers();
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            TrustManager manager = trustManagerArray[n2];
            if (manager instanceof X509TrustManager) {
                this.baseTrustManager = (X509TrustManager)manager;
                break;
            }
            ++n2;
        }
        if (this.baseTrustManager == null) {
            throw new IllegalStateException("Couldn't find JRE's X509TrustManager");
        }
    }

    public ValidatingX509TrustManager(ICertificateValidator validator) {
        this(validator, new SharedTrustStoreProvider());
    }

    public ValidatingX509TrustManager(ICertificateValidator validator, ITrustStoreProvider trustStoreProvider) {
        this.validator = validator;
        this.trustStoreProvider = trustStoreProvider;
        try {
            this.initializeBaseTrustManager();
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException iOException) {}
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.baseTrustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.baseTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        X509Certificate cert = chain[0];
        try {
            if (this.trustStoreProvider.getSessionTrustStore().containsCertificate(cert)) {
                return;
            }
        }
        catch (KeyStoreException keyStoreException) {}
        try {
            this.baseTrustManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException certEx) {
            if (this.validator == null) {
                throw certEx;
            }
            ICertificateValidator.Trust disposition = this.validator.validate(cert, certEx);
            switch (disposition) {
                case REJECT: {
                    throw certEx;
                }
                case ACCEPT_CONNECTION: {
                    return;
                }
                case ACCEPT_SESSION: {
                    try {
                        this.trustStoreProvider.getSessionTrustStore().enterCertificate(cert);
                    }
                    catch (KeyStoreException keyStoreException) {}
                    return;
                }
                case ACCEPT_PERMANENT: {
                    try {
                        this.trustStoreProvider.getSessionTrustStore().enterCertificate(cert);
                        this.trustStoreProvider.installCertificate(cert);
                    }
                    catch (KeyStoreException keyStoreException) {
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    }
                    catch (IOException iOException) {}
                    return;
                }
            }
        }
    }
}

