/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ri.repo;

import com.ibm.rational.wvcm.ri.impl.ControllableResourceImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.repo.RiRepo;
import com.ibm.rational.wvcm.ri.repo.RiRepoActivity;
import com.ibm.rational.wvcm.ri.repo.RiRepoBaseline;
import com.ibm.rational.wvcm.ri.repo.RiRepoConfiguration;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoControllableSymbolicLink;
import com.ibm.rational.wvcm.ri.repo.RiRepoFolderVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoIFolder;
import com.ibm.rational.wvcm.ri.repo.RiRepoResource;
import com.ibm.rational.wvcm.ri.repo.RiRepoStream;
import com.ibm.rational.wvcm.ri.repo.RiRepoSymbolicLinkVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersion;
import com.ibm.rational.wvcm.ri.repo.RiRepoVersionHistory;
import com.ibm.rational.wvcm.ri.repo.RiRepoWorkspace;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcLocation;
import com.ibm.rational.wvcm.ri.srvc.SrvcProvider;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.Activity;
import javax.wvcm.Baseline;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.ControllableSymbolicLink;
import javax.wvcm.Folder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Version;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

public class RiRepoControllableResource
extends RiRepoResource {
    private static Folder.RebindFlag[] RF_DO_UNCHECKOUT = new Folder.RebindFlag[]{Folder.RebindFlag.OVERWRITE};

    @Override
    public Class<?> get_proxyClass() {
        return ControllableResourceImpl.class;
    }

    protected RiRepoControllableResource(RiRepoResource parent, String bindingName, SrvcProvider provider, RiRepo repo) {
        super(parent, bindingName, provider, repo);
        this.initialize(parent);
    }

    private void initialize(RiRepoResource parent) {
        this.createProperty(ControllableResource.ACTIVITY, null);
        this.createProperty(ControllableResource.AUTO_MERGE_LIST, new ArrayList());
        this.createProperty(ControllableResource.CHECKED_IN, null);
        this.createProperty(ControllableResource.CHECKED_OUT, null);
        this.createProperty(ControllableResource.IS_CHECKED_OUT, Boolean.FALSE);
        this.createProperty(ControllableResource.IS_VERSION_CONTROLLED, null);
        this.createProperty(ControllableResource.MERGE_LIST, new ArrayList());
        this.createProperty(ControllableResource.PREDECESSOR_LIST, null);
        this.createProperty(ControllableResource.CONFIGURATION, null);
        this.createProperty(ControllableResource.RESERVED, Boolean.FALSE);
        boolean isInWorkspacesRootFolder = this.getInWorkspacesRootFolder();
        this.createProperty(ControllableResource.IS_VERSION_CONTROLLABLE, isInWorkspacesRootFolder || this instanceof RiRepoConfiguration);
        this.createProperty(ControllableResource.VERSION_HISTORY, null);
        RiRepoWorkspace workspace = null;
        if (isInWorkspacesRootFolder) {
            workspace = this instanceof RiRepoWorkspace ? (RiRepoWorkspace)this : (RiRepoWorkspace)parent.getProperty(ControllableResource.WORKSPACE);
        }
        this.createProperty(ControllableResource.WORKSPACE, workspace);
    }

    @Override
    protected void destroy() {
        if (this.getIsCheckedOut()) {
            RiRepoActivity act = this.getActivity();
            if (act != null) {
                act.setProperty_RemoveFromList(Activity.ACTIVITY_CHECKOUT_LIST, this);
            }
            RiRepoWorkspace ws = this.getWorkspace();
            ws.setProperty_RemoveFromList(Workspace.WORKSPACE_CHECKOUT_LIST, this);
            this.setPropertyEx(ControllableResource.CHECKED_OUT, null);
        } else {
            this.setPropertyEx(ControllableResource.CHECKED_IN, null);
        }
        super.destroy();
    }

    @Override
    protected void checkWhetherPropertyCanBeSet(PropertyNameList.PropertyName<?> propertyName, Object value) throws WvcmException {
        super.checkWhetherPropertyCanBeSet(propertyName, value);
        if (controlledProperties.contains(propertyName)) {
            this.autoCheckoutControlledContent();
        }
        if (propertyName.equals((Object)ControllableResource.ACTIVITY)) {
            RiRepoActivity activity = (RiRepoActivity)value;
            activity.verifyIsNotComplete();
        }
    }

    protected boolean getInWorkspacesRootFolder() {
        RiRepoResource parent = this;
        while (parent != null) {
            if (parent == this._repo.getWorkspaceFolder()) {
                return true;
            }
            parent = parent.getParentResource();
        }
        return false;
    }

    public static void performCreationPreconditionChecks(Location loc, SrvcProvider provider) throws WvcmException {
        RiRepoResource sRes = (RiRepoResource)provider.lookup(loc, null);
        if (sRes != null) {
            throw new WvcmException("Repository resource already exists: " + loc, WvcmException.ReasonCode.RESOURCE_ALREADY_EXISTS_AT_LOCATION);
        }
    }

    @Override
    protected void postSetPropertyEx(PropertyNameList.PropertyName<?> propertyName, Object oldValue, Object value) {
        super.postSetPropertyEx(propertyName, oldValue, value);
        if (propertyName.equals((Object)ControllableResource.ACTIVITY)) {
            RiRepoActivity act = (RiRepoActivity)oldValue;
            if (act != null) {
                act.setProperty_RemoveFromList(Activity.ACTIVITY_CHECKOUT_LIST, this);
            }
            if ((act = (RiRepoActivity)value) != null) {
                act.setProperty_AppendUniqueToList(Activity.ACTIVITY_CHECKOUT_LIST, this);
            }
        }
        if (propertyName.equals((Object)ControllableResource.CHECKED_IN) || propertyName.equals((Object)ControllableResource.CHECKED_OUT)) {
            RiRepoVersion version = (RiRepoVersion)oldValue;
            if (version != null) {
                version.setProperty_RemoveFromList(Version.IN_WORKSPACE_LIST, this.getWorkspace());
            }
            if ((version = (RiRepoVersion)value) != null) {
                version.setProperty_AppendUniqueToList(Version.IN_WORKSPACE_LIST, this.getWorkspace());
            }
        }
    }

    private void recursivelyCheckOneCheckoutPerActivityPerHistory(RiRepoVersion v, RiRepoActivity activity) throws WvcmException {
        List<RiRepoVersion> successorList;
        List<RiRepoControllableResource> checkoutList = v.getCheckoutList();
        if (checkoutList != null) {
            int i = 0;
            while (i < checkoutList.size()) {
                RiRepoActivity currentActivity;
                RiRepoControllableResource cr = checkoutList.get(i);
                if (!cr.getReserved() && (currentActivity = cr.getActivity()) != null && activity == currentActivity) {
                    throw new WvcmException("ONE_CHECKOUT_PER_ACTIVITY_PER_HISTORY", WvcmException.ReasonCode.ONE_CHECKOUT_PER_ACTIVITY_PER_HISTORY);
                }
                ++i;
            }
        }
        if ((successorList = v.getSuccessorList()) != null) {
            int i = 0;
            while (i < successorList.size()) {
                RiRepoVersion successor = successorList.get(i);
                this.recursivelyCheckOneCheckoutPerActivityPerHistory(successor, activity);
                ++i;
            }
        }
    }

    boolean isControlled() {
        try {
            return this.getPropertyAsBoolean(ControllableResource.IS_VERSION_CONTROLLED);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void copyContentAndPropertiesToVersion(RiRepoVersion version) {
        version.set_content(this._content);
        version.setProperty(Resource.COMMENT, this.getProperty(Resource.COMMENT));
        this.setProperty(Resource.COMMENT, null);
        version.setProperty(Resource.CONTENT_CHARACTER_SET, this.getProperty(Resource.CONTENT_CHARACTER_SET));
        version.setProperty(Resource.CONTENT_IDENTIFIER, this.getProperty(Resource.CONTENT_IDENTIFIER));
        version.setProperty(Resource.CONTENT_LANGUAGE, this.getProperty(Resource.CONTENT_LANGUAGE));
        version.setProperty(Resource.CONTENT_LENGTH, this.getProperty(Resource.CONTENT_LENGTH));
        version.setProperty(Resource.CONTENT_TYPE, this.getProperty(Resource.CONTENT_TYPE));
        version.setProperty(Resource.DISPLAY_NAME, this.getProperty(Resource.DISPLAY_NAME));
        for (Map.Entry<PropertyNameList.PropertyName<?>, Object> e : this.get_properties().entrySet()) {
            PropertyNameList.PropertyName<?> propertyName = e.getKey();
            Object value = e.getValue();
            if (!RiRepoControllableResource.isCustomProperty(propertyName) && !propertyName.equals((Object)ControllableSymbolicLink.LINK_TARGET)) continue;
            version.setProperty(propertyName, value);
        }
    }

    public static void copyVersionToVCR(RiRepoVersion version, RiRepoControllableResource resource) {
        resource.set_content(version.get_content());
        resource.setProperty(Resource.CONTENT_CHARACTER_SET, version.getProperty(Resource.CONTENT_CHARACTER_SET));
        resource.setProperty(Resource.CONTENT_IDENTIFIER, version.getProperty(Resource.CONTENT_IDENTIFIER));
        resource.setProperty(Resource.CONTENT_LANGUAGE, version.getProperty(Resource.CONTENT_LANGUAGE));
        resource.setProperty(Resource.CONTENT_LENGTH, version.getProperty(Resource.CONTENT_LENGTH));
        resource.setProperty(Resource.CONTENT_TYPE, version.getProperty(Resource.CONTENT_TYPE));
        resource.setProperty(Resource.DISPLAY_NAME, version.getProperty(Resource.DISPLAY_NAME));
        for (Map.Entry<PropertyNameList.PropertyName<?>, Object> e : version.get_properties().entrySet()) {
            PropertyNameList.PropertyName<?> propertyName = e.getKey();
            Object value = e.getValue();
            if (!RiRepoControllableResource.isCustomProperty(propertyName) && !propertyName.equals((Object)SymbolicLinkVersion.LINK_TARGET)) continue;
            resource.setProperty(propertyName, value);
        }
    }

    protected boolean isControlledStateDifferent(RiRepoVersion version, SrvcFeedback feedback) {
        String newContent;
        byte[] content = version.get_content();
        String origContent = content == null ? "" : new String(content);
        content = this.get_content();
        String string = newContent = content == null ? "" : new String(content);
        if (!origContent.equals(newContent)) {
            return true;
        }
        SrvcProvider p = this.provider();
        if (this.versionKnowsParent() && !(this instanceof RiRepoConfiguration) && !(this instanceof RiRepoWorkspace)) {
            SrvcLocation loc;
            block6: {
                try {
                    loc = p.location(this.calculatePath());
                    if (loc.lastSegment().equals(version.getBindingName(feedback))) break block6;
                    return true;
                }
                catch (WvcmException e) {
                    throw new RuntimeException("Unexpected bad location", e);
                }
            }
            RiRepoControllableFolder parent = (RiRepoControllableFolder)this.getParentResource(loc);
            if (parent.getVersionHistory() != version.getParentVersionHistory(feedback)) {
                return true;
            }
        }
        return this.isPropertyDifferent(Resource.COMMENT, version) || this.isPropertyDifferent(Resource.CONTENT_CHARACTER_SET, version) || this.isPropertyDifferent(Resource.CONTENT_LANGUAGE, version) || this.isPropertyDifferent(Resource.CONTENT_TYPE, version);
    }

    private boolean isPropertyDifferent(PropertyNameList.PropertyName<?> propertyName, RiRepoResource res) {
        Object value1 = null;
        try {
            value1 = this.getProperty(propertyName);
        }
        catch (Exception ex) {
            value1 = ex;
        }
        Object value2 = null;
        try {
            value2 = res.getProperty(propertyName);
        }
        catch (Exception ex) {
            value2 = ex;
        }
        if (value1 instanceof Exception && value2 instanceof Exception) {
            return false;
        }
        if (value1 == null && value2 != null) {
            return true;
        }
        if (value1 == null && value2 == null) {
            return false;
        }
        return !value1.equals(value2);
    }

    public static RiRepoControllableResource createVersionControlledResource(SrvcProvider provider, Location location, RiRepoVersion version, boolean recursing, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepoResource existing;
        RiRepo repo = RiRepo.get_Repo(location, provider);
        if (version instanceof RiRepoBaseline) {
            throw new WvcmException("Version argument cannot be a Baseline", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        RiRepoResource folder = RiRepoControllableResource.getParentResource(provider, location);
        if (!(folder instanceof RiRepoControllableFolder)) {
            throw new WvcmException("Cannot create at this location; must create within a controllable folder", WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        RiRepoControllableFolder parent = (RiRepoControllableFolder)folder;
        RiRepoWorkspace workspace = null;
        if (parent != repo.getWorkspaceFolder()) {
            RiRepoVersion streamVersion;
            workspace = parent.getWorkspace();
            RiRepoStream stream = workspace.getStream();
            if (stream != null && (streamVersion = stream.getVersion(version.getVersionHistory())) != null) {
                version = streamVersion;
            }
            if (!parent.isControlled()) {
                parent.doVersionControl(feedback);
            }
            if (!(recursing || parent.versionKnowsParent() || parent.getIsCheckedOut())) {
                parent.doCheckout(null, null);
            }
        }
        if ((existing = (RiRepoResource)provider.lookup(location, feedback)) != null) {
            throw new WvcmException("Proxy must not identify an existing persistent resource", WvcmException.ReasonCode.RESOURCE_ALREADY_EXISTS_AT_LOCATION);
        }
        RiRepoVersionHistory versionHistory = (RiRepoVersionHistory)version.getProperty(Version.VERSION_HISTORY);
        if (workspace != null) {
            RiRepoControllableResource.checkOneVCRPerHistoryPerWorkspace(workspace, versionHistory);
        }
        if (workspace == null && !(version instanceof RiRepoFolderVersion)) {
            throw new WvcmException("Not a valid location; only FolderVersions can be restored as Workspaces", WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        String bindingName = location.lastSegment();
        RiRepoControllableResource newVCR = parent.updateCreated(workspace, versionHistory, version, bindingName, feedback);
        if (newVCR instanceof RiRepoWorkspace) {
            RiRepoStream stream = null;
            if (updates.containsKey(Workspace.TARGET)) {
                stream = (RiRepoStream)newVCR.convertPropValueToRepo(updates.get(Workspace.TARGET).get_value(), feedback);
            } else {
                stream = (RiRepoStream)RiRepoActivity.doCreateGeneratedActivity(provider, location, true, null, null, feedback);
                if (updates.containsKey(Workspace.ISOLATED_TARGET)) {
                    RiRepoStream target = (RiRepoStream)stream.convertPropValueToRepo(updates.get(Workspace.ISOLATED_TARGET).get_value(), feedback);
                    stream.setPropertyEx(Stream.TARGET, target);
                }
            }
            newVCR.setPropertyEx(Workspace.STREAM, stream);
        }
        if (updates != null) {
            newVCR.set_creationInProgress(true);
            newVCR.doWriteProperties(updates, updated, feedback);
            newVCR.set_creationInProgress(false);
            if (newVCR.getIsCheckedOut()) {
                newVCR.doCheckin(null, null);
            }
        }
        return newVCR;
    }

    private static void checkOneVCRPerHistoryPerWorkspace(RiRepoControllableResource res, RiRepoVersionHistory compareVersionHistory) throws WvcmException {
        RiRepoVersionHistory versionHistory = res.getVersionHistory();
        if (versionHistory == compareVersionHistory) {
            throw new WvcmException("A workspace may not contain more than one controlled resource for a given version history", WvcmException.ReasonCode.ONE_CONTROLLED_RESOURCE_PER_HISTORY_PER_WORKSPACE);
        }
        if (res instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder folder = (RiRepoControllableFolder)res;
            for (RiRepoControllableResource member : folder.getChildList()) {
                if (!member.isControlled()) continue;
                RiRepoControllableResource.checkOneVCRPerHistoryPerWorkspace(member, compareVersionHistory);
            }
        }
    }

    protected RiRepoControllableResource recursivelyLocateByHistoryReport(RiRepoVersionHistory versionHistory) throws WvcmException {
        RiRepoVersionHistory vh = (RiRepoVersionHistory)this.getProperty(ControllableResource.VERSION_HISTORY);
        if (vh == versionHistory) {
            return this;
        }
        if (this instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder thisCF = (RiRepoControllableFolder)this;
            List<RiRepoIFolder.RepoBinding> bindings = thisCF.getChildBindingList();
            int i = 0;
            while (i < bindings.size()) {
                RiRepoIFolder.RepoBinding binding = bindings.get(i);
                RiRepoControllableResource member = (RiRepoControllableResource)binding.get_bindingMember();
                RiRepoControllableResource cr = member.recursivelyLocateByHistoryReport(versionHistory);
                if (cr != null) {
                    return cr;
                }
                ++i;
            }
        }
        return null;
    }

    public void copyControllableResourceContent(Location destination) throws WvcmException {
        SrvcFeedback feedback = null;
        if (this instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder thisCF = (RiRepoControllableFolder)this;
            RiRepoResource parent = this.getParentResource(destination);
            RiRepoControllableFolder folder = (RiRepoControllableFolder)this.provider().lookup(destination, feedback);
            if (folder == null) {
                boolean isWorkspace = parent == this._repo.getWorkspaceFolder();
                folder = isWorkspace ? (RiRepoControllableFolder)RiRepoWorkspace.doCreateResource(this.provider(), destination, null, null, feedback) : (RiRepoControllableFolder)RiRepoControllableFolder.doCreateResource(this.provider(), destination, null, null, feedback);
            }
            folder.setContent(this.get_content(), (String)folder.getProperty(Resource.CONTENT_IDENTIFIER));
            List<RiRepoIFolder.RepoBinding> bindings = thisCF.getChildBindingList();
            int i = 0;
            while (i < bindings.size()) {
                RiRepoIFolder.RepoBinding binding = bindings.get(i);
                RiRepoControllableResource member = (RiRepoControllableResource)binding.get_bindingMember();
                String bindingName = binding.get_bindingName();
                member.copyControllableResourceContent(destination.child(bindingName));
                ++i;
            }
        } else {
            RiRepoControllableResource resource = (RiRepoControllableResource)this.provider().lookup(destination, feedback);
            if (resource == null) {
                resource = (RiRepoControllableResource)RiRepoControllableResource.doCreateControllableResource(this.provider(), destination, null, null, feedback);
            }
            resource.setContent(this.get_content(), (String)resource.getProperty(Resource.CONTENT_IDENTIFIER));
        }
    }

    protected boolean isMemberOf(RiRepoControllableFolder folder) {
        boolean ret = false;
        if (this == folder) {
            ret = true;
        } else {
            List<RiRepoIFolder.RepoBinding> bindings = this.getParentBindingList();
            if (bindings != null && !(this instanceof RiRepoWorkspace)) {
                int i = 0;
                while (i < bindings.size()) {
                    RiRepoIFolder.RepoBinding binding = bindings.get(i);
                    RiRepoControllableFolder parent = (RiRepoControllableFolder)binding.get_bindingFolder();
                    ret = parent.isMemberOf(folder);
                    if (ret) break;
                    ++i;
                }
            }
        }
        return ret;
    }

    protected void createBaselineVersionList(List<RiRepoVersion> versions) {
        if (!this.getIsVersionControlled()) {
            return;
        }
        RiRepoVersion v = this.getCheckedIn();
        if (v == null) {
            throw new RuntimeException("Missing checked-in version");
        }
        versions.add(v);
    }

    public boolean canAutoMerge(RiRepoVersion sourceVersion) throws WvcmException {
        return false;
    }

    protected boolean isNoCheckoutMerge(RiRepoVersion sourceVersion, boolean noAutoMerge) throws WvcmException {
        if (!this.getIsVersionControlled()) {
            return false;
        }
        if (this.getIsCheckedOut()) {
            return false;
        }
        RiRepoVersion targetVersion = this.getCheckedIn();
        if (sourceVersion == targetVersion || sourceVersion.isAncestorOf(targetVersion)) {
            return true;
        }
        if (targetVersion.isAncestorOf(sourceVersion)) {
            return true;
        }
        if (!noAutoMerge) {
            return this.canAutoMerge(sourceVersion);
        }
        return false;
    }

    protected void doMergeWork(RiRepoWorkspace workspace, RiRepoVersion sourceVersion, boolean noAutoMerge, boolean noCheckout, boolean forkOK, boolean reserved, boolean checkinIdentical, Workspace.MergeFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion targetVersion = this.getCheckedOut();
        if (targetVersion == null) {
            targetVersion = this.getCheckedIn();
            if (sourceVersion == targetVersion || sourceVersion.isAncestorOf(targetVersion)) {
                return;
            }
            if (targetVersion.isAncestorOf(sourceVersion)) {
                this.update(sourceVersion, feedback);
                return;
            }
            if (noCheckout) {
                throw new WvcmException("Merge not allowed to checkout (workspace state not restored)", WvcmException.ReasonCode.CANNOT_MERGE_CHECKOUT_NOT_ALLOWED);
            }
            ControllableResource.CheckoutFlag[] coFlags = null;
            if (forkOK || reserved) {
                coFlags = new ControllableResource.CheckoutFlag[2];
                if (forkOK) {
                    coFlags[0] = ControllableResource.CheckoutFlag.FORK_OK;
                }
                if (reserved) {
                    coFlags[1] = ControllableResource.CheckoutFlag.RESERVED;
                }
            }
            this.doCheckout(coFlags, feedback);
        }
        if (noAutoMerge) {
            this.setProperty_AppendToList(ControllableResource.MERGE_LIST, sourceVersion);
        } else if (this instanceof RiRepoConfiguration) {
            ((RiRepoConfiguration)this).autoMergeBaseline((RiRepoBaseline)targetVersion, (RiRepoBaseline)sourceVersion, flags, feedback);
        } else if (this instanceof RiRepoControllableFolder) {
            ((RiRepoControllableFolder)this).autoMergeFolder((RiRepoFolderVersion)sourceVersion, feedback);
        } else {
            this.setProperty_AppendToList(ControllableResource.MERGE_LIST, sourceVersion);
        }
    }

    public void update(RiRepoVersion version, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion checkedInVersion = this.getCheckedIn();
        if (checkedInVersion == null) {
            throw new WvcmException("Resource must be checked in first", WvcmException.ReasonCode.MUST_BE_CHECKED_IN);
        }
        if (this instanceof RiRepoConfiguration) {
            RiRepoControllableFolder baselineControlledFolder = (RiRepoControllableFolder)this.getProperty(Configuration.ROOT_FOLDER);
            baselineControlledFolder.checkNoCheckedOutBaselineControlledFolderMembers();
        }
        if (checkedInVersion == version) {
            return;
        }
        RiRepoControllableResource.copyVersionToVCR(version, this);
        this.setPropertyEx(ControllableResource.CHECKED_IN, version);
        if (feedback != null) {
            feedback.notifyIsModified(this);
        }
        if (this.versionKnowsParent()) {
            RiRepoVersionHistory newParentVH = version.getParentVersionHistory(feedback);
            if (newParentVH != null) {
                String newName = version.getBindingName(feedback);
                SrvcLocation currentPathLoc = this.provider().location(this.calculatePath());
                RiRepoControllableFolder currentParent = (RiRepoControllableFolder)this.getParentResource();
                if (!newParentVH.equals(currentParent.getVersionHistory()) || !newName.equals(currentPathLoc.lastSegment())) {
                    String currentName = currentPathLoc.lastSegment();
                    RiRepoControllableFolder newParent = (RiRepoControllableFolder)this.getWorkspace().locateByHistoryReport(newParentVH);
                    if (newParent == null) {
                        Map<String, RiRepoIFolder.RepoBinding> childBindings = currentParent.getChildBindingsMap();
                        RiRepoIFolder.RepoBinding binding = childBindings.get(currentName);
                        binding.unbind();
                    } else {
                        Map<String, RiRepoIFolder.RepoBinding> childBindings = currentParent.getChildBindingsMap();
                        RiRepoIFolder.RepoBinding binding = childBindings.get(currentName);
                        RiRepoIFolder.RepoBinding oldBinding = newParent.lookupBinding(newName);
                        if (oldBinding != null) {
                            newParent.setupBinding(String.valueOf(newName) + ".waiting.to.be.moved", oldBinding.get_bindingMember());
                            oldBinding.unbind();
                        }
                        newParent.setupBinding(newName, this);
                        binding.unbind();
                    }
                }
            }
        } else if (this instanceof RiRepoControllableFolder) {
            ((RiRepoControllableFolder)this).updateVersionControlledFolderMembers((RiRepoFolderVersion)checkedInVersion, (RiRepoFolderVersion)version, null, feedback);
        }
        if (this instanceof RiRepoConfiguration) {
            RiRepoControllableFolder rootFolder = (RiRepoControllableFolder)this.getProperty(Configuration.ROOT_FOLDER);
            RiRepoBaseline baseline = (RiRepoBaseline)version;
            baseline.setBaselineControlledFolderMembers(rootFolder, feedback);
        }
    }

    public RiRepoVersion getCommonAncestor(List<RiRepoVersion> versions, RiRepoVersion v2) {
        RiRepoVersion common = null;
        ArrayList<RiRepoVersion> list = new ArrayList<RiRepoVersion>();
        list.addAll(versions);
        list.add(v2);
        common = (RiRepoVersion)list.get(0);
        int i = 1;
        while (i < list.size()) {
            RiRepoVersion compare = (RiRepoVersion)list.get(1);
            common = this.getCommonAncestor2(common, compare);
            ++i;
        }
        return common;
    }

    private RiRepoVersion getCommonAncestor2(RiRepoVersion v1, RiRepoVersion v2) {
        if (v1 == v2) {
            return v1;
        }
        if (v2.isAncestorOf(v1)) {
            return v2;
        }
        ArrayList<RiRepoVersion> commonAncestors = new ArrayList<RiRepoVersion>();
        this.recursivelyGetCommonAncestors(commonAncestors, v1, v2);
        int n = commonAncestors.size();
        int i = 0;
        while (i < n) {
            RiRepoVersion v = (RiRepoVersion)commonAncestors.get(i);
            boolean isOK = true;
            int j = 0;
            while (j < n && isOK) {
                if (i != j) {
                    RiRepoVersion vx = (RiRepoVersion)commonAncestors.get(j);
                    isOK = !v.isAncestorOf(vx);
                }
                ++j;
            }
            if (isOK) {
                return v;
            }
            ++i;
        }
        return null;
    }

    private void recursivelyGetCommonAncestors(List<RiRepoVersion> commonAncestors, RiRepoVersion v1, RiRepoVersion v2) {
        if (v1.isAncestorOf(v2)) {
            commonAncestors.add(v1);
            return;
        }
        List<RiRepoVersion> predecessors = v1.getPredecessorList();
        int i = 0;
        while (i < predecessors.size()) {
            RiRepoVersion predecessor = predecessors.get(i);
            this.recursivelyGetCommonAncestors(commonAncestors, predecessor, v2);
            ++i;
        }
    }

    protected void checkCannotMergeCheckedOutResource() throws WvcmException {
        RiRepoVersion v = (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_OUT);
        if (v != null) {
            throw new WvcmException("Resource must not be checked out: " + this.calculatePath(), WvcmException.ReasonCode.MUST_BE_CHECKED_IN);
        }
        if (this instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder thisCF = (RiRepoControllableFolder)this;
            List<RiRepoIFolder.RepoBinding> childBindingList = thisCF.getChildBindingList();
            int i = 0;
            while (i < childBindingList.size()) {
                RiRepoIFolder.RepoBinding binding = childBindingList.get(i);
                RiRepoControllableResource cr = (RiRepoControllableResource)binding.get_bindingMember();
                cr.checkCannotMergeCheckedOutResource();
                ++i;
            }
        }
    }

    protected void addAllCheckedInVersions(List<RiRepoVersion> sourceVersions) {
        RiRepoVersion checkedInVersion = (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_IN);
        if (checkedInVersion != null) {
            sourceVersions.add(checkedInVersion);
        }
        if (this.getProperty(ControllableResource.CHECKED_OUT) != null) {
            throw new RuntimeException("there should be no checked-out resources");
        }
        if (this instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder folder = (RiRepoControllableFolder)this;
            List<RiRepoControllableResource> childList = folder.getChildList();
            int i = 0;
            while (i < childList.size()) {
                RiRepoControllableResource cr = childList.get(i);
                cr.addAllCheckedInVersions(sourceVersions);
                ++i;
            }
        }
    }

    @Override
    protected boolean handleCalculatedProperties(PropertyNameList.PropertyName<?> propertyName, Object[] calculatedValue) {
        if (propertyName.equals((Object)ControllableResource.CONFIGURATION)) {
            calculatedValue[0] = this.calculateConfigurationProperty();
            return true;
        }
        if (propertyName.equals((Object)ControllableResource.IS_VERSION_CONTROLLED)) {
            calculatedValue[0] = this.getVersionHistory() == null ? Boolean.FALSE : Boolean.TRUE;
            return true;
        }
        return super.handleCalculatedProperties(propertyName, calculatedValue);
    }

    protected RiRepoConfiguration calculateConfigurationProperty() {
        RiRepoConfiguration config;
        if (this instanceof RiRepoControllableFolder && (config = ((RiRepoControllableFolder)this).getRootFolderOf()) != null) {
            return config;
        }
        for (RiRepoControllableFolder o : this.getParentList()) {
            RiRepoControllableFolder parent;
            RiRepoConfiguration config2;
            if (!(o instanceof RiRepoControllableFolder) || (config2 = (parent = o).calculateConfigurationProperty()) == null) continue;
            return config2;
        }
        return null;
    }

    protected RiRepoActivity computeCurrentActivity(RiRepoWorkspace workspace, SrvcFeedback feedback) throws WvcmException {
        RiRepoActivity activity = null;
        if (this instanceof RiRepoConfiguration) {
            activity = workspace.getStream();
        } else {
            List<RiRepoActivity> activityList = workspace.getCurrentActivityList();
            if (activityList.size() == 0) {
                activity = RiRepoActivity.doCreateGeneratedActivity(this.provider(), this.get_repo().getActivityFolderLocation().child("act"), this instanceof RiRepoConfiguration, null, null, feedback);
                workspace.setProperty_AppendToList(Workspace.CURRENT_ACTIVITY_LIST, activity);
                activity.setProperty_AppendUniqueToList(Activity.CURRENT_WORKSPACE_LIST, workspace);
            } else {
                activity = activityList.get(0);
            }
        }
        return activity;
    }

    @Override
    protected RiRepoVersion locateByHistory(SrvcResource versionHistory, SrvcFeedback feedback) throws WvcmException {
        if (!(versionHistory instanceof RiRepoVersionHistory)) {
            throw new WvcmException("Argument must be a version history", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        RiRepoVersionHistory vh = (RiRepoVersionHistory)versionHistory;
        RiRepoControllableResource cr = this.getWorkspace().locateByHistoryReport(vh);
        if (cr == null) {
            return null;
        }
        return cr.getCheckedIn();
    }

    @Override
    public Map<String, SrvcResource> getFolderVersionChildMap(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("No need to compute folder versions children");
        }
        if (!(folderVersion instanceof RiRepoFolderVersion)) {
            throw new RuntimeException("getChildMap expects a folder version argument");
        }
        RiRepoFolderVersion v = (RiRepoFolderVersion)folderVersion;
        RiRepoControllableFolder cf = (RiRepoControllableFolder)this.getWorkspace().locateByHistoryReport(v.getVersionHistory());
        HashMap<String, SrvcResource> result = new HashMap<String, SrvcResource>();
        Map<String, RiRepoResource> children = cf.getChildMap();
        for (String bindingName : children.keySet()) {
            RiRepoControllableResource child = (RiRepoControllableResource)children.get(bindingName);
            result.put(bindingName, child.getVersionHistory());
        }
        return result;
    }

    @Override
    public List<SrvcResource> getFolderVersionChildList(SrvcResource folderVersion, SrvcFeedback feedback) throws WvcmException {
        if (!this.versionKnowsParent()) {
            throw new IllegalStateException("No need to compute folder versions children");
        }
        if (!(folderVersion instanceof RiRepoFolderVersion)) {
            throw new RuntimeException("getChildList expects a folder version argument");
        }
        RiRepoFolderVersion v = (RiRepoFolderVersion)folderVersion;
        RiRepoControllableFolder cf = (RiRepoControllableFolder)this.getWorkspace().locateByHistoryReport(v.getVersionHistory());
        ArrayList<SrvcResource> result = new ArrayList<SrvcResource>();
        for (RiRepoControllableResource child : cf.getChildList()) {
            result.add(child.getVersionHistory());
        }
        return result;
    }

    public static SrvcResource doCreateControllableResource(SrvcProvider provider, Location loc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        RiRepo repo = RiRepo.get_Repo(loc, provider);
        RiRepoControllableResource.performCreationPreconditionChecks(loc, provider);
        RiRepoResource parent = RiRepoControllableResource.getParentResource(provider, loc);
        if (!(parent instanceof RiRepoControllableFolder)) {
            throw new WvcmException("Parent folder for a ControllableResource must be a ControllableFolder or Workspace: " + loc, WvcmException.ReasonCode.CANNOT_CREATE_AT_THIS_LOCATION);
        }
        String bindingName = loc.lastSegment();
        RiRepoControllableResource sRes = new RiRepoControllableResource(parent, bindingName, provider, repo);
        if (updates != null) {
            sRes.set_creationInProgress(true);
            sRes.doWriteProperties(updates, updated, feedback);
            sRes.set_creationInProgress(false);
        }
        return sRes;
    }

    public static SrvcResource doCreateVersionControlledResource(SrvcProvider provider, Location location, Location versionLoc, boolean recursing, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        SrvcResource version = provider.getSrvcRes(versionLoc, feedback);
        if (!(version instanceof RiRepoVersion)) {
            throw new WvcmException("Must be a version", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
        }
        return RiRepoControllableResource.createVersionControlledResource(provider, location, (RiRepoVersion)version, recursing, updates, updated, feedback);
    }

    @Override
    public void doVersionControl(SrvcFeedback feedback) throws WvcmException {
        SrvcProvider provider = this.provider();
        RiRepo repo = RiRepo.get_Repo(this.location(), provider);
        if (this.isControlled()) {
            return;
        }
        if (!(this instanceof RiRepoWorkspace)) {
            List<RiRepoIFolder.RepoBinding> parentBindings = this.getParentBindingList();
            int i = 0;
            while (i < parentBindings.size()) {
                RiRepoIFolder.RepoBinding parentBinding = parentBindings.get(i);
                RiRepoControllableFolder parentFolder = (RiRepoControllableFolder)parentBinding.get_bindingFolder();
                if (!parentFolder.getPropertyAsBoolean(ControllableFolder.IS_CHECKED_OUT)) {
                    if (!parentFolder.isControlled()) {
                        parentFolder.doVersionControl(feedback);
                    }
                    if (!this.versionKnowsParent()) {
                        parentFolder.doCheckout(null, null);
                    }
                }
                ++i;
            }
        }
        this.setProperty(ControllableResource.IS_CHECKED_OUT, Boolean.FALSE);
        String versionHistoryName = repo.createUniqueVersionHistoryLocation();
        RiRepoVersionHistory versionHistory = new RiRepoVersionHistory(this._repo.getVersionHistoryFolder(), versionHistoryName, this.provider(), repo);
        this.setProperty(ControllableResource.VERSION_HISTORY, versionHistory);
        String versionName = versionHistory.createUniqueVersionLocation(this instanceof RiRepoControllableFolder);
        RiRepoVersion version = null;
        version = this instanceof RiRepoControllableSymbolicLink ? new RiRepoSymbolicLinkVersion(versionHistory, versionName, this.provider(), repo) : (this instanceof RiRepoControllableFolder ? new RiRepoFolderVersion(versionHistory, versionName, this.provider(), repo) : new RiRepoVersion(versionHistory, versionName, provider, repo));
        if (this.versionKnowsParent()) {
            String name = "NONE";
            RiRepoVersionHistory parentVH = null;
            if (!(this instanceof RiRepoWorkspace)) {
                name = provider.location(this.calculatePath()).lastSegment();
                RiRepoControllableFolder parent = (RiRepoControllableFolder)this.getParentResource();
                parentVH = parent.getVersionHistory();
            }
            version.setProperty(RiRepoVersion.BINDING_NAME, name);
            version.setProperty(RiRepoVersion.PARENT_VERSION_HISTORY, parentVH);
        }
        this.setPropertyEx(ControllableResource.CHECKED_IN, version);
        if (this instanceof RiRepoControllableFolder) {
            ((RiRepoControllableFolder)this).makeIsBaselineControllable();
        }
        this.copyContentAndPropertiesToVersion(version);
        RiRepoWorkspace workspace = (RiRepoWorkspace)this.getProperty(ControllableResource.WORKSPACE);
        version.setPropertyEx(Version.ACTIVITY, this.computeCurrentActivity(workspace, feedback));
        RiRepoStream stream = (RiRepoStream)workspace.getProperty(Workspace.STREAM);
        if (stream != null) {
            stream.setPropertyEx_AppendToList(Stream.VERSION_LIST, version);
        }
    }

    @Override
    public void doCheckout(ControllableResource.CheckoutFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        int i;
        List<RiRepoVersion> streamVersionList;
        boolean forkOK = false;
        boolean reserved = false;
        if (flags != null) {
            int i2 = 0;
            while (i2 < flags.length) {
                if (flags[i2] == ControllableResource.CheckoutFlag.FORK_OK) {
                    forkOK = true;
                } else if (flags[i2] == ControllableResource.CheckoutFlag.RESERVED) {
                    reserved = true;
                }
                ++i2;
            }
        }
        RiRepoVersion checkedInVersion = (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_IN);
        RiRepoVersionHistory checkedInVersionHistory = (RiRepoVersionHistory)this.getProperty(ControllableResource.VERSION_HISTORY);
        RiRepoWorkspace workspace = (RiRepoWorkspace)this.getProperty(ControllableResource.WORKSPACE);
        RiRepoStream stream = (RiRepoStream)workspace.getProperty(Workspace.STREAM);
        RiRepoActivity activity = this.computeCurrentActivity(workspace, feedback);
        if (checkedInVersion == null) {
            throw new WvcmException("Resource must be checked in first", WvcmException.ReasonCode.MUST_BE_CHECKED_IN);
        }
        Version.Fork checkoutFork = (Version.Fork)checkedInVersion.getProperty(Version.CHECKOUT_FORK);
        List<RiRepoVersion> successors = checkedInVersion.getSuccessorList();
        List<RiRepoControllableResource> checkoutList = checkedInVersion.getCheckoutList();
        if (checkoutFork == Version.Fork.FORBIDDEN && successors.size() > 0) {
            throw new WvcmException("CANNOT_CHECKOUT_FORKING_IS_FORBIDDEN", WvcmException.ReasonCode.CANNOT_CHECKOUT_FORKING_IS_FORBIDDEN);
        }
        if (checkoutFork == Version.Fork.DISCOURAGED && !forkOK && successors.size() > 0) {
            throw new WvcmException("CANNOT_CHECKOUT_FORKING_IS_DISCOURAGED", WvcmException.ReasonCode.CANNOT_CHECKOUT_FORKING_IS_DISCOURAGED);
        }
        if (checkoutFork == Version.Fork.DISCOURAGED && !forkOK && checkoutList.size() > 0) {
            throw new WvcmException("CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_DISCOURAGED", WvcmException.ReasonCode.CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_DISCOURAGED);
        }
        if (checkoutFork == Version.Fork.FORBIDDEN && checkoutList.size() > 0) {
            throw new WvcmException("CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_FORBIDDEN", WvcmException.ReasonCode.CANNOT_CHECKOUT_MULTI_CHECKOUT_IS_FORBIDDEN);
        }
        if (stream != null && reserved && !(streamVersionList = stream.getVersionList()).contains(checkedInVersion)) {
            i = 0;
            while (i < streamVersionList.size()) {
                RiRepoVersion streamVersion = streamVersionList.get(i);
                RiRepoVersionHistory streamVersionHistory = (RiRepoVersionHistory)streamVersion.getProperty(Version.VERSION_HISTORY);
                if (streamVersionHistory == checkedInVersionHistory) {
                    throw new WvcmException("CANNOT_CREATE_BRANCH_IN_STREAM", WvcmException.ReasonCode.CANNOT_CREATE_BRANCH_IN_STREAM);
                }
                ++i;
            }
        }
        if (activity != null) {
            if (reserved) {
                RiRepoVersion v = checkedInVersionHistory.getRootVersion();
                this.recursivelyCheckOneCheckoutPerActivityPerHistory(v, activity);
            }
            activity.verifyIsNotComplete();
        }
        if (activity != null && reserved) {
            List<RiRepoVersion> actVersionList = activity.getActivityVersionList();
            i = 0;
            while (i < actVersionList.size()) {
                RiRepoVersionHistory repoResVerHist;
                RiRepoVersion version = actVersionList.get(i);
                if (version != checkedInVersion && (repoResVerHist = (RiRepoVersionHistory)version.getProperty(Version.VERSION_HISTORY)) == checkedInVersionHistory && !version.isAncestorOf(checkedInVersion)) {
                    throw new WvcmException("CANNOT_CREATE_BRANCH_IN_ACTIVITY (on checkout)", WvcmException.ReasonCode.CANNOT_CREATE_BRANCH_IN_ACTIVITY);
                }
                ++i;
            }
        }
        this.setProperty(ControllableResource.IS_CHECKED_OUT, Boolean.TRUE);
        this.setPropertyEx(ControllableResource.CHECKED_OUT, checkedInVersion);
        this.setPropertyEx(ControllableResource.CHECKED_IN, null);
        ArrayList<RiRepoVersion> predecessors = new ArrayList<RiRepoVersion>();
        predecessors.add(checkedInVersion);
        this.setProperty(ControllableResource.PREDECESSOR_LIST, predecessors);
        this.setPropertyEx(ControllableResource.ACTIVITY, activity);
        if (!reserved) {
            this.setProperty(ControllableResource.RESERVED, Boolean.TRUE);
        }
        workspace.setProperty_AppendUniqueToList(Workspace.WORKSPACE_CHECKOUT_LIST, this);
        checkedInVersion.setProperty_AppendUniqueToList(Version.CHECKOUT_LIST, this);
    }

    @Override
    public void doCheckin(ControllableResource.CheckinFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion pred;
        SrvcProvider provider = this.provider();
        RiRepo repo = RiRepo.get_Repo(this.location(), provider);
        boolean keepCheckedOut = false;
        boolean forkOK = false;
        boolean checkinIdentical = false;
        if (flags != null) {
            int i = 0;
            while (i < flags.length) {
                if (flags[i] == ControllableResource.CheckinFlag.KEEP_CHECKED_OUT) {
                    keepCheckedOut = true;
                } else if (flags[i] == ControllableResource.CheckinFlag.FORK_OK) {
                    forkOK = true;
                } else if (flags[i] == ControllableResource.CheckinFlag.CHECKIN_IDENTICAL) {
                    checkinIdentical = true;
                }
                ++i;
            }
        }
        if (!this.getPropertyAsBoolean(ControllableResource.IS_CHECKED_OUT)) {
            throw new WvcmException("Resource must be checked out first", WvcmException.ReasonCode.MUST_BE_CHECKED_OUT);
        }
        RiRepoVersion checkedOutVersion = this.getCheckedOut();
        RiRepoVersionHistory versionHistory = this.getVersionHistory();
        RiRepoActivity activity = this.getActivity();
        RiRepoWorkspace workspace = this.getWorkspace();
        RiRepoStream stream = workspace.getStream();
        ArrayList<RiRepoVersion> predecessors = new ArrayList<RiRepoVersion>();
        predecessors.addAll(this.getPredecessorList());
        predecessors.addAll(this.getMergeList());
        predecessors.addAll(this.getAutoMergeList());
        RiRepoControllableFolder baselineControlledFolder = null;
        if (this instanceof RiRepoConfiguration) {
            activity = stream;
            stream = null;
            RiRepoConfiguration configuration = (RiRepoConfiguration)this;
            baselineControlledFolder = configuration.getRootFolder();
            baselineControlledFolder.checkNoCheckedOutBaselineControlledFolderMembers();
        }
        if (!checkinIdentical && !this.isControlledStateDifferent(checkedOutVersion, feedback) && predecessors.size() == 1 && (pred = (RiRepoVersion)predecessors.get(0)) == checkedOutVersion) {
            if (keepCheckedOut) {
                return;
            }
            this.doUncheckout(feedback);
            return;
        }
        int i = 0;
        while (i < predecessors.size()) {
            RiRepoVersion predecessor = (RiRepoVersion)predecessors.get(i);
            if (predecessor == null) {
                throw new WvcmException("A predecessor cannot be null", WvcmException.ReasonCode.BAD_ARGUMENT_TYPE);
            }
            RiRepoVersionHistory predecessorVersionHistory = predecessor.getVersionHistory();
            if (predecessorVersionHistory != versionHistory) {
                throw new WvcmException("VERSION_HISTORY_MUST_BE_A_TREE", WvcmException.ReasonCode.VERSION_HISTORY_MUST_BE_A_TREE);
            }
            ++i;
        }
        Version.Fork checkinFork = (Version.Fork)checkedOutVersion.getProperty(Version.CHECKIN_FORK);
        List<RiRepoVersion> successors = checkedOutVersion.getSuccessorList();
        if (checkinFork == Version.Fork.FORBIDDEN && successors.size() > 0) {
            throw new WvcmException("checkin-fork-forbidden", WvcmException.ReasonCode.CANNOT_FORK);
        }
        if (checkinFork == Version.Fork.DISCOURAGED && !forkOK && successors.size() > 0) {
            throw new WvcmException("checkin-fork-discouraged", WvcmException.ReasonCode.CANNOT_CHECKIN_FORK_DISCOURAGED);
        }
        List<RiRepoVersion> versionList = versionHistory.getChildList();
        if (!(checkedOutVersion instanceof RiRepoBaseline)) {
            for (RiRepoVersion version : versionList) {
                if (version == checkedOutVersion) continue;
                RiRepoActivity versionActivity = (RiRepoActivity)version.getProperty(Version.ACTIVITY);
                if (activity == null || activity != versionActivity || version.isAncestorOf(checkedOutVersion)) continue;
                throw new WvcmException("CANNOT_CREATE_BRANCH_IN_ACTIVITY", WvcmException.ReasonCode.CANNOT_CREATE_BRANCH_IN_ACTIVITY);
            }
        }
        Boolean reserved = (Boolean)this.getProperty(ControllableResource.RESERVED);
        if (activity != null && !reserved.booleanValue()) {
            List<RiRepoControllableResource> activityCheckoutList = activity.getActivityCheckoutList();
            int i2 = 0;
            while (i2 < activityCheckoutList.size()) {
                Boolean otherReserved;
                RiRepoControllableResource co = activityCheckoutList.get(i2);
                if (co != this && co.getVersionHistory() == versionHistory && (otherReserved = (Boolean)co.getProperty(ControllableResource.RESERVED)).booleanValue()) {
                    throw new WvcmException("CANNOT_CHECKIN_TO_RESERVED_ACTIVITY", WvcmException.ReasonCode.CANNOT_CHECKIN_TO_RESERVED_ACTIVITY);
                }
                ++i2;
            }
        }
        if (activity != null) {
            activity.verifyIsNotComplete();
        }
        RiRepoVersion oldVersionInStream = null;
        if (stream != null) {
            oldVersionInStream = stream.getVersionMap().get(versionHistory);
            if (provider.initArgs().get("com.ibm.rational.wvcm.STREAM_FORGETS_UNBOUND_VERSIONS") == null && oldVersionInStream != null && !predecessors.contains(oldVersionInStream)) {
                throw new WvcmException("CANNOT_CREATE_BRANCH_IN_STREAM", WvcmException.ReasonCode.CANNOT_CREATE_BRANCH_IN_STREAM);
            }
        }
        List<RiRepoVersion> predecessorList = this.getPredecessorList();
        if (!this.getMergeList().isEmpty()) {
            predecessorList.addAll(this.getMergeList());
            this.setPropertyEx(ControllableResource.MERGE_LIST, new ArrayList());
        }
        if (!this.getAutoMergeList().isEmpty()) {
            predecessorList.addAll(this.getAutoMergeList());
            this.setPropertyEx(ControllableResource.AUTO_MERGE_LIST, new ArrayList());
        }
        String versionName = null;
        RiRepoVersion newVersion = null;
        if (this instanceof RiRepoControllableSymbolicLink) {
            versionName = versionHistory.createUniqueVersionLocation(false);
            newVersion = new RiRepoSymbolicLinkVersion(versionHistory, versionName, this.provider(), repo);
        } else if (this instanceof RiRepoControllableFolder) {
            versionName = versionHistory.createUniqueVersionLocation(true);
            newVersion = new RiRepoFolderVersion(versionHistory, versionName, this.provider(), repo);
        } else if (this instanceof RiRepoConfiguration) {
            versionName = versionHistory.createUniqueBaselineLocation();
            newVersion = new RiRepoBaseline(versionHistory, versionName, this.provider(), repo);
        } else {
            versionName = versionHistory.createUniqueVersionLocation(false);
            newVersion = new RiRepoVersion(versionHistory, versionName, this.provider(), repo);
        }
        this.copyContentAndPropertiesToVersion(newVersion);
        newVersion.setPropertyEx(Version.ACTIVITY, activity);
        if (this.versionKnowsParent()) {
            String name = "NONE";
            RiRepoVersionHistory parentVH = null;
            if (!(this instanceof RiRepoWorkspace) && !(this instanceof RiRepoConfiguration)) {
                name = provider.location(this.calculatePath()).lastSegment();
                RiRepoControllableFolder parent = (RiRepoControllableFolder)this.getParentResource();
                parentVH = parent.getVersionHistory();
            }
            newVersion.setProperty(RiRepoVersion.BINDING_NAME, name);
            newVersion.setProperty(RiRepoVersion.PARENT_VERSION_HISTORY, parentVH);
        } else if (this instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder thisCF = (RiRepoControllableFolder)this;
            RiRepoFolderVersion newFolderVersion = (RiRepoFolderVersion)newVersion;
            List<RiRepoIFolder.RepoBinding> childBindings = thisCF.getChildBindingList();
            int i3 = 0;
            while (i3 < childBindings.size()) {
                RiRepoIFolder.RepoBinding binding = childBindings.get(i3);
                RiRepoControllableResource member = (RiRepoControllableResource)binding.get_bindingMember();
                String memberBindingName = binding.get_bindingName();
                if (member.isControlled()) {
                    RiRepoVersionHistory memberVersionHistory = (RiRepoVersionHistory)member.getProperty(Version.VERSION_HISTORY);
                    newFolderVersion.setupBinding(memberBindingName, memberVersionHistory);
                }
                ++i3;
            }
        }
        if (this instanceof RiRepoConfiguration) {
            ArrayList<RiRepoVersion> newBaselineVersions = new ArrayList<RiRepoVersion>();
            baselineControlledFolder.createBaselineVersionList(newBaselineVersions);
            newVersion.setPropertyEx(Baseline.VERSION_LIST, newBaselineVersions);
        }
        checkedOutVersion.setProperty_RemoveFromList(Version.CHECKOUT_LIST, this);
        if (stream != null) {
            if (oldVersionInStream != null) {
                stream.setPropertyEx_RemoveFromList(Stream.VERSION_LIST, oldVersionInStream);
            }
            stream.setPropertyEx_AppendToList(Stream.VERSION_LIST, newVersion);
        }
        newVersion.setPropertyEx(Version.PREDECESSOR_LIST, predecessorList);
        if (keepCheckedOut) {
            ArrayList<RiRepoVersion> newPredecessors = new ArrayList<RiRepoVersion>();
            newPredecessors.add(newVersion);
            this.setProperty(ControllableResource.PREDECESSOR_LIST, newPredecessors);
            this.setPropertyEx(ControllableResource.CHECKED_OUT, newVersion);
        } else {
            this.setProperty(ControllableResource.PREDECESSOR_LIST, null);
            this.setPropertyEx(ControllableResource.CHECKED_IN, newVersion);
            this.setPropertyEx(ControllableResource.CHECKED_OUT, null);
            this.setProperty(ControllableResource.IS_CHECKED_OUT, Boolean.FALSE);
            this.setPropertyEx(ControllableResource.ACTIVITY, null);
            workspace.setProperty_RemoveFromList(Workspace.WORKSPACE_CHECKOUT_LIST, this);
        }
    }

    @Override
    public void doUncheckout(SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion checkedOutVersion = this.getCheckedOut();
        if (checkedOutVersion == null || !this.getIsCheckedOut()) {
            throw new WvcmException("Resource must be a checked out Version Controlled Resource", WvcmException.ReasonCode.MUST_BE_CHECKED_OUT);
        }
        if (this.versionKnowsParent()) {
            RiRepoVersionHistory origParentVH = checkedOutVersion.getParentVersionHistory(feedback);
            if (origParentVH != null) {
                String origName = checkedOutVersion.getBindingName(feedback);
                SrvcLocation currentPathLoc = this.provider().location(this.calculatePath());
                RiRepoControllableFolder currentParent = (RiRepoControllableFolder)this.getParentResource();
                if (!origParentVH.equals(currentParent.getVersionHistory()) || !origName.equals(currentPathLoc.lastSegment())) {
                    String currentName = currentPathLoc.lastSegment();
                    RiRepoControllableFolder origParent = (RiRepoControllableFolder)this.getWorkspace().locateByHistoryReport(origParentVH);
                    if (origParent == null) {
                        currentParent.doUnbindChild(currentName, feedback);
                    } else {
                        origParent.doRebindChild(origName, currentPathLoc, currentName, RF_DO_UNCHECKOUT, feedback);
                    }
                }
            }
        } else if (this instanceof RiRepoControllableFolder) {
            RiRepoControllableFolder cf = (RiRepoControllableFolder)this;
            RiRepoFolderVersion fv = (RiRepoFolderVersion)checkedOutVersion;
            cf.restoreBoundMembersToFolderVersion(fv);
        }
        checkedOutVersion.setProperty_RemoveFromList(Version.CHECKOUT_LIST, this);
        RiRepoWorkspace workspace = this.getWorkspace();
        workspace.setProperty_RemoveFromList(Workspace.WORKSPACE_CHECKOUT_LIST, this);
        this.setPropertyEx(ControllableResource.ACTIVITY, null);
        this.setProperty(ControllableResource.PREDECESSOR_LIST, null);
        ArrayList mergeList = new ArrayList();
        ArrayList autoMergeList = new ArrayList();
        this.setProperty(ControllableResource.MERGE_LIST, mergeList);
        this.setProperty(ControllableResource.AUTO_MERGE_LIST, autoMergeList);
        this.setPropertyEx(ControllableResource.CHECKED_IN, checkedOutVersion);
        this.setPropertyEx(ControllableResource.CHECKED_OUT, null);
        this.setProperty(ControllableResource.IS_CHECKED_OUT, Boolean.FALSE);
        this.setProperty(ControllableResource.RESERVED, Boolean.FALSE);
        RiRepoControllableResource.copyVersionToVCR(checkedOutVersion, this);
    }

    @Override
    public void doRemoveLabel(String label, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion checkedInVersion = (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_IN);
        if (checkedInVersion == null) {
            throw new WvcmException("Resource must be checked in first", WvcmException.ReasonCode.MUST_BE_CHECKED_IN);
        }
        checkedInVersion.doRemoveLabel(label, feedback);
    }

    @Override
    public void doSetLabel(String label, boolean overwrite, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion checkedInVersion = (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_IN);
        if (checkedInVersion == null) {
            throw new WvcmException("Resource must be checked in first", WvcmException.ReasonCode.MUST_BE_CHECKED_IN);
        }
        checkedInVersion.doSetLabel(label, overwrite, feedback);
    }

    @Override
    public RiRepoVersion doReadLabelledVersionProperties(String label, SrvcFeedback feedback) throws WvcmException {
        RiRepoVersion checkedInVersion = (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_IN);
        if (checkedInVersion == null) {
            throw new WvcmException("MUST_BE_CHECKED_IN", WvcmException.ReasonCode.MUST_BE_CHECKED_IN);
        }
        RiRepoVersionHistory vh = (RiRepoVersionHistory)this.getProperty(ControllableResource.VERSION_HISTORY);
        RiRepoVersion version = vh.labelMap.get(label);
        if (version == null) {
            throw new WvcmException("Label not found", WvcmException.ReasonCode.NOT_FOUND);
        }
        return version;
    }

    public boolean getIsVersionControlled() {
        return this.getPropertyAsBoolean(ControllableResource.IS_VERSION_CONTROLLED);
    }

    public RiRepoVersionHistory getVersionHistory() {
        return (RiRepoVersionHistory)this.getProperty(ControllableResource.VERSION_HISTORY);
    }

    public RiRepoVersion getCheckedIn() {
        return (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_IN);
    }

    public RiRepoVersion getCheckedOut() {
        return (RiRepoVersion)this.getProperty(ControllableResource.CHECKED_OUT);
    }

    public boolean getIsCheckedOut() {
        return this.getPropertyAsBoolean(ControllableResource.IS_CHECKED_OUT);
    }

    public boolean getReserved() {
        return this.getPropertyAsBoolean(ControllableResource.RESERVED);
    }

    public RiRepoWorkspace getWorkspace() {
        return (RiRepoWorkspace)this.getProperty(ControllableResource.WORKSPACE);
    }

    public RiRepoActivity getActivity() {
        return (RiRepoActivity)this.getProperty(ControllableResource.ACTIVITY);
    }

    public List<RiRepoVersion> getPredecessorList() {
        return this.getListProperty(ControllableResource.PREDECESSOR_LIST);
    }

    public List<RiRepoVersion> getMergeList() {
        return this.getListProperty(ControllableResource.MERGE_LIST);
    }

    public List<RiRepoVersion> getAutoMergeList() {
        return this.getListProperty(ControllableResource.AUTO_MERGE_LIST);
    }

    public List<RiRepoControllableFolder> getParentList() {
        return this.getListProperty(Resource.PARENT_LIST);
    }

    @Override
    public List<RiRepoIFolder.RepoBinding> getParentBindingList() {
        return this.getListProperty(RiRepoResource.PARENT_BINDING_LIST);
    }
}

