/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.login;

import com.ibm.team.repository.client.internal.login.KeyStoreKeyManager;
import com.ibm.team.repository.client.internal.login.KeyStoreKeyManagerProvider;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.login.IAliasChooser;
import com.ibm.team.repository.client.login.KeyStoreLoginInfo;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.AuthenticationException;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.osgi.util.NLS;

public class SmartCardLoginInfo
extends KeyStoreLoginInfo {
    private static final Log LOGGER;
    public static final String ALIAS = "userId";
    private String alias;

    static {
        Security.addProvider(new KeyStoreKeyManagerProvider());
        LOGGER = LogFactory.getLog(SmartCardLoginInfo.class);
    }

    public SmartCardLoginInfo() {
        KeyStoreKeyManager.setClientAliasChooser(new SmartCardAliasChooser());
    }

    public SmartCardLoginInfo(String _alias) {
        this.alias = _alias;
        KeyStoreKeyManager.setClientAliasChooser(new SmartCardAliasChooser());
    }

    public SmartCardLoginInfo(byte[] certArray) throws TeamRepositoryException {
        ByteArrayInputStream certStream;
        try {
            certStream = new ByteArrayInputStream(certArray);
        }
        catch (NullPointerException e) {
            String message = Messages.getClientString("SmartCardLoginInfo.ErrorGeneratingCertificateFromBytes");
            LOGGER.error((Object)message);
            throw new TeamRepositoryException(message, (Throwable)e);
        }
        try {
            PublicKey pubKey;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(certStream);
            byte[] publicKeyEncoded = null;
            if (cert != null && (pubKey = cert.getPublicKey()) != null) {
                publicKeyEncoded = pubKey.getEncoded();
            }
            this.alias = this.getAliasFromEncodedKey(publicKeyEncoded);
        }
        catch (CertificateException e) {
            String message = Messages.getClientString("SmartCardLoginInfo.ErrorGeneratingCertificateFromBytes");
            LOGGER.error((Object)message);
            throw new TeamRepositoryException(message, (Throwable)e);
        }
        KeyStoreKeyManager.setClientAliasChooser(new SmartCardAliasChooser());
    }

    public SmartCardLoginInfo(IAliasChooser aliasChooser) {
        KeyStoreKeyManager.setClientAliasChooser(aliasChooser);
    }

    @Override
    protected KeyManagerFactory getKeyManagerFactory() throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance("KeyStoreKeyManager");
    }

    @Override
    protected KeyStore createKeyStore() throws KeyStoreException {
        return this.getKeyStore("Windows-MY");
    }

    @Override
    public boolean hasPassword() {
        return false;
    }

    @Override
    public Properties getLoginProperties() {
        Properties properties = super.getLoginProperties();
        if (this.alias != null) {
            properties.setProperty(ALIAS, this.alias);
        }
        return properties;
    }

    @Override
    public void setLoginProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        this.alias = properties.getProperty(ALIAS);
    }

    private String getAliasFromEncodedKey(byte[] encodedKey) throws TeamRepositoryException {
        String message;
        KeyStore ks;
        try {
            ks = this.getKeyStore();
        }
        catch (AuthenticationException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        for (String storeAlias : this.getAliases()) {
            Certificate cert;
            block9: {
                try {
                    cert = ks.getCertificate(storeAlias);
                    if (cert == null) {
                    }
                    break block9;
                }
                catch (KeyStoreException e) {
                    String pattern = Messages.getClientString("KeyStoreKeyManager.FailedToGetClientAlias");
                    String message2 = NLS.bind((String)pattern, (Object)storeAlias);
                    LOGGER.error((Object)message2, (Throwable)e);
                }
                continue;
            }
            PublicKey publicKey = cert.getPublicKey();
            byte[] encodedFromStore = null;
            if (publicKey != null) {
                encodedFromStore = publicKey.getEncoded();
            }
            if (encodedKey == null || encodedFromStore == null || !Arrays.equals(encodedKey, encodedFromStore)) continue;
            return storeAlias;
        }
        String pattern = Messages.getClientString("SmartCardLoginInfo.PublicKeyNotFound");
        if (encodedKey != null && encodedKey.length > 80) {
            String encodedKeyPart = String.valueOf(Arrays.toString(Arrays.copyOf(encodedKey, 80))) + "...";
            message = NLS.bind((String)pattern, (Object)encodedKeyPart);
        } else {
            message = NLS.bind((String)pattern, (Object)Arrays.toString(encodedKey));
        }
        LOGGER.error((Object)message);
        throw new TeamRepositoryException(message);
    }

    private class SmartCardAliasChooser
    implements IAliasChooser {
        private SmartCardAliasChooser() {
        }

        @Override
        public String chooseAlias(List<String> aliases) {
            return SmartCardLoginInfo.this.alias;
        }
    }
}

