/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"*/*"})
@Consumes(value={"*/*"})
public class FileProvider
implements MessageBodyWriter<File>,
MessageBodyReader<File> {
    private static final Logger logger = LoggerFactory.getLogger(FileProvider.class);
    private String prefix = "FP_PRE";
    private String uploadDir = null;
    private String suffix = "FP_SUF";

    @Override
    public long getSize(File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return t.length();
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return File.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(final File t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, final OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws IOException {
                    if (!t.canRead() || t.isDirectory()) {
                        if (logger.isWarnEnabled()) {
                            logger.error(Messages.getMessage("cannotUseFileAsResponse", t.getAbsoluteFile()));
                        }
                        throw new WebApplicationException();
                    }
                    FileInputStream fis = new FileInputStream(t);
                    try {
                        FileProvider.this.pipe(fis, entityStream);
                    }
                    finally {
                        fis.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            if (e.getException() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getException();
            }
            throw new WebApplicationException(e.getException());
        }
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(File.class);
    }

    @Override
    public File readFrom(Class<File> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, final InputStream entityStream) throws IOException, WebApplicationException {
        File dir = null;
        if (!(this.uploadDir == null || (dir = new File(this.uploadDir)).exists() && dir.isDirectory())) {
            dir = null;
            if (logger.isWarnEnabled()) {
                logger.error(Messages.getMessage("uploadDirDoesNotExist", this.uploadDir));
            }
            throw new WebApplicationException();
        }
        final File _dir = dir;
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public File run() throws Exception {
                    File f = File.createTempFile(FileProvider.this.prefix, FileProvider.this.suffix, _dir);
                    FileOutputStream fos = new FileOutputStream(f);
                    try {
                        FileProvider.this.pipe(entityStream, fos);
                    }
                    finally {
                        fos.close();
                    }
                    return f;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            if (e.getException() instanceof WebApplicationException) {
                throw (WebApplicationException)e.getException();
            }
            throw new WebApplicationException(e.getException());
        }
    }

    private void pipe(InputStream is, OutputStream os) throws IOException {
        byte[] ba = new byte[1024];
        int i = is.read(ba);
        while (i != -1) {
            os.write(ba, 0, i);
            i = is.read(ba);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getUploadDir() {
        return this.uploadDir;
    }

    public void setUploadDir(String uploadDir) {
        this.uploadDir = uploadDir;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

