/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.providers.entity.html;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.wink.server.internal.providers.entity.html.HtmlDescriptor;
import org.apache.wink.server.internal.providers.entity.html.OutputStreamHttpServletResponseWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"text/html"})
public class HtmlProvider
implements MessageBodyWriter<HtmlDescriptor> {
    @Context
    protected HttpServletRequest httpServletRequest;
    @Context
    private HttpServletResponse httpServletResponse;

    private void include(OutputStream stream, String includeUrl) throws IOException {
        OutputStreamHttpServletResponseWrapper httpServletResponseWrapper = new OutputStreamHttpServletResponseWrapper(this.httpServletResponse, stream);
        try {
            this.httpServletRequest.getRequestDispatcher(includeUrl).include((ServletRequest)this.httpServletRequest, (ServletResponse)httpServletResponseWrapper);
        }
        catch (ServletException e) {
            throw new WebApplicationException(e);
        }
        httpServletResponseWrapper.flushOutput();
    }

    @Override
    public long getSize(HtmlDescriptor t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return HtmlDescriptor.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(HtmlDescriptor descriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.httpServletRequest.setAttribute(descriptor.getAttributeName(), descriptor.getObject());
        this.include(entityStream, descriptor.getIncludeUrl());
        this.httpServletRequest.removeAttribute(descriptor.getAttributeName());
    }
}

