/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.client;

import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientWebException;
import org.apache.wink.client.EntityType;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.ClientHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OslcRestClient {
    public static final int DEFAULT_READ_TIMEOUT = 60000;
    private final Set<Class<?>> providers;
    private final String uri;
    private final Resource clientResource;
    private final String mediaType;
    private final int readTimeout;

    public OslcRestClient(final Set<Class<?>> providers, String uri, String mediaType, int readTimeout, ClientHandler ... handlers) {
        this.providers = providers;
        this.uri = uri;
        this.mediaType = mediaType;
        this.readTimeout = readTimeout;
        ClientConfig clientConfig = new ClientConfig();
        if (providers != null && providers.size() > 0) {
            Application application = new Application(){

                @Override
                public Set<Class<?>> getClasses() {
                    return providers;
                }
            };
            clientConfig.applications(application);
        }
        clientConfig.readTimeout(readTimeout);
        if (handlers != null && handlers.length > 0) {
            clientConfig.handlers(handlers);
        }
        RestClient client = new RestClient(clientConfig);
        this.clientResource = client.resource(uri);
    }

    public OslcRestClient(Set<Class<?>> providers, String uri, String mediaType) {
        this(providers, uri, mediaType, 60000, new ClientHandler[0]);
    }

    public OslcRestClient(Set<Class<?>> providers, String uri, int timeout) {
        this(providers, uri, "application/rdf+xml", timeout, new ClientHandler[0]);
    }

    public OslcRestClient(Set<Class<?>> providers, String uri) {
        this(providers, uri, "application/rdf+xml", 60000, new ClientHandler[0]);
    }

    public OslcRestClient(Set<Class<?>> providers, URI uri, String mediaType, int readTimeout) {
        this(providers, uri.toString(), mediaType, readTimeout, new ClientHandler[0]);
    }

    public OslcRestClient(Set<Class<?>> providers, URI uri, String mediaType) {
        this(providers, uri.toString(), mediaType, 60000, new ClientHandler[0]);
    }

    public OslcRestClient(Set<Class<?>> providers, URI uri, int timeout) {
        this(providers, uri.toString(), "application/rdf+xml", timeout, new ClientHandler[0]);
    }

    public OslcRestClient(Set<Class<?>> providers, URI uri) {
        this(providers, uri.toString(), "application/rdf+xml", 60000, new ClientHandler[0]);
    }

    public Set<Class<?>> getProviders() {
        return this.providers;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getUri() {
        return this.uri;
    }

    public Resource getClientResource() {
        return this.clientResource;
    }

    public <T> T getOslcResource(Class<T> oslcResourceClass) {
        try {
            ClientResponse response = this.clientResource.accept(this.mediaType).get();
            int statusCode = response.getStatusCode();
            if (200 == statusCode) {
                return response.getEntity(oslcResourceClass);
            }
            throw new ClientWebException(null, response);
        }
        catch (ClientWebException exception) {
            int statusCode;
            ClientResponse response = exception.getResponse();
            if (response != null && (204 == (statusCode = response.getStatusCode()) || 404 == statusCode || 410 == statusCode)) {
                return null;
            }
            throw exception;
        }
    }

    public <T> T[] getOslcResources(Class<T[]> oslcResourceArrayClass) {
        try {
            ClientResponse response = this.clientResource.accept(this.mediaType).get();
            int statusCode = response.getStatusCode();
            if (200 == statusCode) {
                return response.getEntity(oslcResourceArrayClass);
            }
            throw new ClientWebException(null, response);
        }
        catch (ClientWebException exception) {
            int statusCode;
            ClientResponse response = exception.getResponse();
            if (response != null && (204 == (statusCode = response.getStatusCode()) || 404 == statusCode || 410 == statusCode)) {
                return null;
            }
            throw exception;
        }
    }

    public <T extends Collection<?>> T getOslcResources(EntityType<T> entityType) {
        try {
            ClientResponse response = this.clientResource.accept(this.mediaType).get();
            int statusCode = response.getStatusCode();
            if (200 == statusCode) {
                return (T)((Collection)response.getEntity(entityType));
            }
            throw new ClientWebException(null, response);
        }
        catch (ClientWebException exception) {
            int statusCode;
            ClientResponse response = exception.getResponse();
            if (response != null && (204 == (statusCode = response.getStatusCode()) || 404 == statusCode || 410 == statusCode)) {
                return null;
            }
            throw exception;
        }
    }

    public <T> T addOslcResource(T oslcResource) {
        ClientResponse response = this.clientResource.contentType(this.mediaType).accept("*/*").post(ClientResponse.class, oslcResource);
        int statusCode = response.getStatusCode();
        if (200 == statusCode || 201 == statusCode) {
            return (T)response.getEntity(oslcResource.getClass());
        }
        throw new ClientWebException(null, response);
    }

    public ClientResponse addOslcResourceReturnClientResponse(Object oslcResource) {
        try {
            return this.clientResource.contentType(this.mediaType).accept("*/*").post(ClientResponse.class, oslcResource);
        }
        catch (ClientWebException exception) {
            ClientResponse response = exception.getResponse();
            if (response != null) {
                return response;
            }
            throw exception;
        }
    }

    public ClientResponse updateOslcResourceReturnClientResponse(Object oslcResource) {
        try {
            return this.clientResource.contentType(this.mediaType).put(ClientResponse.class, oslcResource);
        }
        catch (ClientWebException exception) {
            ClientResponse response = exception.getResponse();
            if (response != null) {
                return response;
            }
            throw exception;
        }
    }

    public ClientResponse removeOslcResourceReturnClientResponse() {
        try {
            return this.clientResource.accept("*/*").delete();
        }
        catch (ClientWebException exception) {
            ClientResponse response = exception.getResponse();
            if (response != null) {
                return response;
            }
            throw exception;
        }
    }
}

