/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.interceptors.DirtyInterceptor;
import com.urbancode.air.vc.interceptors.InterceptorRegistry;
import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;

public class PersistenceData
implements Serializable {
    private static final long serialVersionUID = 523523623621L;
    private static final Logger log = Logger.getLogger(PersistenceData.class);
    private final Persistent persistent;
    private String path = null;
    private boolean dirty = false;
    private boolean deleted = false;
    private Commit commit = null;
    private int relativeVersion = 0;
    private int versionCount = 0;

    public PersistenceData(Persistent persistent, boolean create) {
        if (persistent == null) {
            throw new IllegalArgumentException("Cannot create PersistentData without a persistent");
        }
        this.persistent = persistent;
        this.dirty = create;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (!this.dirty && dirty) {
            List<DirtyInterceptor> dirtyInterceptors = InterceptorRegistry.getInstance().getDirtyInterceptors();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Dirtying persistent " + this.path));
            }
            for (DirtyInterceptor interceptor : dirtyInterceptors) {
                interceptor.interceptDirty(this.persistent);
            }
        }
        this.dirty = dirty;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        if (deleted) {
            this.setDirty(true);
        }
        this.deleted = deleted;
    }

    protected void internalSetDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    protected void setCommit(Commit commit) {
        this.commit = commit;
    }

    public long getCommit() {
        if (this.commit != null) {
            return this.commit.getId();
        }
        return 0L;
    }

    public Commit getCommitObject() {
        return this.commit;
    }

    protected void setRelativeVersion(int version) {
        this.relativeVersion = version;
    }

    public int getRelativeVersion() {
        return this.relativeVersion;
    }

    protected void setVersionCount(int versionCount) {
        this.versionCount = versionCount;
    }

    public int getVersionCount() {
        return this.versionCount;
    }

    public void setPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Cannot set a null path.");
        }
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }
}

