/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.internal.factory;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.links.internal.links.LinksFactory;
import com.ibm.team.links.internal.links.Reference;
import com.ibm.team.links.internal.links.ReferenceType;
import com.ibm.team.repository.common.IItemHandle;
import java.net.URI;

public class ReferenceFactory
implements IReferenceFactory {
    @Override
    public IItemReference createReferenceToItem(IItemHandle item) {
        return this.createReferenceToItem(item, "");
    }

    @Override
    public IItemReference createReferenceToItem(IItemHandle item, String comment) {
        if (item == null || item.getItemId() == null) {
            throw new IllegalArgumentException("Must specify an item");
        }
        Reference result = LinksFactory.eINSTANCE.createReference();
        result.setReferenceType(ReferenceType.ITEM_REFERENCE_LITERAL);
        result.setReferencedItem(item);
        result.setComment(comment);
        return result;
    }

    @Override
    public IItemReference createReferenceToItem(IItemHandle item, String comment, String extraInfo) {
        if (item == null || item.getItemId() == null) {
            throw new IllegalArgumentException("Must specify an item");
        }
        Reference result = LinksFactory.eINSTANCE.createReference();
        result.setReferenceType(ReferenceType.ITEM_REFERENCE_LITERAL);
        result.setReferencedItem(item);
        result.setComment(comment);
        result.setExtraInfo(extraInfo);
        return result;
    }

    @Override
    public IURIReference createReferenceFromURI(URI uri) {
        return this.uncheckedCreateReferenceFromURI(uri.toString(), "", null, null);
    }

    @Override
    public IURIReference createReferenceFromURI(URI uri, String comment) {
        return this.uncheckedCreateReferenceFromURI(uri.toString(), comment, null, null);
    }

    @Override
    public IURIReference createReferenceFromURI(URI uri, String comment, String extraInfo) {
        return this.uncheckedCreateReferenceFromURI(uri.toString(), comment, extraInfo, null);
    }

    @Override
    public IURIReference createReferenceFromURI(URI uri, String comment, String extraInfo, String contentType) {
        return this.uncheckedCreateReferenceFromURI(uri.toString(), comment, extraInfo, contentType);
    }

    private IURIReference uncheckedCreateReferenceFromURI(String uri, String comment, String extraInfo, String contentType) {
        Reference result = LinksFactory.eINSTANCE.createReference();
        result.setReferenceType(ReferenceType.URI_REFERENCE_LITERAL);
        result.setUri(uri);
        result.setComment(comment);
        result.setExtraInfo(extraInfo);
        result.setContentType(contentType);
        return result;
    }
}

