/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util.tar;

import com.ibm.team.repository.common.internal.content.util.PartialTarEntryCachedDiskBackedHashMap;
import com.ibm.team.repository.common.internal.content.util.tar.ITarFileEntriesMap;
import com.ibm.team.repository.common.internal.content.util.tar.TarEntry;
import com.ibm.team.repository.common.internal.content.util.tar.TarFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class PartialTarFileEntriesMap
implements ITarFileEntriesMap {
    private Map<String, Long[]> entries;
    private static final String CONTENTS_DIR_PATH_PREFIX = "core/Content/";
    private static final String CONTENTS_DIR_PATH_SUFFIX = ".bin";

    public PartialTarFileEntriesMap(long fileSize) {
        this.entries = new PartialTarEntryCachedDiskBackedHashMap<String, Long[]>(Math.max(17L, fileSize / 2048L));
    }

    @Override
    public void loadMapInBackground(InputStream entriesInputStream, Object lock, CountDownLatch allDone, TarFile.EntryFilter filter, IOException[] exception) {
        if (filter != null) {
            throw new IllegalArgumentException("filter is not customizeable in PartialTarFileEntriesMap");
        }
        LoadMap loader = new LoadMap(entriesInputStream, lock, allDone, exception);
        Thread backgroundThread = new Thread((Runnable)loader, "PartialTarFileEntriesMap.LoadMap");
        backgroundThread.start();
    }

    @Override
    public TarEntry get(String key) {
        String name = PartialTarFileEntriesMap.stripName(key);
        Long[] stats = this.entries.get(name);
        if (stats == null) {
            return null;
        }
        long offset = stats[0];
        long size = stats[1];
        TarEntry entry = new TarEntry(key, 0L, 0L, 0L, size, 0L, 0, null, null, null, 0L, 0L, 0L, 0L, offset);
        return entry;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    private static String stripName(String name) {
        if (!name.startsWith(CONTENTS_DIR_PATH_PREFIX)) {
            throw new IllegalArgumentException("bad name for tar entry: " + name);
        }
        if (!name.endsWith(CONTENTS_DIR_PATH_SUFFIX)) {
            throw new IllegalArgumentException("bad name for tar entry: " + name);
        }
        int endIndex = name.length() - CONTENTS_DIR_PATH_SUFFIX.length();
        String result = name.substring(CONTENTS_DIR_PATH_PREFIX.length(), endIndex);
        return result;
    }

    private class LoadMap
    extends ITarFileEntriesMap.AbstractLoadMap {
        public LoadMap(InputStream entriesInputStream, Object lock, CountDownLatch allDone, IOException[] exception) {
            this.entriesInputStream = entriesInputStream;
            this.lock = lock;
            this.allDone = allDone;
            this.exception = exception;
            this.filter = new TarFile.EntryFilter(){

                @Override
                public boolean skipEntry(TarEntry entry) {
                    String name = entry.getName();
                    if (name.startsWith(PartialTarFileEntriesMap.CONTENTS_DIR_PATH_PREFIX)) {
                        return false;
                    }
                    if (entry.getName().charAt(entry.getName().length() - 1) == '/') {
                        return false;
                    }
                    switch (entry.getTypeFlag()) {
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: {
                            return false;
                        }
                    }
                    return true;
                }
            };
        }

        @Override
        protected void putEntry(String name, TarEntry en) {
            long offset = en.getOffset();
            long size = en.getSize();
            Long[] stats = new Long[]{offset, size};
            String strippedName = PartialTarFileEntriesMap.stripName(name);
            PartialTarFileEntriesMap.this.entries.put(strippedName, stats);
        }
    }
}

