/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class ComponentConfigurationRegistry {
    public static final ComponentConfigurationRegistry INSTANCE = new ComponentConfigurationRegistry();
    private volatile List<ComponentConfiguration> componentConfigurations;
    private volatile HashMap<String, String> componentConfigurationsVersionMap;
    private volatile HashMap<String, String> clientCompatibilityMap;
    private volatile Map<String, String> unmodifiableComponentConfigurationsVersionMap;
    private volatile Map<String, String> unmodifiableClientCompatibilityMap;

    public static String formatConfigurationsForHttpHeader(List<ComponentConfiguration> configurations) {
        if (configurations == null) {
            throw new IllegalArgumentException("configurations must not be null");
        }
        StringBuffer buffer = new StringBuffer(configurations.size() * 40);
        for (ComponentConfiguration componentConfiguration : configurations) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(componentConfiguration.getId());
            buffer.append('=');
            buffer.append(componentConfiguration.getVersion());
        }
        return buffer.toString();
    }

    private ComponentConfigurationRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ComponentConfiguration> getComponentConfigurations() {
        if (this.componentConfigurations == null) {
            ComponentConfigurationRegistry componentConfigurationRegistry = this;
            synchronized (componentConfigurationRegistry) {
                if (this.componentConfigurations == null) {
                    List<ComponentConfiguration> newConfigs = ComponentConfigurationRegistry.computeComponentConfigurations();
                    this.componentConfigurations = newConfigs;
                }
            }
        }
        return this.componentConfigurations;
    }

    public Map<String, String> getComponentConfigurationsVersionMap() {
        this.ensureMapsAreInitialized();
        return this.unmodifiableComponentConfigurationsVersionMap;
    }

    public Map<String, String> getClientCompatibilityMap() {
        this.ensureMapsAreInitialized();
        return this.unmodifiableClientCompatibilityMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMapsAreInitialized() {
        HashMap<String, String> newMap;
        ComponentConfigurationRegistry componentConfigurationRegistry;
        if (this.componentConfigurationsVersionMap == null) {
            componentConfigurationRegistry = this;
            synchronized (componentConfigurationRegistry) {
                if (this.componentConfigurationsVersionMap == null) {
                    newMap = this.buildComponentConfigurationsVersionMap();
                    this.componentConfigurationsVersionMap = newMap;
                    this.unmodifiableComponentConfigurationsVersionMap = Collections.unmodifiableMap(this.componentConfigurationsVersionMap);
                }
            }
        }
        if (this.clientCompatibilityMap == null) {
            componentConfigurationRegistry = this;
            synchronized (componentConfigurationRegistry) {
                if (this.clientCompatibilityMap == null) {
                    newMap = this.buildClientCompatibilityMap();
                    this.clientCompatibilityMap = newMap;
                    this.unmodifiableClientCompatibilityMap = Collections.unmodifiableMap(this.clientCompatibilityMap);
                }
            }
        }
    }

    private HashMap<String, String> buildComponentConfigurationsVersionMap() {
        List<ComponentConfiguration> configs = this.getComponentConfigurations();
        int hashmapSize = configs.size() * 4 / 3 + 1;
        HashMap<String, String> map = new HashMap<String, String>(hashmapSize);
        for (ComponentConfiguration config : configs) {
            map.put(config.getId(), config.getVersion());
        }
        return map;
    }

    private HashMap<String, String> buildClientCompatibilityMap() {
        List<ComponentConfiguration> configs = this.getComponentConfigurations();
        int hashmapSize = configs.size() * 4 / 3 + 1;
        HashMap<String, String> map = new HashMap<String, String>(hashmapSize);
        for (ComponentConfiguration config : configs) {
            map.put(config.getId(), config.getClientCompatibilityVersion());
        }
        return map;
    }

    private static List<ComponentConfiguration> computeComponentConfigurations() {
        ArrayList<ComponentConfiguration> componentConfigs = new ArrayList<ComponentConfiguration>();
        IConfigurationElement[] elements = ComponentConfigurationRegistry.getComponentConfigurationDeclarations();
        int i = 0;
        while (i < elements.length) {
            String version;
            IConfigurationElement element = elements[i];
            String id = element.getAttribute("id");
            if (id != null && id.trim().length() > 0 && (version = element.getAttribute("version")) != null && version.trim().length() > 0) {
                if (id.indexOf(44) != -1 || id.indexOf(61) != -1 || version.indexOf(44) != -1 || version.indexOf(61) != -1) {
                    throw new IllegalArgumentException(NLS.bind("componentConfigurations id and version attribute values may not contain a comma or equal sign. id: {0} version: {1}", id, version));
                }
                String clientCompatibilityVersion = element.getAttribute("clientCompatibilityVersion");
                if (clientCompatibilityVersion == null || clientCompatibilityVersion.trim().length() == 0) {
                    clientCompatibilityVersion = "unspecified";
                }
                componentConfigs.add(new ComponentConfiguration(id, version, clientCompatibilityVersion));
            }
            ++i;
        }
        return componentConfigs;
    }

    private static IConfigurationElement[] getComponentConfigurationDeclarations() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.team.repository.common.componentConfigurations");
    }
}

