/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.Version;
import com.ibm.team.repository.common.internal.util.AbstractComponentChildElementDescriptor;
import com.ibm.team.repository.common.internal.util.EvolutionDescriptor;
import com.ibm.team.repository.common.internal.util.GeneralizedAttributeDescriptor;
import com.ibm.team.repository.common.internal.util.IModelElementDescriptor;
import com.ibm.team.repository.common.internal.util.VersionStringComparator;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryFactory;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

class ModelElementDescriptor
extends AbstractComponentChildElementDescriptor
implements IModelElementDescriptor {
    private static final String EVOLUTION_ELEMENT = "evolution";
    private static final String DTO_EVOLUTION_ELEMENT = "dtoEvolution";
    private static final String DTO_MODEL_ELEMENT = "dtoModel";
    private volatile SortedSet<EvolutionDescriptor> evolutions;
    private volatile Map<String, Map<String, IType>> generalizationDataCache;
    private static final VersionStringComparator vsComparator = new VersionStringComparator();
    private static String NULL_MARKER = "this is a special null marker";
    private volatile String originalVersion;
    private final ConcurrentMap<String, String> versionToVersionMap = new ConcurrentHashMap<String, String>(8, 0.75f, 2);
    private final ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, Boolean>>> attributeExistedInVersion = new ConcurrentHashMap<String, ConcurrentMap<String, ConcurrentMap<String, Boolean>>>(30, 0.75f, 2);
    private final ConcurrentMap<String, ConcurrentMap<String, String>> requiredClientUpgradeVersion = new ConcurrentHashMap<String, ConcurrentMap<String, String>>(10, 0.75f, 2);

    ModelElementDescriptor(IConfigurationElement element) {
        super(element, element.getName());
    }

    @Override
    protected void checkElement() {
        if (!DTO_MODEL_ELEMENT.equalsIgnoreCase(this.getElement().getName())) {
            this.checkNameAttribute();
            this.checkVersionAttribute();
        }
        this.checkUriAttribute();
    }

    @Override
    protected void processChild(IConfigurationElement child) {
        String name = child.getName();
        if (EVOLUTION_ELEMENT.equalsIgnoreCase(name) || DTO_EVOLUTION_ELEMENT.equalsIgnoreCase(name)) {
            this.processEvolutionElement(child);
        } else {
            super.processChild(child);
        }
    }

    private void processEvolutionElement(IConfigurationElement element) {
        EvolutionDescriptor desc = new EvolutionDescriptor(element);
        this.getEvolutions().add(desc);
        this.addGeneralizedDataToCache(desc);
    }

    private void addGeneralizedDataToCache(EvolutionDescriptor desc) {
        Map<String, Map<String, GeneralizedAttributeDescriptor>> gads = desc.getGeneralizedAttributeDescriptors();
        for (Map.Entry<String, Map<String, GeneralizedAttributeDescriptor>> entry : gads.entrySet()) {
            String className = entry.getKey();
            Map<String, IType> attribToTypes = this.getGeneralizationDataCache().get(className);
            if (attribToTypes == null) {
                attribToTypes = new HashMap<String, IType>(5);
                this.getGeneralizationDataCache().put(className, attribToTypes);
            }
            for (Map.Entry<String, GeneralizedAttributeDescriptor> inner : entry.getValue().entrySet()) {
                String attributeName = inner.getKey();
                if (attribToTypes.containsKey(attributeName)) {
                    throw new RuntimeException("Multiple generalize declarations on the same attribute not yet supported");
                }
                GeneralizedAttributeDescriptor gad = inner.getValue();
                String namespace = gad.getOldNamespace();
                String type = gad.getOldType();
                ItemType itemType = RepositoryFactory.eINSTANCE.createItemType();
                itemType.setNamespaceURI(namespace);
                itemType.setName(type);
                attribToTypes.put(attributeName, itemType);
            }
        }
    }

    private Map<String, Map<String, IType>> getGeneralizationDataCache() {
        return this.generalizationDataCache;
    }

    public String getOriginalVersionAttribute() {
        return this.originalVersion;
    }

    @Override
    public boolean hasAttributeEvolved(String className, String attribName) {
        for (EvolutionDescriptor evolutionDescriptor : this.getEvolutions()) {
            if (evolutionDescriptor.getNewAttribute(className, attribName) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTypeEvolved(String className) {
        for (EvolutionDescriptor evolutionDescriptor : this.getEvolutions()) {
            if (evolutionDescriptor.getNewType(className) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModelVersionForComponentVersion(String componentVersion) {
        String modelVersion = (String)this.versionToVersionMap.get(componentVersion);
        if (modelVersion != null) {
            return modelVersion.equals(NULL_MARKER) ? null : modelVersion;
        }
        Iterator iter = this.getEvolutions().iterator();
        VersionStringComparator c = vsComparator;
        while (iter.hasNext()) {
            EvolutionDescriptor entry = (EvolutionDescriptor)iter.next();
            if (c.compare(entry.getComponentVersion(), componentVersion) > 0) continue;
            modelVersion = entry.getModelVersion();
            break;
        }
        if (modelVersion == null) {
            modelVersion = this.getOriginalVersionAttribute();
        }
        this.versionToVersionMap.put(componentVersion, modelVersion == null ? NULL_MARKER : modelVersion);
        return modelVersion;
    }

    @Override
    public boolean attributeExistedInVersion(String className, String attributeName, String componentVersion) {
        Boolean existed;
        ConcurrentMap existing;
        ConcurrentMap<String, Boolean> attributeExistedMap;
        ConcurrentMap existing2;
        ConcurrentMap classAttributeMap = (ConcurrentHashMap)this.attributeExistedInVersion.get(componentVersion);
        if (classAttributeMap == null && (existing2 = (ConcurrentMap)this.attributeExistedInVersion.putIfAbsent(componentVersion, classAttributeMap = new ConcurrentHashMap(10, 0.75f, 2))) != null) {
            classAttributeMap = existing2;
        }
        if ((attributeExistedMap = (ConcurrentHashMap<String, Boolean>)classAttributeMap.get(className)) == null && (existing = (ConcurrentMap)classAttributeMap.putIfAbsent(className, attributeExistedMap = new ConcurrentHashMap<String, Boolean>(10, 0.75f, 2))) != null) {
            attributeExistedMap = existing;
        }
        if ((existed = (Boolean)attributeExistedMap.get(attributeName)) == null) {
            existed = this.computeAttributeExistedInVersion(className, attributeName, componentVersion);
            attributeExistedMap.put(attributeName, existed);
        }
        return existed;
    }

    private Boolean computeAttributeExistedInVersion(String className, String attributeName, String componentVersion) {
        VersionStringComparator c = vsComparator;
        for (EvolutionDescriptor desc : this.getEvolutions()) {
            if (c.compare(desc.getComponentVersion(), componentVersion) <= 0) {
                return Boolean.TRUE;
            }
            if (desc.getNewAttribute(className, attributeName) == null) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public boolean typeExistedInVersion(String className, String componentVersion) {
        Iterator iter = this.getEvolutions().iterator();
        VersionStringComparator c = vsComparator;
        while (iter.hasNext()) {
            EvolutionDescriptor desc = (EvolutionDescriptor)iter.next();
            if (c.compare(desc.getComponentVersion(), componentVersion) <= 0) {
                return true;
            }
            if (desc.getNewType(className) == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public String requiredClientUpgradeVersion(String className, String componentVersion) {
        String requiredVersion;
        ConcurrentMap existing;
        ConcurrentMap<String, String> typeComponentVersions = (ConcurrentHashMap<String, String>)this.requiredClientUpgradeVersion.get(componentVersion);
        if (typeComponentVersions == null && (existing = (ConcurrentMap)this.requiredClientUpgradeVersion.putIfAbsent(componentVersion, typeComponentVersions = new ConcurrentHashMap<String, String>(10, 0.75f, 2))) != null) {
            typeComponentVersions = existing;
        }
        if ((requiredVersion = (String)typeComponentVersions.get(className)) == null) {
            requiredVersion = this.computeRequiredClientUpgradeVersion(className, componentVersion);
            if (requiredVersion == null) {
                requiredVersion = NULL_MARKER;
            }
            typeComponentVersions.put(className, requiredVersion);
        }
        return requiredVersion.equals(NULL_MARKER) ? null : requiredVersion;
    }

    private String computeRequiredClientUpgradeVersion(String className, String componentVersion) {
        Iterator iter = this.getEvolutions().iterator();
        VersionStringComparator c = vsComparator;
        while (iter.hasNext()) {
            EvolutionDescriptor desc = (EvolutionDescriptor)iter.next();
            if (c.compare(desc.getComponentVersion(), componentVersion) <= 0) {
                return null;
            }
            if (desc.getNewType(className) == null) continue;
            return desc.getComponentVersion();
        }
        return null;
    }

    @Override
    public IType getNamespaceAndTypeBeforeAttributeWasGeneralized(String className, String attribName) {
        Map<String, IType> attrToType = this.getGeneralizationDataCache().get(className);
        if (attrToType == null) {
            return null;
        }
        return attrToType.get(attribName);
    }

    @Override
    public boolean isClientAndServerCompatible(String clientVersion, String serverVersion) {
        if (clientVersion.equals(serverVersion)) {
            return true;
        }
        for (EvolutionDescriptor desc : this.getEvolutions()) {
            if (desc.getModelVersion().equals(serverVersion)) {
                return true;
            }
            if (desc.isNonClientCompatibilityBreakingChange()) continue;
            return false;
        }
        return false;
    }

    private synchronized SortedSet<EvolutionDescriptor> getEvolutions() {
        return this.evolutions;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.originalVersion = this.getAttribute("originalVersion");
        this.generalizationDataCache = new HashMap<String, Map<String, IType>>(10);
        this.evolutions = new TreeSet<EvolutionDescriptor>(new EvolutionDescriptorComponentVersionComparator());
    }

    private static final class EvolutionDescriptorComponentVersionComparator
    implements Comparator<EvolutionDescriptor>,
    Serializable {
        private static final long serialVersionUID = -8130131474563839273L;

        private EvolutionDescriptorComponentVersionComparator() {
        }

        @Override
        public int compare(EvolutionDescriptor o1, EvolutionDescriptor o2) {
            if (o1 == o2) {
                return 0;
            }
            int componentDifference = this.compareVersions(o1.getComponentVersionVersion(), o2.getComponentVersionVersion());
            if (componentDifference != 0) {
                return componentDifference;
            }
            if (o1.isDtoEvolution()) {
                String msg = NLS.bind((String)"Found two dtoEvolution elements with the same componentVersion value in bundle {0}.", (Object)o1.getBundleSymbolicName());
                throw new IllegalStateException(msg);
            }
            return this.compareVersions(o1.getModelVersionVersion(), o2.getModelVersionVersion());
        }

        private int compareVersions(Version v1, Version v2) {
            return v2.compareTo(v1);
        }
    }
}

