/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.util.SettableSoftReference;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class MessageBundle
extends ResourceBundle {
    private static final SettableSoftReference<Map<String, MessageBundle>> cache = new SettableSoftReference(new HashMap());
    private final ResourceBundle bundle;
    private final ClassLoader classLoader;
    private final String bundleName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageBundle findBundle(Class<?> forClass) {
        MessageBundle srb;
        String forPackage = forClass.getPackage().getName();
        Map cacheMap = cache.get();
        if (cacheMap != null && (srb = cacheMap.get(forPackage)) != null) {
            return srb;
        }
        SettableSoftReference<Map<String, MessageBundle>> settableSoftReference = cache;
        synchronized (settableSoftReference) {
            int i;
            MessageBundle srb2;
            cacheMap = cache.get();
            if (cacheMap == null) {
                cacheMap = cache.set(new HashMap());
            }
            if ((srb2 = cacheMap.get(forPackage)) != null) {
                return srb2;
            }
            ClassLoader cl = forClass.getClassLoader();
            ResourceBundle rb = null;
            String bundleName = null;
            String p = forPackage;
            Locale locale = Locale.getDefault();
            bundleName = String.valueOf(p) + ".messages";
            rb = MessageBundle.getBundleSafe(bundleName, locale, cl);
            if (rb == null) {
                bundleName = String.valueOf(p) + ".nls.messages";
                rb = MessageBundle.getBundleSafe(bundleName, locale, cl);
            }
            if (rb == null && (i = p.lastIndexOf(46)) != -1) {
                bundleName = String.valueOf(p.substring(0, i)) + ".nls.messages";
                rb = MessageBundle.getBundleSafe(bundleName, locale, cl);
            }
            if (rb == null) {
                bundleName = String.valueOf(p) + ".internal.nls.messages";
                rb = MessageBundle.getBundleSafe(bundleName, locale, cl);
            }
            srb2 = new MessageBundle(cl, rb, bundleName);
            cacheMap.put(forPackage, srb2);
            return srb2;
        }
    }

    /*
     * Unable to fully structure code
     */
    public MessageBundle findBundle(Enumeration<Locale> locales) {
        if (this.bundle != null && locales != null) ** GOTO lbl9
        return this;
lbl-1000:
        // 1 sources

        {
            locale = locales.nextElement();
            if (Locale.getDefault().equals(locale)) {
                return this;
            }
            rb = MessageBundle.getBundleSafe(this.bundleName, locale, this.classLoader);
            if (rb == null) continue;
            return new MessageBundle(this.classLoader, rb, this.bundleName);
lbl9:
            // 2 sources

            ** while (locales.hasMoreElements())
        }
lbl10:
        // 1 sources

        return this;
    }

    private MessageBundle(ClassLoader classLoader, ResourceBundle bundle, String bundleName) {
        this.classLoader = classLoader;
        this.bundle = bundle;
        this.bundleName = bundleName;
    }

    public String getString(String key, Object ... args) {
        if (this.bundle == null) {
            return "{!!" + key + "}";
        }
        if (!this.containsKey(key)) {
            return "{!" + key + "}";
        }
        String s = this.bundle.getString(key);
        if (args.length > 0) {
            return MessageFormat.format(s, args);
        }
        return s;
    }

    private static ResourceBundle getBundleSafe(String name, Locale locale, ClassLoader cl) {
        try {
            return MessageBundle.getBundle(name, locale, cl);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.bundle == null ? false : this.bundle.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        if (this.bundle == null) {
            return Collections.emptySet();
        }
        return this.bundle.keySet();
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.bundle == null) {
            return new Vector(0).elements();
        }
        return this.bundle.getKeys();
    }

    @Override
    protected Object handleGetObject(String key) {
        if (this.bundle == null) {
            return "{!!" + key + "}";
        }
        if (!this.containsKey(key)) {
            return "{!" + key + "}";
        }
        return this.bundle.getObject(key);
    }
}

