/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoChangeSet;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoFileItem;
import com.ibm.team.connector.scm.client.JzRepoFolderItem;
import com.ibm.team.connector.scm.client.JzRepoResource;
import com.ibm.team.connector.scm.client.JzRepoSymbolicLinkVersion;
import com.ibm.team.connector.scm.client.JzRepoVersionHistory;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.internal.repository.rcp.util.StringCoder;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.WvcmException;

public abstract class JzRepoVersion
extends JzRepoResource {
    public static final String PNPREFIX_VERSION_ATTRIBUTE = "Version.Attribute.";
    public static final PropertyNameList.PropertyName<String> PN_ELEMENT_UNIVERSAL_SELECTOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "Element.UniversalSelector");
    public static final PropertyNameList.PropertyName<String> PN_BRTYPE_DISPLAYNAME = new PropertyNameList.PropertyName("com.ibm.team.interop", "BranchType.DisplayName");
    public static final PropertyNameList.PropertyName<String> PN_VERSION_NAME = new PropertyNameList.PropertyName("com.ibm.team.interop", "Version.Name");
    public static final PropertyNameList.PropertyName<String> PN_VERSION_UNIVERSAL_SELECTOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "Version.UniversalSelector");
    public static final PropertyNameList.PropertyName<String> PN_PRED_VER_UNIVERSAL_SELECTOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "Predecessor.Version.UniversalSelector");
    public static final PropertyNameList.PropertyName<String> PN_VERSION_ORIGINAL_CREATOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "Version.OriginalCreator");
    public static final PropertyNameList.PropertyName<String> PN_CHANGESET_COMMENT = new PropertyNameList.PropertyName("com.ibm.team.interop", "ChangesetComment");
    public static final PropertyNameList.PropertyName<String> PN_ACTIVITY_NAME = new PropertyNameList.PropertyName("com.ibm.team.interop", "Activity.Name");
    public static final PropertyNameList.PropertyName<String> PN_ORIGINAL_PREDECESSOR = new PropertyNameList.PropertyName("com.ibm.team.interop", "originalPredecessor");
    public static final PropertyNameList.PropertyName<String> PN_ORIGINAL_MERGE_PREDECESSORS = new PropertyNameList.PropertyName("com.ibm.team.interop", "originalMergePredecessors");
    public static final List<PropertyNameList.PropertyName<String>> ImporterCustomPropertyNames = Arrays.asList(PN_ELEMENT_UNIVERSAL_SELECTOR, PN_BRTYPE_DISPLAYNAME, PN_VERSION_NAME, PN_VERSION_UNIVERSAL_SELECTOR, PN_PRED_VER_UNIVERSAL_SELECTOR, PN_VERSION_ORIGINAL_CREATOR, PN_ACTIVITY_NAME);
    List<JzRepoVersion> predecessorList = null;
    JzRepoChangeSet csProxy = null;

    public JzRepoVersion(JzProvider provider, javax.wvcm.Location loc) {
        super(provider, loc);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            JzRepoVersionHistory vh = JzRepoVersionHistory.create(this.provider(), this.location().getComponentLocation(), (IVersionableHandle)this.getItemHandle(feedback));
            return vh;
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return new JzLocation(this.getBindingName(feedback));
        }
        if (propertyName.equals((Object)InteropUtilities.PN_SHA_256)) {
            IVersionable me = this.fetchCompleteState(feedback.nest(10));
            if (me instanceof IFileItem) {
                return this.computeSha256Digest((IFileItem)me, feedback);
            }
            super.getThisProperty(propertyName, configuration, feedback);
        } else {
            if (propertyName.equals((Object)Version.PREDECESSOR_LIST)) {
                return this.getPredecessorList(feedback);
            }
            if (propertyName.equals((Object)Version.ACTIVITY)) {
                return this.getActivity();
            }
            if (propertyName.equals((Object)Version.COMMENT)) {
                return this.getActivity().getThisProperty(propertyName, configuration, feedback);
            }
            if (propertyName.equals((Object)Resource.CREATION_DATE)) {
                return this.getActivity().getThisProperty(propertyName, configuration, feedback);
            }
            if (propertyName.equals((Object)InteropUtilities.PN_ATTRIBUTES)) {
                return this.getAttributes(feedback);
            }
            if (ImporterCustomPropertyNames.contains(propertyName)) {
                return this.lookupImporterCustomProperty(propertyName, feedback);
            }
            if (propertyName.toString().startsWith(new PropertyNameList.PropertyName("com.ibm.team.interop", PNPREFIX_VERSION_ATTRIBUTE).toString())) {
                String value = this.lookupImporterCustomProperty(propertyName, feedback);
                if (value != null) {
                    return value;
                }
            } else {
                if (propertyName.toString().startsWith(PN_VERSION_NAME.toString())) {
                    String value = this.lookupImporterCustomProperty(propertyName, feedback);
                    return value;
                }
                if (propertyName.toString().startsWith(PN_CHANGESET_COMMENT.toString())) {
                    String value = this.lookupImporterCustomProperty(propertyName, feedback);
                    return value;
                }
                if (propertyName.toString().startsWith(PN_BRTYPE_DISPLAYNAME.toString())) {
                    String value = this.lookupImporterCustomProperty(propertyName, feedback);
                    return value;
                }
                if (propertyName.toString().startsWith(PN_ACTIVITY_NAME.toString())) {
                    String value = this.lookupImporterCustomProperty(propertyName, feedback);
                    return value;
                }
                if (propertyName.toString().startsWith(PN_VERSION_ORIGINAL_CREATOR.toString())) {
                    String value = this.lookupImporterCustomProperty(propertyName, feedback);
                    return value;
                }
                if (propertyName.toString().startsWith(PN_ORIGINAL_PREDECESSOR.toString())) {
                    String value = this.lookupImporterCustomProperty(propertyName, feedback);
                    return value;
                }
                if (propertyName.toString().startsWith(PN_ORIGINAL_MERGE_PREDECESSORS.toString())) {
                    String value = this.lookupImporterCustomProperty(propertyName, feedback);
                    return value;
                }
            }
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    private String lookupImporterCustomProperty(PropertyNameList.PropertyName<?> propertyName, SrvcFeedback feedback) throws WvcmException {
        IVersionable me = this.fetchCompleteState(feedback.nest(10));
        String index = propertyName.toString();
        Map userProperties = me.getUserProperties();
        String result = (String)userProperties.get(index);
        return result;
    }

    private Map<String, String> getAttributes(SrvcFeedback feedback) throws WvcmException {
        IVersionable me = this.fetchCompleteState(feedback.nest(10));
        Map userProperties = me.getUserProperties();
        HashMap<String, String> result = new HashMap<String, String>();
        if (userProperties != null) {
            String attrPrefix = new PropertyNameList.PropertyName("com.ibm.team.interop", PNPREFIX_VERSION_ATTRIBUTE).toString();
            for (String key : userProperties.keySet()) {
                if (!key.startsWith(attrPrefix)) continue;
                result.put(key, (String)userProperties.get(key));
            }
        }
        return result;
    }

    private List<JzRepoVersion> getPredecessorList(SrvcFeedback feedback) throws WvcmException {
        if (this.predecessorList == null) {
            throw new IllegalStateException("cannot return predecessor list.  It must be computed by other operations first");
        }
        return this.predecessorList;
    }

    boolean hasPredecessorListValue() {
        return this.predecessorList != null;
    }

    void setPredecessorListValue(List<JzRepoVersion> preds) {
        this.predecessorList = preds;
    }

    void addPredecessorValue(JzRepoVersion pred, boolean isMergeParent) {
        if (this.predecessorList == null) {
            this.predecessorList = new ArrayList<JzRepoVersion>();
        }
        if (isMergeParent || this.predecessorList.isEmpty()) {
            this.predecessorList.add(pred);
        } else {
            this.predecessorList.add(0, pred);
        }
    }

    public JzRepoChangeSet getActivity() {
        return this.csProxy;
    }

    public void setActivityValue(JzRepoChangeSet csProxy) {
        this.csProxy = csProxy;
    }

    private Object computeSha256Digest(IFileItem me, SrvcFeedback f) {
        IFileItem fileItem = me;
        ContentHash hash = fileItem.getContent().getHash();
        byte[] digestBytes = StringCoder.decode((String)hash.toString());
        int length = digestBytes.length;
        Byte[] result = new Byte[length];
        int i = 0;
        while (i < length) {
            result[i] = digestBytes[i];
            ++i;
        }
        return result;
    }

    protected JzRepoVersionHistory getParentVersionHistory(SrvcFeedback feedback) throws WvcmException {
        IFolderHandle parentHandle = this.fetchCompleteState(feedback).getParent();
        JzLocation compLoc = this.location().getComponentLocation();
        JzLocation resultLoc = compLoc.createVersionHistoryLocation(JzRepoVersion.getCurrentStateDisplayName((IItemHandle)parentHandle));
        JzRepoVersionHistory result = new JzRepoVersionHistory(this.provider(), (javax.wvcm.Location)resultLoc);
        result.setItemHandle((IItemHandle)parentHandle);
        return result;
    }

    public IVersionable fetchCompleteState(SrvcFeedback feedback) throws WvcmException {
        return JzRepoVersion.fetchCompleteState(this.provider(), (IVersionableHandle)this.getItemHandle(feedback), feedback);
    }

    public static IVersionable fetchCompleteState(JzProvider p, IVersionableHandle versionableHandle, SrvcFeedback feedback) throws WvcmException {
        return JzRepoVersion.fetchCompleteStates(p, Collections.singletonList(versionableHandle), feedback).get(0);
    }

    public static List<IVersionable> fetchCompleteStates(JzProvider p, List<IVersionableHandle> versionableHandles, SrvcFeedback feedback) throws WvcmException {
        int inputCount = versionableHandles.size();
        try {
            List results = p.getWorkspaceManager().versionableManager().fetchCompleteStates(versionableHandles, JzProvider.getMonitor(feedback, 100));
            int i = 0;
            while (i < inputCount) {
                IVersionable result = (IVersionable)results.get(i);
                if (result == null) {
                    result = JzRepoVersion.fetchCompleteStateInternal(p, versionableHandles.get(i), feedback);
                    results.set(i, result);
                }
                ++i;
            }
            return results;
        }
        catch (TeamRepositoryException e) {
            String itemLocString = inputCount == 1 ? Location.stateLocation((IItemHandle)((IItemHandle)versionableHandles.get(0)), null).toString() : "{various}";
            String msg = NLS.bind((String)Messages.JzRepoVersion_ERROR_CANT_FETCH_VERSIONABLE_STATE, (Object)itemLocString, (Object[])new Object[]{e.getMessage()});
            WvcmException wrapped = new WvcmException(msg, null, JzRepoResource.exceptionToReasonCode(e), (Throwable)e);
            throw wrapped;
        }
    }

    private static IVersionable fetchCompleteStateInternal(JzProvider p, IVersionableHandle vh, SrvcFeedback feedback) throws WvcmException {
        try {
            IVersionable result = p.getWorkspaceManager().versionableManager().fetchCompleteState(vh, JzProvider.getMonitor(feedback, 100));
            return result;
        }
        catch (PermissionDeniedException e) {
            String itemLocString = Location.stateLocation((IItemHandle)vh, null).toString();
            String msg = NLS.bind((String)Messages.JzRepoVersion_ERROR_PERMISSION_DENIED, (Object)itemLocString, (Object[])new Object[0]);
            String msgWithExplanationAndUserAction = NLS.bind((String)Messages.JzProvider_msgAndExplanationAndUserAction, (Object)msg, (Object[])new Object[]{Messages.JzRepoVersion_ERROR_PERMISSION_DENIED$explanation, Messages.JzRepoVersion_ERROR_PERMISSION_DENIED$useraction});
            WvcmException wrapped = new WvcmException(msgWithExplanationAndUserAction, null, JzRepoResource.exceptionToReasonCode(e), (Throwable)e);
            throw wrapped;
        }
        catch (TeamRepositoryException e) {
            String itemLocString = Location.stateLocation((IItemHandle)vh, null).toString();
            String msg = NLS.bind((String)Messages.JzRepoVersion_ERROR_CANT_FETCH_VERSIONABLE_STATE, (Object)itemLocString, (Object[])new Object[]{e.getMessage()});
            WvcmException wrapped = new WvcmException(msg, null, JzRepoResource.exceptionToReasonCode(e), (Throwable)e);
            throw wrapped;
        }
    }

    protected String getBindingName(SrvcFeedback feedback) throws WvcmException {
        IVersionable me = this.fetchCompleteState(feedback);
        String result = me.getName();
        return result;
    }

    public static boolean isSymbolicLink(JzProvider provider, IVersionableHandle versionableHandle, SrvcFeedback feedback) throws WvcmException {
        IFileItem versionable = (IFileItem)JzRepoVersion.fetchCompleteState(provider, versionableHandle, feedback);
        return versionable.getContentType().equals("text/symblink");
    }

    public static JzRepoVersion createAppropriateProxy(JzProvider provider, JzLocation resultLoc, IItemHandle myItemHandle, SrvcFeedback feedback) throws WvcmException {
        JzRepoVersion result = null;
        boolean symbolicLinksSupported = "true".equalsIgnoreCase(provider.getSymlinksSupported());
        if (symbolicLinksSupported) {
            result = myItemHandle.getItemType().equals(IFileItem.ITEM_TYPE) ? (JzRepoVersion.isSymbolicLink(provider, (IVersionableHandle)myItemHandle, feedback) ? new JzRepoSymbolicLinkVersion(provider, (javax.wvcm.Location)resultLoc) : new JzRepoFileItem(provider, (javax.wvcm.Location)resultLoc)) : (myItemHandle.getItemType().equals(ISymbolicLink.ITEM_TYPE) ? new JzRepoSymbolicLinkVersion(provider, (javax.wvcm.Location)resultLoc) : new JzRepoFolderItem(provider, (javax.wvcm.Location)resultLoc));
        } else if (myItemHandle.getItemType().equals(IFileItem.ITEM_TYPE)) {
            result = JzRepoVersion.isSymbolicLink(provider, (IVersionableHandle)myItemHandle, feedback) ? new JzRepoSymbolicLinkVersion(provider, (javax.wvcm.Location)resultLoc) : new JzRepoFileItem(provider, (javax.wvcm.Location)resultLoc);
        } else {
            if (myItemHandle.getItemType().equals(ISymbolicLink.ITEM_TYPE)) {
                throw new WvcmException(Messages.JzRepoVersion_ERROR_UNSUPPORTED_JAZZ_SYMLINK_ENCOUNTERED, null, WvcmException.ReasonCode.FORBIDDEN);
            }
            result = new JzRepoFolderItem(provider, (javax.wvcm.Location)resultLoc);
        }
        result.setItemHandle(myItemHandle);
        return result;
    }

    public IFolderHandle getParentFolderHandle(SrvcFeedback feedback) throws WvcmException {
        return this.fetchCompleteState(feedback).getParent();
    }

    public JzRepoComponent getJzRepoComponent(SrvcFeedback feedback) throws WvcmException {
        JzRepoComponent result = (JzRepoComponent)this.provider().get((javax.wvcm.Location)this.location().getComponentLocation(), feedback);
        return result;
    }

    public IVersionable getWorkingCopy(SrvcFeedback feedback) throws WvcmException {
        return (IVersionable)this.fetchCompleteState(feedback).getWorkingCopy();
    }
}

