/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.workitems.internal;

import com.ibm.team.foundation.rcp.core.IModelAccessor;
import com.ibm.team.links.client.ILinkManager;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.ILinkCollection;
import com.ibm.team.links.common.ILinkQueryPage;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IFetchResult;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.SubMonitor;

public class LocateChangeSetsUtil {
    public static final String PARENT_WORKITEM_LINKTYPE_ID = "com.ibm.team.workitem.linktype.parentworkitem";
    public static final int UNBOUNDED = -1;

    public static LcsEditorChangeSetsResult getLcsEditorChangeSets(ParmsGetLcsEditorChangeSets parms, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (parms == null) {
            throw new IllegalArgumentException();
        }
        if (parms.repo == null) {
            throw new IllegalArgumentException();
        }
        if (parms.maxChildWorkItemsDepth < 0 && parms.maxChildWorkItemsDepth != -1 || parms.maxWorkItems < 0 && parms.maxWorkItems != -1 || parms.maxChangeSets < 0 && parms.maxChangeSets != -1) {
            throw new IllegalArgumentException();
        }
        ITeamRepository repo = parms.repo;
        LcsEditorChangeSetsResult result = new LcsEditorChangeSetsResult();
        List<LcsEditorChangeSetEntry> changeSetRoots = Collections.EMPTY_LIST;
        if (parms.changeSets != null) {
            changeSetRoots = LocateChangeSetsUtil.createChangeSetEntries(repo, parms.changeSets, true, (IProgressMonitor)progress.newChild(10));
        }
        progress.setWorkRemaining(90);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        List<LcsEditorWorkItemEntry> workItemRoots1 = Collections.EMPTY_LIST;
        if (parms.workItems != null) {
            workItemRoots1 = LocateChangeSetsUtil.createWorkItemEntries(repo, parms.workItems, true, (IProgressMonitor)progress.newChild(10));
        }
        progress.setWorkRemaining(80);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ChangeSetsParentWorkItemsResult parentsResult = LocateChangeSetsUtil.fetchChangeSetsParentWorkItems(repo, changeSetRoots, (IProgressMonitor)progress.newChild(10));
        result.unassignedRoot = parentsResult.unassignedParent;
        List<LcsEditorWorkItemEntry> workItemRoots2 = parentsResult.parents;
        List<LcsEditorWorkItemEntry> workItemRoots = LocateChangeSetsUtil.mergeWorkItemEntries(workItemRoots2, workItemRoots1);
        result.args = parms;
        result.workItemRoots = workItemRoots;
        int depth = 0;
        List<LcsEditorWorkItemEntry> parents = workItemRoots;
        int workItemsCount = parents.size();
        int changeSetsCount = 0;
        SubMonitor loopProgress = progress.newChild(70).setWorkRemaining(parents.size() * 2);
        while (parents.size() > 0) {
            if (loopProgress.isCanceled()) {
                throw new OperationCanceledException();
            }
            List<LcsEditorChangeSetEntry> csEntries = LocateChangeSetsUtil.fetchWorkItemChangeSets(repo, parents, (IProgressMonitor)loopProgress.newChild(1));
            if (depth == 0 && parms.changeSets != null) {
                LocateChangeSetsUtil.setChecked(csEntries, parms.changeSets);
            }
            if (parms.maxChangeSets != -1 && (changeSetsCount += csEntries.size()) > parms.maxChangeSets) {
                result.maxChangeSetsTooSmall = true;
                break;
            }
            if (parms.maxChildWorkItemsDepth == -1 || depth < parms.maxChildWorkItemsDepth) {
                parents = LocateChangeSetsUtil.fetchWorkItemChildren(repo, parents, (IProgressMonitor)loopProgress.newChild(1));
                if (parms.maxWorkItems != -1 && (workItemsCount += parents.size()) > parms.maxWorkItems) {
                    result.maxWorkItemsTooSmall = true;
                    break;
                }
            } else {
                parents = new ArrayList<LcsEditorWorkItemEntry>();
            }
            if (depth == parms.maxChildWorkItemsDepth || parms.maxChildWorkItemsDepth == -1 && parents.size() == 0) {
                if (parents.size() <= 0) break;
                result.maxChildWorkItemsDepthTooSmall = true;
                break;
            }
            ++depth;
        }
        loopProgress.done();
        progress.done();
        return result;
    }

    private static List<LcsEditorWorkItemEntry> fetchWorkItemChildren(ITeamRepository repo, List<LcsEditorWorkItemEntry> parents, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILinkManager linkManager = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
        ArrayList<LcsEditorWorkItemEntry> result = new ArrayList<LcsEditorWorkItemEntry>();
        int count = parents.size();
        IReference[] workItemReferences = new IReference[count];
        int i = 0;
        HashMap<UUID, LcsEditorWorkItemEntry> map = new HashMap<UUID, LcsEditorWorkItemEntry>();
        for (LcsEditorWorkItemEntry entry : parents) {
            IWorkItem wi = entry.fWorkItem;
            IItemReference ref = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)wi);
            workItemReferences[i] = ref;
            map.put(wi.getItemId(), entry);
            ++i;
        }
        if (workItemReferences.length > 0) {
            ILinkQueryPage queryPage = linkManager.findLinksByTarget(new String[]{PARENT_WORKITEM_LINKTYPE_ID}, workItemReferences, (IProgressMonitor)progress.newChild(50));
            ILinkCollection linkCollection = queryPage.getAllLinksFromHereOn();
            SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(linkCollection.size());
            for (ILink link : linkCollection) {
                IItemReference itemReference;
                IItemHandle itemHandle;
                if (loopProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IReference ref = link.getSourceRef();
                if (!ref.isItemReference() || !((itemHandle = (itemReference = (IItemReference)ref).getReferencedItem()) instanceof IWorkItemHandle)) continue;
                IWorkItemHandle wiSourceHandle = (IWorkItemHandle)itemHandle;
                ref = link.getTargetRef();
                if (!ref.isItemReference() || !((itemHandle = (itemReference = (IItemReference)ref).getReferencedItem()) instanceof IWorkItemHandle)) continue;
                IWorkItemHandle wiTargetHandle = (IWorkItemHandle)itemHandle;
                IWorkItem wiSource = (IWorkItem)repo.itemManager().fetchCompleteItem((IItemHandle)wiSourceHandle, 0, (IProgressMonitor)loopProgress.newChild(1));
                LcsEditorWorkItemEntry wiParentEntry = (LcsEditorWorkItemEntry)((Object)map.get(wiTargetHandle.getItemId()));
                if (wiParentEntry == null) continue;
                LcsEditorWorkItemEntry wiChildEntry = new LcsEditorWorkItemEntry(repo, wiSource, wiParentEntry, new ArrayList<LcsEditorEntry>(), wiParentEntry.isChecked());
                wiParentEntry.getChildren().add(wiChildEntry);
                result.add(wiChildEntry);
            }
            loopProgress.done();
        }
        progress.done();
        return result;
    }

    private static List<LcsEditorChangeSetEntry> fetchWorkItemChangeSets(ITeamRepository repo, List<LcsEditorWorkItemEntry> parents, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILinkManager linkManager = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
        ArrayList<LcsEditorChangeSetEntry> result = new ArrayList<LcsEditorChangeSetEntry>();
        int count = parents.size();
        IReference[] workItemReferences = new IReference[count];
        int i = 0;
        HashMap<UUID, LcsEditorWorkItemEntry> map = new HashMap<UUID, LcsEditorWorkItemEntry>();
        for (LcsEditorWorkItemEntry entry : parents) {
            IWorkItem wi = entry.fWorkItem;
            IItemReference ref = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)wi);
            workItemReferences[i] = ref;
            map.put(wi.getItemId(), entry);
            ++i;
        }
        if (workItemReferences.length > 0) {
            ILinkQueryPage queryPage = linkManager.findLinksByTarget(new String[]{"com.ibm.team.filesystem.workitems.change_set"}, workItemReferences, (IProgressMonitor)progress.newChild(50));
            ILinkCollection linkCollection = queryPage.getAllLinksFromHereOn();
            SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(linkCollection.size());
            for (ILink link : linkCollection) {
                IItemReference itemReference;
                IItemHandle itemHandle;
                IReference ref = link.getSourceRef();
                if (!ref.isItemReference() || !((itemHandle = (itemReference = (IItemReference)ref).getReferencedItem()) instanceof IChangeSetHandle)) continue;
                IChangeSetHandle csHandle = (IChangeSetHandle)itemHandle;
                ref = link.getTargetRef();
                if (!ref.isItemReference() || !((itemHandle = (itemReference = (IItemReference)ref).getReferencedItem()) instanceof IWorkItemHandle)) continue;
                IWorkItemHandle wiTargetHandle = (IWorkItemHandle)itemHandle;
                IChangeSet csSource = null;
                try {
                    csSource = (IChangeSet)repo.itemManager().fetchCompleteItem((IItemHandle)csHandle, 0, (IProgressMonitor)loopProgress.newChild(1));
                }
                catch (PermissionDeniedException permissionDeniedException) {
                    continue;
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    continue;
                }
                LcsEditorWorkItemEntry wiParentEntry = (LcsEditorWorkItemEntry)((Object)map.get(wiTargetHandle.getItemId()));
                if (wiParentEntry == null) continue;
                LcsEditorChangeSetEntry csChildEntry = new LcsEditorChangeSetEntry(repo, csSource, wiParentEntry, Collections.EMPTY_LIST, wiParentEntry.isChecked());
                wiParentEntry.getChildren().add(csChildEntry);
                result.add(csChildEntry);
            }
            loopProgress.done();
        }
        progress.done();
        return result;
    }

    private static ChangeSetsParentWorkItemsResult fetchChangeSetsParentWorkItems(ITeamRepository repo, List<LcsEditorChangeSetEntry> entries, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ILinkManager linkManager = (ILinkManager)repo.getClientLibrary(ILinkManager.class);
        ChangeSetsParentWorkItemsResult result = new ChangeSetsParentWorkItemsResult();
        result.parents = new ArrayList<LcsEditorWorkItemEntry>();
        LcsEditorUnassignedWorkItemEntry unassignedParent = new LcsEditorUnassignedWorkItemEntry();
        unassignedParent.setChildren(new ArrayList<LcsEditorEntry>());
        unassignedParent.setChecked(false);
        unassignedParent.setParent(null);
        unassignedParent.setRepository(repo);
        int count = entries.size();
        IReference[] changeSetReferences = new IReference[count];
        int i = 0;
        HashMap<UUID, LcsEditorChangeSetEntry> map = new HashMap<UUID, LcsEditorChangeSetEntry>();
        for (LcsEditorChangeSetEntry entry : entries) {
            IChangeSet cs = entry.fChangeSet;
            IItemReference ref = IReferenceFactory.INSTANCE.createReferenceToItem((IItemHandle)cs);
            changeSetReferences[i] = ref;
            map.put(cs.getItemId(), entry);
            ++i;
        }
        HashSet<UUID> changeSetsWithParents = new HashSet<UUID>();
        if (changeSetReferences.length > 0) {
            ILinkQueryPage queryPage = linkManager.findLinksBySource(new String[]{"com.ibm.team.filesystem.workitems.change_set"}, changeSetReferences, (IProgressMonitor)progress.newChild(50));
            ILinkCollection linkCollection = queryPage.getAllLinksFromHereOn();
            SubMonitor loopProgress = progress.newChild(50).setWorkRemaining(linkCollection.size());
            for (ILink link : linkCollection) {
                IItemReference itemReference;
                IItemHandle itemHandle;
                if (loopProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IReference ref = link.getSourceRef();
                if (!ref.isItemReference() || !((itemHandle = (itemReference = (IItemReference)ref).getReferencedItem()) instanceof IChangeSetHandle)) continue;
                IChangeSetHandle csHandle = (IChangeSetHandle)itemHandle;
                ref = link.getTargetRef();
                if (!ref.isItemReference() || !((itemHandle = (itemReference = (IItemReference)ref).getReferencedItem()) instanceof IWorkItemHandle)) continue;
                IWorkItem wi = (IWorkItem)repo.itemManager().fetchCompleteItem(itemHandle, 0, (IProgressMonitor)loopProgress.newChild(1));
                LcsEditorChangeSetEntry csEntry = (LcsEditorChangeSetEntry)((Object)map.get(csHandle.getItemId()));
                if (csEntry == null) continue;
                LcsEditorWorkItemEntry wiParentEntry = new LcsEditorWorkItemEntry(repo, wi, null, new ArrayList<LcsEditorEntry>(), false);
                result.parents.add(wiParentEntry);
                changeSetsWithParents.add(csHandle.getItemId());
            }
            loopProgress.done();
        }
        progress.done();
        for (LcsEditorChangeSetEntry entry : entries) {
            if (changeSetsWithParents.contains(entry.fChangeSet.getItemId())) continue;
            unassignedParent.getChildren().add(entry);
            entry.setParent(unassignedParent);
        }
        if (unassignedParent.getChildren().size() > 0) {
            result.unassignedParent = unassignedParent;
        }
        return result;
    }

    private static List<LcsEditorWorkItemEntry> createWorkItemEntries(ITeamRepository repo, List<IWorkItemHandle> workItems, boolean isChecked, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<LcsEditorWorkItemEntry> result = new ArrayList<LcsEditorWorkItemEntry>();
        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(workItems, 0, monitor);
        if (fetchResult != null && fetchResult.getRetrievedItems() != null) {
            for (Object item : fetchResult.getRetrievedItems()) {
                if (!(item instanceof IWorkItem)) continue;
                IWorkItem wi = (IWorkItem)item;
                result.add(new LcsEditorWorkItemEntry(repo, wi, null, new ArrayList<LcsEditorEntry>(), isChecked));
            }
        }
        return result;
    }

    private static List<LcsEditorChangeSetEntry> createChangeSetEntries(ITeamRepository repo, List<IChangeSetHandle> changeSets, boolean isChecked, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<LcsEditorChangeSetEntry> result = new ArrayList<LcsEditorChangeSetEntry>();
        IFetchResult fetchResult = repo.itemManager().fetchCompleteItemsPermissionAware(changeSets, 0, monitor);
        if (fetchResult != null && fetchResult.getRetrievedItems() != null) {
            for (Object item : fetchResult.getRetrievedItems()) {
                if (!(item instanceof IChangeSet)) continue;
                IChangeSet cs = (IChangeSet)item;
                result.add(new LcsEditorChangeSetEntry(repo, cs, null, Collections.<LcsEditorEntry>emptyList(), isChecked));
            }
        }
        return result;
    }

    private static Map<UUID, LcsEditorWorkItemEntry> createMap(List<LcsEditorWorkItemEntry> entries) {
        HashMap<UUID, LcsEditorWorkItemEntry> result = new HashMap<UUID, LcsEditorWorkItemEntry>();
        for (LcsEditorWorkItemEntry entry : entries) {
            result.put(entry.fWorkItem.getItemId(), entry);
        }
        return result;
    }

    private static List<LcsEditorWorkItemEntry> mergeWorkItemEntries(List<LcsEditorWorkItemEntry> main, List<LcsEditorWorkItemEntry> additions) {
        Map<UUID, LcsEditorWorkItemEntry> workItemsMap = LocateChangeSetsUtil.createMap(main);
        for (LcsEditorWorkItemEntry entry : additions) {
            if (workItemsMap.containsKey(entry.fWorkItem.getItemId())) continue;
            workItemsMap.put(entry.fWorkItem.getItemId(), entry);
        }
        return new ArrayList<LcsEditorWorkItemEntry>(workItemsMap.values());
    }

    private static void setChecked(List<LcsEditorChangeSetEntry> entries, List<IChangeSetHandle> changeSets) {
        HashSet<UUID> uuids = new HashSet<UUID>();
        for (IChangeSetHandle cs : changeSets) {
            uuids.add(cs.getItemId());
        }
        for (LcsEditorChangeSetEntry entry : entries) {
            if (!uuids.contains(entry.fChangeSet.getItemId())) continue;
            entry.setChecked(true);
        }
    }

    public static class ChangeSetsParentWorkItemsResult {
        List<LcsEditorWorkItemEntry> parents;
        LcsEditorUnassignedWorkItemEntry unassignedParent;
    }

    public static class LcsEditorChangeSetEntry
    extends LcsEditorEntry {
        private IChangeSet fChangeSet;

        public LcsEditorChangeSetEntry(ITeamRepository repo, IChangeSet changeSet, LcsEditorEntry parent, Collection<LcsEditorEntry> children, boolean isChecked) {
            this.fChangeSet = changeSet;
            this.setRepository(repo);
            this.setParent(parent);
            this.setChildren(children);
            this.setChecked(isChecked);
        }

        public IChangeSet getChangeSet() {
            return this.fChangeSet;
        }

        public Object getModelInstance() {
            return this.fChangeSet;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IChangeSet.class) {
                return this.fChangeSet;
            }
            if (adapter == IItemHandle.class) {
                return this.fChangeSet;
            }
            return super.getAdapter(adapter);
        }

        @Override
        public boolean isEquivalentTo(Object other) {
            boolean equivalent = true;
            if (!(other instanceof LcsEditorChangeSetEntry)) {
                equivalent = false;
            } else {
                LcsEditorChangeSetEntry otherChangeSet = (LcsEditorChangeSetEntry)((Object)other);
                if (!otherChangeSet.getRepository().equals(this.getRepository())) {
                    equivalent = false;
                }
                if (!otherChangeSet.fChangeSet.equals((Object)this.fChangeSet)) {
                    equivalent = false;
                }
                if (otherChangeSet.getParent() == null && this.getParent() != null || otherChangeSet.getParent() != null && this.getParent() == null) {
                    equivalent = false;
                }
                if (otherChangeSet.getParent() != null && this.getParent() != null && !((Object)((Object)otherChangeSet.getParent())).equals((Object)this.getParent())) {
                    equivalent = false;
                }
            }
            return equivalent;
        }
    }

    public static class LcsEditorChangeSetsResult {
        private Collection<LcsEditorWorkItemEntry> workItemRoots;
        private LcsEditorUnassignedWorkItemEntry unassignedRoot;
        private boolean maxChildWorkItemsDepthTooSmall;
        private boolean maxWorkItemsTooSmall;
        private boolean maxChangeSetsTooSmall;
        private ParmsGetLcsEditorChangeSets args;

        public Collection<LcsEditorWorkItemEntry> getRoots() {
            return this.workItemRoots;
        }

        public void setRoots(Collection<LcsEditorWorkItemEntry> workItemRoots) {
            this.workItemRoots = workItemRoots == null ? Collections.EMPTY_LIST : workItemRoots;
        }

        public LcsEditorUnassignedWorkItemEntry getUnassignedRoot() {
            return this.unassignedRoot;
        }

        public void setUnassignedRoot(LcsEditorUnassignedWorkItemEntry unassignedRoot) {
            this.unassignedRoot = unassignedRoot;
        }

        public boolean isMaxChildWorkItemsDepthTooSmall() {
            return this.maxChildWorkItemsDepthTooSmall;
        }

        public void setMaxChildWorkItemsDepthTooSmall(boolean maxChildWorkItemsDepthTooSmall) {
            this.maxChildWorkItemsDepthTooSmall = maxChildWorkItemsDepthTooSmall;
        }

        public boolean isMaxWorkItemsTooSmall() {
            return this.maxWorkItemsTooSmall;
        }

        public void setMaxWorkItemsTooSmall(boolean maxWorkItemsTooSmall) {
            this.maxWorkItemsTooSmall = maxWorkItemsTooSmall;
        }

        public boolean isMaxChangeSetsTooSmall() {
            return this.maxChangeSetsTooSmall;
        }

        public void setMaxChangeSetsTooSmall(boolean maxChangeSetsTooSmall) {
            this.maxChangeSetsTooSmall = maxChangeSetsTooSmall;
        }

        public ParmsGetLcsEditorChangeSets getArgs() {
            return this.args;
        }

        public void setArgs(ParmsGetLcsEditorChangeSets args) {
            this.args = args;
        }
    }

    public static abstract class LcsEditorEntry
    extends PlatformObject
    implements IModelAccessor,
    IAdaptable {
        private volatile ITeamRepository fRepo;
        private volatile LcsEditorEntry fParent;
        private volatile Collection<LcsEditorEntry> fChildren;
        private volatile boolean fIsChecked;

        public ITeamRepository getRepository() {
            return this.fRepo;
        }

        public void setRepository(ITeamRepository repo) {
            this.fRepo = repo;
        }

        public LcsEditorEntry getParent() {
            return this.fParent;
        }

        public void setParent(LcsEditorEntry parent) {
            this.fParent = parent;
        }

        public Collection<LcsEditorEntry> getChildren() {
            return this.fChildren;
        }

        public void setChildren(Collection<LcsEditorEntry> children) {
            this.fChildren = children == null ? Collections.emptyList() : children;
        }

        public boolean isChecked() {
            return this.fIsChecked;
        }

        public void setChecked(boolean isChecked) {
            this.fIsChecked = isChecked;
        }

        public abstract boolean isEquivalentTo(Object var1);
    }

    public static class LcsEditorUnassignedWorkItemEntry
    extends LcsEditorEntry {
        @Override
        public boolean isEquivalentTo(Object other) {
            boolean equivalent = true;
            if (!(other instanceof LcsEditorUnassignedWorkItemEntry)) {
                equivalent = false;
            } else {
                LcsEditorUnassignedWorkItemEntry otherChangeSet = (LcsEditorUnassignedWorkItemEntry)((Object)other);
                if (!otherChangeSet.getRepository().equals(this.getRepository())) {
                    equivalent = false;
                }
                if (otherChangeSet.getParent() == null && this.getParent() != null || otherChangeSet.getParent() != null && this.getParent() == null) {
                    equivalent = false;
                }
                if (otherChangeSet.getParent() != null && this.getParent() != null && !((Object)((Object)otherChangeSet.getParent())).equals((Object)this.getParent())) {
                    equivalent = false;
                }
            }
            return equivalent;
        }

        public Object getModelInstance() {
            return null;
        }
    }

    public static class LcsEditorWorkItemEntry
    extends LcsEditorEntry {
        private IWorkItem fWorkItem;

        public LcsEditorWorkItemEntry(ITeamRepository repo, IWorkItem workItem, LcsEditorEntry parent, Collection<LcsEditorEntry> children, boolean isChecked) {
            this.fWorkItem = workItem;
            this.setRepository(repo);
            this.setParent(parent);
            this.setChildren(children);
            this.setChecked(isChecked);
        }

        public IWorkItem getWorkItem() {
            return this.fWorkItem;
        }

        public Object getModelInstance() {
            return this.fWorkItem;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IWorkItem.class) {
                return this.fWorkItem;
            }
            if (adapter == IWorkItemHandle.class) {
                return (IWorkItemHandle)this.fWorkItem.getItemHandle();
            }
            if (adapter == IItemHandle.class) {
                return this.fWorkItem.getItemHandle();
            }
            return null;
        }

        @Override
        public boolean isEquivalentTo(Object other) {
            boolean equivalent = true;
            if (!(other instanceof LcsEditorWorkItemEntry)) {
                equivalent = false;
            } else {
                LcsEditorWorkItemEntry otherWorkItem = (LcsEditorWorkItemEntry)((Object)other);
                if (!otherWorkItem.getRepository().equals(this.getRepository())) {
                    equivalent = false;
                }
                if (!otherWorkItem.fWorkItem.equals((Object)this.fWorkItem)) {
                    equivalent = false;
                }
                if (otherWorkItem.getParent() == null && this.getParent() != null || otherWorkItem.getParent() != null && this.getParent() == null) {
                    equivalent = false;
                }
                if (otherWorkItem.getParent() != null && this.getParent() != null && !((Object)((Object)otherWorkItem.getParent())).equals((Object)this.getParent())) {
                    equivalent = false;
                }
            }
            return equivalent;
        }
    }

    public static class ParmsGetLcsEditorChangeSets {
        public ITeamRepository repo;
        public int maxChildWorkItemsDepth;
        public int maxWorkItems;
        public int maxChangeSets;
        public List<IWorkItemHandle> workItems;
        public List<IChangeSetHandle> changeSets;
    }
}

