/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.queryast.util;

import java.util.ArrayList;
import java.util.List;

public class StringReader {
    protected Object lock = this;
    private String str = "";
    private int length;
    private int next = 0;

    protected StringReader() {
    }

    public StringReader(String s) {
        if (s == null) {
            this.length = 0;
            return;
        }
        this.str = s;
        this.length = s.length();
    }

    public List asBlankDelimitedSubstrings() {
        ArrayList<String> aList = new ArrayList<String>();
        this.skipSpaces();
        while (!this.atEnd()) {
            aList.add(this.gatherUntil(' '));
            this.skipSpaces();
        }
        return aList;
    }

    public List asBlankDelimitedSubstringsWithDoubleQuotedChunks() {
        ArrayList<String> aList = new ArrayList<String>();
        char[] chars = new char[]{' ', '\"'};
        this.skipSpaces();
        while (!this.atEnd()) {
            if (this.peek() == '\"') {
                aList.add(this.nextDoubleQuotedChunk());
            } else {
                aList.add(this.gatherUntil(chars));
            }
            this.skipSpaces();
        }
        return aList;
    }

    public List asDelimitedSubstrings(char[] chars) {
        ArrayList<String> aList = new ArrayList<String>();
        this.skipChar(chars);
        while (!this.atEnd()) {
            aList.add(this.gatherUntil(chars));
            this.skipChar(chars);
        }
        return aList;
    }

    public List asDelimitedSubstrings(char aChar) {
        ArrayList<String> aList = new ArrayList<String>();
        this.skipChar(aChar);
        while (!this.atEnd()) {
            aList.add(this.gatherUntil(aChar));
            this.skipChar(aChar);
        }
        return aList;
    }

    public boolean atEnd() {
        if (this.str.length() == 0) {
            return true;
        }
        int aByte = this.read();
        if (aByte != -1) {
            this.backup();
        }
        return aByte == -1;
    }

    public long backup() {
        return this.skip(-1L);
    }

    public long backup(int i) {
        return this.skip(-1L * (long)i);
    }

    public void close() {
        this.str = null;
        this.reset();
    }

    public String gatherUntil(char[] chars) {
        StringBuffer aBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char nextCh = this.next();
            if (this.isOneOf(nextCh, chars)) {
                --this.next;
                return aBuffer.toString();
            }
            aBuffer.append(nextCh);
        }
        return aBuffer.toString();
    }

    public String gatherUntil(String aString) {
        return this.gatherUntil(aString.toCharArray());
    }

    public String gatherUntil(char ch) {
        StringBuffer aBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char nextCh = this.next();
            if (nextCh == ch) {
                --this.next;
                return aBuffer.toString();
            }
            aBuffer.append(nextCh);
        }
        return aBuffer.toString();
    }

    public boolean hasNext() {
        return !this.atEnd();
    }

    public boolean isOneOf(char ch, char[] anArray) {
        int i = 0;
        while (i < anArray.length) {
            if (ch == anArray[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public char next() {
        int aByte = this.read();
        if (aByte == -1) {
            throw new RuntimeException("reading beyond end of string");
        }
        return (char)aByte;
    }

    public String next(int i) {
        StringBuffer aBuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            int ch = this.read();
            if (ch == -1) {
                return aBuffer.toString();
            }
            aBuffer.append((char)ch);
            ++j;
        }
        return aBuffer.toString();
    }

    public String nextAlphaNumeric() {
        StringBuffer aBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char aChar = this.next();
            if (Character.isLetterOrDigit(aChar)) {
                aBuffer.append(aChar);
                continue;
            }
            this.backup();
            break;
        }
        return aBuffer.toString();
    }

    public String nextToken() {
        this.skipSpaces();
        return this.gatherUntil(' ');
    }

    public String nextBalancedChunkFrom(char openParen, char closeParen) {
        StringBuffer aBuffer = new StringBuffer();
        this.skipSpaces();
        if (this.peek() != openParen) {
            throw new RuntimeException("unexpected token");
        }
        aBuffer.append(this.next());
        int i = 1;
        while (i != 0) {
            if (this.atEnd()) {
                throw new RuntimeException("unbalanced parens");
            }
            char ch = this.next();
            if (ch == closeParen) {
                --i;
            }
            if (ch == openParen) {
                ++i;
            }
            aBuffer.append(ch);
        }
        return aBuffer.toString();
    }

    public String nextDoubleQuotedChunk() {
        char quote = '\"';
        StringBuffer aBuffer = new StringBuffer();
        this.skipSpaces();
        if (this.peek() != quote) {
            throw new RuntimeException("unexpected token");
        }
        aBuffer.append(this.next());
        boolean done = false;
        while (!done) {
            if (this.atEnd()) {
                throw new RuntimeException("unbalanced quotes");
            }
            char ch = this.next();
            if (ch == quote) {
                if (this.atEnd()) {
                    done = true;
                } else if (this.peek() == quote) {
                    aBuffer.append(this.next());
                } else {
                    done = true;
                }
            }
            aBuffer.append(ch);
        }
        return aBuffer.toString();
    }

    public Object nextElement() {
        return Character.valueOf(this.next());
    }

    public String nextHostVarChar() {
        String hostVarChars = "@_!.?$";
        StringBuffer aBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char aChar = this.next();
            if (Character.isLetterOrDigit(aChar) || hostVarChars.indexOf(aChar) > -1) {
                aBuffer.append(aChar);
                continue;
            }
            this.backup();
            break;
        }
        return aBuffer.toString();
    }

    public int occurrencesOf(char aChar) {
        int i = 0;
        while (this.hasNext()) {
            if (this.next() != aChar) continue;
            ++i;
        }
        return i;
    }

    public char peek() {
        int aByte = this.read();
        if (aByte == -1) {
            throw new RuntimeException("peeking beyond end of string");
        }
        this.backup();
        return (char)aByte;
    }

    public String peek(int i) {
        StringBuffer aBuffer = new StringBuffer();
        int j = 0;
        while (j < i) {
            int ch = this.read();
            if (ch == -1) break;
            aBuffer.append((char)ch);
            ++j;
        }
        this.backup(aBuffer.length());
        return aBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read() {
        Object object = this.lock;
        synchronized (object) {
            block4: {
                if (this.next < this.length) break block4;
                return -1;
            }
            return this.str.charAt(this.next++);
        }
    }

    public void remove() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.next = 0;
        }
    }

    public long skip() {
        return this.skip(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long ns) {
        Object object = this.lock;
        synchronized (object) {
            block5: {
                if (ns <= 0L || this.next < this.length) break block5;
                return 0L;
            }
            long n = Math.min((long)(this.length - this.next), ns);
            int oldNext = this.next;
            this.next = (int)((long)this.next + n);
            if (this.next < 0) {
                this.next = 0;
                return oldNext;
            }
            return n;
        }
    }

    public void skipChar(char[] chars) {
        while (!this.atEnd()) {
            if (this.isOneOf(this.next(), chars)) continue;
            --this.next;
            return;
        }
    }

    public void skipChar(String aString) {
        this.skipChar(aString.toCharArray());
    }

    public void skipChar(char aChar) {
        while (!this.atEnd()) {
            if (aChar == this.next()) continue;
            --this.next;
            return;
        }
    }

    public void skipSpaces() {
        while (!this.atEnd()) {
            if (Character.isSpaceChar(this.next())) continue;
            --this.next;
            return;
        }
    }

    public int skipUpTo(char aChar) {
        int i = 0;
        while (!this.atEnd()) {
            char c = this.next();
            if (c == aChar) {
                this.backup();
                break;
            }
            ++i;
        }
        return i;
    }

    public int skipUpToSubString(String aString) {
        int i = 0;
        int len = aString.length();
        while (!this.atEnd() && !this.peek(len).equals(aString)) {
            this.next();
            ++i;
        }
        return i;
    }

    public int skipPastSubString(String aString) {
        int i = 0;
        int len = aString.length();
        while (!this.atEnd()) {
            if (this.peek(len).equals(aString)) {
                this.next(len);
                return i + len;
            }
            this.next();
            ++i;
        }
        return i;
    }

    public String upTo(char aChar) {
        StringBuffer aBuffer = new StringBuffer();
        while (!this.atEnd()) {
            char c = this.next();
            if (c == aChar) {
                this.backup();
                break;
            }
            aBuffer.append(c);
        }
        return aBuffer.toString();
    }

    public String upToSubString(String aString) {
        int len = aString.length();
        StringBuffer aBuffer = new StringBuffer();
        while (!this.atEnd() && !this.peek(len).equals(aString)) {
            aBuffer.append(this.next());
        }
        return aBuffer.toString();
    }

    public String upToEnd() {
        StringBuffer aBuffer = new StringBuffer();
        while (!this.atEnd()) {
            aBuffer.append(this.next());
        }
        return aBuffer.toString();
    }

    public String nextLine() {
        String aString = this.gatherUntil("\n\r");
        this.skip();
        return aString;
    }
}

