/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.impl;

import org.codehaus.jackson.JsonLocation;
import org.codehaus.jackson.JsonStreamContext;
import org.codehaus.jackson.util.CharTypes;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    JsonReadContext _child = null;

    public JsonReadContext(JsonReadContext jsonReadContext, int n, int n2, int n3) {
        super(n);
        this._parent = jsonReadContext;
        this._lineNr = n2;
        this._columnNr = n3;
    }

    protected final void reset(int n, int n2, int n3) {
        this._type = n;
        this._index = -1;
        this._lineNr = n2;
        this._columnNr = n3;
        this._currentName = null;
    }

    public static JsonReadContext createRootContext(int n, int n2) {
        return new JsonReadContext(null, 0, n, n2);
    }

    public final JsonReadContext createChildArrayContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = new JsonReadContext(this, 1, n, n2);
            return this._child;
        }
        jsonReadContext.reset(1, n, n2);
        return jsonReadContext;
    }

    public final JsonReadContext createChildObjectContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = new JsonReadContext(this, 2, n, n2);
            return this._child;
        }
        jsonReadContext.reset(2, n, n2);
        return jsonReadContext;
    }

    public final String getCurrentName() {
        return this._currentName;
    }

    public final JsonReadContext getParent() {
        return this._parent;
    }

    public final JsonLocation getStartLocation(Object object) {
        long l = -1L;
        return new JsonLocation(object, l, this._lineNr, this._columnNr);
    }

    public final boolean expectComma() {
        int n = ++this._index;
        return this._type != 0 && n > 0;
    }

    public void setCurrentName(String string) {
        this._currentName = string;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append(']');
            }
        }
        return stringBuilder.toString();
    }
}

