/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.common;

import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.interop.common.IExternalProxyHandle;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.links.common.factory.IReferenceFactory;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CcConnectorUtils {
    private static String LINK_TYPE_PREFIX = "com.ibm.team.connector.scm.common.linkType.";
    public static String CLONE_LINK_TYPE = String.valueOf(LINK_TYPE_PREFIX) + "clone";
    public static String TRACKS_UCM_METADATA_OBJECT = String.valueOf(LINK_TYPE_PREFIX) + "tracksUcmObject";
    public static String UCM_IMP_WORK_ITEM_DEPENDS_UPON_LINK_TYPE = String.valueOf(LINK_TYPE_PREFIX) + "importerDependency";
    public static String UCM_IMP_SRC = String.valueOf(LINK_TYPE_PREFIX) + "importerSourceObject";
    private static final String UTF_8 = "UTF-8";
    public static final List<IItemType> CLONED_ITEM_TYPES = new ArrayList<IItemType>(Arrays.asList(IComponent.ITEM_TYPE, IFileItem.ITEM_TYPE, IFolder.ITEM_TYPE, IWorkItem.ITEM_TYPE, ISymbolicLink.ITEM_TYPE));

    public static URI createUriFromValue(String cloneValue) throws UnsupportedEncodingException, URISyntaxException {
        String encodedValue = URLEncoder.encode(cloneValue, UTF_8);
        URI result = new URI(encodedValue);
        return result;
    }

    public static String createValueFromUri(URI uri) throws UnsupportedEncodingException {
        String result = URLDecoder.decode(uri.toString(), UTF_8);
        return result;
    }

    private static IReferenceFactory refrenceFactory() {
        return IReferenceFactory.INSTANCE;
    }

    public static IItemReference createReferenceToItem(IItemHandle itemHandle) {
        return CcConnectorUtils.refrenceFactory().createReferenceToItem(itemHandle);
    }

    public static IURIReference createReferenceToUri(URI uri) {
        return CcConnectorUtils.refrenceFactory().createReferenceFromURI(uri);
    }

    public static boolean isCloneExternalProxy(IExternalProxyHandle externalProxyHandle, String uriString, IItemHandle targetItemHandle) {
        boolean result = uriString != null && uriString.contains("vobuuid") && targetItemHandle != null;
        return result;
    }
}

