/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.upgrade;

import com.urbancode.air.plugin_command.upgrade.CommandUpgrade;
import com.urbancode.air.plugin_command.upgrade.PluginIdUpgrade;
import com.urbancode.air.plugin_command.upgrade.PropertyGroupUpgrade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginVersionMigration
implements Comparable<PluginVersionMigration> {
    private long version;
    private PluginIdUpgrade idUpgrade;
    private List<CommandUpgrade> commands = new ArrayList<CommandUpgrade>();
    private List<String> removedCommands = new ArrayList<String>();
    private List<PropertyGroupUpgrade> propertyGroups = new ArrayList<PropertyGroupUpgrade>();
    private Map<String, String> removedGroupName2Type = new HashMap<String, String>();

    public PluginVersionMigration(long version) {
        this.version = version;
    }

    public long getVersion() {
        return this.version;
    }

    public void addCommandUpgrade(CommandUpgrade step) {
        this.commands.add(step);
    }

    public List<CommandUpgrade> getCommandUpgradeList() {
        return Collections.unmodifiableList(this.commands);
    }

    public void addPropertyGroupUpgrade(PropertyGroupUpgrade group) {
        this.propertyGroups.add(group);
    }

    public List<PropertyGroupUpgrade> getPropertyGroupUpgradeList() {
        return Collections.unmodifiableList(this.propertyGroups);
    }

    public void addRemovedCommand(String name) {
        this.removedCommands.add(name);
    }

    public List<String> getRemovedCommandsList() {
        return Collections.unmodifiableList(this.removedCommands);
    }

    public void addRemovedPropertyGroup(String name, String type) {
        this.removedGroupName2Type.put(name, type);
    }

    public Map<String, String> getRemovedPropertyGroupMap() {
        return Collections.unmodifiableMap(this.removedGroupName2Type);
    }

    public PluginIdUpgrade getIdUpgrade() {
        return this.idUpgrade;
    }

    public void setIdUpgrade(PluginIdUpgrade idUpgrade) {
        this.idUpgrade = idUpgrade;
    }

    @Override
    public int compareTo(PluginVersionMigration other) {
        int result = 0;
        result = other == null ? 1 : (other.getVersion() < this.version ? 1 : (other.getVersion() == this.version ? 0 : -1));
        return result;
    }
}

