/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.workitems.internal.process;

import com.ibm.team.filesystem.common.workitems.internal.process.Messages;
import com.ibm.team.filesystem.common.workitems.internal.process.RequireWorkItemAdvisor;
import com.ibm.team.filesystem.common.workitems.internal.process.WorkItemAdvisorDetailConstants;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.process.AdvisorDataMarshaller;
import com.ibm.team.scm.common.internal.process.AdvisorDetailConstants;
import com.ibm.team.scm.common.internal.process.UnifiedProcessDescriptionUtil;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequireWorkItemProblemObject
implements AdvisorDataMarshaller.IScmAdvisorMarshallable {
    @Deprecated
    public static final String ATTR_PROBLEM_WANTS_WORKITEM = "wants-workitem";
    @Deprecated
    public static final String ATTR_PROBLEM_WANTS_COMMENT = "wants-comment";
    @Deprecated
    public static final String TAG_PROBLEM = "require-workitem-problem";
    @Deprecated
    public static final String ATTR_PROBLEM_NEED_TARGET = "need-target";
    @Deprecated
    public static final String ATTR_PROBLEM_NEED_OWNER = "need-owner";
    @Deprecated
    public static final String ATTR_PROBLEM_REQUIRES = "requires";
    @Deprecated
    public static final String ATTR_WORKITEM_WORKITEM_UUID = "workitem-uuid";
    @Deprecated
    public static final String TAG_WORKITEM = "workitem";
    @Deprecated
    public static final String ATTR_PROBLEMS_VERSION = "version";
    @Deprecated
    public static final String ATTR_PROBLEMS_REPOSITORY_UUID = "repository-uuid";
    @Deprecated
    public static final String ATTR_PROBLEMS_PROJECTAREA_UUID = "projectarea-uuid";
    @Deprecated
    public static final String ATTR_PROBLEM_CHANGESET_UUID = "changeset-uuid";
    @Deprecated
    public static final String ATTR_PROBLEM_SOURCECOMP_UUID = "component-uuid";
    @Deprecated
    public static final String ATTR_PROBLEM_SOURCEWORKSPACE_UUID = "source-workspace-uuid";
    public static final String ID_REQUIRE_WORK_ITEM_PROBLEM = "com.ibm.team.process.definitions.requireWorkItemProblem";
    public IWorkspaceHandle fWorkspace;
    public IComponentHandle fComponent;
    public IChangeSetHandle fChangeSet;
    public IProjectAreaHandle fProjectArea;
    public List<IWorkItemHandle> fWorkItems;
    public boolean fIsOwnerMustBeUser;
    public boolean fIsNeedOwner;
    public boolean fIsNeedTarget;
    public boolean fWantsComment;
    public boolean fWantsWorkitem;
    public String fRequires;
    public UUID fRepositoryUuid;

    public RequireWorkItemProblemObject() {
    }

    public RequireWorkItemProblemObject(UUID repoUuid, IWorkspaceHandle src, IComponentHandle comp, IChangeSetHandle activity, List<IWorkItemHandle> workItems, IProjectAreaHandle projectArea, String requires, boolean isOwnerMustBeUser, boolean isNeedTarget, boolean isNeedOwner, boolean wantsWorkitem, boolean wantsComment) {
        this.fRepositoryUuid = repoUuid;
        this.fWorkspace = src;
        this.fComponent = comp;
        this.fChangeSet = activity;
        this.fWorkItems = workItems;
        this.fProjectArea = projectArea;
        this.fRequires = requires;
        this.fIsOwnerMustBeUser = isOwnerMustBeUser;
        this.fIsNeedOwner = isNeedOwner;
        this.fIsNeedTarget = isNeedTarget;
        this.fWantsComment = wantsComment;
        this.fWantsWorkitem = wantsWorkitem;
    }

    public IChangeSetHandle getChangeSet() {
        return this.fChangeSet;
    }

    public IProjectAreaHandle getProjectArea() {
        return this.fProjectArea;
    }

    public IWorkspaceHandle getSourceWorkspace() {
        return this.fWorkspace;
    }

    public List<IWorkItemHandle> getWorkItems() {
        return this.fWorkItems;
    }

    public String getRequires() {
        return this.fRequires;
    }

    public boolean isNeedOwner() {
        return this.fIsNeedOwner;
    }

    public boolean isOwnerMustBeUser() {
        return this.fIsOwnerMustBeUser;
    }

    public boolean isNeedTarget() {
        return this.fIsNeedTarget;
    }

    public boolean wantsWorkItem() {
        return this.fWantsWorkitem;
    }

    public boolean wantsComment() {
        return this.fWantsComment;
    }

    public static String deflate(RequireWorkItemProblemObject problem, boolean amlOnly) throws TeamRepositoryException {
        Document doc = UnifiedProcessDescriptionUtil.createXmlDoc();
        RequireWorkItemProblemObject.deflateInto(problem, amlOnly, doc);
        return UnifiedProcessDescriptionUtil.serializeDoc((Document)doc);
    }

    public static void deflateInto(RequireWorkItemProblemObject problem, boolean amlOnly, Document doc) throws TeamRepositoryException {
        Element futureRoot = null;
        if (!amlOnly) {
            Element root = doc.createElement(TAG_PROBLEM);
            root.setAttribute(ATTR_PROBLEMS_VERSION, "1");
            doc.appendChild(root);
            root.setAttribute(ATTR_PROBLEMS_PROJECTAREA_UUID, problem.getProjectArea().getItemId().getUuidValue());
            root.setAttribute(ATTR_PROBLEMS_REPOSITORY_UUID, problem.getRepoUuid().getUuidValue());
            if (problem.getChangeSet() != null) {
                root.setAttribute(ATTR_PROBLEM_CHANGESET_UUID, problem.getChangeSet().getItemId().getUuidValue());
            }
            if (problem.getSourceWorkspace() != null) {
                root.setAttribute(ATTR_PROBLEM_SOURCEWORKSPACE_UUID, problem.getSourceWorkspace().getItemId().getUuidValue());
            }
            root.setAttribute(ATTR_PROBLEM_REQUIRES, problem.getRequires());
            root.setAttribute(ATTR_PROBLEM_NEED_OWNER, problem.isNeedOwner() ? "true" : "false");
            root.setAttribute(ATTR_PROBLEM_NEED_TARGET, problem.isNeedTarget() ? "true" : "false");
            root.setAttribute(ATTR_PROBLEM_WANTS_WORKITEM, problem.wantsWorkItem() ? "true" : "false");
            root.setAttribute(ATTR_PROBLEM_WANTS_COMMENT, problem.wantsComment() ? "true" : "false");
            RequireWorkItemProblemObject.generateWorkItemXmlFor(problem, root);
            futureRoot = doc.createElement("future");
            root.appendChild(futureRoot);
        }
        try {
            AdvisorDataMarshaller.marshallInto((AdvisorDataMarshaller.IScmAdvisorMarshallable)new AdvisorDataMarshaller.AdvisorData(problem.toAML(), (AdvisorDataMarshaller.IScmAdvisorMarshallable)problem), (Document)doc, futureRoot, (UUID)problem.getRepoUuid());
        }
        catch (AdvisorDataMarshaller.MarshallerException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    public String toAML() throws TeamRepositoryException {
        Document doc = UnifiedProcessDescriptionUtil.createXmlDoc();
        Element desc = AdvisorDetailConstants.makeDescAndAppend((Document)doc);
        Element csLink = AdvisorDetailConstants.makeChangeSetLink((Document)doc, (String)Messages.getString("RequireWorkItemProblemObject.CHANGESET_TAG_TEXT"), (UUID)this.getRepoUuid(), (IContextHandle)this.getSourceWorkspace(), (IComponentHandle)this.fComponent, (IChangeSetHandle[])new IChangeSetHandle[]{this.getChangeSet()});
        if (this.wantsComment() && this.wantsWorkItem()) {
            if (RequireWorkItemAdvisor.VAL_WORKITEM_AND_COMMENT.equals(this.getRequires())) {
                UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc), (String)Messages.getString("RequireWorkItemProblemObject.CHANGESET_MISSING_1"), (Object[])new Object[]{csLink});
            } else {
                UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc), (String)Messages.getString("RequireWorkItemProblemObject.CHANGESET_MISSING_2"), (Object[])new Object[]{csLink});
            }
        } else if (this.wantsComment() && !this.wantsWorkItem()) {
            UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc), (String)Messages.getString("RequireWorkItemProblemObject.CHANGESET_MISSING_3"), (Object[])new Object[]{csLink});
        } else if (!this.wantsComment() && this.wantsWorkItem()) {
            UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc), (String)Messages.getString("RequireWorkItemProblemObject.CHANGESET_MISSING_4"), (Object[])new Object[]{csLink});
        }
        if (this.isOwnerMustBeUser()) {
            String wiLinkText = this.getWorkItems().size() == 1 ? Messages.getString("RequireWorkItemProblemObject.WORKITEM_TAG_TEXT") : Messages.getString("RequireWorkItemProblemObject.WORKITEMS_TAG_TEXT");
            Element wiLink = WorkItemAdvisorDetailConstants.makeWorkItemLink(doc, wiLinkText, this.getRepoUuid(), this.getWorkItems());
            UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc), (String)Messages.getString("RequireWorkItemProblemObject.USER_MUST_OWN_WORKITEM_ASSOCIATED_WITH_CHANGESET"), (Object[])new Object[]{wiLink, csLink});
        } else if (this.isNeedOwner()) {
            Element wiLink = WorkItemAdvisorDetailConstants.makeWorkItemLink(doc, Messages.getString("RequireWorkItemProblemObject.LEADING_WORKITEM_TAG_TEXT"), this.getRepoUuid(), this.getWorkItems());
            UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc), (String)Messages.getString("RequireWorkItemProblemObject.WORKITEM_OWNER_MUST_BE_SET_FOR_CHANGESET"), (Object[])new Object[]{wiLink, csLink});
        } else if (this.isNeedTarget()) {
            Element wiLink = WorkItemAdvisorDetailConstants.makeWorkItemLink(doc, Messages.getString("RequireWorkItemProblemObject.LEADING_WORKITEM_TAG_TEXT"), this.getRepoUuid(), this.getWorkItems());
            UnifiedProcessDescriptionUtil.xmlBind((Document)doc, (Element)AdvisorDetailConstants.makeParaAndAppend((Document)doc, (Element)desc), (String)Messages.getString("RequireWorkItemProblemObject.WORKITEM_TARGET_MUST_BE_SET_FOR_CHANGESET"), (Object[])new Object[]{wiLink, csLink});
        }
        return UnifiedProcessDescriptionUtil.serializeDoc((Document)doc);
    }

    @Deprecated
    private static void generateWorkItemXmlFor(RequireWorkItemProblemObject problem, Element problemXml) {
        if (problem.getWorkItems().isEmpty()) {
            return;
        }
        for (IWorkItemHandle wiHandle : problem.getWorkItems()) {
            Element wiXml = problemXml.getOwnerDocument().createElement(TAG_WORKITEM);
            wiXml.setAttribute(ATTR_PROBLEMS_REPOSITORY_UUID, problem.getRepoUuid().getUuidValue());
            wiXml.setAttribute(ATTR_WORKITEM_WORKITEM_UUID, wiHandle.getItemId().getUuidValue());
            problemXml.appendChild(wiXml);
        }
    }

    public UUID getRepoUuid() {
        return this.fRepositoryUuid;
    }
}

