/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal.content;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;

public class BufferedRequestEntity
extends AbstractHttpEntity {
    private final long contentSize;
    private final int bufferSize;
    private final AbstractVersionedContentManagerInputStreamProvider stream;

    public BufferedRequestEntity(AbstractVersionedContentManagerInputStreamProvider stream, long size, String contentType, int bufferSize) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream may not be null");
        }
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be greater than zero");
        }
        super.setContentType(contentType);
        this.stream = stream;
        this.contentSize = size;
        this.bufferSize = bufferSize;
    }

    public void writeTo(OutputStream out) throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        int i = 0;
        try {
            InputStream in = this.stream.getInputStream(2);
            try {
                in = this.stream.wrapInputStream(in);
                while ((i = in.read(buffer)) >= 0) {
                    out.write(buffer, 0, i);
                }
            }
            finally {
                in.close();
            }
        }
        catch (TeamRepositoryException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    public long getContentLength() {
        return this.contentSize;
    }

    public boolean isRepeatable() {
        return true;
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        try {
            return this.stream.getInputStream(2);
        }
        catch (TeamRepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean isStreaming() {
        return true;
    }
}

